#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<ExternalCommandListener>::TypeImpl()
{ }

TypeImpl<ExternalCommandListener>::~TypeImpl()
{ }

String TypeImpl<ExternalCommandListener>::GetName() const
{
	return "ExternalCommandListener";
}

int TypeImpl<ExternalCommandListener>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<ExternalCommandListener>::GetBaseType() const
{
	return ConfigObject::TypeInstance;
}

int TypeImpl<ExternalCommandListener>::GetFieldId(const String& name) const
{
	int offset = ConfigObject::TypeInstance->GetFieldCount();

	switch (static_cast<int>(Utility::SDBM(name, 1))) {
		case 99:
			if (name == "command_path")
				return offset + 0;

			break;
	}

	return ConfigObject::TypeInstance->GetFieldId(name);
}

Field TypeImpl<ExternalCommandListener>::GetFieldInfo(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount();
	if (real_id < 0) { return ConfigObject::TypeInstance->GetFieldInfo(id); }
	switch (real_id) {
		case 0:
			return {0, "String", "command_path", "command_path", nullptr, 2, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<ExternalCommandListener>::GetFieldCount() const
{
	return 1 + ConfigObject::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<ExternalCommandListener>::GetFactory() const
{
	return TypeHelper<ExternalCommandListener, false>::GetFactory();
}

int TypeImpl<ExternalCommandListener>::GetActivationPriority() const
{
	return 100;
}

void TypeImpl<ExternalCommandListener>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	switch (real_id) {
		case 0:
			ObjectImpl<ExternalCommandListener>::OnCommandPathChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<ExternalCommandListener>::Validate(int types, const ValidationUtils& utils)
{
	ConfigObject::Validate(types, utils);

	if (2 & types)
		ValidateCommandPath(Lazy<String>([this]() { return GetCommandPath(); }), utils);
}

void ObjectImpl<ExternalCommandListener>::SimpleValidateCommandPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

ObjectImpl<ExternalCommandListener>::ObjectImpl()
{
	SetCommandPath(GetDefaultCommandPath(), true);
}

ObjectImpl<ExternalCommandListener>::~ObjectImpl()
{ }

void ObjectImpl<ExternalCommandListener>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::SetField(id, value, suppress_events, cookie); return; }
	switch (real_id) {
		case 0:
			SetCommandPath(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<ExternalCommandListener>::GetField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::GetField(id); }
	switch (real_id) {
		case 0:
			return GetCommandPath();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<ExternalCommandListener>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::ValidateField(id, lvalue, utils); return; }
	switch (real_id) {
		case 0:
			ValidateCommandPath(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<ExternalCommandListener>::NotifyField(int id, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::NotifyField(id, cookie); return; }
	switch (real_id) {
		case 0:
			NotifyCommandPath(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<ExternalCommandListener>::NavigateField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::NavigateField(id); }
	throw std::runtime_error("Invalid field ID.");
}

String ObjectImpl<ExternalCommandListener>::GetCommandPath() const
{
	return m_CommandPath.load();
}

void ObjectImpl<ExternalCommandListener>::SetCommandPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_CommandPath.store(value);
	if (!suppress_events) {
		NotifyCommandPath(cookie);
	}

}

void ObjectImpl<ExternalCommandListener>::NotifyCommandPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCommandPathChanged(static_cast<ExternalCommandListener *>(this), cookie);
}

String ObjectImpl<ExternalCommandListener>::GetDefaultCommandPath() const
{
	 return Configuration::InitRunDir + "/cmd/icinga2.cmd"; 
}


boost::signals2::signal<void (const intrusive_ptr<ExternalCommandListener>&, const Value&)> ObjectImpl<ExternalCommandListener>::OnCommandPathChanged;

void ObjectImpl<ExternalCommandListener>::ValidateCommandPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCommandPath(lvalue, utils);
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
