#ifndef EXTERNALCOMMANDLISTENER_TI
#define EXTERNALCOMMANDLISTENER_TI

#include "base/object.hpp"
#include "base/type.hpp"
#include "base/value.hpp"
#include "base/array.hpp"
#include "base/atomic.hpp"
#include "base/dictionary.hpp"
#include <boost/signals2.hpp>

#include "base/configobject.hpp"

#include "base/application.hpp"

namespace icinga
{

class ExternalCommandListener;

template<>
class TypeImpl<ExternalCommandListener> : public TypeImpl<ConfigObject>
{
public:
	DECLARE_PTR_TYPEDEFS(TypeImpl<ExternalCommandListener>);

	TypeImpl();
	~TypeImpl() override;

	String GetName() const override;
	int GetAttributes() const override;
	Type::Ptr GetBaseType() const override;
	int GetFieldId(const String& name) const override;
	Field GetFieldInfo(int id) const override;
	int GetFieldCount() const override;
	ObjectFactory GetFactory() const override;
	int GetActivationPriority() const override;
public:
	void RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback) override;
};


template<>
class ObjectImpl<ExternalCommandListener> : public ConfigObject
{
public:
	DECLARE_PTR_TYPEDEFS(ObjectImpl<ExternalCommandListener>);

	void Validate(int types, const ValidationUtils& utils) override;
	void SimpleValidateCommandPath(const Lazy<String>& value, const ValidationUtils& utils);
public:
	ObjectImpl<ExternalCommandListener>();
public:
	~ObjectImpl<ExternalCommandListener>() override;
public:
	void SetField(int id, const Value& value, bool suppress_events = false, const Value& cookie = Empty) override;
public:
	Value GetField(int id) const override;
public:
	void ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils) override;
public:
	void NotifyField(int id, const Value& cookie = Empty) override;
public:
	Object::Ptr NavigateField(int id) const override;
public:
	String GetCommandPath() const;
public:
	void SetCommandPath(const String& value, bool suppress_events = false, const Value& cookie = Empty);
protected:
public:
	virtual void NotifyCommandPath(const Value& cookie = Empty);
private:
	inline String GetDefaultCommandPath() const;
protected:
	virtual void ValidateCommandPath(const Lazy<String>& lvalue, const ValidationUtils& utils);
private:
	AtomicOrLocked<String> m_CommandPath;
public:
	static boost::signals2::signal<void (const intrusive_ptr<ExternalCommandListener>&, const Value&)> OnCommandPathChanged;
};

}
#endif /* EXTERNALCOMMANDLISTENER_TI */
