#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<IdoMysqlConnection>::TypeImpl()
{ }

TypeImpl<IdoMysqlConnection>::~TypeImpl()
{ }

String TypeImpl<IdoMysqlConnection>::GetName() const
{
	return "IdoMysqlConnection";
}

int TypeImpl<IdoMysqlConnection>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<IdoMysqlConnection>::GetBaseType() const
{
	return DbConnection::TypeInstance;
}

int TypeImpl<IdoMysqlConnection>::GetFieldId(const String& name) const
{
	int offset = DbConnection::TypeInstance->GetFieldCount();

	switch (static_cast<int>(Utility::SDBM(name, 5))) {
		case -1852654458:
			if (name == "password")
				return offset + 3;

			break;
		case -1844041471:
			if (name == "port")
				return offset + 12;

			break;
		case -1622403728:
			if (name == "ssl_cert")
				return offset + 6;
			if (name == "ssl_ca")
				return offset + 7;
			if (name == "ssl_capath")
				return offset + 8;
			if (name == "ssl_cipher")
				return offset + 9;

			break;
		case -1622403720:
			if (name == "ssl_key")
				return offset + 5;

			break;
		case -523351583:
			if (name == "socket_path")
				return offset + 1;

			break;
		case -95083038:
			if (name == "enable_ssl")
				return offset + 13;

			break;
		case 318094683:
			if (name == "instance_name")
				return offset + 10;
			if (name == "instance_description")
				return offset + 11;

			break;
		case 501261128:
			if (name == "host")
				return offset + 0;

			break;
		case 1659523960:
			if (name == "database")
				return offset + 4;

			break;
		case 2091087755:
			if (name == "user")
				return offset + 2;

			break;
	}

	return DbConnection::TypeInstance->GetFieldId(name);
}

Field TypeImpl<IdoMysqlConnection>::GetFieldInfo(int id) const
{
	int real_id = id - DbConnection::TypeInstance->GetFieldCount();
	if (real_id < 0) { return DbConnection::TypeInstance->GetFieldInfo(id); }
	switch (real_id) {
		case 0:
			return {0, "String", "host", "host", nullptr, 2, 0};
		case 1:
			return {1, "String", "socket_path", "socket_path", nullptr, 2, 0};
		case 2:
			return {2, "String", "user", "user", nullptr, 2, 0};
		case 3:
			return {3, "String", "password", "password", nullptr, 3074, 0};
		case 4:
			return {4, "String", "database", "database", nullptr, 2, 0};
		case 5:
			return {5, "String", "ssl_key", "ssl_key", nullptr, 2, 0};
		case 6:
			return {6, "String", "ssl_cert", "ssl_cert", nullptr, 2, 0};
		case 7:
			return {7, "String", "ssl_ca", "ssl_ca", nullptr, 2, 0};
		case 8:
			return {8, "String", "ssl_capath", "ssl_capath", nullptr, 2, 0};
		case 9:
			return {9, "String", "ssl_cipher", "ssl_cipher", nullptr, 2, 0};
		case 10:
			return {10, "String", "instance_name", "instance_name", nullptr, 2, 0};
		case 11:
			return {11, "String", "instance_description", "instance_description", nullptr, 2, 0};
		case 12:
			return {12, "Number", "port", "port", nullptr, 2, 0};
		case 13:
			return {13, "Boolean", "enable_ssl", "enable_ssl", nullptr, 2, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<IdoMysqlConnection>::GetFieldCount() const
{
	return 14 + DbConnection::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<IdoMysqlConnection>::GetFactory() const
{
	return TypeHelper<IdoMysqlConnection, false>::GetFactory();
}

int TypeImpl<IdoMysqlConnection>::GetActivationPriority() const
{
	return 100;
}

void TypeImpl<IdoMysqlConnection>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - DbConnection::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { DbConnection::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	switch (real_id) {
		case 0:
			ObjectImpl<IdoMysqlConnection>::OnHostChanged.connect(callback);
			break;
		case 1:
			ObjectImpl<IdoMysqlConnection>::OnSocketPathChanged.connect(callback);
			break;
		case 2:
			ObjectImpl<IdoMysqlConnection>::OnUserChanged.connect(callback);
			break;
		case 3:
			ObjectImpl<IdoMysqlConnection>::OnPasswordChanged.connect(callback);
			break;
		case 4:
			ObjectImpl<IdoMysqlConnection>::OnDatabaseChanged.connect(callback);
			break;
		case 5:
			ObjectImpl<IdoMysqlConnection>::OnSslKeyChanged.connect(callback);
			break;
		case 6:
			ObjectImpl<IdoMysqlConnection>::OnSslCertChanged.connect(callback);
			break;
		case 7:
			ObjectImpl<IdoMysqlConnection>::OnSslCaChanged.connect(callback);
			break;
		case 8:
			ObjectImpl<IdoMysqlConnection>::OnSslCapathChanged.connect(callback);
			break;
		case 9:
			ObjectImpl<IdoMysqlConnection>::OnSslCipherChanged.connect(callback);
			break;
		case 10:
			ObjectImpl<IdoMysqlConnection>::OnInstanceNameChanged.connect(callback);
			break;
		case 11:
			ObjectImpl<IdoMysqlConnection>::OnInstanceDescriptionChanged.connect(callback);
			break;
		case 12:
			ObjectImpl<IdoMysqlConnection>::OnPortChanged.connect(callback);
			break;
		case 13:
			ObjectImpl<IdoMysqlConnection>::OnEnableSslChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<IdoMysqlConnection>::Validate(int types, const ValidationUtils& utils)
{
	DbConnection::Validate(types, utils);

	if (2 & types)
		ValidateHost(Lazy<String>([this]() { return GetHost(); }), utils);
	if (2 & types)
		ValidateSocketPath(Lazy<String>([this]() { return GetSocketPath(); }), utils);
	if (2 & types)
		ValidateUser(Lazy<String>([this]() { return GetUser(); }), utils);
	if (2 & types)
		ValidatePassword(Lazy<String>([this]() { return GetPassword(); }), utils);
	if (2 & types)
		ValidateDatabase(Lazy<String>([this]() { return GetDatabase(); }), utils);
	if (2 & types)
		ValidateSslKey(Lazy<String>([this]() { return GetSslKey(); }), utils);
	if (2 & types)
		ValidateSslCert(Lazy<String>([this]() { return GetSslCert(); }), utils);
	if (2 & types)
		ValidateSslCa(Lazy<String>([this]() { return GetSslCa(); }), utils);
	if (2 & types)
		ValidateSslCapath(Lazy<String>([this]() { return GetSslCapath(); }), utils);
	if (2 & types)
		ValidateSslCipher(Lazy<String>([this]() { return GetSslCipher(); }), utils);
	if (2 & types)
		ValidateInstanceName(Lazy<String>([this]() { return GetInstanceName(); }), utils);
	if (2 & types)
		ValidateInstanceDescription(Lazy<String>([this]() { return GetInstanceDescription(); }), utils);
	if (2 & types)
		ValidatePort(Lazy<int>([this]() { return GetPort(); }), utils);
	if (2 & types)
		ValidateEnableSsl(Lazy<bool>([this]() { return GetEnableSsl(); }), utils);
}

void ObjectImpl<IdoMysqlConnection>::SimpleValidateHost(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoMysqlConnection>::SimpleValidateSocketPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoMysqlConnection>::SimpleValidateUser(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoMysqlConnection>::SimpleValidatePassword(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoMysqlConnection>::SimpleValidateDatabase(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoMysqlConnection>::SimpleValidateSslKey(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoMysqlConnection>::SimpleValidateSslCert(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoMysqlConnection>::SimpleValidateSslCa(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoMysqlConnection>::SimpleValidateSslCapath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoMysqlConnection>::SimpleValidateSslCipher(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoMysqlConnection>::SimpleValidateInstanceName(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoMysqlConnection>::SimpleValidateInstanceDescription(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoMysqlConnection>::SimpleValidatePort(const Lazy<int>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoMysqlConnection>::SimpleValidateEnableSsl(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

ObjectImpl<IdoMysqlConnection>::ObjectImpl()
{
	SetHost(GetDefaultHost(), true);
	SetSocketPath(GetDefaultSocketPath(), true);
	SetUser(GetDefaultUser(), true);
	SetPassword(GetDefaultPassword(), true);
	SetDatabase(GetDefaultDatabase(), true);
	SetSslKey(GetDefaultSslKey(), true);
	SetSslCert(GetDefaultSslCert(), true);
	SetSslCa(GetDefaultSslCa(), true);
	SetSslCapath(GetDefaultSslCapath(), true);
	SetSslCipher(GetDefaultSslCipher(), true);
	SetInstanceName(GetDefaultInstanceName(), true);
	SetInstanceDescription(GetDefaultInstanceDescription(), true);
	SetPort(GetDefaultPort(), true);
	SetEnableSsl(GetDefaultEnableSsl(), true);
}

ObjectImpl<IdoMysqlConnection>::~ObjectImpl()
{ }

void ObjectImpl<IdoMysqlConnection>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	int real_id = id - DbConnection::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { DbConnection::SetField(id, value, suppress_events, cookie); return; }
	switch (real_id) {
		case 0:
			SetHost(value, suppress_events, cookie);
			break;
		case 1:
			SetSocketPath(value, suppress_events, cookie);
			break;
		case 2:
			SetUser(value, suppress_events, cookie);
			break;
		case 3:
			SetPassword(value, suppress_events, cookie);
			break;
		case 4:
			SetDatabase(value, suppress_events, cookie);
			break;
		case 5:
			SetSslKey(value, suppress_events, cookie);
			break;
		case 6:
			SetSslCert(value, suppress_events, cookie);
			break;
		case 7:
			SetSslCa(value, suppress_events, cookie);
			break;
		case 8:
			SetSslCapath(value, suppress_events, cookie);
			break;
		case 9:
			SetSslCipher(value, suppress_events, cookie);
			break;
		case 10:
			SetInstanceName(value, suppress_events, cookie);
			break;
		case 11:
			SetInstanceDescription(value, suppress_events, cookie);
			break;
		case 12:
			SetPort(value, suppress_events, cookie);
			break;
		case 13:
			SetEnableSsl(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<IdoMysqlConnection>::GetField(int id) const
{
	int real_id = id - DbConnection::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return DbConnection::GetField(id); }
	switch (real_id) {
		case 0:
			return GetHost();
		case 1:
			return GetSocketPath();
		case 2:
			return GetUser();
		case 3:
			return GetPassword();
		case 4:
			return GetDatabase();
		case 5:
			return GetSslKey();
		case 6:
			return GetSslCert();
		case 7:
			return GetSslCa();
		case 8:
			return GetSslCapath();
		case 9:
			return GetSslCipher();
		case 10:
			return GetInstanceName();
		case 11:
			return GetInstanceDescription();
		case 12:
			return GetPort();
		case 13:
			return GetEnableSsl();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<IdoMysqlConnection>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	int real_id = id - DbConnection::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { DbConnection::ValidateField(id, lvalue, utils); return; }
	switch (real_id) {
		case 0:
			ValidateHost(lvalue, utils);
			break;
		case 1:
			ValidateSocketPath(lvalue, utils);
			break;
		case 2:
			ValidateUser(lvalue, utils);
			break;
		case 3:
			ValidatePassword(lvalue, utils);
			break;
		case 4:
			ValidateDatabase(lvalue, utils);
			break;
		case 5:
			ValidateSslKey(lvalue, utils);
			break;
		case 6:
			ValidateSslCert(lvalue, utils);
			break;
		case 7:
			ValidateSslCa(lvalue, utils);
			break;
		case 8:
			ValidateSslCapath(lvalue, utils);
			break;
		case 9:
			ValidateSslCipher(lvalue, utils);
			break;
		case 10:
			ValidateInstanceName(lvalue, utils);
			break;
		case 11:
			ValidateInstanceDescription(lvalue, utils);
			break;
		case 12:
			ValidatePort(lvalue, utils);
			break;
		case 13:
			ValidateEnableSsl(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<IdoMysqlConnection>::NotifyField(int id, const Value& cookie)
{
	int real_id = id - DbConnection::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { DbConnection::NotifyField(id, cookie); return; }
	switch (real_id) {
		case 0:
			NotifyHost(cookie);
			break;
		case 1:
			NotifySocketPath(cookie);
			break;
		case 2:
			NotifyUser(cookie);
			break;
		case 3:
			NotifyPassword(cookie);
			break;
		case 4:
			NotifyDatabase(cookie);
			break;
		case 5:
			NotifySslKey(cookie);
			break;
		case 6:
			NotifySslCert(cookie);
			break;
		case 7:
			NotifySslCa(cookie);
			break;
		case 8:
			NotifySslCapath(cookie);
			break;
		case 9:
			NotifySslCipher(cookie);
			break;
		case 10:
			NotifyInstanceName(cookie);
			break;
		case 11:
			NotifyInstanceDescription(cookie);
			break;
		case 12:
			NotifyPort(cookie);
			break;
		case 13:
			NotifyEnableSsl(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<IdoMysqlConnection>::NavigateField(int id) const
{
	int real_id = id - DbConnection::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return DbConnection::NavigateField(id); }
	throw std::runtime_error("Invalid field ID.");
}

String ObjectImpl<IdoMysqlConnection>::GetHost() const
{
	return m_Host.load();
}

String ObjectImpl<IdoMysqlConnection>::GetSocketPath() const
{
	return m_SocketPath.load();
}

String ObjectImpl<IdoMysqlConnection>::GetUser() const
{
	return m_User.load();
}

String ObjectImpl<IdoMysqlConnection>::GetPassword() const
{
	return m_Password.load();
}

String ObjectImpl<IdoMysqlConnection>::GetDatabase() const
{
	return m_Database.load();
}

String ObjectImpl<IdoMysqlConnection>::GetSslKey() const
{
	return m_SslKey.load();
}

String ObjectImpl<IdoMysqlConnection>::GetSslCert() const
{
	return m_SslCert.load();
}

String ObjectImpl<IdoMysqlConnection>::GetSslCa() const
{
	return m_SslCa.load();
}

String ObjectImpl<IdoMysqlConnection>::GetSslCapath() const
{
	return m_SslCapath.load();
}

String ObjectImpl<IdoMysqlConnection>::GetSslCipher() const
{
	return m_SslCipher.load();
}

String ObjectImpl<IdoMysqlConnection>::GetInstanceName() const
{
	return m_InstanceName.load();
}

String ObjectImpl<IdoMysqlConnection>::GetInstanceDescription() const
{
	return m_InstanceDescription.load();
}

int ObjectImpl<IdoMysqlConnection>::GetPort() const
{
	return m_Port.load();
}

bool ObjectImpl<IdoMysqlConnection>::GetEnableSsl() const
{
	return m_EnableSsl.load();
}

void ObjectImpl<IdoMysqlConnection>::SetHost(const String& value, bool suppress_events, const Value& cookie)
{
	m_Host.store(value);
	if (!suppress_events) {
		NotifyHost(cookie);
	}

}

void ObjectImpl<IdoMysqlConnection>::SetSocketPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_SocketPath.store(value);
	if (!suppress_events) {
		NotifySocketPath(cookie);
	}

}

void ObjectImpl<IdoMysqlConnection>::SetUser(const String& value, bool suppress_events, const Value& cookie)
{
	m_User.store(value);
	if (!suppress_events) {
		NotifyUser(cookie);
	}

}

void ObjectImpl<IdoMysqlConnection>::SetPassword(const String& value, bool suppress_events, const Value& cookie)
{
	m_Password.store(value);
	if (!suppress_events) {
		NotifyPassword(cookie);
	}

}

void ObjectImpl<IdoMysqlConnection>::SetDatabase(const String& value, bool suppress_events, const Value& cookie)
{
	m_Database.store(value);
	if (!suppress_events) {
		NotifyDatabase(cookie);
	}

}

void ObjectImpl<IdoMysqlConnection>::SetSslKey(const String& value, bool suppress_events, const Value& cookie)
{
	m_SslKey.store(value);
	if (!suppress_events) {
		NotifySslKey(cookie);
	}

}

void ObjectImpl<IdoMysqlConnection>::SetSslCert(const String& value, bool suppress_events, const Value& cookie)
{
	m_SslCert.store(value);
	if (!suppress_events) {
		NotifySslCert(cookie);
	}

}

void ObjectImpl<IdoMysqlConnection>::SetSslCa(const String& value, bool suppress_events, const Value& cookie)
{
	m_SslCa.store(value);
	if (!suppress_events) {
		NotifySslCa(cookie);
	}

}

void ObjectImpl<IdoMysqlConnection>::SetSslCapath(const String& value, bool suppress_events, const Value& cookie)
{
	m_SslCapath.store(value);
	if (!suppress_events) {
		NotifySslCapath(cookie);
	}

}

void ObjectImpl<IdoMysqlConnection>::SetSslCipher(const String& value, bool suppress_events, const Value& cookie)
{
	m_SslCipher.store(value);
	if (!suppress_events) {
		NotifySslCipher(cookie);
	}

}

void ObjectImpl<IdoMysqlConnection>::SetInstanceName(const String& value, bool suppress_events, const Value& cookie)
{
	m_InstanceName.store(value);
	if (!suppress_events) {
		NotifyInstanceName(cookie);
	}

}

void ObjectImpl<IdoMysqlConnection>::SetInstanceDescription(const String& value, bool suppress_events, const Value& cookie)
{
	m_InstanceDescription.store(value);
	if (!suppress_events) {
		NotifyInstanceDescription(cookie);
	}

}

void ObjectImpl<IdoMysqlConnection>::SetPort(int value, bool suppress_events, const Value& cookie)
{
	m_Port.store(value);
	if (!suppress_events) {
		NotifyPort(cookie);
	}

}

void ObjectImpl<IdoMysqlConnection>::SetEnableSsl(bool value, bool suppress_events, const Value& cookie)
{
	m_EnableSsl.store(value);
	if (!suppress_events) {
		NotifyEnableSsl(cookie);
	}

}

void ObjectImpl<IdoMysqlConnection>::NotifyHost(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnHostChanged(static_cast<IdoMysqlConnection *>(this), cookie);
}

void ObjectImpl<IdoMysqlConnection>::NotifySocketPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSocketPathChanged(static_cast<IdoMysqlConnection *>(this), cookie);
}

void ObjectImpl<IdoMysqlConnection>::NotifyUser(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnUserChanged(static_cast<IdoMysqlConnection *>(this), cookie);
}

void ObjectImpl<IdoMysqlConnection>::NotifyPassword(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPasswordChanged(static_cast<IdoMysqlConnection *>(this), cookie);
}

void ObjectImpl<IdoMysqlConnection>::NotifyDatabase(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnDatabaseChanged(static_cast<IdoMysqlConnection *>(this), cookie);
}

void ObjectImpl<IdoMysqlConnection>::NotifySslKey(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSslKeyChanged(static_cast<IdoMysqlConnection *>(this), cookie);
}

void ObjectImpl<IdoMysqlConnection>::NotifySslCert(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSslCertChanged(static_cast<IdoMysqlConnection *>(this), cookie);
}

void ObjectImpl<IdoMysqlConnection>::NotifySslCa(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSslCaChanged(static_cast<IdoMysqlConnection *>(this), cookie);
}

void ObjectImpl<IdoMysqlConnection>::NotifySslCapath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSslCapathChanged(static_cast<IdoMysqlConnection *>(this), cookie);
}

void ObjectImpl<IdoMysqlConnection>::NotifySslCipher(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSslCipherChanged(static_cast<IdoMysqlConnection *>(this), cookie);
}

void ObjectImpl<IdoMysqlConnection>::NotifyInstanceName(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnInstanceNameChanged(static_cast<IdoMysqlConnection *>(this), cookie);
}

void ObjectImpl<IdoMysqlConnection>::NotifyInstanceDescription(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnInstanceDescriptionChanged(static_cast<IdoMysqlConnection *>(this), cookie);
}

void ObjectImpl<IdoMysqlConnection>::NotifyPort(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPortChanged(static_cast<IdoMysqlConnection *>(this), cookie);
}

void ObjectImpl<IdoMysqlConnection>::NotifyEnableSsl(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnableSslChanged(static_cast<IdoMysqlConnection *>(this), cookie);
}

String ObjectImpl<IdoMysqlConnection>::GetDefaultHost() const
{
	 return "localhost"; 
}

String ObjectImpl<IdoMysqlConnection>::GetDefaultSocketPath() const
{
	return String();
}

String ObjectImpl<IdoMysqlConnection>::GetDefaultUser() const
{
	 return "icinga"; 
}

String ObjectImpl<IdoMysqlConnection>::GetDefaultPassword() const
{
	 return "icinga"; 
}

String ObjectImpl<IdoMysqlConnection>::GetDefaultDatabase() const
{
	 return "icinga"; 
}

String ObjectImpl<IdoMysqlConnection>::GetDefaultSslKey() const
{
	return String();
}

String ObjectImpl<IdoMysqlConnection>::GetDefaultSslCert() const
{
	return String();
}

String ObjectImpl<IdoMysqlConnection>::GetDefaultSslCa() const
{
	return String();
}

String ObjectImpl<IdoMysqlConnection>::GetDefaultSslCapath() const
{
	return String();
}

String ObjectImpl<IdoMysqlConnection>::GetDefaultSslCipher() const
{
	return String();
}

String ObjectImpl<IdoMysqlConnection>::GetDefaultInstanceName() const
{
	 return "default"; 
}

String ObjectImpl<IdoMysqlConnection>::GetDefaultInstanceDescription() const
{
	return String();
}

int ObjectImpl<IdoMysqlConnection>::GetDefaultPort() const
{
	 return 3306; 
}

bool ObjectImpl<IdoMysqlConnection>::GetDefaultEnableSsl() const
{
	return bool();
}


boost::signals2::signal<void (const intrusive_ptr<IdoMysqlConnection>&, const Value&)> ObjectImpl<IdoMysqlConnection>::OnHostChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoMysqlConnection>&, const Value&)> ObjectImpl<IdoMysqlConnection>::OnSocketPathChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoMysqlConnection>&, const Value&)> ObjectImpl<IdoMysqlConnection>::OnUserChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoMysqlConnection>&, const Value&)> ObjectImpl<IdoMysqlConnection>::OnPasswordChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoMysqlConnection>&, const Value&)> ObjectImpl<IdoMysqlConnection>::OnDatabaseChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoMysqlConnection>&, const Value&)> ObjectImpl<IdoMysqlConnection>::OnSslKeyChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoMysqlConnection>&, const Value&)> ObjectImpl<IdoMysqlConnection>::OnSslCertChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoMysqlConnection>&, const Value&)> ObjectImpl<IdoMysqlConnection>::OnSslCaChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoMysqlConnection>&, const Value&)> ObjectImpl<IdoMysqlConnection>::OnSslCapathChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoMysqlConnection>&, const Value&)> ObjectImpl<IdoMysqlConnection>::OnSslCipherChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoMysqlConnection>&, const Value&)> ObjectImpl<IdoMysqlConnection>::OnInstanceNameChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoMysqlConnection>&, const Value&)> ObjectImpl<IdoMysqlConnection>::OnInstanceDescriptionChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoMysqlConnection>&, const Value&)> ObjectImpl<IdoMysqlConnection>::OnPortChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoMysqlConnection>&, const Value&)> ObjectImpl<IdoMysqlConnection>::OnEnableSslChanged;

void ObjectImpl<IdoMysqlConnection>::ValidateDatabase(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateDatabase(lvalue, utils);
}

void ObjectImpl<IdoMysqlConnection>::ValidateEnableSsl(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnableSsl(lvalue, utils);
}

void ObjectImpl<IdoMysqlConnection>::ValidateHost(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateHost(lvalue, utils);
}

void ObjectImpl<IdoMysqlConnection>::ValidateInstanceDescription(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateInstanceDescription(lvalue, utils);
}

void ObjectImpl<IdoMysqlConnection>::ValidateInstanceName(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateInstanceName(lvalue, utils);
}

void ObjectImpl<IdoMysqlConnection>::ValidatePassword(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePassword(lvalue, utils);
}

void ObjectImpl<IdoMysqlConnection>::ValidatePort(const Lazy<int>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePort(lvalue, utils);
}

void ObjectImpl<IdoMysqlConnection>::ValidateSocketPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSocketPath(lvalue, utils);
}

void ObjectImpl<IdoMysqlConnection>::ValidateSslCa(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSslCa(lvalue, utils);
}

void ObjectImpl<IdoMysqlConnection>::ValidateSslCapath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSslCapath(lvalue, utils);
}

void ObjectImpl<IdoMysqlConnection>::ValidateSslCert(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSslCert(lvalue, utils);
}

void ObjectImpl<IdoMysqlConnection>::ValidateSslCipher(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSslCipher(lvalue, utils);
}

void ObjectImpl<IdoMysqlConnection>::ValidateSslKey(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSslKey(lvalue, utils);
}

void ObjectImpl<IdoMysqlConnection>::ValidateUser(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateUser(lvalue, utils);
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
