#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<IdoPgsqlConnection>::TypeImpl()
{ }

TypeImpl<IdoPgsqlConnection>::~TypeImpl()
{ }

String TypeImpl<IdoPgsqlConnection>::GetName() const
{
	return "IdoPgsqlConnection";
}

int TypeImpl<IdoPgsqlConnection>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<IdoPgsqlConnection>::GetBaseType() const
{
	return DbConnection::TypeInstance;
}

int TypeImpl<IdoPgsqlConnection>::GetFieldId(const String& name) const
{
	int offset = DbConnection::TypeInstance->GetFieldCount();

	switch (static_cast<int>(Utility::SDBM(name, 2))) {
		case 6559997:
			if (name == "database")
				return offset + 4;

			break;
		case 6822407:
			if (name == "host")
				return offset + 0;

			break;
		case 6888005:
			if (name == "instance_name")
				return offset + 5;
			if (name == "instance_description")
				return offset + 6;

			break;
		case 7347185:
			if (name == "password")
				return offset + 3;

			break;
		case 7347199:
			if (name == "port")
				return offset + 1;

			break;
		case 7544000:
			if (name == "ssl_mode")
				return offset + 7;
			if (name == "ssl_key")
				return offset + 8;
			if (name == "ssl_cert")
				return offset + 9;
			if (name == "ssl_ca")
				return offset + 10;

			break;
		case 7675198:
			if (name == "user")
				return offset + 2;

			break;
	}

	return DbConnection::TypeInstance->GetFieldId(name);
}

Field TypeImpl<IdoPgsqlConnection>::GetFieldInfo(int id) const
{
	int real_id = id - DbConnection::TypeInstance->GetFieldCount();
	if (real_id < 0) { return DbConnection::TypeInstance->GetFieldInfo(id); }
	switch (real_id) {
		case 0:
			return {0, "String", "host", "host", nullptr, 2, 0};
		case 1:
			return {1, "String", "port", "port", nullptr, 2, 0};
		case 2:
			return {2, "String", "user", "user", nullptr, 2, 0};
		case 3:
			return {3, "String", "password", "password", nullptr, 3074, 0};
		case 4:
			return {4, "String", "database", "database", nullptr, 2, 0};
		case 5:
			return {5, "String", "instance_name", "instance_name", nullptr, 2, 0};
		case 6:
			return {6, "String", "instance_description", "instance_description", nullptr, 2, 0};
		case 7:
			return {7, "String", "ssl_mode", "ssl_mode", nullptr, 2, 0};
		case 8:
			return {8, "String", "ssl_key", "ssl_key", nullptr, 2, 0};
		case 9:
			return {9, "String", "ssl_cert", "ssl_cert", nullptr, 2, 0};
		case 10:
			return {10, "String", "ssl_ca", "ssl_ca", nullptr, 2, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<IdoPgsqlConnection>::GetFieldCount() const
{
	return 11 + DbConnection::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<IdoPgsqlConnection>::GetFactory() const
{
	return TypeHelper<IdoPgsqlConnection, false>::GetFactory();
}

int TypeImpl<IdoPgsqlConnection>::GetActivationPriority() const
{
	return 100;
}

void TypeImpl<IdoPgsqlConnection>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - DbConnection::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { DbConnection::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	switch (real_id) {
		case 0:
			ObjectImpl<IdoPgsqlConnection>::OnHostChanged.connect(callback);
			break;
		case 1:
			ObjectImpl<IdoPgsqlConnection>::OnPortChanged.connect(callback);
			break;
		case 2:
			ObjectImpl<IdoPgsqlConnection>::OnUserChanged.connect(callback);
			break;
		case 3:
			ObjectImpl<IdoPgsqlConnection>::OnPasswordChanged.connect(callback);
			break;
		case 4:
			ObjectImpl<IdoPgsqlConnection>::OnDatabaseChanged.connect(callback);
			break;
		case 5:
			ObjectImpl<IdoPgsqlConnection>::OnInstanceNameChanged.connect(callback);
			break;
		case 6:
			ObjectImpl<IdoPgsqlConnection>::OnInstanceDescriptionChanged.connect(callback);
			break;
		case 7:
			ObjectImpl<IdoPgsqlConnection>::OnSslModeChanged.connect(callback);
			break;
		case 8:
			ObjectImpl<IdoPgsqlConnection>::OnSslKeyChanged.connect(callback);
			break;
		case 9:
			ObjectImpl<IdoPgsqlConnection>::OnSslCertChanged.connect(callback);
			break;
		case 10:
			ObjectImpl<IdoPgsqlConnection>::OnSslCaChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<IdoPgsqlConnection>::Validate(int types, const ValidationUtils& utils)
{
	DbConnection::Validate(types, utils);

	if (2 & types)
		ValidateHost(Lazy<String>([this]() { return GetHost(); }), utils);
	if (2 & types)
		ValidatePort(Lazy<String>([this]() { return GetPort(); }), utils);
	if (2 & types)
		ValidateUser(Lazy<String>([this]() { return GetUser(); }), utils);
	if (2 & types)
		ValidatePassword(Lazy<String>([this]() { return GetPassword(); }), utils);
	if (2 & types)
		ValidateDatabase(Lazy<String>([this]() { return GetDatabase(); }), utils);
	if (2 & types)
		ValidateInstanceName(Lazy<String>([this]() { return GetInstanceName(); }), utils);
	if (2 & types)
		ValidateInstanceDescription(Lazy<String>([this]() { return GetInstanceDescription(); }), utils);
	if (2 & types)
		ValidateSslMode(Lazy<String>([this]() { return GetSslMode(); }), utils);
	if (2 & types)
		ValidateSslKey(Lazy<String>([this]() { return GetSslKey(); }), utils);
	if (2 & types)
		ValidateSslCert(Lazy<String>([this]() { return GetSslCert(); }), utils);
	if (2 & types)
		ValidateSslCa(Lazy<String>([this]() { return GetSslCa(); }), utils);
}

void ObjectImpl<IdoPgsqlConnection>::SimpleValidateHost(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoPgsqlConnection>::SimpleValidatePort(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoPgsqlConnection>::SimpleValidateUser(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoPgsqlConnection>::SimpleValidatePassword(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoPgsqlConnection>::SimpleValidateDatabase(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoPgsqlConnection>::SimpleValidateInstanceName(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoPgsqlConnection>::SimpleValidateInstanceDescription(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoPgsqlConnection>::SimpleValidateSslMode(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoPgsqlConnection>::SimpleValidateSslKey(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoPgsqlConnection>::SimpleValidateSslCert(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IdoPgsqlConnection>::SimpleValidateSslCa(const Lazy<String>& value, const ValidationUtils& utils)
{
}

ObjectImpl<IdoPgsqlConnection>::ObjectImpl()
{
	SetHost(GetDefaultHost(), true);
	SetPort(GetDefaultPort(), true);
	SetUser(GetDefaultUser(), true);
	SetPassword(GetDefaultPassword(), true);
	SetDatabase(GetDefaultDatabase(), true);
	SetInstanceName(GetDefaultInstanceName(), true);
	SetInstanceDescription(GetDefaultInstanceDescription(), true);
	SetSslMode(GetDefaultSslMode(), true);
	SetSslKey(GetDefaultSslKey(), true);
	SetSslCert(GetDefaultSslCert(), true);
	SetSslCa(GetDefaultSslCa(), true);
}

ObjectImpl<IdoPgsqlConnection>::~ObjectImpl()
{ }

void ObjectImpl<IdoPgsqlConnection>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	int real_id = id - DbConnection::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { DbConnection::SetField(id, value, suppress_events, cookie); return; }
	switch (real_id) {
		case 0:
			SetHost(value, suppress_events, cookie);
			break;
		case 1:
			SetPort(value, suppress_events, cookie);
			break;
		case 2:
			SetUser(value, suppress_events, cookie);
			break;
		case 3:
			SetPassword(value, suppress_events, cookie);
			break;
		case 4:
			SetDatabase(value, suppress_events, cookie);
			break;
		case 5:
			SetInstanceName(value, suppress_events, cookie);
			break;
		case 6:
			SetInstanceDescription(value, suppress_events, cookie);
			break;
		case 7:
			SetSslMode(value, suppress_events, cookie);
			break;
		case 8:
			SetSslKey(value, suppress_events, cookie);
			break;
		case 9:
			SetSslCert(value, suppress_events, cookie);
			break;
		case 10:
			SetSslCa(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<IdoPgsqlConnection>::GetField(int id) const
{
	int real_id = id - DbConnection::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return DbConnection::GetField(id); }
	switch (real_id) {
		case 0:
			return GetHost();
		case 1:
			return GetPort();
		case 2:
			return GetUser();
		case 3:
			return GetPassword();
		case 4:
			return GetDatabase();
		case 5:
			return GetInstanceName();
		case 6:
			return GetInstanceDescription();
		case 7:
			return GetSslMode();
		case 8:
			return GetSslKey();
		case 9:
			return GetSslCert();
		case 10:
			return GetSslCa();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<IdoPgsqlConnection>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	int real_id = id - DbConnection::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { DbConnection::ValidateField(id, lvalue, utils); return; }
	switch (real_id) {
		case 0:
			ValidateHost(lvalue, utils);
			break;
		case 1:
			ValidatePort(lvalue, utils);
			break;
		case 2:
			ValidateUser(lvalue, utils);
			break;
		case 3:
			ValidatePassword(lvalue, utils);
			break;
		case 4:
			ValidateDatabase(lvalue, utils);
			break;
		case 5:
			ValidateInstanceName(lvalue, utils);
			break;
		case 6:
			ValidateInstanceDescription(lvalue, utils);
			break;
		case 7:
			ValidateSslMode(lvalue, utils);
			break;
		case 8:
			ValidateSslKey(lvalue, utils);
			break;
		case 9:
			ValidateSslCert(lvalue, utils);
			break;
		case 10:
			ValidateSslCa(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<IdoPgsqlConnection>::NotifyField(int id, const Value& cookie)
{
	int real_id = id - DbConnection::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { DbConnection::NotifyField(id, cookie); return; }
	switch (real_id) {
		case 0:
			NotifyHost(cookie);
			break;
		case 1:
			NotifyPort(cookie);
			break;
		case 2:
			NotifyUser(cookie);
			break;
		case 3:
			NotifyPassword(cookie);
			break;
		case 4:
			NotifyDatabase(cookie);
			break;
		case 5:
			NotifyInstanceName(cookie);
			break;
		case 6:
			NotifyInstanceDescription(cookie);
			break;
		case 7:
			NotifySslMode(cookie);
			break;
		case 8:
			NotifySslKey(cookie);
			break;
		case 9:
			NotifySslCert(cookie);
			break;
		case 10:
			NotifySslCa(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<IdoPgsqlConnection>::NavigateField(int id) const
{
	int real_id = id - DbConnection::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return DbConnection::NavigateField(id); }
	throw std::runtime_error("Invalid field ID.");
}

String ObjectImpl<IdoPgsqlConnection>::GetHost() const
{
	return m_Host.load();
}

String ObjectImpl<IdoPgsqlConnection>::GetPort() const
{
	return m_Port.load();
}

String ObjectImpl<IdoPgsqlConnection>::GetUser() const
{
	return m_User.load();
}

String ObjectImpl<IdoPgsqlConnection>::GetPassword() const
{
	return m_Password.load();
}

String ObjectImpl<IdoPgsqlConnection>::GetDatabase() const
{
	return m_Database.load();
}

String ObjectImpl<IdoPgsqlConnection>::GetInstanceName() const
{
	return m_InstanceName.load();
}

String ObjectImpl<IdoPgsqlConnection>::GetInstanceDescription() const
{
	return m_InstanceDescription.load();
}

String ObjectImpl<IdoPgsqlConnection>::GetSslMode() const
{
	return m_SslMode.load();
}

String ObjectImpl<IdoPgsqlConnection>::GetSslKey() const
{
	return m_SslKey.load();
}

String ObjectImpl<IdoPgsqlConnection>::GetSslCert() const
{
	return m_SslCert.load();
}

String ObjectImpl<IdoPgsqlConnection>::GetSslCa() const
{
	return m_SslCa.load();
}

void ObjectImpl<IdoPgsqlConnection>::SetHost(const String& value, bool suppress_events, const Value& cookie)
{
	m_Host.store(value);
	if (!suppress_events) {
		NotifyHost(cookie);
	}

}

void ObjectImpl<IdoPgsqlConnection>::SetPort(const String& value, bool suppress_events, const Value& cookie)
{
	m_Port.store(value);
	if (!suppress_events) {
		NotifyPort(cookie);
	}

}

void ObjectImpl<IdoPgsqlConnection>::SetUser(const String& value, bool suppress_events, const Value& cookie)
{
	m_User.store(value);
	if (!suppress_events) {
		NotifyUser(cookie);
	}

}

void ObjectImpl<IdoPgsqlConnection>::SetPassword(const String& value, bool suppress_events, const Value& cookie)
{
	m_Password.store(value);
	if (!suppress_events) {
		NotifyPassword(cookie);
	}

}

void ObjectImpl<IdoPgsqlConnection>::SetDatabase(const String& value, bool suppress_events, const Value& cookie)
{
	m_Database.store(value);
	if (!suppress_events) {
		NotifyDatabase(cookie);
	}

}

void ObjectImpl<IdoPgsqlConnection>::SetInstanceName(const String& value, bool suppress_events, const Value& cookie)
{
	m_InstanceName.store(value);
	if (!suppress_events) {
		NotifyInstanceName(cookie);
	}

}

void ObjectImpl<IdoPgsqlConnection>::SetInstanceDescription(const String& value, bool suppress_events, const Value& cookie)
{
	m_InstanceDescription.store(value);
	if (!suppress_events) {
		NotifyInstanceDescription(cookie);
	}

}

void ObjectImpl<IdoPgsqlConnection>::SetSslMode(const String& value, bool suppress_events, const Value& cookie)
{
	m_SslMode.store(value);
	if (!suppress_events) {
		NotifySslMode(cookie);
	}

}

void ObjectImpl<IdoPgsqlConnection>::SetSslKey(const String& value, bool suppress_events, const Value& cookie)
{
	m_SslKey.store(value);
	if (!suppress_events) {
		NotifySslKey(cookie);
	}

}

void ObjectImpl<IdoPgsqlConnection>::SetSslCert(const String& value, bool suppress_events, const Value& cookie)
{
	m_SslCert.store(value);
	if (!suppress_events) {
		NotifySslCert(cookie);
	}

}

void ObjectImpl<IdoPgsqlConnection>::SetSslCa(const String& value, bool suppress_events, const Value& cookie)
{
	m_SslCa.store(value);
	if (!suppress_events) {
		NotifySslCa(cookie);
	}

}

void ObjectImpl<IdoPgsqlConnection>::NotifyHost(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnHostChanged(static_cast<IdoPgsqlConnection *>(this), cookie);
}

void ObjectImpl<IdoPgsqlConnection>::NotifyPort(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPortChanged(static_cast<IdoPgsqlConnection *>(this), cookie);
}

void ObjectImpl<IdoPgsqlConnection>::NotifyUser(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnUserChanged(static_cast<IdoPgsqlConnection *>(this), cookie);
}

void ObjectImpl<IdoPgsqlConnection>::NotifyPassword(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPasswordChanged(static_cast<IdoPgsqlConnection *>(this), cookie);
}

void ObjectImpl<IdoPgsqlConnection>::NotifyDatabase(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnDatabaseChanged(static_cast<IdoPgsqlConnection *>(this), cookie);
}

void ObjectImpl<IdoPgsqlConnection>::NotifyInstanceName(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnInstanceNameChanged(static_cast<IdoPgsqlConnection *>(this), cookie);
}

void ObjectImpl<IdoPgsqlConnection>::NotifyInstanceDescription(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnInstanceDescriptionChanged(static_cast<IdoPgsqlConnection *>(this), cookie);
}

void ObjectImpl<IdoPgsqlConnection>::NotifySslMode(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSslModeChanged(static_cast<IdoPgsqlConnection *>(this), cookie);
}

void ObjectImpl<IdoPgsqlConnection>::NotifySslKey(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSslKeyChanged(static_cast<IdoPgsqlConnection *>(this), cookie);
}

void ObjectImpl<IdoPgsqlConnection>::NotifySslCert(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSslCertChanged(static_cast<IdoPgsqlConnection *>(this), cookie);
}

void ObjectImpl<IdoPgsqlConnection>::NotifySslCa(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSslCaChanged(static_cast<IdoPgsqlConnection *>(this), cookie);
}

String ObjectImpl<IdoPgsqlConnection>::GetDefaultHost() const
{
	 return "localhost"; 
}

String ObjectImpl<IdoPgsqlConnection>::GetDefaultPort() const
{
	 return "5432"; 
}

String ObjectImpl<IdoPgsqlConnection>::GetDefaultUser() const
{
	 return "icinga"; 
}

String ObjectImpl<IdoPgsqlConnection>::GetDefaultPassword() const
{
	 return "icinga"; 
}

String ObjectImpl<IdoPgsqlConnection>::GetDefaultDatabase() const
{
	 return "icinga"; 
}

String ObjectImpl<IdoPgsqlConnection>::GetDefaultInstanceName() const
{
	 return "default"; 
}

String ObjectImpl<IdoPgsqlConnection>::GetDefaultInstanceDescription() const
{
	return String();
}

String ObjectImpl<IdoPgsqlConnection>::GetDefaultSslMode() const
{
	return String();
}

String ObjectImpl<IdoPgsqlConnection>::GetDefaultSslKey() const
{
	return String();
}

String ObjectImpl<IdoPgsqlConnection>::GetDefaultSslCert() const
{
	return String();
}

String ObjectImpl<IdoPgsqlConnection>::GetDefaultSslCa() const
{
	return String();
}


boost::signals2::signal<void (const intrusive_ptr<IdoPgsqlConnection>&, const Value&)> ObjectImpl<IdoPgsqlConnection>::OnHostChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoPgsqlConnection>&, const Value&)> ObjectImpl<IdoPgsqlConnection>::OnPortChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoPgsqlConnection>&, const Value&)> ObjectImpl<IdoPgsqlConnection>::OnUserChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoPgsqlConnection>&, const Value&)> ObjectImpl<IdoPgsqlConnection>::OnPasswordChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoPgsqlConnection>&, const Value&)> ObjectImpl<IdoPgsqlConnection>::OnDatabaseChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoPgsqlConnection>&, const Value&)> ObjectImpl<IdoPgsqlConnection>::OnInstanceNameChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoPgsqlConnection>&, const Value&)> ObjectImpl<IdoPgsqlConnection>::OnInstanceDescriptionChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoPgsqlConnection>&, const Value&)> ObjectImpl<IdoPgsqlConnection>::OnSslModeChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoPgsqlConnection>&, const Value&)> ObjectImpl<IdoPgsqlConnection>::OnSslKeyChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoPgsqlConnection>&, const Value&)> ObjectImpl<IdoPgsqlConnection>::OnSslCertChanged;


boost::signals2::signal<void (const intrusive_ptr<IdoPgsqlConnection>&, const Value&)> ObjectImpl<IdoPgsqlConnection>::OnSslCaChanged;

void ObjectImpl<IdoPgsqlConnection>::ValidateDatabase(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateDatabase(lvalue, utils);
}

void ObjectImpl<IdoPgsqlConnection>::ValidateHost(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateHost(lvalue, utils);
}

void ObjectImpl<IdoPgsqlConnection>::ValidateInstanceDescription(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateInstanceDescription(lvalue, utils);
}

void ObjectImpl<IdoPgsqlConnection>::ValidateInstanceName(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateInstanceName(lvalue, utils);
}

void ObjectImpl<IdoPgsqlConnection>::ValidatePassword(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePassword(lvalue, utils);
}

void ObjectImpl<IdoPgsqlConnection>::ValidatePort(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePort(lvalue, utils);
}

void ObjectImpl<IdoPgsqlConnection>::ValidateSslCa(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSslCa(lvalue, utils);
}

void ObjectImpl<IdoPgsqlConnection>::ValidateSslCert(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSslCert(lvalue, utils);
}

void ObjectImpl<IdoPgsqlConnection>::ValidateSslKey(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSslKey(lvalue, utils);
}

void ObjectImpl<IdoPgsqlConnection>::ValidateSslMode(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSslMode(lvalue, utils);
}

void ObjectImpl<IdoPgsqlConnection>::ValidateUser(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateUser(lvalue, utils);
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
