#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<CheckCommand>::TypeImpl()
{ }

TypeImpl<CheckCommand>::~TypeImpl()
{ }

String TypeImpl<CheckCommand>::GetName() const
{
	return "CheckCommand";
}

int TypeImpl<CheckCommand>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<CheckCommand>::GetBaseType() const
{
	return Command::TypeInstance;
}

int TypeImpl<CheckCommand>::GetFieldId(const String& name) const
{

	return Command::TypeInstance->GetFieldId(name);
}

Field TypeImpl<CheckCommand>::GetFieldInfo(int id) const
{
	int real_id = id - Command::TypeInstance->GetFieldCount();
	if (real_id < 0) { return Command::TypeInstance->GetFieldInfo(id); }
	throw std::runtime_error("Invalid field ID.");
}

int TypeImpl<CheckCommand>::GetFieldCount() const
{
	return 0 + Command::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<CheckCommand>::GetFactory() const
{
	return TypeHelper<CheckCommand, false>::GetFactory();
}

int TypeImpl<CheckCommand>::GetActivationPriority() const
{
	return 0;
}

void TypeImpl<CheckCommand>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - Command::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { Command::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	throw std::runtime_error("Invalid field ID.");
}

void ObjectImpl<CheckCommand>::Validate(int types, const ValidationUtils& utils)
{
	Command::Validate(types, utils);

}

ObjectImpl<CheckCommand>::ObjectImpl()
{
}

ObjectImpl<CheckCommand>::~ObjectImpl()
{ }

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
