#ifndef CHECKCOMMAND_TI
#define CHECKCOMMAND_TI

#include "base/object.hpp"
#include "base/type.hpp"
#include "base/value.hpp"
#include "base/array.hpp"
#include "base/atomic.hpp"
#include "base/dictionary.hpp"
#include <boost/signals2.hpp>

#include "icinga/command.hpp"

namespace icinga
{

class CheckCommand;

template<>
class TypeImpl<CheckCommand> : public TypeImpl<Command>
{
public:
	DECLARE_PTR_TYPEDEFS(TypeImpl<CheckCommand>);

	TypeImpl();
	~TypeImpl() override;

	String GetName() const override;
	int GetAttributes() const override;
	Type::Ptr GetBaseType() const override;
	int GetFieldId(const String& name) const override;
	Field GetFieldInfo(int id) const override;
	int GetFieldCount() const override;
	ObjectFactory GetFactory() const override;
	int GetActivationPriority() const override;
public:
	void RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback) override;
};


template<>
class ObjectImpl<CheckCommand> : public Command
{
public:
	DECLARE_PTR_TYPEDEFS(ObjectImpl<CheckCommand>);

	void Validate(int types, const ValidationUtils& utils) override;
public:
	ObjectImpl<CheckCommand>();
public:
	~ObjectImpl<CheckCommand>() override;
};

}
#endif /* CHECKCOMMAND_TI */
