#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<CheckResult>::TypeImpl()
{ }

TypeImpl<CheckResult>::~TypeImpl()
{ }

String TypeImpl<CheckResult>::GetName() const
{
	return "CheckResult";
}

int TypeImpl<CheckResult>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<CheckResult>::GetBaseType() const
{
	return Object::TypeInstance;
}

int TypeImpl<CheckResult>::GetFieldId(const String& name) const
{
	int offset = 0;

	switch (static_cast<int>(Utility::SDBM(name, 3))) {
		case 807860402:
			if (name == "active")
				return offset + 14;

			break;
		case 824711392:
			if (name == "check_source")
				return offset + 2;

			break;
		case 825170593:
			if (name == "command")
				return offset + 0;

			break;
		case 842283986:
			if (name == "execution_start")
				return offset + 12;
			if (name == "execution_end")
				return offset + 13;

			break;
		case 842283990:
			if (name == "exit_status")
				return offset + 15;

			break;
		case 924702254:
			if (name == "output")
				return offset + 1;

			break;
		case 931914173:
			if (name == "performance_data")
				return offset + 5;

			break;
		case 932766947:
			if (name == "previous_hard_state")
				return offset + 9;

			break;
		case 956567480:
			if (name == "scheduling_source")
				return offset + 3;
			if (name == "schedule_start")
				return offset + 10;
			if (name == "schedule_end")
				return offset + 11;

			break;
		case 957682656:
			if (name == "state")
				return offset + 8;

			break;
		case 965944172:
			if (name == "ttl")
				return offset + 4;

			break;
		case 981220807:
			if (name == "vars_before")
				return offset + 6;
			if (name == "vars_after")
				return offset + 7;

			break;
	}

	return -1;
}

Field TypeImpl<CheckResult>::GetFieldInfo(int id) const
{
	switch (id) {
		case 0:
			return {0, "Value", "command", "command", nullptr, 4, 0};
		case 1:
			return {1, "String", "output", "output", nullptr, 4, 0};
		case 2:
			return {2, "String", "check_source", "check_source", nullptr, 4, 0};
		case 3:
			return {3, "String", "scheduling_source", "scheduling_source", nullptr, 4, 0};
		case 4:
			return {4, "Number", "ttl", "ttl", nullptr, 4, 0};
		case 5:
			return {5, "Array", "performance_data", "performance_data", nullptr, 4, 0};
		case 6:
			return {6, "Dictionary", "vars_before", "vars_before", nullptr, 4, 0};
		case 7:
			return {7, "Dictionary", "vars_after", "vars_after", nullptr, 4, 0};
		case 8:
			return {8, "Number", "state", "state", nullptr, 12, 0};
		case 9:
			return {9, "Number", "previous_hard_state", "previous_hard_state", nullptr, 12, 0};
		case 10:
			return {10, "Timestamp", "schedule_start", "schedule_start", nullptr, 4, 0};
		case 11:
			return {11, "Timestamp", "schedule_end", "schedule_end", nullptr, 4, 0};
		case 12:
			return {12, "Timestamp", "execution_start", "execution_start", nullptr, 4, 0};
		case 13:
			return {13, "Timestamp", "execution_end", "execution_end", nullptr, 4, 0};
		case 14:
			return {14, "Boolean", "active", "active", nullptr, 4, 0};
		case 15:
			return {15, "int_fast64_t", "exit_status", "exit_status", nullptr, 4, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<CheckResult>::GetFieldCount() const
{
	return 16;
}

ObjectFactory TypeImpl<CheckResult>::GetFactory() const
{
	return TypeHelper<CheckResult, false>::GetFactory();
}

int TypeImpl<CheckResult>::GetActivationPriority() const
{
	return 0;
}

void TypeImpl<CheckResult>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	switch (fieldId) {
		case 0:
			ObjectImpl<CheckResult>::OnCommandChanged.connect(callback);
			break;
		case 1:
			ObjectImpl<CheckResult>::OnOutputChanged.connect(callback);
			break;
		case 2:
			ObjectImpl<CheckResult>::OnCheckSourceChanged.connect(callback);
			break;
		case 3:
			ObjectImpl<CheckResult>::OnSchedulingSourceChanged.connect(callback);
			break;
		case 4:
			ObjectImpl<CheckResult>::OnTtlChanged.connect(callback);
			break;
		case 5:
			ObjectImpl<CheckResult>::OnPerformanceDataChanged.connect(callback);
			break;
		case 6:
			ObjectImpl<CheckResult>::OnVarsBeforeChanged.connect(callback);
			break;
		case 7:
			ObjectImpl<CheckResult>::OnVarsAfterChanged.connect(callback);
			break;
		case 8:
			ObjectImpl<CheckResult>::OnStateChanged.connect(callback);
			break;
		case 9:
			ObjectImpl<CheckResult>::OnPreviousHardStateChanged.connect(callback);
			break;
		case 10:
			ObjectImpl<CheckResult>::OnScheduleStartChanged.connect(callback);
			break;
		case 11:
			ObjectImpl<CheckResult>::OnScheduleEndChanged.connect(callback);
			break;
		case 12:
			ObjectImpl<CheckResult>::OnExecutionStartChanged.connect(callback);
			break;
		case 13:
			ObjectImpl<CheckResult>::OnExecutionEndChanged.connect(callback);
			break;
		case 14:
			ObjectImpl<CheckResult>::OnActiveChanged.connect(callback);
			break;
		case 15:
			ObjectImpl<CheckResult>::OnExitStatusChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<CheckResult>::Validate(int types, const ValidationUtils& utils)
{
	if (4 & types)
		ValidateCommand(Lazy<Value>([this]() { return GetCommand(); }), utils);
	if (4 & types)
		ValidateOutput(Lazy<String>([this]() { return GetOutput(); }), utils);
	if (4 & types)
		ValidateCheckSource(Lazy<String>([this]() { return GetCheckSource(); }), utils);
	if (4 & types)
		ValidateSchedulingSource(Lazy<String>([this]() { return GetSchedulingSource(); }), utils);
	if (4 & types)
		ValidateTtl(Lazy<double>([this]() { return GetTtl(); }), utils);
	if (4 & types)
		ValidatePerformanceData(Lazy<Array::Ptr>([this]() { return GetPerformanceData(); }), utils);
	if (4 & types)
		ValidateVarsBefore(Lazy<Dictionary::Ptr>([this]() { return GetVarsBefore(); }), utils);
	if (4 & types)
		ValidateVarsAfter(Lazy<Dictionary::Ptr>([this]() { return GetVarsAfter(); }), utils);
	if (4 & types)
		ValidateState(Lazy<ServiceState>([this]() { return GetState(); }), utils);
	if (4 & types)
		ValidatePreviousHardState(Lazy<ServiceState>([this]() { return GetPreviousHardState(); }), utils);
	if (4 & types)
		ValidateScheduleStart(Lazy<Timestamp>([this]() { return GetScheduleStart(); }), utils);
	if (4 & types)
		ValidateScheduleEnd(Lazy<Timestamp>([this]() { return GetScheduleEnd(); }), utils);
	if (4 & types)
		ValidateExecutionStart(Lazy<Timestamp>([this]() { return GetExecutionStart(); }), utils);
	if (4 & types)
		ValidateExecutionEnd(Lazy<Timestamp>([this]() { return GetExecutionEnd(); }), utils);
	if (4 & types)
		ValidateActive(Lazy<bool>([this]() { return GetActive(); }), utils);
	if (4 & types)
		ValidateExitStatus(Lazy<int_fast64_t>([this]() { return GetExitStatus(); }), utils);
}

void ObjectImpl<CheckResult>::SimpleValidateCommand(const Lazy<Value>& value, const ValidationUtils& utils)
{
	if (value().IsObjectType<Function>()) {
		Function::Ptr func = value();
		if (func->IsDeprecated())
			Log(LogWarning, "CheckResult") << "Attribute 'command' for object '" << dynamic_cast<ConfigObject *>(this)->GetName() << "' of type '" << dynamic_cast<ConfigObject *>(this)->GetReflectionType()->GetName() << "' is set to a deprecated function: " << func->GetName();
	}

}

void ObjectImpl<CheckResult>::SimpleValidateOutput(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<CheckResult>::SimpleValidateCheckSource(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<CheckResult>::SimpleValidateSchedulingSource(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<CheckResult>::SimpleValidateTtl(const Lazy<double>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<CheckResult>::SimpleValidatePerformanceData(const Lazy<Array::Ptr>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<CheckResult>::SimpleValidateVarsBefore(const Lazy<Dictionary::Ptr>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<CheckResult>::SimpleValidateVarsAfter(const Lazy<Dictionary::Ptr>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<CheckResult>::SimpleValidateState(const Lazy<ServiceState>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<CheckResult>::SimpleValidatePreviousHardState(const Lazy<ServiceState>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<CheckResult>::SimpleValidateScheduleStart(const Lazy<Timestamp>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<CheckResult>::SimpleValidateScheduleEnd(const Lazy<Timestamp>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<CheckResult>::SimpleValidateExecutionStart(const Lazy<Timestamp>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<CheckResult>::SimpleValidateExecutionEnd(const Lazy<Timestamp>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<CheckResult>::SimpleValidateActive(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<CheckResult>::SimpleValidateExitStatus(const Lazy<int_fast64_t>& value, const ValidationUtils& utils)
{
}

ObjectImpl<CheckResult>::ObjectImpl()
{
	SetCommand(GetDefaultCommand(), true);
	SetOutput(GetDefaultOutput(), true);
	SetCheckSource(GetDefaultCheckSource(), true);
	SetSchedulingSource(GetDefaultSchedulingSource(), true);
	SetTtl(GetDefaultTtl(), true);
	SetPerformanceData(GetDefaultPerformanceData(), true);
	SetVarsBefore(GetDefaultVarsBefore(), true);
	SetVarsAfter(GetDefaultVarsAfter(), true);
	SetState(GetDefaultState(), true);
	SetPreviousHardState(GetDefaultPreviousHardState(), true);
	SetScheduleStart(GetDefaultScheduleStart(), true);
	SetScheduleEnd(GetDefaultScheduleEnd(), true);
	SetExecutionStart(GetDefaultExecutionStart(), true);
	SetExecutionEnd(GetDefaultExecutionEnd(), true);
	SetActive(GetDefaultActive(), true);
	SetExitStatus(GetDefaultExitStatus(), true);
}

ObjectImpl<CheckResult>::~ObjectImpl()
{ }

void ObjectImpl<CheckResult>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	switch (id) {
		case 0:
			SetCommand(value, suppress_events, cookie);
			break;
		case 1:
			SetOutput(value, suppress_events, cookie);
			break;
		case 2:
			SetCheckSource(value, suppress_events, cookie);
			break;
		case 3:
			SetSchedulingSource(value, suppress_events, cookie);
			break;
		case 4:
			SetTtl(value, suppress_events, cookie);
			break;
		case 5:
			SetPerformanceData(value, suppress_events, cookie);
			break;
		case 6:
			SetVarsBefore(value, suppress_events, cookie);
			break;
		case 7:
			SetVarsAfter(value, suppress_events, cookie);
			break;
		case 8:
			SetState(static_cast<ServiceState>(static_cast<int>(value)), suppress_events, cookie);
			break;
		case 9:
			SetPreviousHardState(static_cast<ServiceState>(static_cast<int>(value)), suppress_events, cookie);
			break;
		case 10:
			SetScheduleStart(value, suppress_events, cookie);
			break;
		case 11:
			SetScheduleEnd(value, suppress_events, cookie);
			break;
		case 12:
			SetExecutionStart(value, suppress_events, cookie);
			break;
		case 13:
			SetExecutionEnd(value, suppress_events, cookie);
			break;
		case 14:
			SetActive(value, suppress_events, cookie);
			break;
		case 15:
			SetExitStatus(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<CheckResult>::GetField(int id) const
{
	switch (id) {
		case 0:
			return GetCommand();
		case 1:
			return GetOutput();
		case 2:
			return GetCheckSource();
		case 3:
			return GetSchedulingSource();
		case 4:
			return GetTtl();
		case 5:
			return GetPerformanceData();
		case 6:
			return GetVarsBefore();
		case 7:
			return GetVarsAfter();
		case 8:
			return GetState();
		case 9:
			return GetPreviousHardState();
		case 10:
			return GetScheduleStart();
		case 11:
			return GetScheduleEnd();
		case 12:
			return GetExecutionStart();
		case 13:
			return GetExecutionEnd();
		case 14:
			return GetActive();
		case 15:
			return GetExitStatus();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<CheckResult>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	switch (id) {
		case 0:
			ValidateCommand(lvalue, utils);
			break;
		case 1:
			ValidateOutput(lvalue, utils);
			break;
		case 2:
			ValidateCheckSource(lvalue, utils);
			break;
		case 3:
			ValidateSchedulingSource(lvalue, utils);
			break;
		case 4:
			ValidateTtl(lvalue, utils);
			break;
		case 5:
			ValidatePerformanceData(lvalue, utils);
			break;
		case 6:
			ValidateVarsBefore(lvalue, utils);
			break;
		case 7:
			ValidateVarsAfter(lvalue, utils);
			break;
		case 8:
			ValidateState(static_cast<Lazy<ServiceState> >(static_cast<Lazy<int> >(lvalue)), utils);
			break;
		case 9:
			ValidatePreviousHardState(static_cast<Lazy<ServiceState> >(static_cast<Lazy<int> >(lvalue)), utils);
			break;
		case 10:
			ValidateScheduleStart(lvalue, utils);
			break;
		case 11:
			ValidateScheduleEnd(lvalue, utils);
			break;
		case 12:
			ValidateExecutionStart(lvalue, utils);
			break;
		case 13:
			ValidateExecutionEnd(lvalue, utils);
			break;
		case 14:
			ValidateActive(lvalue, utils);
			break;
		case 15:
			ValidateExitStatus(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<CheckResult>::NotifyField(int id, const Value& cookie)
{
	switch (id) {
		case 0:
			NotifyCommand(cookie);
			break;
		case 1:
			NotifyOutput(cookie);
			break;
		case 2:
			NotifyCheckSource(cookie);
			break;
		case 3:
			NotifySchedulingSource(cookie);
			break;
		case 4:
			NotifyTtl(cookie);
			break;
		case 5:
			NotifyPerformanceData(cookie);
			break;
		case 6:
			NotifyVarsBefore(cookie);
			break;
		case 7:
			NotifyVarsAfter(cookie);
			break;
		case 8:
			NotifyState(cookie);
			break;
		case 9:
			NotifyPreviousHardState(cookie);
			break;
		case 10:
			NotifyScheduleStart(cookie);
			break;
		case 11:
			NotifyScheduleEnd(cookie);
			break;
		case 12:
			NotifyExecutionStart(cookie);
			break;
		case 13:
			NotifyExecutionEnd(cookie);
			break;
		case 14:
			NotifyActive(cookie);
			break;
		case 15:
			NotifyExitStatus(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<CheckResult>::NavigateField(int id) const
{
	throw std::runtime_error("Invalid field ID.");
}

Value ObjectImpl<CheckResult>::GetCommand() const
{
	return m_Command.load();
}

String ObjectImpl<CheckResult>::GetOutput() const
{
	return m_Output.load();
}

String ObjectImpl<CheckResult>::GetCheckSource() const
{
	return m_CheckSource.load();
}

String ObjectImpl<CheckResult>::GetSchedulingSource() const
{
	return m_SchedulingSource.load();
}

double ObjectImpl<CheckResult>::GetTtl() const
{
	return m_Ttl.load();
}

Array::Ptr ObjectImpl<CheckResult>::GetPerformanceData() const
{
	return m_PerformanceData.load();
}

Dictionary::Ptr ObjectImpl<CheckResult>::GetVarsBefore() const
{
	return m_VarsBefore.load();
}

Dictionary::Ptr ObjectImpl<CheckResult>::GetVarsAfter() const
{
	return m_VarsAfter.load();
}

ServiceState ObjectImpl<CheckResult>::GetState() const
{
	return m_State.load();
}

ServiceState ObjectImpl<CheckResult>::GetPreviousHardState() const
{
	return m_PreviousHardState.load();
}

Timestamp ObjectImpl<CheckResult>::GetScheduleStart() const
{
	return m_ScheduleStart.load();
}

Timestamp ObjectImpl<CheckResult>::GetScheduleEnd() const
{
	return m_ScheduleEnd.load();
}

Timestamp ObjectImpl<CheckResult>::GetExecutionStart() const
{
	return m_ExecutionStart.load();
}

Timestamp ObjectImpl<CheckResult>::GetExecutionEnd() const
{
	return m_ExecutionEnd.load();
}

bool ObjectImpl<CheckResult>::GetActive() const
{
	return m_Active.load();
}

int_fast64_t ObjectImpl<CheckResult>::GetExitStatus() const
{
	return m_ExitStatus.load();
}

void ObjectImpl<CheckResult>::SetCommand(const Value& value, bool suppress_events, const Value& cookie)
{
	m_Command.store(value);
	if (!suppress_events) {
		NotifyCommand(cookie);
	}

}

void ObjectImpl<CheckResult>::SetOutput(const String& value, bool suppress_events, const Value& cookie)
{
	m_Output.store(value);
	if (!suppress_events) {
		NotifyOutput(cookie);
	}

}

void ObjectImpl<CheckResult>::SetCheckSource(const String& value, bool suppress_events, const Value& cookie)
{
	m_CheckSource.store(value);
	if (!suppress_events) {
		NotifyCheckSource(cookie);
	}

}

void ObjectImpl<CheckResult>::SetSchedulingSource(const String& value, bool suppress_events, const Value& cookie)
{
	m_SchedulingSource.store(value);
	if (!suppress_events) {
		NotifySchedulingSource(cookie);
	}

}

void ObjectImpl<CheckResult>::SetTtl(double value, bool suppress_events, const Value& cookie)
{
	m_Ttl.store(value);
	if (!suppress_events) {
		NotifyTtl(cookie);
	}

}

void ObjectImpl<CheckResult>::SetPerformanceData(const Array::Ptr& value, bool suppress_events, const Value& cookie)
{
	m_PerformanceData.store(value);
	if (!suppress_events) {
		NotifyPerformanceData(cookie);
	}

}

void ObjectImpl<CheckResult>::SetVarsBefore(const Dictionary::Ptr& value, bool suppress_events, const Value& cookie)
{
	m_VarsBefore.store(value);
	if (!suppress_events) {
		NotifyVarsBefore(cookie);
	}

}

void ObjectImpl<CheckResult>::SetVarsAfter(const Dictionary::Ptr& value, bool suppress_events, const Value& cookie)
{
	m_VarsAfter.store(value);
	if (!suppress_events) {
		NotifyVarsAfter(cookie);
	}

}

void ObjectImpl<CheckResult>::SetState(const ServiceState& value, bool suppress_events, const Value& cookie)
{
	m_State.store(value);
	if (!suppress_events) {
		NotifyState(cookie);
	}

}

void ObjectImpl<CheckResult>::SetPreviousHardState(const ServiceState& value, bool suppress_events, const Value& cookie)
{
	m_PreviousHardState.store(value);
	if (!suppress_events) {
		NotifyPreviousHardState(cookie);
	}

}

void ObjectImpl<CheckResult>::SetScheduleStart(const Timestamp& value, bool suppress_events, const Value& cookie)
{
	m_ScheduleStart.store(value);
	if (!suppress_events) {
		NotifyScheduleStart(cookie);
	}

}

void ObjectImpl<CheckResult>::SetScheduleEnd(const Timestamp& value, bool suppress_events, const Value& cookie)
{
	m_ScheduleEnd.store(value);
	if (!suppress_events) {
		NotifyScheduleEnd(cookie);
	}

}

void ObjectImpl<CheckResult>::SetExecutionStart(const Timestamp& value, bool suppress_events, const Value& cookie)
{
	m_ExecutionStart.store(value);
	if (!suppress_events) {
		NotifyExecutionStart(cookie);
	}

}

void ObjectImpl<CheckResult>::SetExecutionEnd(const Timestamp& value, bool suppress_events, const Value& cookie)
{
	m_ExecutionEnd.store(value);
	if (!suppress_events) {
		NotifyExecutionEnd(cookie);
	}

}

void ObjectImpl<CheckResult>::SetActive(bool value, bool suppress_events, const Value& cookie)
{
	m_Active.store(value);
	if (!suppress_events) {
		NotifyActive(cookie);
	}

}

void ObjectImpl<CheckResult>::SetExitStatus(const int_fast64_t& value, bool suppress_events, const Value& cookie)
{
	m_ExitStatus.store(value);
	if (!suppress_events) {
		NotifyExitStatus(cookie);
	}

}

void ObjectImpl<CheckResult>::NotifyCommand(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCommandChanged(static_cast<CheckResult *>(this), cookie);
}

void ObjectImpl<CheckResult>::NotifyOutput(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnOutputChanged(static_cast<CheckResult *>(this), cookie);
}

void ObjectImpl<CheckResult>::NotifyCheckSource(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCheckSourceChanged(static_cast<CheckResult *>(this), cookie);
}

void ObjectImpl<CheckResult>::NotifySchedulingSource(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSchedulingSourceChanged(static_cast<CheckResult *>(this), cookie);
}

void ObjectImpl<CheckResult>::NotifyTtl(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnTtlChanged(static_cast<CheckResult *>(this), cookie);
}

void ObjectImpl<CheckResult>::NotifyPerformanceData(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPerformanceDataChanged(static_cast<CheckResult *>(this), cookie);
}

void ObjectImpl<CheckResult>::NotifyVarsBefore(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnVarsBeforeChanged(static_cast<CheckResult *>(this), cookie);
}

void ObjectImpl<CheckResult>::NotifyVarsAfter(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnVarsAfterChanged(static_cast<CheckResult *>(this), cookie);
}

void ObjectImpl<CheckResult>::NotifyState(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnStateChanged(static_cast<CheckResult *>(this), cookie);
}

void ObjectImpl<CheckResult>::NotifyPreviousHardState(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPreviousHardStateChanged(static_cast<CheckResult *>(this), cookie);
}

void ObjectImpl<CheckResult>::NotifyScheduleStart(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnScheduleStartChanged(static_cast<CheckResult *>(this), cookie);
}

void ObjectImpl<CheckResult>::NotifyScheduleEnd(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnScheduleEndChanged(static_cast<CheckResult *>(this), cookie);
}

void ObjectImpl<CheckResult>::NotifyExecutionStart(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnExecutionStartChanged(static_cast<CheckResult *>(this), cookie);
}

void ObjectImpl<CheckResult>::NotifyExecutionEnd(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnExecutionEndChanged(static_cast<CheckResult *>(this), cookie);
}

void ObjectImpl<CheckResult>::NotifyActive(const Value& cookie)
{
	OnActiveChanged(static_cast<CheckResult *>(this), cookie);
}

void ObjectImpl<CheckResult>::NotifyExitStatus(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnExitStatusChanged(static_cast<CheckResult *>(this), cookie);
}

Value ObjectImpl<CheckResult>::GetDefaultCommand() const
{
	return Value();
}

String ObjectImpl<CheckResult>::GetDefaultOutput() const
{
	return String();
}

String ObjectImpl<CheckResult>::GetDefaultCheckSource() const
{
	return String();
}

String ObjectImpl<CheckResult>::GetDefaultSchedulingSource() const
{
	return String();
}

double ObjectImpl<CheckResult>::GetDefaultTtl() const
{
	return double();
}

Array::Ptr ObjectImpl<CheckResult>::GetDefaultPerformanceData() const
{
	return Array::Ptr();
}

Dictionary::Ptr ObjectImpl<CheckResult>::GetDefaultVarsBefore() const
{
	return Dictionary::Ptr();
}

Dictionary::Ptr ObjectImpl<CheckResult>::GetDefaultVarsAfter() const
{
	return Dictionary::Ptr();
}

ServiceState ObjectImpl<CheckResult>::GetDefaultState() const
{
	return ServiceState();
}

ServiceState ObjectImpl<CheckResult>::GetDefaultPreviousHardState() const
{
	return ServiceState();
}

Timestamp ObjectImpl<CheckResult>::GetDefaultScheduleStart() const
{
	return Timestamp();
}

Timestamp ObjectImpl<CheckResult>::GetDefaultScheduleEnd() const
{
	return Timestamp();
}

Timestamp ObjectImpl<CheckResult>::GetDefaultExecutionStart() const
{
	return Timestamp();
}

Timestamp ObjectImpl<CheckResult>::GetDefaultExecutionEnd() const
{
	return Timestamp();
}

bool ObjectImpl<CheckResult>::GetDefaultActive() const
{
	 return true; 
}

int_fast64_t ObjectImpl<CheckResult>::GetDefaultExitStatus() const
{
	return int_fast64_t();
}


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnCommandChanged;


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnOutputChanged;


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnCheckSourceChanged;


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnSchedulingSourceChanged;


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnTtlChanged;


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnPerformanceDataChanged;


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnVarsBeforeChanged;


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnVarsAfterChanged;


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnStateChanged;


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnPreviousHardStateChanged;


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnScheduleStartChanged;


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnScheduleEndChanged;


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnExecutionStartChanged;


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnExecutionEndChanged;


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnActiveChanged;


boost::signals2::signal<void (const intrusive_ptr<CheckResult>&, const Value&)> ObjectImpl<CheckResult>::OnExitStatusChanged;

void ObjectImpl<CheckResult>::ValidateActive(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateActive(lvalue, utils);
}

void ObjectImpl<CheckResult>::ValidateCheckSource(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCheckSource(lvalue, utils);
}

void ObjectImpl<CheckResult>::ValidateCommand(const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCommand(lvalue, utils);
}

void ObjectImpl<CheckResult>::ValidateExecutionEnd(const Lazy<Timestamp>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateExecutionEnd(lvalue, utils);
}

void ObjectImpl<CheckResult>::ValidateExecutionStart(const Lazy<Timestamp>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateExecutionStart(lvalue, utils);
}

void ObjectImpl<CheckResult>::ValidateExitStatus(const Lazy<int_fast64_t>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateExitStatus(lvalue, utils);
}

void ObjectImpl<CheckResult>::ValidateOutput(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateOutput(lvalue, utils);
}

void ObjectImpl<CheckResult>::ValidatePerformanceData(const Lazy<Array::Ptr>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePerformanceData(lvalue, utils);
}

void ObjectImpl<CheckResult>::ValidatePreviousHardState(const Lazy<ServiceState>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePreviousHardState(lvalue, utils);
}

void ObjectImpl<CheckResult>::ValidateScheduleEnd(const Lazy<Timestamp>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateScheduleEnd(lvalue, utils);
}

void ObjectImpl<CheckResult>::ValidateScheduleStart(const Lazy<Timestamp>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateScheduleStart(lvalue, utils);
}

void ObjectImpl<CheckResult>::ValidateSchedulingSource(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSchedulingSource(lvalue, utils);
}

void ObjectImpl<CheckResult>::ValidateState(const Lazy<ServiceState>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateState(lvalue, utils);
}

void ObjectImpl<CheckResult>::ValidateTtl(const Lazy<double>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateTtl(lvalue, utils);
}

void ObjectImpl<CheckResult>::ValidateVarsAfter(const Lazy<Dictionary::Ptr>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateVarsAfter(lvalue, utils);
}

void ObjectImpl<CheckResult>::ValidateVarsBefore(const Lazy<Dictionary::Ptr>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateVarsBefore(lvalue, utils);
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
