#ifndef CUSTOMVAROBJECT_TI
#define CUSTOMVAROBJECT_TI

#include "base/object.hpp"
#include "base/type.hpp"
#include "base/value.hpp"
#include "base/array.hpp"
#include "base/atomic.hpp"
#include "base/dictionary.hpp"
#include <boost/signals2.hpp>

#include "base/configobject.hpp"

namespace icinga
{

class CustomVarObject;

template<>
struct TypeHelper<CustomVarObject, false>
{
	static ObjectFactory GetFactory()
	{
		return nullptr;
	}
};

template<>
class TypeImpl<CustomVarObject> : public TypeImpl<ConfigObject>
{
public:
	DECLARE_PTR_TYPEDEFS(TypeImpl<CustomVarObject>);

	TypeImpl();
	~TypeImpl() override;

	String GetName() const override;
	int GetAttributes() const override;
	Type::Ptr GetBaseType() const override;
	int GetFieldId(const String& name) const override;
	Field GetFieldInfo(int id) const override;
	int GetFieldCount() const override;
	ObjectFactory GetFactory() const override;
	int GetActivationPriority() const override;
public:
	void RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback) override;
};


template<>
class ObjectImpl<CustomVarObject> : public ConfigObject
{
public:
	DECLARE_PTR_TYPEDEFS(ObjectImpl<CustomVarObject>);

	void Validate(int types, const ValidationUtils& utils) override;
	void SimpleValidateVars(const Lazy<Dictionary::Ptr>& value, const ValidationUtils& utils);
public:
	ObjectImpl<CustomVarObject>();
public:
	~ObjectImpl<CustomVarObject>() override;
public:
	void SetField(int id, const Value& value, bool suppress_events = false, const Value& cookie = Empty) override;
public:
	Value GetField(int id) const override;
public:
	void ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils) override;
public:
	void NotifyField(int id, const Value& cookie = Empty) override;
public:
	Object::Ptr NavigateField(int id) const override;
public:
	Dictionary::Ptr GetVars() const;
public:
	void SetVars(const Dictionary::Ptr& value, bool suppress_events = false, const Value& cookie = Empty);
protected:
public:
	virtual void NotifyVars(const Value& cookie = Empty);
private:
	inline Dictionary::Ptr GetDefaultVars() const;
protected:
	virtual void ValidateVars(const Lazy<Dictionary::Ptr>& lvalue, const ValidationUtils& utils);
private:
	AtomicOrLocked<Dictionary::Ptr> m_Vars;
public:
	static boost::signals2::signal<void (const intrusive_ptr<CustomVarObject>&, const Value&)> OnVarsChanged;
	static boost::signals2::signal<void (const intrusive_ptr<CustomVarObject>&, const Value&, const Value&)> OnVarsChangedWithOldValue;
};

}
#endif /* CUSTOMVAROBJECT_TI */
