#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<EventCommand>::TypeImpl()
{ }

TypeImpl<EventCommand>::~TypeImpl()
{ }

String TypeImpl<EventCommand>::GetName() const
{
	return "EventCommand";
}

int TypeImpl<EventCommand>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<EventCommand>::GetBaseType() const
{
	return Command::TypeInstance;
}

int TypeImpl<EventCommand>::GetFieldId(const String& name) const
{

	return Command::TypeInstance->GetFieldId(name);
}

Field TypeImpl<EventCommand>::GetFieldInfo(int id) const
{
	int real_id = id - Command::TypeInstance->GetFieldCount();
	if (real_id < 0) { return Command::TypeInstance->GetFieldInfo(id); }
	throw std::runtime_error("Invalid field ID.");
}

int TypeImpl<EventCommand>::GetFieldCount() const
{
	return 0 + Command::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<EventCommand>::GetFactory() const
{
	return TypeHelper<EventCommand, false>::GetFactory();
}

int TypeImpl<EventCommand>::GetActivationPriority() const
{
	return 0;
}

void TypeImpl<EventCommand>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - Command::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { Command::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	throw std::runtime_error("Invalid field ID.");
}

void ObjectImpl<EventCommand>::Validate(int types, const ValidationUtils& utils)
{
	Command::Validate(types, utils);

}

ObjectImpl<EventCommand>::ObjectImpl()
{
}

ObjectImpl<EventCommand>::~ObjectImpl()
{ }

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
