#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<NotificationCommand>::TypeImpl()
{ }

TypeImpl<NotificationCommand>::~TypeImpl()
{ }

String TypeImpl<NotificationCommand>::GetName() const
{
	return "NotificationCommand";
}

int TypeImpl<NotificationCommand>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<NotificationCommand>::GetBaseType() const
{
	return Command::TypeInstance;
}

int TypeImpl<NotificationCommand>::GetFieldId(const String& name) const
{

	return Command::TypeInstance->GetFieldId(name);
}

Field TypeImpl<NotificationCommand>::GetFieldInfo(int id) const
{
	int real_id = id - Command::TypeInstance->GetFieldCount();
	if (real_id < 0) { return Command::TypeInstance->GetFieldInfo(id); }
	throw std::runtime_error("Invalid field ID.");
}

int TypeImpl<NotificationCommand>::GetFieldCount() const
{
	return 0 + Command::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<NotificationCommand>::GetFactory() const
{
	return TypeHelper<NotificationCommand, false>::GetFactory();
}

int TypeImpl<NotificationCommand>::GetActivationPriority() const
{
	return 0;
}

void TypeImpl<NotificationCommand>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - Command::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { Command::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	throw std::runtime_error("Invalid field ID.");
}

void ObjectImpl<NotificationCommand>::Validate(int types, const ValidationUtils& utils)
{
	Command::Validate(types, utils);

}

ObjectImpl<NotificationCommand>::ObjectImpl()
{
}

ObjectImpl<NotificationCommand>::~ObjectImpl()
{ }

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
