#ifndef NOTIFICATIONCOMMAND_TI
#define NOTIFICATIONCOMMAND_TI

#include "base/object.hpp"
#include "base/type.hpp"
#include "base/value.hpp"
#include "base/array.hpp"
#include "base/atomic.hpp"
#include "base/dictionary.hpp"
#include <boost/signals2.hpp>

#include "icinga/command.hpp"

namespace icinga
{

class NotificationCommand;

template<>
class TypeImpl<NotificationCommand> : public TypeImpl<Command>
{
public:
	DECLARE_PTR_TYPEDEFS(TypeImpl<NotificationCommand>);

	TypeImpl();
	~TypeImpl() override;

	String GetName() const override;
	int GetAttributes() const override;
	Type::Ptr GetBaseType() const override;
	int GetFieldId(const String& name) const override;
	Field GetFieldInfo(int id) const override;
	int GetFieldCount() const override;
	ObjectFactory GetFactory() const override;
	int GetActivationPriority() const override;
public:
	void RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback) override;
};


template<>
class ObjectImpl<NotificationCommand> : public Command
{
public:
	DECLARE_PTR_TYPEDEFS(ObjectImpl<NotificationCommand>);

	void Validate(int types, const ValidationUtils& utils) override;
public:
	ObjectImpl<NotificationCommand>();
public:
	~ObjectImpl<NotificationCommand>() override;
};

}
#endif /* NOTIFICATIONCOMMAND_TI */
