#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<UserGroup>::TypeImpl()
{ }

TypeImpl<UserGroup>::~TypeImpl()
{ }

String TypeImpl<UserGroup>::GetName() const
{
	return "UserGroup";
}

int TypeImpl<UserGroup>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<UserGroup>::GetBaseType() const
{
	return CustomVarObject::TypeInstance;
}

int TypeImpl<UserGroup>::GetFieldId(const String& name) const
{
	int offset = CustomVarObject::TypeInstance->GetFieldCount();

	switch (static_cast<int>(Utility::SDBM(name, 1))) {
		case 100:
			if (name == "display_name")
				return offset + 0;

			break;
		case 103:
			if (name == "groups")
				return offset + 1;

			break;
	}

	return CustomVarObject::TypeInstance->GetFieldId(name);
}

Field TypeImpl<UserGroup>::GetFieldInfo(int id) const
{
	int real_id = id - CustomVarObject::TypeInstance->GetFieldCount();
	if (real_id < 0) { return CustomVarObject::TypeInstance->GetFieldInfo(id); }
	switch (real_id) {
		case 0:
			return {0, "String", "display_name", "display_name", nullptr, 2, 0};
		case 1:
			return {1, "Array", "groups", "groups", "UserGroup", 1026, 1};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<UserGroup>::GetFieldCount() const
{
	return 2 + CustomVarObject::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<UserGroup>::GetFactory() const
{
	return TypeHelper<UserGroup, false>::GetFactory();
}

int TypeImpl<UserGroup>::GetActivationPriority() const
{
	return 0;
}

void TypeImpl<UserGroup>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - CustomVarObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { CustomVarObject::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	switch (real_id) {
		case 0:
			ObjectImpl<UserGroup>::OnDisplayNameChanged.connect(callback);
			break;
		case 1:
			ObjectImpl<UserGroup>::OnGroupsChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<UserGroup>::Validate(int types, const ValidationUtils& utils)
{
	CustomVarObject::Validate(types, utils);

	if (2 & types)
		ValidateDisplayName(Lazy<String>([this]() { return GetDisplayName(); }), utils);
	if (2 & types)
		ValidateGroups(Lazy<Array::Ptr>([this]() { return GetGroups(); }), utils);
}

void ObjectImpl<UserGroup>::SimpleValidateDisplayName(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<UserGroup>::SimpleValidateGroups(const Lazy<Array::Ptr>& avalue, const ValidationUtils& utils)
{
	if (avalue()) {
		ObjectLock olock(avalue());
		for (const Value& value : avalue()) {
			if (!value.IsEmpty() && !value.IsString())
				BOOST_THROW_EXCEPTION(ValidationError(dynamic_cast<ConfigObject *>(this), { "groups" }, "It is not allowed to specify '" + value + "' of type '" + value.GetTypeName() + "' as 'UserGroup' name. Expected type of 'UserGroup' name: 'String'."));
			if (value.IsEmpty() || !utils.ValidateName("UserGroup", value))
				BOOST_THROW_EXCEPTION(ValidationError(dynamic_cast<ConfigObject *>(this), { "groups" }, "Object '" + value + "' of type 'UserGroup' does not exist."));
		}
	}
}

ObjectImpl<UserGroup>::ObjectImpl()
{
	SetDisplayName(GetDefaultDisplayName(), true);
	SetGroups(GetDefaultGroups(), true);
}

ObjectImpl<UserGroup>::~ObjectImpl()
{ }

void ObjectImpl<UserGroup>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	int real_id = id - CustomVarObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { CustomVarObject::SetField(id, value, suppress_events, cookie); return; }
	switch (real_id) {
		case 0:
			SetDisplayName(value, suppress_events, cookie);
			break;
		case 1:
			SetGroups(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<UserGroup>::GetField(int id) const
{
	int real_id = id - CustomVarObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return CustomVarObject::GetField(id); }
	switch (real_id) {
		case 0:
			return GetDisplayName();
		case 1:
			return GetGroups();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<UserGroup>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	int real_id = id - CustomVarObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { CustomVarObject::ValidateField(id, lvalue, utils); return; }
	switch (real_id) {
		case 0:
			ValidateDisplayName(lvalue, utils);
			break;
		case 1:
			ValidateGroups(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<UserGroup>::NotifyField(int id, const Value& cookie)
{
	int real_id = id - CustomVarObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { CustomVarObject::NotifyField(id, cookie); return; }
	switch (real_id) {
		case 0:
			NotifyDisplayName(cookie);
			break;
		case 1:
			NotifyGroups(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<UserGroup>::NavigateField(int id) const
{
	int real_id = id - CustomVarObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return CustomVarObject::NavigateField(id); }
	throw std::runtime_error("Invalid field ID.");
}

String ObjectImpl<UserGroup>::GetDisplayName() const
{

			String displayName = m_DisplayName.load();
			if (displayName.IsEmpty())
				return GetName();
			else
				return displayName;
		
}

Array::Ptr ObjectImpl<UserGroup>::GetGroups() const
{
	return m_Groups.load();
}

void ObjectImpl<UserGroup>::SetDisplayName(const String& value, bool suppress_events, const Value& cookie)
{
	m_DisplayName.store(value);
	if (!suppress_events) {
		NotifyDisplayName(cookie);
	}

}

void ObjectImpl<UserGroup>::SetGroups(const Array::Ptr& value, bool suppress_events, const Value& cookie)
{
	Value oldValue = GetGroups();
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	m_Groups.store(value);
	if (!dobj || dobj->IsActive())
		TrackGroups(oldValue, value);
	if (!suppress_events) {
		NotifyGroups(cookie);
	}

}

void ObjectImpl<UserGroup>::TrackGroups(const Array::Ptr& oldValue, const Array::Ptr& newValue)
{
	if (oldValue) {
		ObjectLock olock(oldValue);
		for (auto& ref : oldValue) {
			DependencyGraph::RemoveDependency(this, ConfigObject::GetObject<UserGroup>(ref).get());
		}
	}
	if (newValue) {
		ObjectLock olock(newValue);
		for (auto& ref : newValue) {
			DependencyGraph::AddDependency(this, ConfigObject::GetObject<UserGroup>(ref).get());
		}
	}
}

void ObjectImpl<UserGroup>::Start(bool runtimeCreated)
{
	CustomVarObject::Start(runtimeCreated);

	TrackGroups(Empty, GetGroups());
}

void ObjectImpl<UserGroup>::Stop(bool runtimeRemoved)
{
	CustomVarObject::Stop(runtimeRemoved);

	TrackGroups(GetGroups(), Empty);
}

void ObjectImpl<UserGroup>::NotifyDisplayName(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnDisplayNameChanged(static_cast<UserGroup *>(this), cookie);
}

void ObjectImpl<UserGroup>::NotifyGroups(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnGroupsChanged(static_cast<UserGroup *>(this), cookie);
}

String ObjectImpl<UserGroup>::GetDefaultDisplayName() const
{
	return String();
}

Array::Ptr ObjectImpl<UserGroup>::GetDefaultGroups() const
{
	return Array::Ptr();
}


boost::signals2::signal<void (const intrusive_ptr<UserGroup>&, const Value&)> ObjectImpl<UserGroup>::OnDisplayNameChanged;


boost::signals2::signal<void (const intrusive_ptr<UserGroup>&, const Value&)> ObjectImpl<UserGroup>::OnGroupsChanged;

void ObjectImpl<UserGroup>::ValidateDisplayName(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateDisplayName(lvalue, utils);
}

void ObjectImpl<UserGroup>::ValidateGroups(const Lazy<Array::Ptr>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateGroups(lvalue, utils);
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
