#ifndef USERGROUP_TI
#define USERGROUP_TI

#include "base/object.hpp"
#include "base/type.hpp"
#include "base/value.hpp"
#include "base/array.hpp"
#include "base/atomic.hpp"
#include "base/dictionary.hpp"
#include <boost/signals2.hpp>

#include "icinga/customvarobject.hpp"

namespace icinga
{

class UserGroup;

template<>
class TypeImpl<UserGroup> : public TypeImpl<CustomVarObject>
{
public:
	DECLARE_PTR_TYPEDEFS(TypeImpl<UserGroup>);

	TypeImpl();
	~TypeImpl() override;

	String GetName() const override;
	int GetAttributes() const override;
	Type::Ptr GetBaseType() const override;
	int GetFieldId(const String& name) const override;
	Field GetFieldInfo(int id) const override;
	int GetFieldCount() const override;
	ObjectFactory GetFactory() const override;
	int GetActivationPriority() const override;
public:
	void RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback) override;
};


template<>
class ObjectImpl<UserGroup> : public CustomVarObject
{
public:
	DECLARE_PTR_TYPEDEFS(ObjectImpl<UserGroup>);

	void Validate(int types, const ValidationUtils& utils) override;
	void SimpleValidateDisplayName(const Lazy<String>& value, const ValidationUtils& utils);
	void SimpleValidateGroups(const Lazy<Array::Ptr>& avalue, const ValidationUtils& utils);
public:
	ObjectImpl<UserGroup>();
public:
	~ObjectImpl<UserGroup>() override;
public:
	void SetField(int id, const Value& value, bool suppress_events = false, const Value& cookie = Empty) override;
public:
	Value GetField(int id) const override;
public:
	void ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils) override;
public:
	void NotifyField(int id, const Value& cookie = Empty) override;
public:
	Object::Ptr NavigateField(int id) const override;
public:
	String GetDisplayName() const;
public:
	Array::Ptr GetGroups() const;
public:
	void SetDisplayName(const String& value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetGroups(const Array::Ptr& value, bool suppress_events = false, const Value& cookie = Empty);
protected:
	void TrackGroups(const Array::Ptr& oldValue, const Array::Ptr& newValue);
protected:
	void Start(bool runtimeCreated = false) override;
	void Stop(bool runtimeRemoved = false) override;
public:
	virtual void NotifyDisplayName(const Value& cookie = Empty);
public:
	virtual void NotifyGroups(const Value& cookie = Empty);
private:
	inline String GetDefaultDisplayName() const;
private:
	inline Array::Ptr GetDefaultGroups() const;
protected:
	virtual void ValidateDisplayName(const Lazy<String>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateGroups(const Lazy<Array::Ptr>& lvalue, const ValidationUtils& utils);
private:
	AtomicOrLocked<String> m_DisplayName;
	AtomicOrLocked<Array::Ptr> m_Groups;
public:
	static boost::signals2::signal<void (const intrusive_ptr<UserGroup>&, const Value&)> OnDisplayNameChanged;
	static boost::signals2::signal<void (const intrusive_ptr<UserGroup>&, const Value&)> OnGroupsChanged;
};

}
#endif /* USERGROUP_TI */
