#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<IcingaDB>::TypeImpl()
{ }

TypeImpl<IcingaDB>::~TypeImpl()
{ }

String TypeImpl<IcingaDB>::GetName() const
{
	return "IcingaDB";
}

int TypeImpl<IcingaDB>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<IcingaDB>::GetBaseType() const
{
	return ConfigObject::TypeInstance;
}

int TypeImpl<IcingaDB>::GetFieldId(const String& name) const
{
	int offset = ConfigObject::TypeInstance->GetFieldCount();

	switch (static_cast<int>(Utility::SDBM(name, 2))) {
		case 6494398:
			if (name == "ca_path")
				return offset + 6;

			break;
		case 6494402:
			if (name == "cert_path")
				return offset + 4;

			break;
		case 6494406:
			if (name == "cipher_list")
				return offset + 8;

			break;
		case 6494412:
			if (name == "connect_timeout")
				return offset + 14;

			break;
		case 6494415:
			if (name == "crl_path")
				return offset + 7;

			break;
		case 6559998:
			if (name == "db_index")
				return offset + 15;

			break;
		case 6625609:
			if (name == "environment_id")
				return offset + 10;
			if (name == "enable_tls")
				return offset + 17;

			break;
		case 6822407:
			if (name == "host")
				return offset + 0;

			break;
		case 6888005:
			if (name == "insecure_noverify")
				return offset + 18;

			break;
		case 7019194:
			if (name == "key_path")
				return offset + 5;

			break;
		case 7084789:
			if (name == "lastdump_took")
				return offset + 11;
			if (name == "lastdump_end")
				return offset + 12;

			break;
		case 7281599:
			if (name == "ongoing_dump_start")
				return offset + 13;

			break;
		case 7347185:
			if (name == "path")
				return offset + 1;
			if (name == "password")
				return offset + 3;

			break;
		case 7347199:
			if (name == "port")
				return offset + 16;

			break;
		case 7609592:
			if (name == "tls_protocolmin")
				return offset + 9;

			break;
		case 7675198:
			if (name == "username")
				return offset + 2;

			break;
	}

	return ConfigObject::TypeInstance->GetFieldId(name);
}

Field TypeImpl<IcingaDB>::GetFieldInfo(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount();
	if (real_id < 0) { return ConfigObject::TypeInstance->GetFieldInfo(id); }
	switch (real_id) {
		case 0:
			return {0, "String", "host", "host", nullptr, 1026, 0};
		case 1:
			return {1, "String", "path", "path", nullptr, 1026, 0};
		case 2:
			return {2, "String", "username", "username", nullptr, 1026, 0};
		case 3:
			return {3, "String", "password", "password", nullptr, 3074, 0};
		case 4:
			return {4, "String", "cert_path", "cert_path", nullptr, 1026, 0};
		case 5:
			return {5, "String", "key_path", "key_path", nullptr, 1026, 0};
		case 6:
			return {6, "String", "ca_path", "ca_path", nullptr, 1026, 0};
		case 7:
			return {7, "String", "crl_path", "crl_path", nullptr, 1026, 0};
		case 8:
			return {8, "String", "cipher_list", "cipher_list", nullptr, 1026, 0};
		case 9:
			return {9, "String", "tls_protocolmin", "tls_protocolmin", nullptr, 1026, 0};
		case 10:
			return {10, "String", "environment_id", "environment_id", nullptr, 65, 0};
		case 11:
			return {11, "Number", "lastdump_took", "lastdump_took", nullptr, 36, 0};
		case 12:
			return {12, "Number", "lastdump_end", "lastdump_end", nullptr, 36, 0};
		case 13:
			return {13, "Number", "ongoing_dump_start", "ongoing_dump_start", nullptr, 33, 0};
		case 14:
			return {14, "Number", "connect_timeout", "connect_timeout", nullptr, 1026, 0};
		case 15:
			return {15, "Number", "db_index", "db_index", nullptr, 1026, 0};
		case 16:
			return {16, "Number", "port", "port", nullptr, 1026, 0};
		case 17:
			return {17, "Boolean", "enable_tls", "enable_tls", nullptr, 1026, 0};
		case 18:
			return {18, "Boolean", "insecure_noverify", "insecure_noverify", nullptr, 1026, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<IcingaDB>::GetFieldCount() const
{
	return 19 + ConfigObject::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<IcingaDB>::GetFactory() const
{
	return TypeHelper<IcingaDB, false>::GetFactory();
}

int TypeImpl<IcingaDB>::GetActivationPriority() const
{
	return 100;
}

void TypeImpl<IcingaDB>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	switch (real_id) {
		case 0:
			ObjectImpl<IcingaDB>::OnHostChanged.connect(callback);
			break;
		case 1:
			ObjectImpl<IcingaDB>::OnPathChanged.connect(callback);
			break;
		case 2:
			ObjectImpl<IcingaDB>::OnUsernameChanged.connect(callback);
			break;
		case 3:
			ObjectImpl<IcingaDB>::OnPasswordChanged.connect(callback);
			break;
		case 4:
			ObjectImpl<IcingaDB>::OnCertPathChanged.connect(callback);
			break;
		case 5:
			ObjectImpl<IcingaDB>::OnKeyPathChanged.connect(callback);
			break;
		case 6:
			ObjectImpl<IcingaDB>::OnCaPathChanged.connect(callback);
			break;
		case 7:
			ObjectImpl<IcingaDB>::OnCrlPathChanged.connect(callback);
			break;
		case 8:
			ObjectImpl<IcingaDB>::OnCipherListChanged.connect(callback);
			break;
		case 9:
			ObjectImpl<IcingaDB>::OnTlsProtocolminChanged.connect(callback);
			break;
		case 10:
			ObjectImpl<IcingaDB>::OnEnvironmentIdChanged.connect(callback);
			break;
		case 11:
			ObjectImpl<IcingaDB>::OnLastdumpTookChanged.connect(callback);
			break;
		case 12:
			ObjectImpl<IcingaDB>::OnLastdumpEndChanged.connect(callback);
			break;
		case 13:
			ObjectImpl<IcingaDB>::OnOngoingDumpStartChanged.connect(callback);
			break;
		case 14:
			ObjectImpl<IcingaDB>::OnConnectTimeoutChanged.connect(callback);
			break;
		case 15:
			ObjectImpl<IcingaDB>::OnDbIndexChanged.connect(callback);
			break;
		case 16:
			ObjectImpl<IcingaDB>::OnPortChanged.connect(callback);
			break;
		case 17:
			ObjectImpl<IcingaDB>::OnEnableTlsChanged.connect(callback);
			break;
		case 18:
			ObjectImpl<IcingaDB>::OnInsecureNoverifyChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<IcingaDB>::Validate(int types, const ValidationUtils& utils)
{
	ConfigObject::Validate(types, utils);

	if (2 & types)
		ValidateHost(Lazy<String>([this]() { return GetHost(); }), utils);
	if (2 & types)
		ValidatePath(Lazy<String>([this]() { return GetPath(); }), utils);
	if (2 & types)
		ValidateUsername(Lazy<String>([this]() { return GetUsername(); }), utils);
	if (2 & types)
		ValidatePassword(Lazy<String>([this]() { return GetPassword(); }), utils);
	if (2 & types)
		ValidateCertPath(Lazy<String>([this]() { return GetCertPath(); }), utils);
	if (2 & types)
		ValidateKeyPath(Lazy<String>([this]() { return GetKeyPath(); }), utils);
	if (2 & types)
		ValidateCaPath(Lazy<String>([this]() { return GetCaPath(); }), utils);
	if (2 & types)
		ValidateCrlPath(Lazy<String>([this]() { return GetCrlPath(); }), utils);
	if (2 & types)
		ValidateCipherList(Lazy<String>([this]() { return GetCipherList(); }), utils);
	if (2 & types)
		ValidateTlsProtocolmin(Lazy<String>([this]() { return GetTlsProtocolmin(); }), utils);
	if (1 & types)
		ValidateEnvironmentId(Lazy<String>([this]() { return GetEnvironmentId(); }), utils);
	if (4 & types)
		ValidateLastdumpTook(Lazy<double>([this]() { return GetLastdumpTook(); }), utils);
	if (4 & types)
		ValidateLastdumpEnd(Lazy<double>([this]() { return GetLastdumpEnd(); }), utils);
	if (1 & types)
		ValidateOngoingDumpStart(Lazy<double>([this]() { return GetOngoingDumpStart(); }), utils);
	if (2 & types)
		ValidateConnectTimeout(Lazy<double>([this]() { return GetConnectTimeout(); }), utils);
	if (2 & types)
		ValidateDbIndex(Lazy<int>([this]() { return GetDbIndex(); }), utils);
	if (2 & types)
		ValidatePort(Lazy<int>([this]() { return GetPort(); }), utils);
	if (2 & types)
		ValidateEnableTls(Lazy<bool>([this]() { return GetEnableTls(); }), utils);
	if (2 & types)
		ValidateInsecureNoverify(Lazy<bool>([this]() { return GetInsecureNoverify(); }), utils);
}

void ObjectImpl<IcingaDB>::SimpleValidateHost(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidatePath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidateUsername(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidatePassword(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidateCertPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidateKeyPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidateCaPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidateCrlPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidateCipherList(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidateTlsProtocolmin(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidateEnvironmentId(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidateLastdumpTook(const Lazy<double>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidateLastdumpEnd(const Lazy<double>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidateOngoingDumpStart(const Lazy<double>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidateConnectTimeout(const Lazy<double>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidateDbIndex(const Lazy<int>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidatePort(const Lazy<int>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidateEnableTls(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<IcingaDB>::SimpleValidateInsecureNoverify(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

ObjectImpl<IcingaDB>::ObjectImpl()
{
	SetHost(GetDefaultHost(), true);
	SetPath(GetDefaultPath(), true);
	SetUsername(GetDefaultUsername(), true);
	SetPassword(GetDefaultPassword(), true);
	SetCertPath(GetDefaultCertPath(), true);
	SetKeyPath(GetDefaultKeyPath(), true);
	SetCaPath(GetDefaultCaPath(), true);
	SetCrlPath(GetDefaultCrlPath(), true);
	SetCipherList(GetDefaultCipherList(), true);
	SetTlsProtocolmin(GetDefaultTlsProtocolmin(), true);
	SetEnvironmentId(GetDefaultEnvironmentId(), true);
	SetLastdumpTook(GetDefaultLastdumpTook(), true);
	SetLastdumpEnd(GetDefaultLastdumpEnd(), true);
	SetOngoingDumpStart(GetDefaultOngoingDumpStart(), true);
	SetConnectTimeout(GetDefaultConnectTimeout(), true);
	SetDbIndex(GetDefaultDbIndex(), true);
	SetPort(GetDefaultPort(), true);
	SetEnableTls(GetDefaultEnableTls(), true);
	SetInsecureNoverify(GetDefaultInsecureNoverify(), true);
}

ObjectImpl<IcingaDB>::~ObjectImpl()
{ }

void ObjectImpl<IcingaDB>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::SetField(id, value, suppress_events, cookie); return; }
	switch (real_id) {
		case 0:
			SetHost(value, suppress_events, cookie);
			break;
		case 1:
			SetPath(value, suppress_events, cookie);
			break;
		case 2:
			SetUsername(value, suppress_events, cookie);
			break;
		case 3:
			SetPassword(value, suppress_events, cookie);
			break;
		case 4:
			SetCertPath(value, suppress_events, cookie);
			break;
		case 5:
			SetKeyPath(value, suppress_events, cookie);
			break;
		case 6:
			SetCaPath(value, suppress_events, cookie);
			break;
		case 7:
			SetCrlPath(value, suppress_events, cookie);
			break;
		case 8:
			SetCipherList(value, suppress_events, cookie);
			break;
		case 9:
			SetTlsProtocolmin(value, suppress_events, cookie);
			break;
		case 10:
			SetEnvironmentId(value, suppress_events, cookie);
			break;
		case 11:
			SetLastdumpTook(value, suppress_events, cookie);
			break;
		case 12:
			SetLastdumpEnd(value, suppress_events, cookie);
			break;
		case 13:
			SetOngoingDumpStart(value, suppress_events, cookie);
			break;
		case 14:
			SetConnectTimeout(value, suppress_events, cookie);
			break;
		case 15:
			SetDbIndex(value, suppress_events, cookie);
			break;
		case 16:
			SetPort(value, suppress_events, cookie);
			break;
		case 17:
			SetEnableTls(value, suppress_events, cookie);
			break;
		case 18:
			SetInsecureNoverify(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<IcingaDB>::GetField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::GetField(id); }
	switch (real_id) {
		case 0:
			return GetHost();
		case 1:
			return GetPath();
		case 2:
			return GetUsername();
		case 3:
			return GetPassword();
		case 4:
			return GetCertPath();
		case 5:
			return GetKeyPath();
		case 6:
			return GetCaPath();
		case 7:
			return GetCrlPath();
		case 8:
			return GetCipherList();
		case 9:
			return GetTlsProtocolmin();
		case 10:
			return GetEnvironmentId();
		case 11:
			return GetLastdumpTook();
		case 12:
			return GetLastdumpEnd();
		case 13:
			return GetOngoingDumpStart();
		case 14:
			return GetConnectTimeout();
		case 15:
			return GetDbIndex();
		case 16:
			return GetPort();
		case 17:
			return GetEnableTls();
		case 18:
			return GetInsecureNoverify();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<IcingaDB>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::ValidateField(id, lvalue, utils); return; }
	switch (real_id) {
		case 0:
			ValidateHost(lvalue, utils);
			break;
		case 1:
			ValidatePath(lvalue, utils);
			break;
		case 2:
			ValidateUsername(lvalue, utils);
			break;
		case 3:
			ValidatePassword(lvalue, utils);
			break;
		case 4:
			ValidateCertPath(lvalue, utils);
			break;
		case 5:
			ValidateKeyPath(lvalue, utils);
			break;
		case 6:
			ValidateCaPath(lvalue, utils);
			break;
		case 7:
			ValidateCrlPath(lvalue, utils);
			break;
		case 8:
			ValidateCipherList(lvalue, utils);
			break;
		case 9:
			ValidateTlsProtocolmin(lvalue, utils);
			break;
		case 10:
			ValidateEnvironmentId(lvalue, utils);
			break;
		case 11:
			ValidateLastdumpTook(lvalue, utils);
			break;
		case 12:
			ValidateLastdumpEnd(lvalue, utils);
			break;
		case 13:
			ValidateOngoingDumpStart(lvalue, utils);
			break;
		case 14:
			ValidateConnectTimeout(lvalue, utils);
			break;
		case 15:
			ValidateDbIndex(lvalue, utils);
			break;
		case 16:
			ValidatePort(lvalue, utils);
			break;
		case 17:
			ValidateEnableTls(lvalue, utils);
			break;
		case 18:
			ValidateInsecureNoverify(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<IcingaDB>::NotifyField(int id, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::NotifyField(id, cookie); return; }
	switch (real_id) {
		case 0:
			NotifyHost(cookie);
			break;
		case 1:
			NotifyPath(cookie);
			break;
		case 2:
			NotifyUsername(cookie);
			break;
		case 3:
			NotifyPassword(cookie);
			break;
		case 4:
			NotifyCertPath(cookie);
			break;
		case 5:
			NotifyKeyPath(cookie);
			break;
		case 6:
			NotifyCaPath(cookie);
			break;
		case 7:
			NotifyCrlPath(cookie);
			break;
		case 8:
			NotifyCipherList(cookie);
			break;
		case 9:
			NotifyTlsProtocolmin(cookie);
			break;
		case 10:
			NotifyEnvironmentId(cookie);
			break;
		case 11:
			NotifyLastdumpTook(cookie);
			break;
		case 12:
			NotifyLastdumpEnd(cookie);
			break;
		case 13:
			NotifyOngoingDumpStart(cookie);
			break;
		case 14:
			NotifyConnectTimeout(cookie);
			break;
		case 15:
			NotifyDbIndex(cookie);
			break;
		case 16:
			NotifyPort(cookie);
			break;
		case 17:
			NotifyEnableTls(cookie);
			break;
		case 18:
			NotifyInsecureNoverify(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<IcingaDB>::NavigateField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::NavigateField(id); }
	throw std::runtime_error("Invalid field ID.");
}

String ObjectImpl<IcingaDB>::GetHost() const
{
	return m_Host.load();
}

String ObjectImpl<IcingaDB>::GetPath() const
{
	return m_Path.load();
}

String ObjectImpl<IcingaDB>::GetUsername() const
{
	return m_Username.load();
}

String ObjectImpl<IcingaDB>::GetPassword() const
{
	return m_Password.load();
}

String ObjectImpl<IcingaDB>::GetCertPath() const
{
	return m_CertPath.load();
}

String ObjectImpl<IcingaDB>::GetKeyPath() const
{
	return m_KeyPath.load();
}

String ObjectImpl<IcingaDB>::GetCaPath() const
{
	return m_CaPath.load();
}

String ObjectImpl<IcingaDB>::GetCrlPath() const
{
	return m_CrlPath.load();
}

String ObjectImpl<IcingaDB>::GetCipherList() const
{
	return m_CipherList.load();
}

String ObjectImpl<IcingaDB>::GetTlsProtocolmin() const
{
	return m_TlsProtocolmin.load();
}

double ObjectImpl<IcingaDB>::GetLastdumpTook() const
{
	return m_LastdumpTook.load();
}

double ObjectImpl<IcingaDB>::GetLastdumpEnd() const
{
	return m_LastdumpEnd.load();
}

double ObjectImpl<IcingaDB>::GetOngoingDumpStart() const
{
	return m_OngoingDumpStart.load();
}

double ObjectImpl<IcingaDB>::GetConnectTimeout() const
{
	return m_ConnectTimeout.load();
}

int ObjectImpl<IcingaDB>::GetDbIndex() const
{
	return m_DbIndex.load();
}

int ObjectImpl<IcingaDB>::GetPort() const
{
	return m_Port.load();
}

bool ObjectImpl<IcingaDB>::GetEnableTls() const
{
	return m_EnableTls.load();
}

bool ObjectImpl<IcingaDB>::GetInsecureNoverify() const
{
	return m_InsecureNoverify.load();
}

void ObjectImpl<IcingaDB>::SetHost(const String& value, bool suppress_events, const Value& cookie)
{
	m_Host.store(value);
	if (!suppress_events) {
		NotifyHost(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_Path.store(value);
	if (!suppress_events) {
		NotifyPath(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetUsername(const String& value, bool suppress_events, const Value& cookie)
{
	m_Username.store(value);
	if (!suppress_events) {
		NotifyUsername(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetPassword(const String& value, bool suppress_events, const Value& cookie)
{
	m_Password.store(value);
	if (!suppress_events) {
		NotifyPassword(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetCertPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_CertPath.store(value);
	if (!suppress_events) {
		NotifyCertPath(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetKeyPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_KeyPath.store(value);
	if (!suppress_events) {
		NotifyKeyPath(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetCaPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_CaPath.store(value);
	if (!suppress_events) {
		NotifyCaPath(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetCrlPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_CrlPath.store(value);
	if (!suppress_events) {
		NotifyCrlPath(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetCipherList(const String& value, bool suppress_events, const Value& cookie)
{
	m_CipherList.store(value);
	if (!suppress_events) {
		NotifyCipherList(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetTlsProtocolmin(const String& value, bool suppress_events, const Value& cookie)
{
	m_TlsProtocolmin.store(value);
	if (!suppress_events) {
		NotifyTlsProtocolmin(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetEnvironmentId(const String& value, bool suppress_events, const Value& cookie)
{


	if (!suppress_events) {
		NotifyEnvironmentId(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetLastdumpTook(double value, bool suppress_events, const Value& cookie)
{
	m_LastdumpTook.store(value);
	if (!suppress_events) {
		NotifyLastdumpTook(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetLastdumpEnd(double value, bool suppress_events, const Value& cookie)
{
	m_LastdumpEnd.store(value);
	if (!suppress_events) {
		NotifyLastdumpEnd(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetOngoingDumpStart(double value, bool suppress_events, const Value& cookie)
{
	m_OngoingDumpStart.store(value);
	if (!suppress_events) {
		NotifyOngoingDumpStart(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetConnectTimeout(double value, bool suppress_events, const Value& cookie)
{
	m_ConnectTimeout.store(value);
	if (!suppress_events) {
		NotifyConnectTimeout(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetDbIndex(int value, bool suppress_events, const Value& cookie)
{
	m_DbIndex.store(value);
	if (!suppress_events) {
		NotifyDbIndex(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetPort(int value, bool suppress_events, const Value& cookie)
{
	m_Port.store(value);
	if (!suppress_events) {
		NotifyPort(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetEnableTls(bool value, bool suppress_events, const Value& cookie)
{
	m_EnableTls.store(value);
	if (!suppress_events) {
		NotifyEnableTls(cookie);
	}

}

void ObjectImpl<IcingaDB>::SetInsecureNoverify(bool value, bool suppress_events, const Value& cookie)
{
	m_InsecureNoverify.store(value);
	if (!suppress_events) {
		NotifyInsecureNoverify(cookie);
	}

}

void ObjectImpl<IcingaDB>::NotifyHost(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnHostChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPathChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyUsername(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnUsernameChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyPassword(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPasswordChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyCertPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCertPathChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyKeyPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnKeyPathChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyCaPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCaPathChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyCrlPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCrlPathChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyCipherList(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCipherListChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyTlsProtocolmin(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnTlsProtocolminChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyEnvironmentId(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnvironmentIdChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyLastdumpTook(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnLastdumpTookChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyLastdumpEnd(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnLastdumpEndChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyOngoingDumpStart(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnOngoingDumpStartChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyConnectTimeout(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnConnectTimeoutChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyDbIndex(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnDbIndexChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyPort(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPortChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyEnableTls(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnableTlsChanged(static_cast<IcingaDB *>(this), cookie);
}

void ObjectImpl<IcingaDB>::NotifyInsecureNoverify(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnInsecureNoverifyChanged(static_cast<IcingaDB *>(this), cookie);
}

String ObjectImpl<IcingaDB>::GetDefaultHost() const
{
	 return "127.0.0.1"; 
}

String ObjectImpl<IcingaDB>::GetDefaultPath() const
{
	return String();
}

String ObjectImpl<IcingaDB>::GetDefaultUsername() const
{
	return String();
}

String ObjectImpl<IcingaDB>::GetDefaultPassword() const
{
	return String();
}

String ObjectImpl<IcingaDB>::GetDefaultCertPath() const
{
	return String();
}

String ObjectImpl<IcingaDB>::GetDefaultKeyPath() const
{
	return String();
}

String ObjectImpl<IcingaDB>::GetDefaultCaPath() const
{
	return String();
}

String ObjectImpl<IcingaDB>::GetDefaultCrlPath() const
{
	return String();
}

String ObjectImpl<IcingaDB>::GetDefaultCipherList() const
{
	 return DEFAULT_TLS_CIPHERS; 
}

String ObjectImpl<IcingaDB>::GetDefaultTlsProtocolmin() const
{
	 return DEFAULT_TLS_PROTOCOLMIN; 
}

String ObjectImpl<IcingaDB>::GetDefaultEnvironmentId() const
{
	return String();
}

double ObjectImpl<IcingaDB>::GetDefaultLastdumpTook() const
{
	 return 0; 
}

double ObjectImpl<IcingaDB>::GetDefaultLastdumpEnd() const
{
	 return 0; 
}

double ObjectImpl<IcingaDB>::GetDefaultOngoingDumpStart() const
{
	 return 0; 
}

double ObjectImpl<IcingaDB>::GetDefaultConnectTimeout() const
{
	 return DEFAULT_CONNECT_TIMEOUT; 
}

int ObjectImpl<IcingaDB>::GetDefaultDbIndex() const
{
	return int();
}

int ObjectImpl<IcingaDB>::GetDefaultPort() const
{
	 return 6380; 
}

bool ObjectImpl<IcingaDB>::GetDefaultEnableTls() const
{
	 return false; 
}

bool ObjectImpl<IcingaDB>::GetDefaultInsecureNoverify() const
{
	 return false; 
}


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnHostChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnPathChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnUsernameChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnPasswordChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnCertPathChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnKeyPathChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnCaPathChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnCrlPathChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnCipherListChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnTlsProtocolminChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnEnvironmentIdChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnLastdumpTookChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnLastdumpEndChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnOngoingDumpStartChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnConnectTimeoutChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnDbIndexChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnPortChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnEnableTlsChanged;


boost::signals2::signal<void (const intrusive_ptr<IcingaDB>&, const Value&)> ObjectImpl<IcingaDB>::OnInsecureNoverifyChanged;

void ObjectImpl<IcingaDB>::ValidateCaPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCaPath(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidateCertPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCertPath(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidateCipherList(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCipherList(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidateConnectTimeout(const Lazy<double>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateConnectTimeout(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidateCrlPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCrlPath(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidateDbIndex(const Lazy<int>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateDbIndex(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidateEnableTls(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnableTls(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidateEnvironmentId(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnvironmentId(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidateHost(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateHost(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidateInsecureNoverify(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateInsecureNoverify(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidateKeyPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateKeyPath(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidateLastdumpEnd(const Lazy<double>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateLastdumpEnd(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidateLastdumpTook(const Lazy<double>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateLastdumpTook(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidateOngoingDumpStart(const Lazy<double>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateOngoingDumpStart(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidatePassword(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePassword(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidatePath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePath(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidatePort(const Lazy<int>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePort(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidateTlsProtocolmin(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateTlsProtocolmin(lvalue, utils);
}

void ObjectImpl<IcingaDB>::ValidateUsername(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateUsername(lvalue, utils);
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
