#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<NotificationComponent>::TypeImpl()
{ }

TypeImpl<NotificationComponent>::~TypeImpl()
{ }

String TypeImpl<NotificationComponent>::GetName() const
{
	return "NotificationComponent";
}

int TypeImpl<NotificationComponent>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<NotificationComponent>::GetBaseType() const
{
	return ConfigObject::TypeInstance;
}

int TypeImpl<NotificationComponent>::GetFieldId(const String& name) const
{
	int offset = ConfigObject::TypeInstance->GetFieldCount();

	switch (static_cast<int>(Utility::SDBM(name, 1))) {
		case 101:
			if (name == "enable_ha")
				return offset + 0;

			break;
	}

	return ConfigObject::TypeInstance->GetFieldId(name);
}

Field TypeImpl<NotificationComponent>::GetFieldInfo(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount();
	if (real_id < 0) { return ConfigObject::TypeInstance->GetFieldInfo(id); }
	switch (real_id) {
		case 0:
			return {0, "Boolean", "enable_ha", "enable_ha", nullptr, 2, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<NotificationComponent>::GetFieldCount() const
{
	return 1 + ConfigObject::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<NotificationComponent>::GetFactory() const
{
	return TypeHelper<NotificationComponent, false>::GetFactory();
}

int TypeImpl<NotificationComponent>::GetActivationPriority() const
{
	return 200;
}

void TypeImpl<NotificationComponent>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	switch (real_id) {
		case 0:
			ObjectImpl<NotificationComponent>::OnEnableHAChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<NotificationComponent>::Validate(int types, const ValidationUtils& utils)
{
	ConfigObject::Validate(types, utils);

	if (2 & types)
		ValidateEnableHA(Lazy<bool>([this]() { return GetEnableHA(); }), utils);
}

void ObjectImpl<NotificationComponent>::SimpleValidateEnableHA(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

ObjectImpl<NotificationComponent>::ObjectImpl()
{
	SetEnableHA(GetDefaultEnableHA(), true);
}

ObjectImpl<NotificationComponent>::~ObjectImpl()
{ }

void ObjectImpl<NotificationComponent>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::SetField(id, value, suppress_events, cookie); return; }
	switch (real_id) {
		case 0:
			SetEnableHA(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<NotificationComponent>::GetField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::GetField(id); }
	switch (real_id) {
		case 0:
			return GetEnableHA();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<NotificationComponent>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::ValidateField(id, lvalue, utils); return; }
	switch (real_id) {
		case 0:
			ValidateEnableHA(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<NotificationComponent>::NotifyField(int id, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::NotifyField(id, cookie); return; }
	switch (real_id) {
		case 0:
			NotifyEnableHA(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<NotificationComponent>::NavigateField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::NavigateField(id); }
	throw std::runtime_error("Invalid field ID.");
}

bool ObjectImpl<NotificationComponent>::GetEnableHA() const
{
	return m_EnableHA.load();
}

void ObjectImpl<NotificationComponent>::SetEnableHA(bool value, bool suppress_events, const Value& cookie)
{
	m_EnableHA.store(value);
	if (!suppress_events) {
		NotifyEnableHA(cookie);
	}

}

void ObjectImpl<NotificationComponent>::NotifyEnableHA(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnableHAChanged(static_cast<NotificationComponent *>(this), cookie);
}

bool ObjectImpl<NotificationComponent>::GetDefaultEnableHA() const
{
	 return true; 
}


boost::signals2::signal<void (const intrusive_ptr<NotificationComponent>&, const Value&)> ObjectImpl<NotificationComponent>::OnEnableHAChanged;

void ObjectImpl<NotificationComponent>::ValidateEnableHA(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnableHA(lvalue, utils);
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
