#ifndef NOTIFICATIONCOMPONENT_TI
#define NOTIFICATIONCOMPONENT_TI

#include "base/object.hpp"
#include "base/type.hpp"
#include "base/value.hpp"
#include "base/array.hpp"
#include "base/atomic.hpp"
#include "base/dictionary.hpp"
#include <boost/signals2.hpp>

#include "base/configobject.hpp"

namespace icinga
{

class NotificationComponent;

template<>
class TypeImpl<NotificationComponent> : public TypeImpl<ConfigObject>
{
public:
	DECLARE_PTR_TYPEDEFS(TypeImpl<NotificationComponent>);

	TypeImpl();
	~TypeImpl() override;

	String GetName() const override;
	int GetAttributes() const override;
	Type::Ptr GetBaseType() const override;
	int GetFieldId(const String& name) const override;
	Field GetFieldInfo(int id) const override;
	int GetFieldCount() const override;
	ObjectFactory GetFactory() const override;
	int GetActivationPriority() const override;
public:
	void RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback) override;
};


template<>
class ObjectImpl<NotificationComponent> : public ConfigObject
{
public:
	DECLARE_PTR_TYPEDEFS(ObjectImpl<NotificationComponent>);

	void Validate(int types, const ValidationUtils& utils) override;
	void SimpleValidateEnableHA(const Lazy<bool>& value, const ValidationUtils& utils);
public:
	ObjectImpl<NotificationComponent>();
public:
	~ObjectImpl<NotificationComponent>() override;
public:
	void SetField(int id, const Value& value, bool suppress_events = false, const Value& cookie = Empty) override;
public:
	Value GetField(int id) const override;
public:
	void ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils) override;
public:
	void NotifyField(int id, const Value& cookie = Empty) override;
public:
	Object::Ptr NavigateField(int id) const override;
public:
	bool GetEnableHA() const;
public:
	void SetEnableHA(bool value, bool suppress_events = false, const Value& cookie = Empty);
protected:
public:
	virtual void NotifyEnableHA(const Value& cookie = Empty);
private:
	inline bool GetDefaultEnableHA() const;
protected:
	virtual void ValidateEnableHA(const Lazy<bool>& lvalue, const ValidationUtils& utils);
private:
	AtomicOrLocked<bool> m_EnableHA;
public:
	static boost::signals2::signal<void (const intrusive_ptr<NotificationComponent>&, const Value&)> OnEnableHAChanged;
};

}
#endif /* NOTIFICATIONCOMPONENT_TI */
