#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<ElasticsearchWriter>::TypeImpl()
{ }

TypeImpl<ElasticsearchWriter>::~TypeImpl()
{ }

String TypeImpl<ElasticsearchWriter>::GetName() const
{
	return "ElasticsearchWriter";
}

int TypeImpl<ElasticsearchWriter>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<ElasticsearchWriter>::GetBaseType() const
{
	return ConfigObject::TypeInstance;
}

int TypeImpl<ElasticsearchWriter>::GetFieldId(const String& name) const
{
	int offset = ConfigObject::TypeInstance->GetFieldCount();

	switch (static_cast<int>(Utility::SDBM(name, 3))) {
		case 824252193:
			if (name == "ca_path")
				return offset + 5;

			break;
		case 824514608:
			if (name == "cert_path")
				return offset + 6;

			break;
		case 841627992:
			if (name == "enable_send_perfdata")
				return offset + 12;
			if (name == "enable_tls")
				return offset + 13;
			if (name == "enable_ha")
				return offset + 15;

			break;
		case 849758319:
			if (name == "flush_interval")
				return offset + 10;
			if (name == "flush_threshold")
				return offset + 11;

			break;
		case 866478124:
			if (name == "host")
				return offset + 0;
			if (name == "host_tags_template")
				return offset + 8;

			break;
		case 874674015:
			if (name == "index")
				return offset + 2;

			break;
		case 874674030:
			if (name == "insecure_noverify")
				return offset + 14;

			break;
		case 890606655:
			if (name == "key_path")
				return offset + 7;

			break;
		case 931651778:
			if (name == "password")
				return offset + 4;

			break;
		case 932570163:
			if (name == "port")
				return offset + 1;

			break;
		case 956698688:
			if (name == "service_tags_template")
				return offset + 9;

			break;
		case 974140071:
			if (name == "username")
				return offset + 3;

			break;
	}

	return ConfigObject::TypeInstance->GetFieldId(name);
}

Field TypeImpl<ElasticsearchWriter>::GetFieldInfo(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount();
	if (real_id < 0) { return ConfigObject::TypeInstance->GetFieldInfo(id); }
	switch (real_id) {
		case 0:
			return {0, "String", "host", "host", nullptr, 258, 0};
		case 1:
			return {1, "String", "port", "port", nullptr, 258, 0};
		case 2:
			return {2, "String", "index", "index", nullptr, 258, 0};
		case 3:
			return {3, "String", "username", "username", nullptr, 2, 0};
		case 4:
			return {4, "String", "password", "password", nullptr, 3074, 0};
		case 5:
			return {5, "String", "ca_path", "ca_path", nullptr, 2, 0};
		case 6:
			return {6, "String", "cert_path", "cert_path", nullptr, 2, 0};
		case 7:
			return {7, "String", "key_path", "key_path", nullptr, 2, 0};
		case 8:
			return {8, "Dictionary", "host_tags_template", "host_tags_template", nullptr, 2, 0};
		case 9:
			return {9, "Dictionary", "service_tags_template", "service_tags_template", nullptr, 2, 0};
		case 10:
			return {10, "Number", "flush_interval", "flush_interval", nullptr, 2, 0};
		case 11:
			return {11, "Number", "flush_threshold", "flush_threshold", nullptr, 2, 0};
		case 12:
			return {12, "Boolean", "enable_send_perfdata", "enable_send_perfdata", nullptr, 2, 0};
		case 13:
			return {13, "Boolean", "enable_tls", "enable_tls", nullptr, 2, 0};
		case 14:
			return {14, "Boolean", "insecure_noverify", "insecure_noverify", nullptr, 2, 0};
		case 15:
			return {15, "Boolean", "enable_ha", "enable_ha", nullptr, 2, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<ElasticsearchWriter>::GetFieldCount() const
{
	return 16 + ConfigObject::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<ElasticsearchWriter>::GetFactory() const
{
	return TypeHelper<ElasticsearchWriter, false>::GetFactory();
}

int TypeImpl<ElasticsearchWriter>::GetActivationPriority() const
{
	return 100;
}

void TypeImpl<ElasticsearchWriter>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	switch (real_id) {
		case 0:
			ObjectImpl<ElasticsearchWriter>::OnHostChanged.connect(callback);
			break;
		case 1:
			ObjectImpl<ElasticsearchWriter>::OnPortChanged.connect(callback);
			break;
		case 2:
			ObjectImpl<ElasticsearchWriter>::OnIndexChanged.connect(callback);
			break;
		case 3:
			ObjectImpl<ElasticsearchWriter>::OnUsernameChanged.connect(callback);
			break;
		case 4:
			ObjectImpl<ElasticsearchWriter>::OnPasswordChanged.connect(callback);
			break;
		case 5:
			ObjectImpl<ElasticsearchWriter>::OnCaPathChanged.connect(callback);
			break;
		case 6:
			ObjectImpl<ElasticsearchWriter>::OnCertPathChanged.connect(callback);
			break;
		case 7:
			ObjectImpl<ElasticsearchWriter>::OnKeyPathChanged.connect(callback);
			break;
		case 8:
			ObjectImpl<ElasticsearchWriter>::OnHostTagsTemplateChanged.connect(callback);
			break;
		case 9:
			ObjectImpl<ElasticsearchWriter>::OnServiceTagsTemplateChanged.connect(callback);
			break;
		case 10:
			ObjectImpl<ElasticsearchWriter>::OnFlushIntervalChanged.connect(callback);
			break;
		case 11:
			ObjectImpl<ElasticsearchWriter>::OnFlushThresholdChanged.connect(callback);
			break;
		case 12:
			ObjectImpl<ElasticsearchWriter>::OnEnableSendPerfdataChanged.connect(callback);
			break;
		case 13:
			ObjectImpl<ElasticsearchWriter>::OnEnableTlsChanged.connect(callback);
			break;
		case 14:
			ObjectImpl<ElasticsearchWriter>::OnInsecureNoverifyChanged.connect(callback);
			break;
		case 15:
			ObjectImpl<ElasticsearchWriter>::OnEnableHaChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<ElasticsearchWriter>::Validate(int types, const ValidationUtils& utils)
{
	ConfigObject::Validate(types, utils);

	if (2 & types)
		ValidateHost(Lazy<String>([this]() { return GetHost(); }), utils);
	if (2 & types)
		ValidatePort(Lazy<String>([this]() { return GetPort(); }), utils);
	if (2 & types)
		ValidateIndex(Lazy<String>([this]() { return GetIndex(); }), utils);
	if (2 & types)
		ValidateUsername(Lazy<String>([this]() { return GetUsername(); }), utils);
	if (2 & types)
		ValidatePassword(Lazy<String>([this]() { return GetPassword(); }), utils);
	if (2 & types)
		ValidateCaPath(Lazy<String>([this]() { return GetCaPath(); }), utils);
	if (2 & types)
		ValidateCertPath(Lazy<String>([this]() { return GetCertPath(); }), utils);
	if (2 & types)
		ValidateKeyPath(Lazy<String>([this]() { return GetKeyPath(); }), utils);
	if (2 & types)
		ValidateHostTagsTemplate(Lazy<Dictionary::Ptr>([this]() { return GetHostTagsTemplate(); }), utils);
	if (2 & types)
		ValidateServiceTagsTemplate(Lazy<Dictionary::Ptr>([this]() { return GetServiceTagsTemplate(); }), utils);
	if (2 & types)
		ValidateFlushInterval(Lazy<int>([this]() { return GetFlushInterval(); }), utils);
	if (2 & types)
		ValidateFlushThreshold(Lazy<int>([this]() { return GetFlushThreshold(); }), utils);
	if (2 & types)
		ValidateEnableSendPerfdata(Lazy<bool>([this]() { return GetEnableSendPerfdata(); }), utils);
	if (2 & types)
		ValidateEnableTls(Lazy<bool>([this]() { return GetEnableTls(); }), utils);
	if (2 & types)
		ValidateInsecureNoverify(Lazy<bool>([this]() { return GetInsecureNoverify(); }), utils);
	if (2 & types)
		ValidateEnableHa(Lazy<bool>([this]() { return GetEnableHa(); }), utils);
}

void ObjectImpl<ElasticsearchWriter>::SimpleValidateHost(const Lazy<String>& value, const ValidationUtils& utils)
{
	if (value().IsEmpty())
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_cast<ConfigObject *>(this), { "host" }, "Attribute must not be empty."));

}

void ObjectImpl<ElasticsearchWriter>::SimpleValidatePort(const Lazy<String>& value, const ValidationUtils& utils)
{
	if (value().IsEmpty())
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_cast<ConfigObject *>(this), { "port" }, "Attribute must not be empty."));

}

void ObjectImpl<ElasticsearchWriter>::SimpleValidateIndex(const Lazy<String>& value, const ValidationUtils& utils)
{
	if (value().IsEmpty())
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_cast<ConfigObject *>(this), { "index" }, "Attribute must not be empty."));

}

void ObjectImpl<ElasticsearchWriter>::SimpleValidateUsername(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ElasticsearchWriter>::SimpleValidatePassword(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ElasticsearchWriter>::SimpleValidateCaPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ElasticsearchWriter>::SimpleValidateCertPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ElasticsearchWriter>::SimpleValidateKeyPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ElasticsearchWriter>::SimpleValidateHostTagsTemplate(const Lazy<Dictionary::Ptr>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ElasticsearchWriter>::SimpleValidateServiceTagsTemplate(const Lazy<Dictionary::Ptr>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ElasticsearchWriter>::SimpleValidateFlushInterval(const Lazy<int>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ElasticsearchWriter>::SimpleValidateFlushThreshold(const Lazy<int>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ElasticsearchWriter>::SimpleValidateEnableSendPerfdata(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ElasticsearchWriter>::SimpleValidateEnableTls(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ElasticsearchWriter>::SimpleValidateInsecureNoverify(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ElasticsearchWriter>::SimpleValidateEnableHa(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

ObjectImpl<ElasticsearchWriter>::ObjectImpl()
{
	SetHost(GetDefaultHost(), true);
	SetPort(GetDefaultPort(), true);
	SetIndex(GetDefaultIndex(), true);
	SetUsername(GetDefaultUsername(), true);
	SetPassword(GetDefaultPassword(), true);
	SetCaPath(GetDefaultCaPath(), true);
	SetCertPath(GetDefaultCertPath(), true);
	SetKeyPath(GetDefaultKeyPath(), true);
	SetHostTagsTemplate(GetDefaultHostTagsTemplate(), true);
	SetServiceTagsTemplate(GetDefaultServiceTagsTemplate(), true);
	SetFlushInterval(GetDefaultFlushInterval(), true);
	SetFlushThreshold(GetDefaultFlushThreshold(), true);
	SetEnableSendPerfdata(GetDefaultEnableSendPerfdata(), true);
	SetEnableTls(GetDefaultEnableTls(), true);
	SetInsecureNoverify(GetDefaultInsecureNoverify(), true);
	SetEnableHa(GetDefaultEnableHa(), true);
}

ObjectImpl<ElasticsearchWriter>::~ObjectImpl()
{ }

void ObjectImpl<ElasticsearchWriter>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::SetField(id, value, suppress_events, cookie); return; }
	switch (real_id) {
		case 0:
			SetHost(value, suppress_events, cookie);
			break;
		case 1:
			SetPort(value, suppress_events, cookie);
			break;
		case 2:
			SetIndex(value, suppress_events, cookie);
			break;
		case 3:
			SetUsername(value, suppress_events, cookie);
			break;
		case 4:
			SetPassword(value, suppress_events, cookie);
			break;
		case 5:
			SetCaPath(value, suppress_events, cookie);
			break;
		case 6:
			SetCertPath(value, suppress_events, cookie);
			break;
		case 7:
			SetKeyPath(value, suppress_events, cookie);
			break;
		case 8:
			SetHostTagsTemplate(value, suppress_events, cookie);
			break;
		case 9:
			SetServiceTagsTemplate(value, suppress_events, cookie);
			break;
		case 10:
			SetFlushInterval(value, suppress_events, cookie);
			break;
		case 11:
			SetFlushThreshold(value, suppress_events, cookie);
			break;
		case 12:
			SetEnableSendPerfdata(value, suppress_events, cookie);
			break;
		case 13:
			SetEnableTls(value, suppress_events, cookie);
			break;
		case 14:
			SetInsecureNoverify(value, suppress_events, cookie);
			break;
		case 15:
			SetEnableHa(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<ElasticsearchWriter>::GetField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::GetField(id); }
	switch (real_id) {
		case 0:
			return GetHost();
		case 1:
			return GetPort();
		case 2:
			return GetIndex();
		case 3:
			return GetUsername();
		case 4:
			return GetPassword();
		case 5:
			return GetCaPath();
		case 6:
			return GetCertPath();
		case 7:
			return GetKeyPath();
		case 8:
			return GetHostTagsTemplate();
		case 9:
			return GetServiceTagsTemplate();
		case 10:
			return GetFlushInterval();
		case 11:
			return GetFlushThreshold();
		case 12:
			return GetEnableSendPerfdata();
		case 13:
			return GetEnableTls();
		case 14:
			return GetInsecureNoverify();
		case 15:
			return GetEnableHa();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<ElasticsearchWriter>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::ValidateField(id, lvalue, utils); return; }
	switch (real_id) {
		case 0:
			ValidateHost(lvalue, utils);
			break;
		case 1:
			ValidatePort(lvalue, utils);
			break;
		case 2:
			ValidateIndex(lvalue, utils);
			break;
		case 3:
			ValidateUsername(lvalue, utils);
			break;
		case 4:
			ValidatePassword(lvalue, utils);
			break;
		case 5:
			ValidateCaPath(lvalue, utils);
			break;
		case 6:
			ValidateCertPath(lvalue, utils);
			break;
		case 7:
			ValidateKeyPath(lvalue, utils);
			break;
		case 8:
			ValidateHostTagsTemplate(lvalue, utils);
			break;
		case 9:
			ValidateServiceTagsTemplate(lvalue, utils);
			break;
		case 10:
			ValidateFlushInterval(lvalue, utils);
			break;
		case 11:
			ValidateFlushThreshold(lvalue, utils);
			break;
		case 12:
			ValidateEnableSendPerfdata(lvalue, utils);
			break;
		case 13:
			ValidateEnableTls(lvalue, utils);
			break;
		case 14:
			ValidateInsecureNoverify(lvalue, utils);
			break;
		case 15:
			ValidateEnableHa(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<ElasticsearchWriter>::NotifyField(int id, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::NotifyField(id, cookie); return; }
	switch (real_id) {
		case 0:
			NotifyHost(cookie);
			break;
		case 1:
			NotifyPort(cookie);
			break;
		case 2:
			NotifyIndex(cookie);
			break;
		case 3:
			NotifyUsername(cookie);
			break;
		case 4:
			NotifyPassword(cookie);
			break;
		case 5:
			NotifyCaPath(cookie);
			break;
		case 6:
			NotifyCertPath(cookie);
			break;
		case 7:
			NotifyKeyPath(cookie);
			break;
		case 8:
			NotifyHostTagsTemplate(cookie);
			break;
		case 9:
			NotifyServiceTagsTemplate(cookie);
			break;
		case 10:
			NotifyFlushInterval(cookie);
			break;
		case 11:
			NotifyFlushThreshold(cookie);
			break;
		case 12:
			NotifyEnableSendPerfdata(cookie);
			break;
		case 13:
			NotifyEnableTls(cookie);
			break;
		case 14:
			NotifyInsecureNoverify(cookie);
			break;
		case 15:
			NotifyEnableHa(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<ElasticsearchWriter>::NavigateField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::NavigateField(id); }
	throw std::runtime_error("Invalid field ID.");
}

String ObjectImpl<ElasticsearchWriter>::GetHost() const
{
	return m_Host.load();
}

String ObjectImpl<ElasticsearchWriter>::GetPort() const
{
	return m_Port.load();
}

String ObjectImpl<ElasticsearchWriter>::GetIndex() const
{
	return m_Index.load();
}

String ObjectImpl<ElasticsearchWriter>::GetUsername() const
{
	return m_Username.load();
}

String ObjectImpl<ElasticsearchWriter>::GetPassword() const
{
	return m_Password.load();
}

String ObjectImpl<ElasticsearchWriter>::GetCaPath() const
{
	return m_CaPath.load();
}

String ObjectImpl<ElasticsearchWriter>::GetCertPath() const
{
	return m_CertPath.load();
}

String ObjectImpl<ElasticsearchWriter>::GetKeyPath() const
{
	return m_KeyPath.load();
}

Dictionary::Ptr ObjectImpl<ElasticsearchWriter>::GetHostTagsTemplate() const
{
	return m_HostTagsTemplate.load();
}

Dictionary::Ptr ObjectImpl<ElasticsearchWriter>::GetServiceTagsTemplate() const
{
	return m_ServiceTagsTemplate.load();
}

int ObjectImpl<ElasticsearchWriter>::GetFlushInterval() const
{
	return m_FlushInterval.load();
}

int ObjectImpl<ElasticsearchWriter>::GetFlushThreshold() const
{
	return m_FlushThreshold.load();
}

bool ObjectImpl<ElasticsearchWriter>::GetEnableSendPerfdata() const
{
	return m_EnableSendPerfdata.load();
}

bool ObjectImpl<ElasticsearchWriter>::GetEnableTls() const
{
	return m_EnableTls.load();
}

bool ObjectImpl<ElasticsearchWriter>::GetInsecureNoverify() const
{
	return m_InsecureNoverify.load();
}

bool ObjectImpl<ElasticsearchWriter>::GetEnableHa() const
{
	return m_EnableHa.load();
}

void ObjectImpl<ElasticsearchWriter>::SetHost(const String& value, bool suppress_events, const Value& cookie)
{
	m_Host.store(value);
	if (!suppress_events) {
		NotifyHost(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::SetPort(const String& value, bool suppress_events, const Value& cookie)
{
	m_Port.store(value);
	if (!suppress_events) {
		NotifyPort(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::SetIndex(const String& value, bool suppress_events, const Value& cookie)
{
	m_Index.store(value);
	if (!suppress_events) {
		NotifyIndex(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::SetUsername(const String& value, bool suppress_events, const Value& cookie)
{
	m_Username.store(value);
	if (!suppress_events) {
		NotifyUsername(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::SetPassword(const String& value, bool suppress_events, const Value& cookie)
{
	m_Password.store(value);
	if (!suppress_events) {
		NotifyPassword(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::SetCaPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_CaPath.store(value);
	if (!suppress_events) {
		NotifyCaPath(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::SetCertPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_CertPath.store(value);
	if (!suppress_events) {
		NotifyCertPath(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::SetKeyPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_KeyPath.store(value);
	if (!suppress_events) {
		NotifyKeyPath(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::SetHostTagsTemplate(const Dictionary::Ptr& value, bool suppress_events, const Value& cookie)
{
	m_HostTagsTemplate.store(value);
	if (!suppress_events) {
		NotifyHostTagsTemplate(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::SetServiceTagsTemplate(const Dictionary::Ptr& value, bool suppress_events, const Value& cookie)
{
	m_ServiceTagsTemplate.store(value);
	if (!suppress_events) {
		NotifyServiceTagsTemplate(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::SetFlushInterval(int value, bool suppress_events, const Value& cookie)
{
	m_FlushInterval.store(value);
	if (!suppress_events) {
		NotifyFlushInterval(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::SetFlushThreshold(int value, bool suppress_events, const Value& cookie)
{
	m_FlushThreshold.store(value);
	if (!suppress_events) {
		NotifyFlushThreshold(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::SetEnableSendPerfdata(bool value, bool suppress_events, const Value& cookie)
{
	m_EnableSendPerfdata.store(value);
	if (!suppress_events) {
		NotifyEnableSendPerfdata(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::SetEnableTls(bool value, bool suppress_events, const Value& cookie)
{
	m_EnableTls.store(value);
	if (!suppress_events) {
		NotifyEnableTls(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::SetInsecureNoverify(bool value, bool suppress_events, const Value& cookie)
{
	m_InsecureNoverify.store(value);
	if (!suppress_events) {
		NotifyInsecureNoverify(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::SetEnableHa(bool value, bool suppress_events, const Value& cookie)
{
	m_EnableHa.store(value);
	if (!suppress_events) {
		NotifyEnableHa(cookie);
	}

}

void ObjectImpl<ElasticsearchWriter>::NotifyHost(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnHostChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

void ObjectImpl<ElasticsearchWriter>::NotifyPort(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPortChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

void ObjectImpl<ElasticsearchWriter>::NotifyIndex(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnIndexChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

void ObjectImpl<ElasticsearchWriter>::NotifyUsername(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnUsernameChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

void ObjectImpl<ElasticsearchWriter>::NotifyPassword(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPasswordChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

void ObjectImpl<ElasticsearchWriter>::NotifyCaPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCaPathChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

void ObjectImpl<ElasticsearchWriter>::NotifyCertPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCertPathChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

void ObjectImpl<ElasticsearchWriter>::NotifyKeyPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnKeyPathChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

void ObjectImpl<ElasticsearchWriter>::NotifyHostTagsTemplate(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnHostTagsTemplateChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

void ObjectImpl<ElasticsearchWriter>::NotifyServiceTagsTemplate(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnServiceTagsTemplateChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

void ObjectImpl<ElasticsearchWriter>::NotifyFlushInterval(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnFlushIntervalChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

void ObjectImpl<ElasticsearchWriter>::NotifyFlushThreshold(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnFlushThresholdChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

void ObjectImpl<ElasticsearchWriter>::NotifyEnableSendPerfdata(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnableSendPerfdataChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

void ObjectImpl<ElasticsearchWriter>::NotifyEnableTls(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnableTlsChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

void ObjectImpl<ElasticsearchWriter>::NotifyInsecureNoverify(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnInsecureNoverifyChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

void ObjectImpl<ElasticsearchWriter>::NotifyEnableHa(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnableHaChanged(static_cast<ElasticsearchWriter *>(this), cookie);
}

String ObjectImpl<ElasticsearchWriter>::GetDefaultHost() const
{
	 return "127.0.0.1"; 
}

String ObjectImpl<ElasticsearchWriter>::GetDefaultPort() const
{
	 return "9200"; 
}

String ObjectImpl<ElasticsearchWriter>::GetDefaultIndex() const
{
	 return "icinga2"; 
}

String ObjectImpl<ElasticsearchWriter>::GetDefaultUsername() const
{
	return String();
}

String ObjectImpl<ElasticsearchWriter>::GetDefaultPassword() const
{
	return String();
}

String ObjectImpl<ElasticsearchWriter>::GetDefaultCaPath() const
{
	return String();
}

String ObjectImpl<ElasticsearchWriter>::GetDefaultCertPath() const
{
	return String();
}

String ObjectImpl<ElasticsearchWriter>::GetDefaultKeyPath() const
{
	return String();
}

Dictionary::Ptr ObjectImpl<ElasticsearchWriter>::GetDefaultHostTagsTemplate() const
{
	return Dictionary::Ptr();
}

Dictionary::Ptr ObjectImpl<ElasticsearchWriter>::GetDefaultServiceTagsTemplate() const
{
	return Dictionary::Ptr();
}

int ObjectImpl<ElasticsearchWriter>::GetDefaultFlushInterval() const
{
	 return 10; 
}

int ObjectImpl<ElasticsearchWriter>::GetDefaultFlushThreshold() const
{
	 return 1024; 
}

bool ObjectImpl<ElasticsearchWriter>::GetDefaultEnableSendPerfdata() const
{
	 return false; 
}

bool ObjectImpl<ElasticsearchWriter>::GetDefaultEnableTls() const
{
	 return false; 
}

bool ObjectImpl<ElasticsearchWriter>::GetDefaultInsecureNoverify() const
{
	 return false; 
}

bool ObjectImpl<ElasticsearchWriter>::GetDefaultEnableHa() const
{
	 return false; 
}


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnHostChanged;


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnPortChanged;


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnIndexChanged;


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnUsernameChanged;


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnPasswordChanged;


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnCaPathChanged;


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnCertPathChanged;


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnKeyPathChanged;


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnHostTagsTemplateChanged;


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnServiceTagsTemplateChanged;


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnFlushIntervalChanged;


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnFlushThresholdChanged;


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnEnableSendPerfdataChanged;


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnEnableTlsChanged;


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnInsecureNoverifyChanged;


boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> ObjectImpl<ElasticsearchWriter>::OnEnableHaChanged;

static void TIValidateElasticsearchWriter_1_2(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, const String& key, const Value& value, std::vector<String>& location, const ValidationUtils& utils)
{
	bool known_attribute = false;
	do {
		known_attribute = true;
		if (value.IsEmpty() || value.IsScalar())
			return;
	} while (0);

	if (!known_attribute)
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid attribute: " + key));
	else
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid type."));
}

static void TIValidateElasticsearchWriter_1(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, const String& key, const Value& value, std::vector<String>& location, const ValidationUtils& utils)
{
	bool known_attribute = false;
	do {
		known_attribute = true;
		if (value.IsEmpty() || value.IsScalar())
			return;
	} while (0);

	do {
		known_attribute = true;
		if (value.IsObjectType<Array>()) {
			Array::Ptr arr = value;
			Array::SizeType anum = 0;
			{
				ObjectLock olock(arr);
				for (const Value& avalue : arr) {
					String akey = Convert::ToString(anum);
					location.emplace_back(akey);
					TIValidateElasticsearchWriter_1_2(object, akey, avalue, location, utils);
					location.pop_back();
					anum++;
				}
			}
			return;
		}
	} while (0);

	if (!known_attribute)
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid attribute: " + key));
	else
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid type."));
}

static void TIValidateElasticsearchWriter_2_2(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, const String& key, const Value& value, std::vector<String>& location, const ValidationUtils& utils)
{
	bool known_attribute = false;
	do {
		known_attribute = true;
		if (value.IsEmpty() || value.IsScalar())
			return;
	} while (0);

	if (!known_attribute)
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid attribute: " + key));
	else
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid type."));
}

static void TIValidateElasticsearchWriter_2(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, const String& key, const Value& value, std::vector<String>& location, const ValidationUtils& utils)
{
	bool known_attribute = false;
	do {
		known_attribute = true;
		if (value.IsEmpty() || value.IsScalar())
			return;
	} while (0);

	do {
		known_attribute = true;
		if (value.IsObjectType<Array>()) {
			Array::Ptr arr = value;
			Array::SizeType anum = 0;
			{
				ObjectLock olock(arr);
				for (const Value& avalue : arr) {
					String akey = Convert::ToString(anum);
					location.emplace_back(akey);
					TIValidateElasticsearchWriter_2_2(object, akey, avalue, location, utils);
					location.pop_back();
					anum++;
				}
			}
			return;
		}
	} while (0);

	if (!known_attribute)
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid attribute: " + key));
	else
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid type."));
}

static void TIValidateElasticsearchWriterCaPath(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, const String& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (value.IsEmpty())
		return;

}

static void TIValidateElasticsearchWriterCertPath(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, const String& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (value.IsEmpty())
		return;

}

static void TIValidateElasticsearchWriterEnableHa(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, bool value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (!value)
		return;

}

static void TIValidateElasticsearchWriterEnableSendPerfdata(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, bool value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (!value)
		return;

}

static void TIValidateElasticsearchWriterEnableTls(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, bool value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (!value)
		return;

}

static void TIValidateElasticsearchWriterFlushInterval(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, int value, std::vector<String>& location, const ValidationUtils& utils)
{
}

static void TIValidateElasticsearchWriterFlushThreshold(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, int value, std::vector<String>& location, const ValidationUtils& utils)
{
}

static void TIValidateElasticsearchWriterHost(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, const String& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (value.IsEmpty())
		return;

}

static void TIValidateElasticsearchWriterHostTagsTemplate(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, const Dictionary::Ptr& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (!value)
		return;

	do {
		const Dictionary::Ptr& dict = value;
		{
			ObjectLock olock(dict);
			for (const Dictionary::Pair& kv : dict) {
				const String& akey = kv.first;
				const Value& avalue = kv.second;
				location.emplace_back(akey);
				TIValidateElasticsearchWriter_1(object, akey, avalue, location, utils);
				location.pop_back();
			}
		}
		return;
	} while (0);

}

static void TIValidateElasticsearchWriterIndex(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, const String& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (value.IsEmpty())
		return;

}

static void TIValidateElasticsearchWriterInsecureNoverify(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, bool value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (!value)
		return;

}

static void TIValidateElasticsearchWriterKeyPath(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, const String& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (value.IsEmpty())
		return;

}

static void TIValidateElasticsearchWriterPassword(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, const String& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (value.IsEmpty())
		return;

}

static void TIValidateElasticsearchWriterPort(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, const String& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (value.IsEmpty())
		return;

}

static void TIValidateElasticsearchWriterServiceTagsTemplate(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, const Dictionary::Ptr& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (!value)
		return;

	do {
		const Dictionary::Ptr& dict = value;
		{
			ObjectLock olock(dict);
			for (const Dictionary::Pair& kv : dict) {
				const String& akey = kv.first;
				const Value& avalue = kv.second;
				location.emplace_back(akey);
				TIValidateElasticsearchWriter_2(object, akey, avalue, location, utils);
				location.pop_back();
			}
		}
		return;
	} while (0);

}

static void TIValidateElasticsearchWriterUsername(const intrusive_ptr<ObjectImpl<ElasticsearchWriter> >& object, const String& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (value.IsEmpty())
		return;

}

void ObjectImpl<ElasticsearchWriter>::ValidateCaPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCaPath(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("ca_path");
	TIValidateElasticsearchWriterCaPath(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<ElasticsearchWriter>::ValidateCertPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCertPath(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("cert_path");
	TIValidateElasticsearchWriterCertPath(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<ElasticsearchWriter>::ValidateEnableHa(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnableHa(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("enable_ha");
	TIValidateElasticsearchWriterEnableHa(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<ElasticsearchWriter>::ValidateEnableSendPerfdata(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnableSendPerfdata(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("enable_send_perfdata");
	TIValidateElasticsearchWriterEnableSendPerfdata(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<ElasticsearchWriter>::ValidateEnableTls(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnableTls(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("enable_tls");
	TIValidateElasticsearchWriterEnableTls(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<ElasticsearchWriter>::ValidateFlushInterval(const Lazy<int>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateFlushInterval(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("flush_interval");
	TIValidateElasticsearchWriterFlushInterval(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<ElasticsearchWriter>::ValidateFlushThreshold(const Lazy<int>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateFlushThreshold(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("flush_threshold");
	TIValidateElasticsearchWriterFlushThreshold(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<ElasticsearchWriter>::ValidateHost(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateHost(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("host");
	TIValidateElasticsearchWriterHost(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<ElasticsearchWriter>::ValidateHostTagsTemplate(const Lazy<Dictionary::Ptr>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateHostTagsTemplate(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("host_tags_template");
	TIValidateElasticsearchWriterHostTagsTemplate(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<ElasticsearchWriter>::ValidateIndex(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateIndex(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("index");
	TIValidateElasticsearchWriterIndex(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<ElasticsearchWriter>::ValidateInsecureNoverify(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateInsecureNoverify(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("insecure_noverify");
	TIValidateElasticsearchWriterInsecureNoverify(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<ElasticsearchWriter>::ValidateKeyPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateKeyPath(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("key_path");
	TIValidateElasticsearchWriterKeyPath(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<ElasticsearchWriter>::ValidatePassword(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePassword(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("password");
	TIValidateElasticsearchWriterPassword(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<ElasticsearchWriter>::ValidatePort(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePort(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("port");
	TIValidateElasticsearchWriterPort(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<ElasticsearchWriter>::ValidateServiceTagsTemplate(const Lazy<Dictionary::Ptr>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateServiceTagsTemplate(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("service_tags_template");
	TIValidateElasticsearchWriterServiceTagsTemplate(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<ElasticsearchWriter>::ValidateUsername(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateUsername(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("username");
	TIValidateElasticsearchWriterUsername(this, lvalue(), location, utils);
	location.pop_back();
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
