#ifndef ELASTICSEARCHWRITER_TI
#define ELASTICSEARCHWRITER_TI

#include "base/object.hpp"
#include "base/type.hpp"
#include "base/value.hpp"
#include "base/array.hpp"
#include "base/atomic.hpp"
#include "base/dictionary.hpp"
#include <boost/signals2.hpp>

#include "base/configobject.hpp"

namespace icinga
{

class ElasticsearchWriter;

template<>
class TypeImpl<ElasticsearchWriter> : public TypeImpl<ConfigObject>
{
public:
	DECLARE_PTR_TYPEDEFS(TypeImpl<ElasticsearchWriter>);

	TypeImpl();
	~TypeImpl() override;

	String GetName() const override;
	int GetAttributes() const override;
	Type::Ptr GetBaseType() const override;
	int GetFieldId(const String& name) const override;
	Field GetFieldInfo(int id) const override;
	int GetFieldCount() const override;
	ObjectFactory GetFactory() const override;
	int GetActivationPriority() const override;
public:
	void RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback) override;
};


template<>
class ObjectImpl<ElasticsearchWriter> : public ConfigObject
{
public:
	DECLARE_PTR_TYPEDEFS(ObjectImpl<ElasticsearchWriter>);

	void Validate(int types, const ValidationUtils& utils) override;
	void SimpleValidateHost(const Lazy<String>& value, const ValidationUtils& utils);
	void SimpleValidatePort(const Lazy<String>& value, const ValidationUtils& utils);
	void SimpleValidateIndex(const Lazy<String>& value, const ValidationUtils& utils);
	void SimpleValidateUsername(const Lazy<String>& value, const ValidationUtils& utils);
	void SimpleValidatePassword(const Lazy<String>& value, const ValidationUtils& utils);
	void SimpleValidateCaPath(const Lazy<String>& value, const ValidationUtils& utils);
	void SimpleValidateCertPath(const Lazy<String>& value, const ValidationUtils& utils);
	void SimpleValidateKeyPath(const Lazy<String>& value, const ValidationUtils& utils);
	void SimpleValidateHostTagsTemplate(const Lazy<Dictionary::Ptr>& value, const ValidationUtils& utils);
	void SimpleValidateServiceTagsTemplate(const Lazy<Dictionary::Ptr>& value, const ValidationUtils& utils);
	void SimpleValidateFlushInterval(const Lazy<int>& value, const ValidationUtils& utils);
	void SimpleValidateFlushThreshold(const Lazy<int>& value, const ValidationUtils& utils);
	void SimpleValidateEnableSendPerfdata(const Lazy<bool>& value, const ValidationUtils& utils);
	void SimpleValidateEnableTls(const Lazy<bool>& value, const ValidationUtils& utils);
	void SimpleValidateInsecureNoverify(const Lazy<bool>& value, const ValidationUtils& utils);
	void SimpleValidateEnableHa(const Lazy<bool>& value, const ValidationUtils& utils);
public:
	ObjectImpl<ElasticsearchWriter>();
public:
	~ObjectImpl<ElasticsearchWriter>() override;
public:
	void SetField(int id, const Value& value, bool suppress_events = false, const Value& cookie = Empty) override;
public:
	Value GetField(int id) const override;
public:
	void ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils) override;
public:
	void NotifyField(int id, const Value& cookie = Empty) override;
public:
	Object::Ptr NavigateField(int id) const override;
public:
	String GetHost() const;
public:
	String GetPort() const;
public:
	String GetIndex() const;
public:
	String GetUsername() const;
public:
	String GetPassword() const;
public:
	String GetCaPath() const;
public:
	String GetCertPath() const;
public:
	String GetKeyPath() const;
public:
	Dictionary::Ptr GetHostTagsTemplate() const;
public:
	Dictionary::Ptr GetServiceTagsTemplate() const;
public:
	int GetFlushInterval() const;
public:
	int GetFlushThreshold() const;
public:
	bool GetEnableSendPerfdata() const;
public:
	bool GetEnableTls() const;
public:
	bool GetInsecureNoverify() const;
public:
	bool GetEnableHa() const;
public:
	void SetHost(const String& value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetPort(const String& value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetIndex(const String& value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetUsername(const String& value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetPassword(const String& value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetCaPath(const String& value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetCertPath(const String& value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetKeyPath(const String& value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetHostTagsTemplate(const Dictionary::Ptr& value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetServiceTagsTemplate(const Dictionary::Ptr& value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetFlushInterval(int value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetFlushThreshold(int value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetEnableSendPerfdata(bool value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetEnableTls(bool value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetInsecureNoverify(bool value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetEnableHa(bool value, bool suppress_events = false, const Value& cookie = Empty);
protected:
public:
	virtual void NotifyHost(const Value& cookie = Empty);
public:
	virtual void NotifyPort(const Value& cookie = Empty);
public:
	virtual void NotifyIndex(const Value& cookie = Empty);
public:
	virtual void NotifyUsername(const Value& cookie = Empty);
public:
	virtual void NotifyPassword(const Value& cookie = Empty);
public:
	virtual void NotifyCaPath(const Value& cookie = Empty);
public:
	virtual void NotifyCertPath(const Value& cookie = Empty);
public:
	virtual void NotifyKeyPath(const Value& cookie = Empty);
public:
	virtual void NotifyHostTagsTemplate(const Value& cookie = Empty);
public:
	virtual void NotifyServiceTagsTemplate(const Value& cookie = Empty);
public:
	virtual void NotifyFlushInterval(const Value& cookie = Empty);
public:
	virtual void NotifyFlushThreshold(const Value& cookie = Empty);
public:
	virtual void NotifyEnableSendPerfdata(const Value& cookie = Empty);
public:
	virtual void NotifyEnableTls(const Value& cookie = Empty);
public:
	virtual void NotifyInsecureNoverify(const Value& cookie = Empty);
public:
	virtual void NotifyEnableHa(const Value& cookie = Empty);
private:
	inline String GetDefaultHost() const;
private:
	inline String GetDefaultPort() const;
private:
	inline String GetDefaultIndex() const;
private:
	inline String GetDefaultUsername() const;
private:
	inline String GetDefaultPassword() const;
private:
	inline String GetDefaultCaPath() const;
private:
	inline String GetDefaultCertPath() const;
private:
	inline String GetDefaultKeyPath() const;
private:
	inline Dictionary::Ptr GetDefaultHostTagsTemplate() const;
private:
	inline Dictionary::Ptr GetDefaultServiceTagsTemplate() const;
private:
	inline int GetDefaultFlushInterval() const;
private:
	inline int GetDefaultFlushThreshold() const;
private:
	inline bool GetDefaultEnableSendPerfdata() const;
private:
	inline bool GetDefaultEnableTls() const;
private:
	inline bool GetDefaultInsecureNoverify() const;
private:
	inline bool GetDefaultEnableHa() const;
protected:
	virtual void ValidateHost(const Lazy<String>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidatePort(const Lazy<String>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateIndex(const Lazy<String>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateUsername(const Lazy<String>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidatePassword(const Lazy<String>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateCaPath(const Lazy<String>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateCertPath(const Lazy<String>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateKeyPath(const Lazy<String>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateHostTagsTemplate(const Lazy<Dictionary::Ptr>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateServiceTagsTemplate(const Lazy<Dictionary::Ptr>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateFlushInterval(const Lazy<int>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateFlushThreshold(const Lazy<int>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateEnableSendPerfdata(const Lazy<bool>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateEnableTls(const Lazy<bool>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateInsecureNoverify(const Lazy<bool>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateEnableHa(const Lazy<bool>& lvalue, const ValidationUtils& utils);
private:
	AtomicOrLocked<String> m_Host;
	AtomicOrLocked<String> m_Port;
	AtomicOrLocked<String> m_Index;
	AtomicOrLocked<String> m_Username;
	AtomicOrLocked<String> m_Password;
	AtomicOrLocked<String> m_CaPath;
	AtomicOrLocked<String> m_CertPath;
	AtomicOrLocked<String> m_KeyPath;
	AtomicOrLocked<Dictionary::Ptr> m_HostTagsTemplate;
	AtomicOrLocked<Dictionary::Ptr> m_ServiceTagsTemplate;
	AtomicOrLocked<int> m_FlushInterval;
	AtomicOrLocked<int> m_FlushThreshold;
	AtomicOrLocked<bool> m_EnableSendPerfdata;
	AtomicOrLocked<bool> m_EnableTls;
	AtomicOrLocked<bool> m_InsecureNoverify;
	AtomicOrLocked<bool> m_EnableHa;
public:
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnHostChanged;
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnPortChanged;
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnIndexChanged;
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnUsernameChanged;
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnPasswordChanged;
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnCaPathChanged;
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnCertPathChanged;
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnKeyPathChanged;
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnHostTagsTemplateChanged;
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnServiceTagsTemplateChanged;
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnFlushIntervalChanged;
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnFlushThresholdChanged;
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnEnableSendPerfdataChanged;
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnEnableTlsChanged;
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnInsecureNoverifyChanged;
	static boost::signals2::signal<void (const intrusive_ptr<ElasticsearchWriter>&, const Value&)> OnEnableHaChanged;
};

}
#endif /* ELASTICSEARCHWRITER_TI */
