#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<GelfWriter>::TypeImpl()
{ }

TypeImpl<GelfWriter>::~TypeImpl()
{ }

String TypeImpl<GelfWriter>::GetName() const
{
	return "GelfWriter";
}

int TypeImpl<GelfWriter>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<GelfWriter>::GetBaseType() const
{
	return ConfigObject::TypeInstance;
}

int TypeImpl<GelfWriter>::GetFieldId(const String& name) const
{
	int offset = ConfigObject::TypeInstance->GetFieldCount();

	switch (static_cast<int>(Utility::SDBM(name, 2))) {
		case 6494398:
			if (name == "ca_path")
				return offset + 3;

			break;
		case 6494402:
			if (name == "cert_path")
				return offset + 4;

			break;
		case 6494412:
			if (name == "connected")
				return offset + 7;

			break;
		case 6625609:
			if (name == "enable_send_perfdata")
				return offset + 6;
			if (name == "enable_ha")
				return offset + 9;
			if (name == "enable_tls")
				return offset + 10;

			break;
		case 6822407:
			if (name == "host")
				return offset + 0;

			break;
		case 6888005:
			if (name == "insecure_noverify")
				return offset + 11;

			break;
		case 7019194:
			if (name == "key_path")
				return offset + 5;

			break;
		case 7347199:
			if (name == "port")
				return offset + 1;

			break;
		case 7543989:
			if (name == "should_connect")
				return offset + 8;

			break;
		case 7543996:
			if (name == "source")
				return offset + 2;

			break;
	}

	return ConfigObject::TypeInstance->GetFieldId(name);
}

Field TypeImpl<GelfWriter>::GetFieldInfo(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount();
	if (real_id < 0) { return ConfigObject::TypeInstance->GetFieldInfo(id); }
	switch (real_id) {
		case 0:
			return {0, "String", "host", "host", nullptr, 2, 0};
		case 1:
			return {1, "String", "port", "port", nullptr, 2, 0};
		case 2:
			return {2, "String", "source", "source", nullptr, 2, 0};
		case 3:
			return {3, "String", "ca_path", "ca_path", nullptr, 2, 0};
		case 4:
			return {4, "String", "cert_path", "cert_path", nullptr, 2, 0};
		case 5:
			return {5, "String", "key_path", "key_path", nullptr, 2, 0};
		case 6:
			return {6, "Boolean", "enable_send_perfdata", "enable_send_perfdata", nullptr, 2, 0};
		case 7:
			return {7, "Boolean", "connected", "connected", nullptr, 1025, 0};
		case 8:
			return {8, "Boolean", "should_connect", "should_connect", nullptr, 1025, 0};
		case 9:
			return {9, "Boolean", "enable_ha", "enable_ha", nullptr, 2, 0};
		case 10:
			return {10, "Boolean", "enable_tls", "enable_tls", nullptr, 2, 0};
		case 11:
			return {11, "Boolean", "insecure_noverify", "insecure_noverify", nullptr, 2, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<GelfWriter>::GetFieldCount() const
{
	return 12 + ConfigObject::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<GelfWriter>::GetFactory() const
{
	return TypeHelper<GelfWriter, false>::GetFactory();
}

int TypeImpl<GelfWriter>::GetActivationPriority() const
{
	return 100;
}

void TypeImpl<GelfWriter>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	switch (real_id) {
		case 0:
			ObjectImpl<GelfWriter>::OnHostChanged.connect(callback);
			break;
		case 1:
			ObjectImpl<GelfWriter>::OnPortChanged.connect(callback);
			break;
		case 2:
			ObjectImpl<GelfWriter>::OnSourceChanged.connect(callback);
			break;
		case 3:
			ObjectImpl<GelfWriter>::OnCaPathChanged.connect(callback);
			break;
		case 4:
			ObjectImpl<GelfWriter>::OnCertPathChanged.connect(callback);
			break;
		case 5:
			ObjectImpl<GelfWriter>::OnKeyPathChanged.connect(callback);
			break;
		case 6:
			ObjectImpl<GelfWriter>::OnEnableSendPerfdataChanged.connect(callback);
			break;
		case 7:
			ObjectImpl<GelfWriter>::OnConnectedChanged.connect(callback);
			break;
		case 8:
			ObjectImpl<GelfWriter>::OnShouldConnectChanged.connect(callback);
			break;
		case 9:
			ObjectImpl<GelfWriter>::OnEnableHaChanged.connect(callback);
			break;
		case 10:
			ObjectImpl<GelfWriter>::OnEnableTlsChanged.connect(callback);
			break;
		case 11:
			ObjectImpl<GelfWriter>::OnInsecureNoverifyChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<GelfWriter>::Validate(int types, const ValidationUtils& utils)
{
	ConfigObject::Validate(types, utils);

	if (2 & types)
		ValidateHost(Lazy<String>([this]() { return GetHost(); }), utils);
	if (2 & types)
		ValidatePort(Lazy<String>([this]() { return GetPort(); }), utils);
	if (2 & types)
		ValidateSource(Lazy<String>([this]() { return GetSource(); }), utils);
	if (2 & types)
		ValidateCaPath(Lazy<String>([this]() { return GetCaPath(); }), utils);
	if (2 & types)
		ValidateCertPath(Lazy<String>([this]() { return GetCertPath(); }), utils);
	if (2 & types)
		ValidateKeyPath(Lazy<String>([this]() { return GetKeyPath(); }), utils);
	if (2 & types)
		ValidateEnableSendPerfdata(Lazy<bool>([this]() { return GetEnableSendPerfdata(); }), utils);
	if (1 & types)
		ValidateConnected(Lazy<bool>([this]() { return GetConnected(); }), utils);
	if (1 & types)
		ValidateShouldConnect(Lazy<bool>([this]() { return GetShouldConnect(); }), utils);
	if (2 & types)
		ValidateEnableHa(Lazy<bool>([this]() { return GetEnableHa(); }), utils);
	if (2 & types)
		ValidateEnableTls(Lazy<bool>([this]() { return GetEnableTls(); }), utils);
	if (2 & types)
		ValidateInsecureNoverify(Lazy<bool>([this]() { return GetInsecureNoverify(); }), utils);
}

void ObjectImpl<GelfWriter>::SimpleValidateHost(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GelfWriter>::SimpleValidatePort(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GelfWriter>::SimpleValidateSource(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GelfWriter>::SimpleValidateCaPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GelfWriter>::SimpleValidateCertPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GelfWriter>::SimpleValidateKeyPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GelfWriter>::SimpleValidateEnableSendPerfdata(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GelfWriter>::SimpleValidateConnected(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GelfWriter>::SimpleValidateShouldConnect(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GelfWriter>::SimpleValidateEnableHa(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GelfWriter>::SimpleValidateEnableTls(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GelfWriter>::SimpleValidateInsecureNoverify(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

ObjectImpl<GelfWriter>::ObjectImpl()
{
	SetHost(GetDefaultHost(), true);
	SetPort(GetDefaultPort(), true);
	SetSource(GetDefaultSource(), true);
	SetCaPath(GetDefaultCaPath(), true);
	SetCertPath(GetDefaultCertPath(), true);
	SetKeyPath(GetDefaultKeyPath(), true);
	SetEnableSendPerfdata(GetDefaultEnableSendPerfdata(), true);
	SetConnected(GetDefaultConnected(), true);
	SetShouldConnect(GetDefaultShouldConnect(), true);
	SetEnableHa(GetDefaultEnableHa(), true);
	SetEnableTls(GetDefaultEnableTls(), true);
	SetInsecureNoverify(GetDefaultInsecureNoverify(), true);
}

ObjectImpl<GelfWriter>::~ObjectImpl()
{ }

void ObjectImpl<GelfWriter>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::SetField(id, value, suppress_events, cookie); return; }
	switch (real_id) {
		case 0:
			SetHost(value, suppress_events, cookie);
			break;
		case 1:
			SetPort(value, suppress_events, cookie);
			break;
		case 2:
			SetSource(value, suppress_events, cookie);
			break;
		case 3:
			SetCaPath(value, suppress_events, cookie);
			break;
		case 4:
			SetCertPath(value, suppress_events, cookie);
			break;
		case 5:
			SetKeyPath(value, suppress_events, cookie);
			break;
		case 6:
			SetEnableSendPerfdata(value, suppress_events, cookie);
			break;
		case 7:
			SetConnected(value, suppress_events, cookie);
			break;
		case 8:
			SetShouldConnect(value, suppress_events, cookie);
			break;
		case 9:
			SetEnableHa(value, suppress_events, cookie);
			break;
		case 10:
			SetEnableTls(value, suppress_events, cookie);
			break;
		case 11:
			SetInsecureNoverify(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<GelfWriter>::GetField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::GetField(id); }
	switch (real_id) {
		case 0:
			return GetHost();
		case 1:
			return GetPort();
		case 2:
			return GetSource();
		case 3:
			return GetCaPath();
		case 4:
			return GetCertPath();
		case 5:
			return GetKeyPath();
		case 6:
			return GetEnableSendPerfdata();
		case 7:
			return GetConnected();
		case 8:
			return GetShouldConnect();
		case 9:
			return GetEnableHa();
		case 10:
			return GetEnableTls();
		case 11:
			return GetInsecureNoverify();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<GelfWriter>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::ValidateField(id, lvalue, utils); return; }
	switch (real_id) {
		case 0:
			ValidateHost(lvalue, utils);
			break;
		case 1:
			ValidatePort(lvalue, utils);
			break;
		case 2:
			ValidateSource(lvalue, utils);
			break;
		case 3:
			ValidateCaPath(lvalue, utils);
			break;
		case 4:
			ValidateCertPath(lvalue, utils);
			break;
		case 5:
			ValidateKeyPath(lvalue, utils);
			break;
		case 6:
			ValidateEnableSendPerfdata(lvalue, utils);
			break;
		case 7:
			ValidateConnected(lvalue, utils);
			break;
		case 8:
			ValidateShouldConnect(lvalue, utils);
			break;
		case 9:
			ValidateEnableHa(lvalue, utils);
			break;
		case 10:
			ValidateEnableTls(lvalue, utils);
			break;
		case 11:
			ValidateInsecureNoverify(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<GelfWriter>::NotifyField(int id, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::NotifyField(id, cookie); return; }
	switch (real_id) {
		case 0:
			NotifyHost(cookie);
			break;
		case 1:
			NotifyPort(cookie);
			break;
		case 2:
			NotifySource(cookie);
			break;
		case 3:
			NotifyCaPath(cookie);
			break;
		case 4:
			NotifyCertPath(cookie);
			break;
		case 5:
			NotifyKeyPath(cookie);
			break;
		case 6:
			NotifyEnableSendPerfdata(cookie);
			break;
		case 7:
			NotifyConnected(cookie);
			break;
		case 8:
			NotifyShouldConnect(cookie);
			break;
		case 9:
			NotifyEnableHa(cookie);
			break;
		case 10:
			NotifyEnableTls(cookie);
			break;
		case 11:
			NotifyInsecureNoverify(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<GelfWriter>::NavigateField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::NavigateField(id); }
	throw std::runtime_error("Invalid field ID.");
}

String ObjectImpl<GelfWriter>::GetHost() const
{
	return m_Host.load();
}

String ObjectImpl<GelfWriter>::GetPort() const
{
	return m_Port.load();
}

String ObjectImpl<GelfWriter>::GetSource() const
{
	return m_Source.load();
}

String ObjectImpl<GelfWriter>::GetCaPath() const
{
	return m_CaPath.load();
}

String ObjectImpl<GelfWriter>::GetCertPath() const
{
	return m_CertPath.load();
}

String ObjectImpl<GelfWriter>::GetKeyPath() const
{
	return m_KeyPath.load();
}

bool ObjectImpl<GelfWriter>::GetEnableSendPerfdata() const
{
	return m_EnableSendPerfdata.load();
}

bool ObjectImpl<GelfWriter>::GetConnected() const
{
	return m_Connected.load();
}

bool ObjectImpl<GelfWriter>::GetShouldConnect() const
{
	return m_ShouldConnect.load();
}

bool ObjectImpl<GelfWriter>::GetEnableHa() const
{
	return m_EnableHa.load();
}

bool ObjectImpl<GelfWriter>::GetEnableTls() const
{
	return m_EnableTls.load();
}

bool ObjectImpl<GelfWriter>::GetInsecureNoverify() const
{
	return m_InsecureNoverify.load();
}

void ObjectImpl<GelfWriter>::SetHost(const String& value, bool suppress_events, const Value& cookie)
{
	m_Host.store(value);
	if (!suppress_events) {
		NotifyHost(cookie);
	}

}

void ObjectImpl<GelfWriter>::SetPort(const String& value, bool suppress_events, const Value& cookie)
{
	m_Port.store(value);
	if (!suppress_events) {
		NotifyPort(cookie);
	}

}

void ObjectImpl<GelfWriter>::SetSource(const String& value, bool suppress_events, const Value& cookie)
{
	m_Source.store(value);
	if (!suppress_events) {
		NotifySource(cookie);
	}

}

void ObjectImpl<GelfWriter>::SetCaPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_CaPath.store(value);
	if (!suppress_events) {
		NotifyCaPath(cookie);
	}

}

void ObjectImpl<GelfWriter>::SetCertPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_CertPath.store(value);
	if (!suppress_events) {
		NotifyCertPath(cookie);
	}

}

void ObjectImpl<GelfWriter>::SetKeyPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_KeyPath.store(value);
	if (!suppress_events) {
		NotifyKeyPath(cookie);
	}

}

void ObjectImpl<GelfWriter>::SetEnableSendPerfdata(bool value, bool suppress_events, const Value& cookie)
{
	m_EnableSendPerfdata.store(value);
	if (!suppress_events) {
		NotifyEnableSendPerfdata(cookie);
	}

}

void ObjectImpl<GelfWriter>::SetConnected(bool value, bool suppress_events, const Value& cookie)
{
	m_Connected.store(value);
	if (!suppress_events) {
		NotifyConnected(cookie);
	}

}

void ObjectImpl<GelfWriter>::SetShouldConnect(bool value, bool suppress_events, const Value& cookie)
{
	m_ShouldConnect.store(value);
	if (!suppress_events) {
		NotifyShouldConnect(cookie);
	}

}

void ObjectImpl<GelfWriter>::SetEnableHa(bool value, bool suppress_events, const Value& cookie)
{
	m_EnableHa.store(value);
	if (!suppress_events) {
		NotifyEnableHa(cookie);
	}

}

void ObjectImpl<GelfWriter>::SetEnableTls(bool value, bool suppress_events, const Value& cookie)
{
	m_EnableTls.store(value);
	if (!suppress_events) {
		NotifyEnableTls(cookie);
	}

}

void ObjectImpl<GelfWriter>::SetInsecureNoverify(bool value, bool suppress_events, const Value& cookie)
{
	m_InsecureNoverify.store(value);
	if (!suppress_events) {
		NotifyInsecureNoverify(cookie);
	}

}

void ObjectImpl<GelfWriter>::NotifyHost(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnHostChanged(static_cast<GelfWriter *>(this), cookie);
}

void ObjectImpl<GelfWriter>::NotifyPort(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPortChanged(static_cast<GelfWriter *>(this), cookie);
}

void ObjectImpl<GelfWriter>::NotifySource(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSourceChanged(static_cast<GelfWriter *>(this), cookie);
}

void ObjectImpl<GelfWriter>::NotifyCaPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCaPathChanged(static_cast<GelfWriter *>(this), cookie);
}

void ObjectImpl<GelfWriter>::NotifyCertPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCertPathChanged(static_cast<GelfWriter *>(this), cookie);
}

void ObjectImpl<GelfWriter>::NotifyKeyPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnKeyPathChanged(static_cast<GelfWriter *>(this), cookie);
}

void ObjectImpl<GelfWriter>::NotifyEnableSendPerfdata(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnableSendPerfdataChanged(static_cast<GelfWriter *>(this), cookie);
}

void ObjectImpl<GelfWriter>::NotifyConnected(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnConnectedChanged(static_cast<GelfWriter *>(this), cookie);
}

void ObjectImpl<GelfWriter>::NotifyShouldConnect(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnShouldConnectChanged(static_cast<GelfWriter *>(this), cookie);
}

void ObjectImpl<GelfWriter>::NotifyEnableHa(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnableHaChanged(static_cast<GelfWriter *>(this), cookie);
}

void ObjectImpl<GelfWriter>::NotifyEnableTls(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnableTlsChanged(static_cast<GelfWriter *>(this), cookie);
}

void ObjectImpl<GelfWriter>::NotifyInsecureNoverify(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnInsecureNoverifyChanged(static_cast<GelfWriter *>(this), cookie);
}

String ObjectImpl<GelfWriter>::GetDefaultHost() const
{
	 return "127.0.0.1"; 
}

String ObjectImpl<GelfWriter>::GetDefaultPort() const
{
	 return "12201"; 
}

String ObjectImpl<GelfWriter>::GetDefaultSource() const
{
	 return "icinga2"; 
}

String ObjectImpl<GelfWriter>::GetDefaultCaPath() const
{
	return String();
}

String ObjectImpl<GelfWriter>::GetDefaultCertPath() const
{
	return String();
}

String ObjectImpl<GelfWriter>::GetDefaultKeyPath() const
{
	return String();
}

bool ObjectImpl<GelfWriter>::GetDefaultEnableSendPerfdata() const
{
	 return false; 
}

bool ObjectImpl<GelfWriter>::GetDefaultConnected() const
{
	return bool();
}

bool ObjectImpl<GelfWriter>::GetDefaultShouldConnect() const
{
	 return true; 
}

bool ObjectImpl<GelfWriter>::GetDefaultEnableHa() const
{
	 return false; 
}

bool ObjectImpl<GelfWriter>::GetDefaultEnableTls() const
{
	 return false; 
}

bool ObjectImpl<GelfWriter>::GetDefaultInsecureNoverify() const
{
	 return false; 
}


boost::signals2::signal<void (const intrusive_ptr<GelfWriter>&, const Value&)> ObjectImpl<GelfWriter>::OnHostChanged;


boost::signals2::signal<void (const intrusive_ptr<GelfWriter>&, const Value&)> ObjectImpl<GelfWriter>::OnPortChanged;


boost::signals2::signal<void (const intrusive_ptr<GelfWriter>&, const Value&)> ObjectImpl<GelfWriter>::OnSourceChanged;


boost::signals2::signal<void (const intrusive_ptr<GelfWriter>&, const Value&)> ObjectImpl<GelfWriter>::OnCaPathChanged;


boost::signals2::signal<void (const intrusive_ptr<GelfWriter>&, const Value&)> ObjectImpl<GelfWriter>::OnCertPathChanged;


boost::signals2::signal<void (const intrusive_ptr<GelfWriter>&, const Value&)> ObjectImpl<GelfWriter>::OnKeyPathChanged;


boost::signals2::signal<void (const intrusive_ptr<GelfWriter>&, const Value&)> ObjectImpl<GelfWriter>::OnEnableSendPerfdataChanged;


boost::signals2::signal<void (const intrusive_ptr<GelfWriter>&, const Value&)> ObjectImpl<GelfWriter>::OnConnectedChanged;


boost::signals2::signal<void (const intrusive_ptr<GelfWriter>&, const Value&)> ObjectImpl<GelfWriter>::OnShouldConnectChanged;


boost::signals2::signal<void (const intrusive_ptr<GelfWriter>&, const Value&)> ObjectImpl<GelfWriter>::OnEnableHaChanged;


boost::signals2::signal<void (const intrusive_ptr<GelfWriter>&, const Value&)> ObjectImpl<GelfWriter>::OnEnableTlsChanged;


boost::signals2::signal<void (const intrusive_ptr<GelfWriter>&, const Value&)> ObjectImpl<GelfWriter>::OnInsecureNoverifyChanged;

void ObjectImpl<GelfWriter>::ValidateCaPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCaPath(lvalue, utils);
}

void ObjectImpl<GelfWriter>::ValidateCertPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCertPath(lvalue, utils);
}

void ObjectImpl<GelfWriter>::ValidateConnected(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateConnected(lvalue, utils);
}

void ObjectImpl<GelfWriter>::ValidateEnableHa(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnableHa(lvalue, utils);
}

void ObjectImpl<GelfWriter>::ValidateEnableSendPerfdata(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnableSendPerfdata(lvalue, utils);
}

void ObjectImpl<GelfWriter>::ValidateEnableTls(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnableTls(lvalue, utils);
}

void ObjectImpl<GelfWriter>::ValidateHost(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateHost(lvalue, utils);
}

void ObjectImpl<GelfWriter>::ValidateInsecureNoverify(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateInsecureNoverify(lvalue, utils);
}

void ObjectImpl<GelfWriter>::ValidateKeyPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateKeyPath(lvalue, utils);
}

void ObjectImpl<GelfWriter>::ValidatePort(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePort(lvalue, utils);
}

void ObjectImpl<GelfWriter>::ValidateShouldConnect(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateShouldConnect(lvalue, utils);
}

void ObjectImpl<GelfWriter>::ValidateSource(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSource(lvalue, utils);
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
