#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<GraphiteWriter>::TypeImpl()
{ }

TypeImpl<GraphiteWriter>::~TypeImpl()
{ }

String TypeImpl<GraphiteWriter>::GetName() const
{
	return "GraphiteWriter";
}

int TypeImpl<GraphiteWriter>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<GraphiteWriter>::GetBaseType() const
{
	return ConfigObject::TypeInstance;
}

int TypeImpl<GraphiteWriter>::GetFieldId(const String& name) const
{
	int offset = ConfigObject::TypeInstance->GetFieldCount();

	switch (static_cast<int>(Utility::SDBM(name, 1))) {
		case 99:
			if (name == "connected")
				return offset + 6;

			break;
		case 101:
			if (name == "enable_send_thresholds")
				return offset + 4;
			if (name == "enable_send_metadata")
				return offset + 5;
			if (name == "enable_ha")
				return offset + 8;

			break;
		case 104:
			if (name == "host")
				return offset + 0;
			if (name == "host_name_template")
				return offset + 2;

			break;
		case 112:
			if (name == "port")
				return offset + 1;

			break;
		case 115:
			if (name == "service_name_template")
				return offset + 3;
			if (name == "should_connect")
				return offset + 7;

			break;
	}

	return ConfigObject::TypeInstance->GetFieldId(name);
}

Field TypeImpl<GraphiteWriter>::GetFieldInfo(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount();
	if (real_id < 0) { return ConfigObject::TypeInstance->GetFieldInfo(id); }
	switch (real_id) {
		case 0:
			return {0, "String", "host", "host", nullptr, 2, 0};
		case 1:
			return {1, "String", "port", "port", nullptr, 2, 0};
		case 2:
			return {2, "String", "host_name_template", "host_name_template", nullptr, 2, 0};
		case 3:
			return {3, "String", "service_name_template", "service_name_template", nullptr, 2, 0};
		case 4:
			return {4, "Boolean", "enable_send_thresholds", "enable_send_thresholds", nullptr, 2, 0};
		case 5:
			return {5, "Boolean", "enable_send_metadata", "enable_send_metadata", nullptr, 2, 0};
		case 6:
			return {6, "Boolean", "connected", "connected", nullptr, 1025, 0};
		case 7:
			return {7, "Boolean", "should_connect", "should_connect", nullptr, 1025, 0};
		case 8:
			return {8, "Boolean", "enable_ha", "enable_ha", nullptr, 2, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<GraphiteWriter>::GetFieldCount() const
{
	return 9 + ConfigObject::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<GraphiteWriter>::GetFactory() const
{
	return TypeHelper<GraphiteWriter, false>::GetFactory();
}

int TypeImpl<GraphiteWriter>::GetActivationPriority() const
{
	return 100;
}

void TypeImpl<GraphiteWriter>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	switch (real_id) {
		case 0:
			ObjectImpl<GraphiteWriter>::OnHostChanged.connect(callback);
			break;
		case 1:
			ObjectImpl<GraphiteWriter>::OnPortChanged.connect(callback);
			break;
		case 2:
			ObjectImpl<GraphiteWriter>::OnHostNameTemplateChanged.connect(callback);
			break;
		case 3:
			ObjectImpl<GraphiteWriter>::OnServiceNameTemplateChanged.connect(callback);
			break;
		case 4:
			ObjectImpl<GraphiteWriter>::OnEnableSendThresholdsChanged.connect(callback);
			break;
		case 5:
			ObjectImpl<GraphiteWriter>::OnEnableSendMetadataChanged.connect(callback);
			break;
		case 6:
			ObjectImpl<GraphiteWriter>::OnConnectedChanged.connect(callback);
			break;
		case 7:
			ObjectImpl<GraphiteWriter>::OnShouldConnectChanged.connect(callback);
			break;
		case 8:
			ObjectImpl<GraphiteWriter>::OnEnableHaChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<GraphiteWriter>::Validate(int types, const ValidationUtils& utils)
{
	ConfigObject::Validate(types, utils);

	if (2 & types)
		ValidateHost(Lazy<String>([this]() { return GetHost(); }), utils);
	if (2 & types)
		ValidatePort(Lazy<String>([this]() { return GetPort(); }), utils);
	if (2 & types)
		ValidateHostNameTemplate(Lazy<String>([this]() { return GetHostNameTemplate(); }), utils);
	if (2 & types)
		ValidateServiceNameTemplate(Lazy<String>([this]() { return GetServiceNameTemplate(); }), utils);
	if (2 & types)
		ValidateEnableSendThresholds(Lazy<bool>([this]() { return GetEnableSendThresholds(); }), utils);
	if (2 & types)
		ValidateEnableSendMetadata(Lazy<bool>([this]() { return GetEnableSendMetadata(); }), utils);
	if (1 & types)
		ValidateConnected(Lazy<bool>([this]() { return GetConnected(); }), utils);
	if (1 & types)
		ValidateShouldConnect(Lazy<bool>([this]() { return GetShouldConnect(); }), utils);
	if (2 & types)
		ValidateEnableHa(Lazy<bool>([this]() { return GetEnableHa(); }), utils);
}

void ObjectImpl<GraphiteWriter>::SimpleValidateHost(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GraphiteWriter>::SimpleValidatePort(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GraphiteWriter>::SimpleValidateHostNameTemplate(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GraphiteWriter>::SimpleValidateServiceNameTemplate(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GraphiteWriter>::SimpleValidateEnableSendThresholds(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GraphiteWriter>::SimpleValidateEnableSendMetadata(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GraphiteWriter>::SimpleValidateConnected(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GraphiteWriter>::SimpleValidateShouldConnect(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<GraphiteWriter>::SimpleValidateEnableHa(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

ObjectImpl<GraphiteWriter>::ObjectImpl()
{
	SetHost(GetDefaultHost(), true);
	SetPort(GetDefaultPort(), true);
	SetHostNameTemplate(GetDefaultHostNameTemplate(), true);
	SetServiceNameTemplate(GetDefaultServiceNameTemplate(), true);
	SetEnableSendThresholds(GetDefaultEnableSendThresholds(), true);
	SetEnableSendMetadata(GetDefaultEnableSendMetadata(), true);
	SetConnected(GetDefaultConnected(), true);
	SetShouldConnect(GetDefaultShouldConnect(), true);
	SetEnableHa(GetDefaultEnableHa(), true);
}

ObjectImpl<GraphiteWriter>::~ObjectImpl()
{ }

void ObjectImpl<GraphiteWriter>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::SetField(id, value, suppress_events, cookie); return; }
	switch (real_id) {
		case 0:
			SetHost(value, suppress_events, cookie);
			break;
		case 1:
			SetPort(value, suppress_events, cookie);
			break;
		case 2:
			SetHostNameTemplate(value, suppress_events, cookie);
			break;
		case 3:
			SetServiceNameTemplate(value, suppress_events, cookie);
			break;
		case 4:
			SetEnableSendThresholds(value, suppress_events, cookie);
			break;
		case 5:
			SetEnableSendMetadata(value, suppress_events, cookie);
			break;
		case 6:
			SetConnected(value, suppress_events, cookie);
			break;
		case 7:
			SetShouldConnect(value, suppress_events, cookie);
			break;
		case 8:
			SetEnableHa(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<GraphiteWriter>::GetField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::GetField(id); }
	switch (real_id) {
		case 0:
			return GetHost();
		case 1:
			return GetPort();
		case 2:
			return GetHostNameTemplate();
		case 3:
			return GetServiceNameTemplate();
		case 4:
			return GetEnableSendThresholds();
		case 5:
			return GetEnableSendMetadata();
		case 6:
			return GetConnected();
		case 7:
			return GetShouldConnect();
		case 8:
			return GetEnableHa();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<GraphiteWriter>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::ValidateField(id, lvalue, utils); return; }
	switch (real_id) {
		case 0:
			ValidateHost(lvalue, utils);
			break;
		case 1:
			ValidatePort(lvalue, utils);
			break;
		case 2:
			ValidateHostNameTemplate(lvalue, utils);
			break;
		case 3:
			ValidateServiceNameTemplate(lvalue, utils);
			break;
		case 4:
			ValidateEnableSendThresholds(lvalue, utils);
			break;
		case 5:
			ValidateEnableSendMetadata(lvalue, utils);
			break;
		case 6:
			ValidateConnected(lvalue, utils);
			break;
		case 7:
			ValidateShouldConnect(lvalue, utils);
			break;
		case 8:
			ValidateEnableHa(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<GraphiteWriter>::NotifyField(int id, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::NotifyField(id, cookie); return; }
	switch (real_id) {
		case 0:
			NotifyHost(cookie);
			break;
		case 1:
			NotifyPort(cookie);
			break;
		case 2:
			NotifyHostNameTemplate(cookie);
			break;
		case 3:
			NotifyServiceNameTemplate(cookie);
			break;
		case 4:
			NotifyEnableSendThresholds(cookie);
			break;
		case 5:
			NotifyEnableSendMetadata(cookie);
			break;
		case 6:
			NotifyConnected(cookie);
			break;
		case 7:
			NotifyShouldConnect(cookie);
			break;
		case 8:
			NotifyEnableHa(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<GraphiteWriter>::NavigateField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::NavigateField(id); }
	throw std::runtime_error("Invalid field ID.");
}

String ObjectImpl<GraphiteWriter>::GetHost() const
{
	return m_Host.load();
}

String ObjectImpl<GraphiteWriter>::GetPort() const
{
	return m_Port.load();
}

String ObjectImpl<GraphiteWriter>::GetHostNameTemplate() const
{
	return m_HostNameTemplate.load();
}

String ObjectImpl<GraphiteWriter>::GetServiceNameTemplate() const
{
	return m_ServiceNameTemplate.load();
}

bool ObjectImpl<GraphiteWriter>::GetEnableSendThresholds() const
{
	return m_EnableSendThresholds.load();
}

bool ObjectImpl<GraphiteWriter>::GetEnableSendMetadata() const
{
	return m_EnableSendMetadata.load();
}

bool ObjectImpl<GraphiteWriter>::GetConnected() const
{
	return m_Connected.load();
}

bool ObjectImpl<GraphiteWriter>::GetShouldConnect() const
{
	return m_ShouldConnect.load();
}

bool ObjectImpl<GraphiteWriter>::GetEnableHa() const
{
	return m_EnableHa.load();
}

void ObjectImpl<GraphiteWriter>::SetHost(const String& value, bool suppress_events, const Value& cookie)
{
	m_Host.store(value);
	if (!suppress_events) {
		NotifyHost(cookie);
	}

}

void ObjectImpl<GraphiteWriter>::SetPort(const String& value, bool suppress_events, const Value& cookie)
{
	m_Port.store(value);
	if (!suppress_events) {
		NotifyPort(cookie);
	}

}

void ObjectImpl<GraphiteWriter>::SetHostNameTemplate(const String& value, bool suppress_events, const Value& cookie)
{
	m_HostNameTemplate.store(value);
	if (!suppress_events) {
		NotifyHostNameTemplate(cookie);
	}

}

void ObjectImpl<GraphiteWriter>::SetServiceNameTemplate(const String& value, bool suppress_events, const Value& cookie)
{
	m_ServiceNameTemplate.store(value);
	if (!suppress_events) {
		NotifyServiceNameTemplate(cookie);
	}

}

void ObjectImpl<GraphiteWriter>::SetEnableSendThresholds(bool value, bool suppress_events, const Value& cookie)
{
	m_EnableSendThresholds.store(value);
	if (!suppress_events) {
		NotifyEnableSendThresholds(cookie);
	}

}

void ObjectImpl<GraphiteWriter>::SetEnableSendMetadata(bool value, bool suppress_events, const Value& cookie)
{
	m_EnableSendMetadata.store(value);
	if (!suppress_events) {
		NotifyEnableSendMetadata(cookie);
	}

}

void ObjectImpl<GraphiteWriter>::SetConnected(bool value, bool suppress_events, const Value& cookie)
{
	m_Connected.store(value);
	if (!suppress_events) {
		NotifyConnected(cookie);
	}

}

void ObjectImpl<GraphiteWriter>::SetShouldConnect(bool value, bool suppress_events, const Value& cookie)
{
	m_ShouldConnect.store(value);
	if (!suppress_events) {
		NotifyShouldConnect(cookie);
	}

}

void ObjectImpl<GraphiteWriter>::SetEnableHa(bool value, bool suppress_events, const Value& cookie)
{
	m_EnableHa.store(value);
	if (!suppress_events) {
		NotifyEnableHa(cookie);
	}

}

void ObjectImpl<GraphiteWriter>::NotifyHost(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnHostChanged(static_cast<GraphiteWriter *>(this), cookie);
}

void ObjectImpl<GraphiteWriter>::NotifyPort(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPortChanged(static_cast<GraphiteWriter *>(this), cookie);
}

void ObjectImpl<GraphiteWriter>::NotifyHostNameTemplate(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnHostNameTemplateChanged(static_cast<GraphiteWriter *>(this), cookie);
}

void ObjectImpl<GraphiteWriter>::NotifyServiceNameTemplate(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnServiceNameTemplateChanged(static_cast<GraphiteWriter *>(this), cookie);
}

void ObjectImpl<GraphiteWriter>::NotifyEnableSendThresholds(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnableSendThresholdsChanged(static_cast<GraphiteWriter *>(this), cookie);
}

void ObjectImpl<GraphiteWriter>::NotifyEnableSendMetadata(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnableSendMetadataChanged(static_cast<GraphiteWriter *>(this), cookie);
}

void ObjectImpl<GraphiteWriter>::NotifyConnected(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnConnectedChanged(static_cast<GraphiteWriter *>(this), cookie);
}

void ObjectImpl<GraphiteWriter>::NotifyShouldConnect(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnShouldConnectChanged(static_cast<GraphiteWriter *>(this), cookie);
}

void ObjectImpl<GraphiteWriter>::NotifyEnableHa(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnableHaChanged(static_cast<GraphiteWriter *>(this), cookie);
}

String ObjectImpl<GraphiteWriter>::GetDefaultHost() const
{
	 return "127.0.0.1"; 
}

String ObjectImpl<GraphiteWriter>::GetDefaultPort() const
{
	 return "2003"; 
}

String ObjectImpl<GraphiteWriter>::GetDefaultHostNameTemplate() const
{
	 return "icinga2.$host.name$.host.$host.check_command$"; 
}

String ObjectImpl<GraphiteWriter>::GetDefaultServiceNameTemplate() const
{
	 return "icinga2.$host.name$.services.$service.name$.$service.check_command$"; 
}

bool ObjectImpl<GraphiteWriter>::GetDefaultEnableSendThresholds() const
{
	return bool();
}

bool ObjectImpl<GraphiteWriter>::GetDefaultEnableSendMetadata() const
{
	return bool();
}

bool ObjectImpl<GraphiteWriter>::GetDefaultConnected() const
{
	return bool();
}

bool ObjectImpl<GraphiteWriter>::GetDefaultShouldConnect() const
{
	 return true; 
}

bool ObjectImpl<GraphiteWriter>::GetDefaultEnableHa() const
{
	 return false; 
}


boost::signals2::signal<void (const intrusive_ptr<GraphiteWriter>&, const Value&)> ObjectImpl<GraphiteWriter>::OnHostChanged;


boost::signals2::signal<void (const intrusive_ptr<GraphiteWriter>&, const Value&)> ObjectImpl<GraphiteWriter>::OnPortChanged;


boost::signals2::signal<void (const intrusive_ptr<GraphiteWriter>&, const Value&)> ObjectImpl<GraphiteWriter>::OnHostNameTemplateChanged;


boost::signals2::signal<void (const intrusive_ptr<GraphiteWriter>&, const Value&)> ObjectImpl<GraphiteWriter>::OnServiceNameTemplateChanged;


boost::signals2::signal<void (const intrusive_ptr<GraphiteWriter>&, const Value&)> ObjectImpl<GraphiteWriter>::OnEnableSendThresholdsChanged;


boost::signals2::signal<void (const intrusive_ptr<GraphiteWriter>&, const Value&)> ObjectImpl<GraphiteWriter>::OnEnableSendMetadataChanged;


boost::signals2::signal<void (const intrusive_ptr<GraphiteWriter>&, const Value&)> ObjectImpl<GraphiteWriter>::OnConnectedChanged;


boost::signals2::signal<void (const intrusive_ptr<GraphiteWriter>&, const Value&)> ObjectImpl<GraphiteWriter>::OnShouldConnectChanged;


boost::signals2::signal<void (const intrusive_ptr<GraphiteWriter>&, const Value&)> ObjectImpl<GraphiteWriter>::OnEnableHaChanged;

void ObjectImpl<GraphiteWriter>::ValidateConnected(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateConnected(lvalue, utils);
}

void ObjectImpl<GraphiteWriter>::ValidateEnableHa(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnableHa(lvalue, utils);
}

void ObjectImpl<GraphiteWriter>::ValidateEnableSendMetadata(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnableSendMetadata(lvalue, utils);
}

void ObjectImpl<GraphiteWriter>::ValidateEnableSendThresholds(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnableSendThresholds(lvalue, utils);
}

void ObjectImpl<GraphiteWriter>::ValidateHost(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateHost(lvalue, utils);
}

void ObjectImpl<GraphiteWriter>::ValidateHostNameTemplate(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateHostNameTemplate(lvalue, utils);
}

void ObjectImpl<GraphiteWriter>::ValidatePort(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePort(lvalue, utils);
}

void ObjectImpl<GraphiteWriter>::ValidateServiceNameTemplate(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateServiceNameTemplate(lvalue, utils);
}

void ObjectImpl<GraphiteWriter>::ValidateShouldConnect(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateShouldConnect(lvalue, utils);
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
