#ifndef INFLUXDB2WRITER_TI
#define INFLUXDB2WRITER_TI

#include "base/object.hpp"
#include "base/type.hpp"
#include "base/value.hpp"
#include "base/array.hpp"
#include "base/atomic.hpp"
#include "base/dictionary.hpp"
#include <boost/signals2.hpp>

#include "perfdata/influxdbcommonwriter.hpp"

namespace icinga
{

class Influxdb2Writer;

template<>
class TypeImpl<Influxdb2Writer> : public TypeImpl<InfluxdbCommonWriter>
{
public:
	DECLARE_PTR_TYPEDEFS(TypeImpl<Influxdb2Writer>);

	TypeImpl();
	~TypeImpl() override;

	String GetName() const override;
	int GetAttributes() const override;
	Type::Ptr GetBaseType() const override;
	int GetFieldId(const String& name) const override;
	Field GetFieldInfo(int id) const override;
	int GetFieldCount() const override;
	ObjectFactory GetFactory() const override;
	int GetActivationPriority() const override;
public:
	void RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback) override;
};


template<>
class ObjectImpl<Influxdb2Writer> : public InfluxdbCommonWriter
{
public:
	DECLARE_PTR_TYPEDEFS(ObjectImpl<Influxdb2Writer>);

	void Validate(int types, const ValidationUtils& utils) override;
	void SimpleValidateOrganization(const Lazy<String>& value, const ValidationUtils& utils);
	void SimpleValidateBucket(const Lazy<String>& value, const ValidationUtils& utils);
	void SimpleValidateAuthToken(const Lazy<String>& value, const ValidationUtils& utils);
public:
	ObjectImpl<Influxdb2Writer>();
public:
	~ObjectImpl<Influxdb2Writer>() override;
public:
	void SetField(int id, const Value& value, bool suppress_events = false, const Value& cookie = Empty) override;
public:
	Value GetField(int id) const override;
public:
	void ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils) override;
public:
	void NotifyField(int id, const Value& cookie = Empty) override;
public:
	Object::Ptr NavigateField(int id) const override;
public:
	String GetOrganization() const;
public:
	String GetBucket() const;
public:
	String GetAuthToken() const;
public:
	void SetOrganization(const String& value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetBucket(const String& value, bool suppress_events = false, const Value& cookie = Empty);
public:
	void SetAuthToken(const String& value, bool suppress_events = false, const Value& cookie = Empty);
protected:
public:
	virtual void NotifyOrganization(const Value& cookie = Empty);
public:
	virtual void NotifyBucket(const Value& cookie = Empty);
public:
	virtual void NotifyAuthToken(const Value& cookie = Empty);
private:
	inline String GetDefaultOrganization() const;
private:
	inline String GetDefaultBucket() const;
private:
	inline String GetDefaultAuthToken() const;
protected:
	virtual void ValidateOrganization(const Lazy<String>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateBucket(const Lazy<String>& lvalue, const ValidationUtils& utils);
protected:
	virtual void ValidateAuthToken(const Lazy<String>& lvalue, const ValidationUtils& utils);
private:
	AtomicOrLocked<String> m_Organization;
	AtomicOrLocked<String> m_Bucket;
	AtomicOrLocked<String> m_AuthToken;
public:
	static boost::signals2::signal<void (const intrusive_ptr<Influxdb2Writer>&, const Value&)> OnOrganizationChanged;
	static boost::signals2::signal<void (const intrusive_ptr<Influxdb2Writer>&, const Value&)> OnBucketChanged;
	static boost::signals2::signal<void (const intrusive_ptr<Influxdb2Writer>&, const Value&)> OnAuthTokenChanged;
};

}
#endif /* INFLUXDB2WRITER_TI */
