#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<InfluxdbCommonWriter>::TypeImpl()
{ }

TypeImpl<InfluxdbCommonWriter>::~TypeImpl()
{ }

String TypeImpl<InfluxdbCommonWriter>::GetName() const
{
	return "InfluxdbCommonWriter";
}

int TypeImpl<InfluxdbCommonWriter>::GetAttributes() const
{
	return 1;
}

Type::Ptr TypeImpl<InfluxdbCommonWriter>::GetBaseType() const
{
	return ConfigObject::TypeInstance;
}

int TypeImpl<InfluxdbCommonWriter>::GetFieldId(const String& name) const
{
	int offset = ConfigObject::TypeInstance->GetFieldCount();

	switch (static_cast<int>(Utility::SDBM(name, 5))) {
		case -1844041471:
			if (name == "port")
				return offset + 1;

			break;
		case -1622403728:
			if (name == "ssl_ca_cert")
				return offset + 2;
			if (name == "ssl_cert")
				return offset + 3;

			break;
		case -1622403726:
			if (name == "ssl_enable")
				return offset + 9;

			break;
		case -1622403722:
			if (name == "ssl_insecure_noverify")
				return offset + 10;

			break;
		case -1622403720:
			if (name == "ssl_key")
				return offset + 4;

			break;
		case -350347868:
			if (name == "flush_interval")
				return offset + 7;
			if (name == "flush_threshold")
				return offset + 8;

			break;
		case -95083038:
			if (name == "enable_send_thresholds")
				return offset + 11;
			if (name == "enable_send_metadata")
				return offset + 12;
			if (name == "enable_ha")
				return offset + 13;

			break;
		case -40882409:
			if (name == "host_template")
				return offset + 5;

			break;
		case 385355187:
			if (name == "service_template")
				return offset + 6;

			break;
		case 501261128:
			if (name == "host")
				return offset + 0;

			break;
	}

	return ConfigObject::TypeInstance->GetFieldId(name);
}

Field TypeImpl<InfluxdbCommonWriter>::GetFieldInfo(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount();
	if (real_id < 0) { return ConfigObject::TypeInstance->GetFieldInfo(id); }
	switch (real_id) {
		case 0:
			return {0, "String", "host", "host", nullptr, 258, 0};
		case 1:
			return {1, "String", "port", "port", nullptr, 258, 0};
		case 2:
			return {2, "String", "ssl_ca_cert", "ssl_ca_cert", nullptr, 2, 0};
		case 3:
			return {3, "String", "ssl_cert", "ssl_cert", nullptr, 2, 0};
		case 4:
			return {4, "String", "ssl_key", "ssl_key", nullptr, 2, 0};
		case 5:
			return {5, "Dictionary", "host_template", "host_template", nullptr, 258, 0};
		case 6:
			return {6, "Dictionary", "service_template", "service_template", nullptr, 258, 0};
		case 7:
			return {7, "Number", "flush_interval", "flush_interval", nullptr, 2, 0};
		case 8:
			return {8, "Number", "flush_threshold", "flush_threshold", nullptr, 2, 0};
		case 9:
			return {9, "Boolean", "ssl_enable", "ssl_enable", nullptr, 2, 0};
		case 10:
			return {10, "Boolean", "ssl_insecure_noverify", "ssl_insecure_noverify", nullptr, 2, 0};
		case 11:
			return {11, "Boolean", "enable_send_thresholds", "enable_send_thresholds", nullptr, 2, 0};
		case 12:
			return {12, "Boolean", "enable_send_metadata", "enable_send_metadata", nullptr, 2, 0};
		case 13:
			return {13, "Boolean", "enable_ha", "enable_ha", nullptr, 2, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<InfluxdbCommonWriter>::GetFieldCount() const
{
	return 14 + ConfigObject::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<InfluxdbCommonWriter>::GetFactory() const
{
	return TypeHelper<InfluxdbCommonWriter, false>::GetFactory();
}

int TypeImpl<InfluxdbCommonWriter>::GetActivationPriority() const
{
	return 0;
}

void TypeImpl<InfluxdbCommonWriter>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	switch (real_id) {
		case 0:
			ObjectImpl<InfluxdbCommonWriter>::OnHostChanged.connect(callback);
			break;
		case 1:
			ObjectImpl<InfluxdbCommonWriter>::OnPortChanged.connect(callback);
			break;
		case 2:
			ObjectImpl<InfluxdbCommonWriter>::OnSslCaCertChanged.connect(callback);
			break;
		case 3:
			ObjectImpl<InfluxdbCommonWriter>::OnSslCertChanged.connect(callback);
			break;
		case 4:
			ObjectImpl<InfluxdbCommonWriter>::OnSslKeyChanged.connect(callback);
			break;
		case 5:
			ObjectImpl<InfluxdbCommonWriter>::OnHostTemplateChanged.connect(callback);
			break;
		case 6:
			ObjectImpl<InfluxdbCommonWriter>::OnServiceTemplateChanged.connect(callback);
			break;
		case 7:
			ObjectImpl<InfluxdbCommonWriter>::OnFlushIntervalChanged.connect(callback);
			break;
		case 8:
			ObjectImpl<InfluxdbCommonWriter>::OnFlushThresholdChanged.connect(callback);
			break;
		case 9:
			ObjectImpl<InfluxdbCommonWriter>::OnSslEnableChanged.connect(callback);
			break;
		case 10:
			ObjectImpl<InfluxdbCommonWriter>::OnSslInsecureNoverifyChanged.connect(callback);
			break;
		case 11:
			ObjectImpl<InfluxdbCommonWriter>::OnEnableSendThresholdsChanged.connect(callback);
			break;
		case 12:
			ObjectImpl<InfluxdbCommonWriter>::OnEnableSendMetadataChanged.connect(callback);
			break;
		case 13:
			ObjectImpl<InfluxdbCommonWriter>::OnEnableHaChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<InfluxdbCommonWriter>::Validate(int types, const ValidationUtils& utils)
{
	ConfigObject::Validate(types, utils);

	if (2 & types)
		ValidateHost(Lazy<String>([this]() { return GetHost(); }), utils);
	if (2 & types)
		ValidatePort(Lazy<String>([this]() { return GetPort(); }), utils);
	if (2 & types)
		ValidateSslCaCert(Lazy<String>([this]() { return GetSslCaCert(); }), utils);
	if (2 & types)
		ValidateSslCert(Lazy<String>([this]() { return GetSslCert(); }), utils);
	if (2 & types)
		ValidateSslKey(Lazy<String>([this]() { return GetSslKey(); }), utils);
	if (2 & types)
		ValidateHostTemplate(Lazy<Dictionary::Ptr>([this]() { return GetHostTemplate(); }), utils);
	if (2 & types)
		ValidateServiceTemplate(Lazy<Dictionary::Ptr>([this]() { return GetServiceTemplate(); }), utils);
	if (2 & types)
		ValidateFlushInterval(Lazy<int>([this]() { return GetFlushInterval(); }), utils);
	if (2 & types)
		ValidateFlushThreshold(Lazy<int>([this]() { return GetFlushThreshold(); }), utils);
	if (2 & types)
		ValidateSslEnable(Lazy<bool>([this]() { return GetSslEnable(); }), utils);
	if (2 & types)
		ValidateSslInsecureNoverify(Lazy<bool>([this]() { return GetSslInsecureNoverify(); }), utils);
	if (2 & types)
		ValidateEnableSendThresholds(Lazy<bool>([this]() { return GetEnableSendThresholds(); }), utils);
	if (2 & types)
		ValidateEnableSendMetadata(Lazy<bool>([this]() { return GetEnableSendMetadata(); }), utils);
	if (2 & types)
		ValidateEnableHa(Lazy<bool>([this]() { return GetEnableHa(); }), utils);
}

void ObjectImpl<InfluxdbCommonWriter>::SimpleValidateHost(const Lazy<String>& value, const ValidationUtils& utils)
{
	if (value().IsEmpty())
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_cast<ConfigObject *>(this), { "host" }, "Attribute must not be empty."));

}

void ObjectImpl<InfluxdbCommonWriter>::SimpleValidatePort(const Lazy<String>& value, const ValidationUtils& utils)
{
	if (value().IsEmpty())
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_cast<ConfigObject *>(this), { "port" }, "Attribute must not be empty."));

}

void ObjectImpl<InfluxdbCommonWriter>::SimpleValidateSslCaCert(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<InfluxdbCommonWriter>::SimpleValidateSslCert(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<InfluxdbCommonWriter>::SimpleValidateSslKey(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<InfluxdbCommonWriter>::SimpleValidateHostTemplate(const Lazy<Dictionary::Ptr>& value, const ValidationUtils& utils)
{
	if (!value())
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_cast<ConfigObject *>(this), { "host_template" }, "Attribute must not be empty."));

}

void ObjectImpl<InfluxdbCommonWriter>::SimpleValidateServiceTemplate(const Lazy<Dictionary::Ptr>& value, const ValidationUtils& utils)
{
	if (!value())
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_cast<ConfigObject *>(this), { "service_template" }, "Attribute must not be empty."));

}

void ObjectImpl<InfluxdbCommonWriter>::SimpleValidateFlushInterval(const Lazy<int>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<InfluxdbCommonWriter>::SimpleValidateFlushThreshold(const Lazy<int>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<InfluxdbCommonWriter>::SimpleValidateSslEnable(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<InfluxdbCommonWriter>::SimpleValidateSslInsecureNoverify(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<InfluxdbCommonWriter>::SimpleValidateEnableSendThresholds(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<InfluxdbCommonWriter>::SimpleValidateEnableSendMetadata(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<InfluxdbCommonWriter>::SimpleValidateEnableHa(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

ObjectImpl<InfluxdbCommonWriter>::ObjectImpl()
{
	SetHost(GetDefaultHost(), true);
	SetPort(GetDefaultPort(), true);
	SetSslCaCert(GetDefaultSslCaCert(), true);
	SetSslCert(GetDefaultSslCert(), true);
	SetSslKey(GetDefaultSslKey(), true);
	SetHostTemplate(GetDefaultHostTemplate(), true);
	SetServiceTemplate(GetDefaultServiceTemplate(), true);
	SetFlushInterval(GetDefaultFlushInterval(), true);
	SetFlushThreshold(GetDefaultFlushThreshold(), true);
	SetSslEnable(GetDefaultSslEnable(), true);
	SetSslInsecureNoverify(GetDefaultSslInsecureNoverify(), true);
	SetEnableSendThresholds(GetDefaultEnableSendThresholds(), true);
	SetEnableSendMetadata(GetDefaultEnableSendMetadata(), true);
	SetEnableHa(GetDefaultEnableHa(), true);
}

ObjectImpl<InfluxdbCommonWriter>::~ObjectImpl()
{ }

void ObjectImpl<InfluxdbCommonWriter>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::SetField(id, value, suppress_events, cookie); return; }
	switch (real_id) {
		case 0:
			SetHost(value, suppress_events, cookie);
			break;
		case 1:
			SetPort(value, suppress_events, cookie);
			break;
		case 2:
			SetSslCaCert(value, suppress_events, cookie);
			break;
		case 3:
			SetSslCert(value, suppress_events, cookie);
			break;
		case 4:
			SetSslKey(value, suppress_events, cookie);
			break;
		case 5:
			SetHostTemplate(value, suppress_events, cookie);
			break;
		case 6:
			SetServiceTemplate(value, suppress_events, cookie);
			break;
		case 7:
			SetFlushInterval(value, suppress_events, cookie);
			break;
		case 8:
			SetFlushThreshold(value, suppress_events, cookie);
			break;
		case 9:
			SetSslEnable(value, suppress_events, cookie);
			break;
		case 10:
			SetSslInsecureNoverify(value, suppress_events, cookie);
			break;
		case 11:
			SetEnableSendThresholds(value, suppress_events, cookie);
			break;
		case 12:
			SetEnableSendMetadata(value, suppress_events, cookie);
			break;
		case 13:
			SetEnableHa(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<InfluxdbCommonWriter>::GetField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::GetField(id); }
	switch (real_id) {
		case 0:
			return GetHost();
		case 1:
			return GetPort();
		case 2:
			return GetSslCaCert();
		case 3:
			return GetSslCert();
		case 4:
			return GetSslKey();
		case 5:
			return GetHostTemplate();
		case 6:
			return GetServiceTemplate();
		case 7:
			return GetFlushInterval();
		case 8:
			return GetFlushThreshold();
		case 9:
			return GetSslEnable();
		case 10:
			return GetSslInsecureNoverify();
		case 11:
			return GetEnableSendThresholds();
		case 12:
			return GetEnableSendMetadata();
		case 13:
			return GetEnableHa();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<InfluxdbCommonWriter>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::ValidateField(id, lvalue, utils); return; }
	switch (real_id) {
		case 0:
			ValidateHost(lvalue, utils);
			break;
		case 1:
			ValidatePort(lvalue, utils);
			break;
		case 2:
			ValidateSslCaCert(lvalue, utils);
			break;
		case 3:
			ValidateSslCert(lvalue, utils);
			break;
		case 4:
			ValidateSslKey(lvalue, utils);
			break;
		case 5:
			ValidateHostTemplate(lvalue, utils);
			break;
		case 6:
			ValidateServiceTemplate(lvalue, utils);
			break;
		case 7:
			ValidateFlushInterval(lvalue, utils);
			break;
		case 8:
			ValidateFlushThreshold(lvalue, utils);
			break;
		case 9:
			ValidateSslEnable(lvalue, utils);
			break;
		case 10:
			ValidateSslInsecureNoverify(lvalue, utils);
			break;
		case 11:
			ValidateEnableSendThresholds(lvalue, utils);
			break;
		case 12:
			ValidateEnableSendMetadata(lvalue, utils);
			break;
		case 13:
			ValidateEnableHa(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<InfluxdbCommonWriter>::NotifyField(int id, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::NotifyField(id, cookie); return; }
	switch (real_id) {
		case 0:
			NotifyHost(cookie);
			break;
		case 1:
			NotifyPort(cookie);
			break;
		case 2:
			NotifySslCaCert(cookie);
			break;
		case 3:
			NotifySslCert(cookie);
			break;
		case 4:
			NotifySslKey(cookie);
			break;
		case 5:
			NotifyHostTemplate(cookie);
			break;
		case 6:
			NotifyServiceTemplate(cookie);
			break;
		case 7:
			NotifyFlushInterval(cookie);
			break;
		case 8:
			NotifyFlushThreshold(cookie);
			break;
		case 9:
			NotifySslEnable(cookie);
			break;
		case 10:
			NotifySslInsecureNoverify(cookie);
			break;
		case 11:
			NotifyEnableSendThresholds(cookie);
			break;
		case 12:
			NotifyEnableSendMetadata(cookie);
			break;
		case 13:
			NotifyEnableHa(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<InfluxdbCommonWriter>::NavigateField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::NavigateField(id); }
	throw std::runtime_error("Invalid field ID.");
}

String ObjectImpl<InfluxdbCommonWriter>::GetHost() const
{
	return m_Host.load();
}

String ObjectImpl<InfluxdbCommonWriter>::GetPort() const
{
	return m_Port.load();
}

String ObjectImpl<InfluxdbCommonWriter>::GetSslCaCert() const
{
	return m_SslCaCert.load();
}

String ObjectImpl<InfluxdbCommonWriter>::GetSslCert() const
{
	return m_SslCert.load();
}

String ObjectImpl<InfluxdbCommonWriter>::GetSslKey() const
{
	return m_SslKey.load();
}

Dictionary::Ptr ObjectImpl<InfluxdbCommonWriter>::GetHostTemplate() const
{
	return m_HostTemplate.load();
}

Dictionary::Ptr ObjectImpl<InfluxdbCommonWriter>::GetServiceTemplate() const
{
	return m_ServiceTemplate.load();
}

int ObjectImpl<InfluxdbCommonWriter>::GetFlushInterval() const
{
	return m_FlushInterval.load();
}

int ObjectImpl<InfluxdbCommonWriter>::GetFlushThreshold() const
{
	return m_FlushThreshold.load();
}

bool ObjectImpl<InfluxdbCommonWriter>::GetSslEnable() const
{
	return m_SslEnable.load();
}

bool ObjectImpl<InfluxdbCommonWriter>::GetSslInsecureNoverify() const
{
	return m_SslInsecureNoverify.load();
}

bool ObjectImpl<InfluxdbCommonWriter>::GetEnableSendThresholds() const
{
	return m_EnableSendThresholds.load();
}

bool ObjectImpl<InfluxdbCommonWriter>::GetEnableSendMetadata() const
{
	return m_EnableSendMetadata.load();
}

bool ObjectImpl<InfluxdbCommonWriter>::GetEnableHa() const
{
	return m_EnableHa.load();
}

void ObjectImpl<InfluxdbCommonWriter>::SetHost(const String& value, bool suppress_events, const Value& cookie)
{
	m_Host.store(value);
	if (!suppress_events) {
		NotifyHost(cookie);
	}

}

void ObjectImpl<InfluxdbCommonWriter>::SetPort(const String& value, bool suppress_events, const Value& cookie)
{
	m_Port.store(value);
	if (!suppress_events) {
		NotifyPort(cookie);
	}

}

void ObjectImpl<InfluxdbCommonWriter>::SetSslCaCert(const String& value, bool suppress_events, const Value& cookie)
{
	m_SslCaCert.store(value);
	if (!suppress_events) {
		NotifySslCaCert(cookie);
	}

}

void ObjectImpl<InfluxdbCommonWriter>::SetSslCert(const String& value, bool suppress_events, const Value& cookie)
{
	m_SslCert.store(value);
	if (!suppress_events) {
		NotifySslCert(cookie);
	}

}

void ObjectImpl<InfluxdbCommonWriter>::SetSslKey(const String& value, bool suppress_events, const Value& cookie)
{
	m_SslKey.store(value);
	if (!suppress_events) {
		NotifySslKey(cookie);
	}

}

void ObjectImpl<InfluxdbCommonWriter>::SetHostTemplate(const Dictionary::Ptr& value, bool suppress_events, const Value& cookie)
{
	m_HostTemplate.store(value);
	if (!suppress_events) {
		NotifyHostTemplate(cookie);
	}

}

void ObjectImpl<InfluxdbCommonWriter>::SetServiceTemplate(const Dictionary::Ptr& value, bool suppress_events, const Value& cookie)
{
	m_ServiceTemplate.store(value);
	if (!suppress_events) {
		NotifyServiceTemplate(cookie);
	}

}

void ObjectImpl<InfluxdbCommonWriter>::SetFlushInterval(int value, bool suppress_events, const Value& cookie)
{
	m_FlushInterval.store(value);
	if (!suppress_events) {
		NotifyFlushInterval(cookie);
	}

}

void ObjectImpl<InfluxdbCommonWriter>::SetFlushThreshold(int value, bool suppress_events, const Value& cookie)
{
	m_FlushThreshold.store(value);
	if (!suppress_events) {
		NotifyFlushThreshold(cookie);
	}

}

void ObjectImpl<InfluxdbCommonWriter>::SetSslEnable(bool value, bool suppress_events, const Value& cookie)
{
	m_SslEnable.store(value);
	if (!suppress_events) {
		NotifySslEnable(cookie);
	}

}

void ObjectImpl<InfluxdbCommonWriter>::SetSslInsecureNoverify(bool value, bool suppress_events, const Value& cookie)
{
	m_SslInsecureNoverify.store(value);
	if (!suppress_events) {
		NotifySslInsecureNoverify(cookie);
	}

}

void ObjectImpl<InfluxdbCommonWriter>::SetEnableSendThresholds(bool value, bool suppress_events, const Value& cookie)
{
	m_EnableSendThresholds.store(value);
	if (!suppress_events) {
		NotifyEnableSendThresholds(cookie);
	}

}

void ObjectImpl<InfluxdbCommonWriter>::SetEnableSendMetadata(bool value, bool suppress_events, const Value& cookie)
{
	m_EnableSendMetadata.store(value);
	if (!suppress_events) {
		NotifyEnableSendMetadata(cookie);
	}

}

void ObjectImpl<InfluxdbCommonWriter>::SetEnableHa(bool value, bool suppress_events, const Value& cookie)
{
	m_EnableHa.store(value);
	if (!suppress_events) {
		NotifyEnableHa(cookie);
	}

}

void ObjectImpl<InfluxdbCommonWriter>::NotifyHost(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnHostChanged(static_cast<InfluxdbCommonWriter *>(this), cookie);
}

void ObjectImpl<InfluxdbCommonWriter>::NotifyPort(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPortChanged(static_cast<InfluxdbCommonWriter *>(this), cookie);
}

void ObjectImpl<InfluxdbCommonWriter>::NotifySslCaCert(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSslCaCertChanged(static_cast<InfluxdbCommonWriter *>(this), cookie);
}

void ObjectImpl<InfluxdbCommonWriter>::NotifySslCert(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSslCertChanged(static_cast<InfluxdbCommonWriter *>(this), cookie);
}

void ObjectImpl<InfluxdbCommonWriter>::NotifySslKey(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSslKeyChanged(static_cast<InfluxdbCommonWriter *>(this), cookie);
}

void ObjectImpl<InfluxdbCommonWriter>::NotifyHostTemplate(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnHostTemplateChanged(static_cast<InfluxdbCommonWriter *>(this), cookie);
}

void ObjectImpl<InfluxdbCommonWriter>::NotifyServiceTemplate(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnServiceTemplateChanged(static_cast<InfluxdbCommonWriter *>(this), cookie);
}

void ObjectImpl<InfluxdbCommonWriter>::NotifyFlushInterval(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnFlushIntervalChanged(static_cast<InfluxdbCommonWriter *>(this), cookie);
}

void ObjectImpl<InfluxdbCommonWriter>::NotifyFlushThreshold(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnFlushThresholdChanged(static_cast<InfluxdbCommonWriter *>(this), cookie);
}

void ObjectImpl<InfluxdbCommonWriter>::NotifySslEnable(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSslEnableChanged(static_cast<InfluxdbCommonWriter *>(this), cookie);
}

void ObjectImpl<InfluxdbCommonWriter>::NotifySslInsecureNoverify(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSslInsecureNoverifyChanged(static_cast<InfluxdbCommonWriter *>(this), cookie);
}

void ObjectImpl<InfluxdbCommonWriter>::NotifyEnableSendThresholds(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnableSendThresholdsChanged(static_cast<InfluxdbCommonWriter *>(this), cookie);
}

void ObjectImpl<InfluxdbCommonWriter>::NotifyEnableSendMetadata(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnableSendMetadataChanged(static_cast<InfluxdbCommonWriter *>(this), cookie);
}

void ObjectImpl<InfluxdbCommonWriter>::NotifyEnableHa(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEnableHaChanged(static_cast<InfluxdbCommonWriter *>(this), cookie);
}

String ObjectImpl<InfluxdbCommonWriter>::GetDefaultHost() const
{
	 return "127.0.0.1"; 
}

String ObjectImpl<InfluxdbCommonWriter>::GetDefaultPort() const
{
	 return "8086"; 
}

String ObjectImpl<InfluxdbCommonWriter>::GetDefaultSslCaCert() const
{
	 return ""; 
}

String ObjectImpl<InfluxdbCommonWriter>::GetDefaultSslCert() const
{
	 return ""; 
}

String ObjectImpl<InfluxdbCommonWriter>::GetDefaultSslKey() const
{
	 return ""; 
}

Dictionary::Ptr ObjectImpl<InfluxdbCommonWriter>::GetDefaultHostTemplate() const
{
	
			return new Dictionary({
				{ "measurement", "$host.check_command$" },
				{ "tags", new Dictionary({
					{ "hostname", "$host.name$" }
				}) }
			});
		
}

Dictionary::Ptr ObjectImpl<InfluxdbCommonWriter>::GetDefaultServiceTemplate() const
{
	
			return new Dictionary({
				{ "measurement", "$service.check_command$" },
				{ "tags", new Dictionary({
					{ "hostname", "$host.name$" },
					{ "service", "$service.name$" }
				}) }
			});
		
}

int ObjectImpl<InfluxdbCommonWriter>::GetDefaultFlushInterval() const
{
	 return 10; 
}

int ObjectImpl<InfluxdbCommonWriter>::GetDefaultFlushThreshold() const
{
	 return 1024; 
}

bool ObjectImpl<InfluxdbCommonWriter>::GetDefaultSslEnable() const
{
	 return false; 
}

bool ObjectImpl<InfluxdbCommonWriter>::GetDefaultSslInsecureNoverify() const
{
	 return false; 
}

bool ObjectImpl<InfluxdbCommonWriter>::GetDefaultEnableSendThresholds() const
{
	 return false; 
}

bool ObjectImpl<InfluxdbCommonWriter>::GetDefaultEnableSendMetadata() const
{
	 return false; 
}

bool ObjectImpl<InfluxdbCommonWriter>::GetDefaultEnableHa() const
{
	 return false; 
}


boost::signals2::signal<void (const intrusive_ptr<InfluxdbCommonWriter>&, const Value&)> ObjectImpl<InfluxdbCommonWriter>::OnHostChanged;


boost::signals2::signal<void (const intrusive_ptr<InfluxdbCommonWriter>&, const Value&)> ObjectImpl<InfluxdbCommonWriter>::OnPortChanged;


boost::signals2::signal<void (const intrusive_ptr<InfluxdbCommonWriter>&, const Value&)> ObjectImpl<InfluxdbCommonWriter>::OnSslCaCertChanged;


boost::signals2::signal<void (const intrusive_ptr<InfluxdbCommonWriter>&, const Value&)> ObjectImpl<InfluxdbCommonWriter>::OnSslCertChanged;


boost::signals2::signal<void (const intrusive_ptr<InfluxdbCommonWriter>&, const Value&)> ObjectImpl<InfluxdbCommonWriter>::OnSslKeyChanged;


boost::signals2::signal<void (const intrusive_ptr<InfluxdbCommonWriter>&, const Value&)> ObjectImpl<InfluxdbCommonWriter>::OnHostTemplateChanged;


boost::signals2::signal<void (const intrusive_ptr<InfluxdbCommonWriter>&, const Value&)> ObjectImpl<InfluxdbCommonWriter>::OnServiceTemplateChanged;


boost::signals2::signal<void (const intrusive_ptr<InfluxdbCommonWriter>&, const Value&)> ObjectImpl<InfluxdbCommonWriter>::OnFlushIntervalChanged;


boost::signals2::signal<void (const intrusive_ptr<InfluxdbCommonWriter>&, const Value&)> ObjectImpl<InfluxdbCommonWriter>::OnFlushThresholdChanged;


boost::signals2::signal<void (const intrusive_ptr<InfluxdbCommonWriter>&, const Value&)> ObjectImpl<InfluxdbCommonWriter>::OnSslEnableChanged;


boost::signals2::signal<void (const intrusive_ptr<InfluxdbCommonWriter>&, const Value&)> ObjectImpl<InfluxdbCommonWriter>::OnSslInsecureNoverifyChanged;


boost::signals2::signal<void (const intrusive_ptr<InfluxdbCommonWriter>&, const Value&)> ObjectImpl<InfluxdbCommonWriter>::OnEnableSendThresholdsChanged;


boost::signals2::signal<void (const intrusive_ptr<InfluxdbCommonWriter>&, const Value&)> ObjectImpl<InfluxdbCommonWriter>::OnEnableSendMetadataChanged;


boost::signals2::signal<void (const intrusive_ptr<InfluxdbCommonWriter>&, const Value&)> ObjectImpl<InfluxdbCommonWriter>::OnEnableHaChanged;

static void TIValidateInfluxdbCommonWriter_1_2(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, const String& key, const Value& value, std::vector<String>& location, const ValidationUtils& utils)
{
	bool known_attribute = false;
	do {
		known_attribute = true;
		if (value.IsEmpty() || value.IsScalar())
			return;
	} while (0);

	if (!known_attribute)
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid attribute: " + key));
	else
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid type."));
}

static void TIValidateInfluxdbCommonWriter_1(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, const String& key, const Value& value, std::vector<String>& location, const ValidationUtils& utils)
{
	bool known_attribute = false;
	do {
		if (key != "measurement")
			break;
		known_attribute = true;
		if (value.IsEmpty() || value.IsScalar())
			return;
	} while (0);

	do {
		if (key != "tags")
			break;
		known_attribute = true;
		if (value.IsObjectType<Dictionary>()) {
			Dictionary::Ptr dict = value;
			{
				ObjectLock olock(dict);
				for (const Dictionary::Pair& kv : dict) {
					const String& akey = kv.first;
					const Value& avalue = kv.second;
					location.emplace_back(akey);
					TIValidateInfluxdbCommonWriter_1_2(object, akey, avalue, location, utils);
					location.pop_back();
				}
			}
			return;
		}
	} while (0);

	if (!known_attribute)
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid attribute: " + key));
	else
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid type."));
}

static void TIValidateInfluxdbCommonWriter_2_2(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, const String& key, const Value& value, std::vector<String>& location, const ValidationUtils& utils)
{
	bool known_attribute = false;
	do {
		known_attribute = true;
		if (value.IsEmpty() || value.IsScalar())
			return;
	} while (0);

	if (!known_attribute)
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid attribute: " + key));
	else
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid type."));
}

static void TIValidateInfluxdbCommonWriter_2(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, const String& key, const Value& value, std::vector<String>& location, const ValidationUtils& utils)
{
	bool known_attribute = false;
	do {
		if (key != "measurement")
			break;
		known_attribute = true;
		if (value.IsEmpty() || value.IsScalar())
			return;
	} while (0);

	do {
		if (key != "tags")
			break;
		known_attribute = true;
		if (value.IsObjectType<Dictionary>()) {
			Dictionary::Ptr dict = value;
			{
				ObjectLock olock(dict);
				for (const Dictionary::Pair& kv : dict) {
					const String& akey = kv.first;
					const Value& avalue = kv.second;
					location.emplace_back(akey);
					TIValidateInfluxdbCommonWriter_2_2(object, akey, avalue, location, utils);
					location.pop_back();
				}
			}
			return;
		}
	} while (0);

	if (!known_attribute)
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid attribute: " + key));
	else
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Invalid type."));
}

static void TIValidateInfluxdbCommonWriterEnableHa(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, bool value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (!value)
		return;

}

static void TIValidateInfluxdbCommonWriterEnableSendMetadata(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, bool value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (!value)
		return;

}

static void TIValidateInfluxdbCommonWriterEnableSendThresholds(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, bool value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (!value)
		return;

}

static void TIValidateInfluxdbCommonWriterFlushInterval(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, int value, std::vector<String>& location, const ValidationUtils& utils)
{
}

static void TIValidateInfluxdbCommonWriterFlushThreshold(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, int value, std::vector<String>& location, const ValidationUtils& utils)
{
}

static void TIValidateInfluxdbCommonWriterHost(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, const String& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (value.IsEmpty())
		return;

}

static void TIValidateInfluxdbCommonWriterHostTemplate(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, const Dictionary::Ptr& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (!value)
		return;

	do {
		const Dictionary::Ptr& dict = value;
		{
			ObjectLock olock(dict);
			for (const Dictionary::Pair& kv : dict) {
				const String& akey = kv.first;
				const Value& avalue = kv.second;
				location.emplace_back(akey);
				TIValidateInfluxdbCommonWriter_1(object, akey, avalue, location, utils);
				location.pop_back();
			}
		}
		if (dict->Get("measurement").IsEmpty())
			BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Required dictionary item 'measurement' is not set."));
		return;
	} while (0);

}

static void TIValidateInfluxdbCommonWriterPort(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, const String& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (value.IsEmpty())
		return;

}

static void TIValidateInfluxdbCommonWriterServiceTemplate(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, const Dictionary::Ptr& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (!value)
		return;

	do {
		const Dictionary::Ptr& dict = value;
		{
			ObjectLock olock(dict);
			for (const Dictionary::Pair& kv : dict) {
				const String& akey = kv.first;
				const Value& avalue = kv.second;
				location.emplace_back(akey);
				TIValidateInfluxdbCommonWriter_2(object, akey, avalue, location, utils);
				location.pop_back();
			}
		}
		if (dict->Get("measurement").IsEmpty())
			BOOST_THROW_EXCEPTION(ValidationError(dynamic_pointer_cast<ConfigObject>(object), location, "Required dictionary item 'measurement' is not set."));
		return;
	} while (0);

}

static void TIValidateInfluxdbCommonWriterSslCaCert(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, const String& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (value.IsEmpty())
		return;

}

static void TIValidateInfluxdbCommonWriterSslCert(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, const String& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (value.IsEmpty())
		return;

}

static void TIValidateInfluxdbCommonWriterSslEnable(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, bool value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (!value)
		return;

}

static void TIValidateInfluxdbCommonWriterSslInsecureNoverify(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, bool value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (!value)
		return;

}

static void TIValidateInfluxdbCommonWriterSslKey(const intrusive_ptr<ObjectImpl<InfluxdbCommonWriter> >& object, const String& value, std::vector<String>& location, const ValidationUtils& utils)
{
	if (value.IsEmpty())
		return;

}

void ObjectImpl<InfluxdbCommonWriter>::ValidateEnableHa(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnableHa(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("enable_ha");
	TIValidateInfluxdbCommonWriterEnableHa(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<InfluxdbCommonWriter>::ValidateEnableSendMetadata(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnableSendMetadata(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("enable_send_metadata");
	TIValidateInfluxdbCommonWriterEnableSendMetadata(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<InfluxdbCommonWriter>::ValidateEnableSendThresholds(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEnableSendThresholds(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("enable_send_thresholds");
	TIValidateInfluxdbCommonWriterEnableSendThresholds(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<InfluxdbCommonWriter>::ValidateFlushInterval(const Lazy<int>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateFlushInterval(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("flush_interval");
	TIValidateInfluxdbCommonWriterFlushInterval(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<InfluxdbCommonWriter>::ValidateFlushThreshold(const Lazy<int>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateFlushThreshold(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("flush_threshold");
	TIValidateInfluxdbCommonWriterFlushThreshold(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<InfluxdbCommonWriter>::ValidateHost(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateHost(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("host");
	TIValidateInfluxdbCommonWriterHost(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<InfluxdbCommonWriter>::ValidateHostTemplate(const Lazy<Dictionary::Ptr>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateHostTemplate(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("host_template");
	TIValidateInfluxdbCommonWriterHostTemplate(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<InfluxdbCommonWriter>::ValidatePort(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePort(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("port");
	TIValidateInfluxdbCommonWriterPort(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<InfluxdbCommonWriter>::ValidateServiceTemplate(const Lazy<Dictionary::Ptr>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateServiceTemplate(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("service_template");
	TIValidateInfluxdbCommonWriterServiceTemplate(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<InfluxdbCommonWriter>::ValidateSslCaCert(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSslCaCert(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("ssl_ca_cert");
	TIValidateInfluxdbCommonWriterSslCaCert(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<InfluxdbCommonWriter>::ValidateSslCert(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSslCert(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("ssl_cert");
	TIValidateInfluxdbCommonWriterSslCert(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<InfluxdbCommonWriter>::ValidateSslEnable(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSslEnable(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("ssl_enable");
	TIValidateInfluxdbCommonWriterSslEnable(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<InfluxdbCommonWriter>::ValidateSslInsecureNoverify(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSslInsecureNoverify(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("ssl_insecure_noverify");
	TIValidateInfluxdbCommonWriterSslInsecureNoverify(this, lvalue(), location, utils);
	location.pop_back();
}

void ObjectImpl<InfluxdbCommonWriter>::ValidateSslKey(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSslKey(lvalue, utils);
	std::vector<String> location;
	location.emplace_back("ssl_key");
	TIValidateInfluxdbCommonWriterSslKey(this, lvalue(), location, utils);
	location.pop_back();
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
