#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<ApiListener>::TypeImpl()
{ }

TypeImpl<ApiListener>::~TypeImpl()
{ }

String TypeImpl<ApiListener>::GetName() const
{
	return "ApiListener";
}

int TypeImpl<ApiListener>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<ApiListener>::GetBaseType() const
{
	return ConfigObject::TypeInstance;
}

int TypeImpl<ApiListener>::GetFieldId(const String& name) const
{
	int offset = ConfigObject::TypeInstance->GetFieldCount();

	switch (static_cast<int>(Utility::SDBM(name, 6))) {
		case -2005202490:
			if (name == "bind_host")
				return offset + 6;

			break;
		case -2005202482:
			if (name == "bind_port")
				return offset + 5;

			break;
		case -1568417997:
			if (name == "crl_path")
				return offset + 9;

			break;
		case -1247211277:
			if (name == "log_message_timestamp")
				return offset + 17;

			break;
		case -913062499:
			if (name == "tls_handshake_timeout")
				return offset + 12;

			break;
		case -912537690:
			if (name == "tls_protocolmin")
				return offset + 7;

			break;
		case -884411806:
			if (name == "ca_path")
				return offset + 10;

			break;
		case -611808760:
			if (name == "accept_config")
				return offset + 18;
			if (name == "accept_commands")
				return offset + 19;

			break;
		case -611611964:
			if (name == "access_control_allow_methods")
				return offset + 2;
			if (name == "access_control_allow_headers")
				return offset + 3;
			if (name == "access_control_allow_origin")
				return offset + 14;
			if (name == "access_control_allow_credentials")
				return offset + 20;

			break;
		case -38581237:
			if (name == "cipher_list")
				return offset + 8;

			break;
		case 457659916:
			if (name == "ticket_salt")
				return offset + 4;

			break;
		case 735058408:
			if (name == "max_anonymous_clients")
				return offset + 16;

			break;
		case 844636409:
			if (name == "identity")
				return offset + 1;

			break;
		case 928442877:
			if (name == "last_failed_zones_stage_validation")
				return offset + 15;

			break;
		case 992231818:
			if (name == "connect_timeout")
				return offset + 13;

			break;
		case 1035904977:
			if (name == "key_path")
				return offset + 0;

			break;
		case 1358047765:
			if (name == "cert_path")
				return offset + 11;

			break;
	}

	return ConfigObject::TypeInstance->GetFieldId(name);
}

Field TypeImpl<ApiListener>::GetFieldInfo(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount();
	if (real_id < 0) { return ConfigObject::TypeInstance->GetFieldInfo(id); }
	switch (real_id) {
		case 0:
			return {0, "String", "key_path", "key_path", nullptr, 4098, 0};
		case 1:
			return {1, "String", "identity", "identity", nullptr, 1025, 0};
		case 2:
			return {2, "String", "access_control_allow_methods", "access_control_allow_methods", nullptr, 4098, 0};
		case 3:
			return {3, "String", "access_control_allow_headers", "access_control_allow_headers", nullptr, 4098, 0};
		case 4:
			return {4, "String", "ticket_salt", "ticket_salt", nullptr, 3074, 0};
		case 5:
			return {5, "String", "bind_port", "bind_port", nullptr, 2, 0};
		case 6:
			return {6, "String", "bind_host", "bind_host", nullptr, 2, 0};
		case 7:
			return {7, "String", "tls_protocolmin", "tls_protocolmin", nullptr, 2, 0};
		case 8:
			return {8, "String", "cipher_list", "cipher_list", nullptr, 2, 0};
		case 9:
			return {9, "String", "crl_path", "crl_path", nullptr, 2, 0};
		case 10:
			return {10, "String", "ca_path", "ca_path", nullptr, 4098, 0};
		case 11:
			return {11, "String", "cert_path", "cert_path", nullptr, 4098, 0};
		case 12:
			return {12, "Number", "tls_handshake_timeout", "tls_handshake_timeout", nullptr, 4098, 0};
		case 13:
			return {13, "Number", "connect_timeout", "connect_timeout", nullptr, 2, 0};
		case 14:
			return {14, "Array", "access_control_allow_origin", "access_control_allow_origin", nullptr, 2, 0};
		case 15:
			return {15, "Dictionary", "last_failed_zones_stage_validation", "last_failed_zones_stage_validation", nullptr, 1028, 0};
		case 16:
			return {16, "Number", "max_anonymous_clients", "max_anonymous_clients", nullptr, 2, 0};
		case 17:
			return {17, "Timestamp", "log_message_timestamp", "log_message_timestamp", nullptr, 1028, 0};
		case 18:
			return {18, "Boolean", "accept_config", "accept_config", nullptr, 2, 0};
		case 19:
			return {19, "Boolean", "accept_commands", "accept_commands", nullptr, 2, 0};
		case 20:
			return {20, "Boolean", "access_control_allow_credentials", "access_control_allow_credentials", nullptr, 4098, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<ApiListener>::GetFieldCount() const
{
	return 21 + ConfigObject::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<ApiListener>::GetFactory() const
{
	return TypeHelper<ApiListener, false>::GetFactory();
}

int TypeImpl<ApiListener>::GetActivationPriority() const
{
	return 50;
}

void TypeImpl<ApiListener>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	switch (real_id) {
		case 0:
			ObjectImpl<ApiListener>::OnKeyPathChanged.connect(callback);
			break;
		case 1:
			ObjectImpl<ApiListener>::OnIdentityChanged.connect(callback);
			break;
		case 2:
			ObjectImpl<ApiListener>::OnAccessControlAllowMethodsChanged.connect(callback);
			break;
		case 3:
			ObjectImpl<ApiListener>::OnAccessControlAllowHeadersChanged.connect(callback);
			break;
		case 4:
			ObjectImpl<ApiListener>::OnTicketSaltChanged.connect(callback);
			break;
		case 5:
			ObjectImpl<ApiListener>::OnBindPortChanged.connect(callback);
			break;
		case 6:
			ObjectImpl<ApiListener>::OnBindHostChanged.connect(callback);
			break;
		case 7:
			ObjectImpl<ApiListener>::OnTlsProtocolminChanged.connect(callback);
			break;
		case 8:
			ObjectImpl<ApiListener>::OnCipherListChanged.connect(callback);
			break;
		case 9:
			ObjectImpl<ApiListener>::OnCrlPathChanged.connect(callback);
			break;
		case 10:
			ObjectImpl<ApiListener>::OnCaPathChanged.connect(callback);
			break;
		case 11:
			ObjectImpl<ApiListener>::OnCertPathChanged.connect(callback);
			break;
		case 12:
			ObjectImpl<ApiListener>::OnTlsHandshakeTimeoutChanged.connect(callback);
			break;
		case 13:
			ObjectImpl<ApiListener>::OnConnectTimeoutChanged.connect(callback);
			break;
		case 14:
			ObjectImpl<ApiListener>::OnAccessControlAllowOriginChanged.connect(callback);
			break;
		case 15:
			ObjectImpl<ApiListener>::OnLastFailedZonesStageValidationChanged.connect(callback);
			break;
		case 16:
			ObjectImpl<ApiListener>::OnMaxAnonymousClientsChanged.connect(callback);
			break;
		case 17:
			ObjectImpl<ApiListener>::OnLogMessageTimestampChanged.connect(callback);
			break;
		case 18:
			ObjectImpl<ApiListener>::OnAcceptConfigChanged.connect(callback);
			break;
		case 19:
			ObjectImpl<ApiListener>::OnAcceptCommandsChanged.connect(callback);
			break;
		case 20:
			ObjectImpl<ApiListener>::OnAccessControlAllowCredentialsChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<ApiListener>::Validate(int types, const ValidationUtils& utils)
{
	ConfigObject::Validate(types, utils);

	if (2 & types)
		ValidateKeyPath(Lazy<String>([this]() { return GetKeyPath(); }), utils);
	if (1 & types)
		ValidateIdentity(Lazy<String>([this]() { return GetIdentity(); }), utils);
	if (2 & types)
		ValidateAccessControlAllowMethods(Lazy<String>([this]() { return GetAccessControlAllowMethods(); }), utils);
	if (2 & types)
		ValidateAccessControlAllowHeaders(Lazy<String>([this]() { return GetAccessControlAllowHeaders(); }), utils);
	if (2 & types)
		ValidateTicketSalt(Lazy<String>([this]() { return GetTicketSalt(); }), utils);
	if (2 & types)
		ValidateBindPort(Lazy<String>([this]() { return GetBindPort(); }), utils);
	if (2 & types)
		ValidateBindHost(Lazy<String>([this]() { return GetBindHost(); }), utils);
	if (2 & types)
		ValidateTlsProtocolmin(Lazy<String>([this]() { return GetTlsProtocolmin(); }), utils);
	if (2 & types)
		ValidateCipherList(Lazy<String>([this]() { return GetCipherList(); }), utils);
	if (2 & types)
		ValidateCrlPath(Lazy<String>([this]() { return GetCrlPath(); }), utils);
	if (2 & types)
		ValidateCaPath(Lazy<String>([this]() { return GetCaPath(); }), utils);
	if (2 & types)
		ValidateCertPath(Lazy<String>([this]() { return GetCertPath(); }), utils);
	if (2 & types)
		ValidateTlsHandshakeTimeout(Lazy<double>([this]() { return GetTlsHandshakeTimeout(); }), utils);
	if (2 & types)
		ValidateConnectTimeout(Lazy<double>([this]() { return GetConnectTimeout(); }), utils);
	if (2 & types)
		ValidateAccessControlAllowOrigin(Lazy<Array::Ptr>([this]() { return GetAccessControlAllowOrigin(); }), utils);
	if (4 & types)
		ValidateLastFailedZonesStageValidation(Lazy<Dictionary::Ptr>([this]() { return GetLastFailedZonesStageValidation(); }), utils);
	if (2 & types)
		ValidateMaxAnonymousClients(Lazy<int>([this]() { return GetMaxAnonymousClients(); }), utils);
	if (4 & types)
		ValidateLogMessageTimestamp(Lazy<Timestamp>([this]() { return GetLogMessageTimestamp(); }), utils);
	if (2 & types)
		ValidateAcceptConfig(Lazy<bool>([this]() { return GetAcceptConfig(); }), utils);
	if (2 & types)
		ValidateAcceptCommands(Lazy<bool>([this]() { return GetAcceptCommands(); }), utils);
	if (2 & types)
		ValidateAccessControlAllowCredentials(Lazy<bool>([this]() { return GetAccessControlAllowCredentials(); }), utils);
}

void ObjectImpl<ApiListener>::SimpleValidateKeyPath(const Lazy<String>& value, const ValidationUtils& utils)
{
	if (value() != GetDefaultKeyPath())
		Log(LogWarning, "ApiListener") << "Attribute 'key_path' for object '" << dynamic_cast<ConfigObject *>(this)->GetName() << "' of type '" << dynamic_cast<ConfigObject *>(this)->GetReflectionType()->GetName() << "' is deprecated and should not be used.";
}

void ObjectImpl<ApiListener>::SimpleValidateIdentity(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ApiListener>::SimpleValidateAccessControlAllowMethods(const Lazy<String>& value, const ValidationUtils& utils)
{
	if (value() != GetDefaultAccessControlAllowMethods())
		Log(LogWarning, "ApiListener") << "Attribute 'access_control_allow_methods' for object '" << dynamic_cast<ConfigObject *>(this)->GetName() << "' of type '" << dynamic_cast<ConfigObject *>(this)->GetReflectionType()->GetName() << "' is deprecated and should not be used.";
}

void ObjectImpl<ApiListener>::SimpleValidateAccessControlAllowHeaders(const Lazy<String>& value, const ValidationUtils& utils)
{
	if (value() != GetDefaultAccessControlAllowHeaders())
		Log(LogWarning, "ApiListener") << "Attribute 'access_control_allow_headers' for object '" << dynamic_cast<ConfigObject *>(this)->GetName() << "' of type '" << dynamic_cast<ConfigObject *>(this)->GetReflectionType()->GetName() << "' is deprecated and should not be used.";
}

void ObjectImpl<ApiListener>::SimpleValidateTicketSalt(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ApiListener>::SimpleValidateBindPort(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ApiListener>::SimpleValidateBindHost(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ApiListener>::SimpleValidateTlsProtocolmin(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ApiListener>::SimpleValidateCipherList(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ApiListener>::SimpleValidateCrlPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ApiListener>::SimpleValidateCaPath(const Lazy<String>& value, const ValidationUtils& utils)
{
	if (value() != GetDefaultCaPath())
		Log(LogWarning, "ApiListener") << "Attribute 'ca_path' for object '" << dynamic_cast<ConfigObject *>(this)->GetName() << "' of type '" << dynamic_cast<ConfigObject *>(this)->GetReflectionType()->GetName() << "' is deprecated and should not be used.";
}

void ObjectImpl<ApiListener>::SimpleValidateCertPath(const Lazy<String>& value, const ValidationUtils& utils)
{
	if (value() != GetDefaultCertPath())
		Log(LogWarning, "ApiListener") << "Attribute 'cert_path' for object '" << dynamic_cast<ConfigObject *>(this)->GetName() << "' of type '" << dynamic_cast<ConfigObject *>(this)->GetReflectionType()->GetName() << "' is deprecated and should not be used.";
}

void ObjectImpl<ApiListener>::SimpleValidateTlsHandshakeTimeout(const Lazy<double>& value, const ValidationUtils& utils)
{
	if (value() != GetDefaultTlsHandshakeTimeout())
		Log(LogWarning, "ApiListener") << "Attribute 'tls_handshake_timeout' for object '" << dynamic_cast<ConfigObject *>(this)->GetName() << "' of type '" << dynamic_cast<ConfigObject *>(this)->GetReflectionType()->GetName() << "' is deprecated and should not be used.";
}

void ObjectImpl<ApiListener>::SimpleValidateConnectTimeout(const Lazy<double>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ApiListener>::SimpleValidateAccessControlAllowOrigin(const Lazy<Array::Ptr>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ApiListener>::SimpleValidateLastFailedZonesStageValidation(const Lazy<Dictionary::Ptr>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ApiListener>::SimpleValidateMaxAnonymousClients(const Lazy<int>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ApiListener>::SimpleValidateLogMessageTimestamp(const Lazy<Timestamp>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ApiListener>::SimpleValidateAcceptConfig(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ApiListener>::SimpleValidateAcceptCommands(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<ApiListener>::SimpleValidateAccessControlAllowCredentials(const Lazy<bool>& value, const ValidationUtils& utils)
{
	if (value() != GetDefaultAccessControlAllowCredentials())
		Log(LogWarning, "ApiListener") << "Attribute 'access_control_allow_credentials' for object '" << dynamic_cast<ConfigObject *>(this)->GetName() << "' of type '" << dynamic_cast<ConfigObject *>(this)->GetReflectionType()->GetName() << "' is deprecated and should not be used.";
}

ObjectImpl<ApiListener>::ObjectImpl()
{
	SetKeyPath(GetDefaultKeyPath(), true);
	SetIdentity(GetDefaultIdentity(), true);
	SetAccessControlAllowMethods(GetDefaultAccessControlAllowMethods(), true);
	SetAccessControlAllowHeaders(GetDefaultAccessControlAllowHeaders(), true);
	SetTicketSalt(GetDefaultTicketSalt(), true);
	SetBindPort(GetDefaultBindPort(), true);
	SetBindHost(GetDefaultBindHost(), true);
	SetTlsProtocolmin(GetDefaultTlsProtocolmin(), true);
	SetCipherList(GetDefaultCipherList(), true);
	SetCrlPath(GetDefaultCrlPath(), true);
	SetCaPath(GetDefaultCaPath(), true);
	SetCertPath(GetDefaultCertPath(), true);
	SetConnectTimeout(GetDefaultConnectTimeout(), true);
	SetAccessControlAllowOrigin(GetDefaultAccessControlAllowOrigin(), true);
	SetLastFailedZonesStageValidation(GetDefaultLastFailedZonesStageValidation(), true);
	SetMaxAnonymousClients(GetDefaultMaxAnonymousClients(), true);
	SetLogMessageTimestamp(GetDefaultLogMessageTimestamp(), true);
	SetAcceptConfig(GetDefaultAcceptConfig(), true);
	SetAcceptCommands(GetDefaultAcceptCommands(), true);
	SetAccessControlAllowCredentials(GetDefaultAccessControlAllowCredentials(), true);
}

ObjectImpl<ApiListener>::~ObjectImpl()
{ }

void ObjectImpl<ApiListener>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::SetField(id, value, suppress_events, cookie); return; }
	switch (real_id) {
		case 0:
			SetKeyPath(value, suppress_events, cookie);
			break;
		case 1:
			SetIdentity(value, suppress_events, cookie);
			break;
		case 2:
			SetAccessControlAllowMethods(value, suppress_events, cookie);
			break;
		case 3:
			SetAccessControlAllowHeaders(value, suppress_events, cookie);
			break;
		case 4:
			SetTicketSalt(value, suppress_events, cookie);
			break;
		case 5:
			SetBindPort(value, suppress_events, cookie);
			break;
		case 6:
			SetBindHost(value, suppress_events, cookie);
			break;
		case 7:
			SetTlsProtocolmin(value, suppress_events, cookie);
			break;
		case 8:
			SetCipherList(value, suppress_events, cookie);
			break;
		case 9:
			SetCrlPath(value, suppress_events, cookie);
			break;
		case 10:
			SetCaPath(value, suppress_events, cookie);
			break;
		case 11:
			SetCertPath(value, suppress_events, cookie);
			break;
		case 12:
			SetTlsHandshakeTimeout(value, suppress_events, cookie);
			break;
		case 13:
			SetConnectTimeout(value, suppress_events, cookie);
			break;
		case 14:
			SetAccessControlAllowOrigin(value, suppress_events, cookie);
			break;
		case 15:
			SetLastFailedZonesStageValidation(value, suppress_events, cookie);
			break;
		case 16:
			SetMaxAnonymousClients(value, suppress_events, cookie);
			break;
		case 17:
			SetLogMessageTimestamp(value, suppress_events, cookie);
			break;
		case 18:
			SetAcceptConfig(value, suppress_events, cookie);
			break;
		case 19:
			SetAcceptCommands(value, suppress_events, cookie);
			break;
		case 20:
			SetAccessControlAllowCredentials(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<ApiListener>::GetField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::GetField(id); }
	switch (real_id) {
		case 0:
			return GetKeyPath();
		case 1:
			return GetIdentity();
		case 2:
			return GetAccessControlAllowMethods();
		case 3:
			return GetAccessControlAllowHeaders();
		case 4:
			return GetTicketSalt();
		case 5:
			return GetBindPort();
		case 6:
			return GetBindHost();
		case 7:
			return GetTlsProtocolmin();
		case 8:
			return GetCipherList();
		case 9:
			return GetCrlPath();
		case 10:
			return GetCaPath();
		case 11:
			return GetCertPath();
		case 12:
			return GetTlsHandshakeTimeout();
		case 13:
			return GetConnectTimeout();
		case 14:
			return GetAccessControlAllowOrigin();
		case 15:
			return GetLastFailedZonesStageValidation();
		case 16:
			return GetMaxAnonymousClients();
		case 17:
			return GetLogMessageTimestamp();
		case 18:
			return GetAcceptConfig();
		case 19:
			return GetAcceptCommands();
		case 20:
			return GetAccessControlAllowCredentials();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<ApiListener>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::ValidateField(id, lvalue, utils); return; }
	switch (real_id) {
		case 0:
			ValidateKeyPath(lvalue, utils);
			break;
		case 1:
			ValidateIdentity(lvalue, utils);
			break;
		case 2:
			ValidateAccessControlAllowMethods(lvalue, utils);
			break;
		case 3:
			ValidateAccessControlAllowHeaders(lvalue, utils);
			break;
		case 4:
			ValidateTicketSalt(lvalue, utils);
			break;
		case 5:
			ValidateBindPort(lvalue, utils);
			break;
		case 6:
			ValidateBindHost(lvalue, utils);
			break;
		case 7:
			ValidateTlsProtocolmin(lvalue, utils);
			break;
		case 8:
			ValidateCipherList(lvalue, utils);
			break;
		case 9:
			ValidateCrlPath(lvalue, utils);
			break;
		case 10:
			ValidateCaPath(lvalue, utils);
			break;
		case 11:
			ValidateCertPath(lvalue, utils);
			break;
		case 12:
			ValidateTlsHandshakeTimeout(lvalue, utils);
			break;
		case 13:
			ValidateConnectTimeout(lvalue, utils);
			break;
		case 14:
			ValidateAccessControlAllowOrigin(lvalue, utils);
			break;
		case 15:
			ValidateLastFailedZonesStageValidation(lvalue, utils);
			break;
		case 16:
			ValidateMaxAnonymousClients(lvalue, utils);
			break;
		case 17:
			ValidateLogMessageTimestamp(lvalue, utils);
			break;
		case 18:
			ValidateAcceptConfig(lvalue, utils);
			break;
		case 19:
			ValidateAcceptCommands(lvalue, utils);
			break;
		case 20:
			ValidateAccessControlAllowCredentials(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<ApiListener>::NotifyField(int id, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::NotifyField(id, cookie); return; }
	switch (real_id) {
		case 0:
			NotifyKeyPath(cookie);
			break;
		case 1:
			NotifyIdentity(cookie);
			break;
		case 2:
			NotifyAccessControlAllowMethods(cookie);
			break;
		case 3:
			NotifyAccessControlAllowHeaders(cookie);
			break;
		case 4:
			NotifyTicketSalt(cookie);
			break;
		case 5:
			NotifyBindPort(cookie);
			break;
		case 6:
			NotifyBindHost(cookie);
			break;
		case 7:
			NotifyTlsProtocolmin(cookie);
			break;
		case 8:
			NotifyCipherList(cookie);
			break;
		case 9:
			NotifyCrlPath(cookie);
			break;
		case 10:
			NotifyCaPath(cookie);
			break;
		case 11:
			NotifyCertPath(cookie);
			break;
		case 12:
			NotifyTlsHandshakeTimeout(cookie);
			break;
		case 13:
			NotifyConnectTimeout(cookie);
			break;
		case 14:
			NotifyAccessControlAllowOrigin(cookie);
			break;
		case 15:
			NotifyLastFailedZonesStageValidation(cookie);
			break;
		case 16:
			NotifyMaxAnonymousClients(cookie);
			break;
		case 17:
			NotifyLogMessageTimestamp(cookie);
			break;
		case 18:
			NotifyAcceptConfig(cookie);
			break;
		case 19:
			NotifyAcceptCommands(cookie);
			break;
		case 20:
			NotifyAccessControlAllowCredentials(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<ApiListener>::NavigateField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::NavigateField(id); }
	throw std::runtime_error("Invalid field ID.");
}

String ObjectImpl<ApiListener>::GetKeyPath() const
{
	return m_KeyPath.load();
}

String ObjectImpl<ApiListener>::GetIdentity() const
{
	return m_Identity.load();
}

String ObjectImpl<ApiListener>::GetAccessControlAllowMethods() const
{
	return m_AccessControlAllowMethods.load();
}

String ObjectImpl<ApiListener>::GetAccessControlAllowHeaders() const
{
	return m_AccessControlAllowHeaders.load();
}

String ObjectImpl<ApiListener>::GetTicketSalt() const
{
	return m_TicketSalt.load();
}

String ObjectImpl<ApiListener>::GetBindPort() const
{
	return m_BindPort.load();
}

String ObjectImpl<ApiListener>::GetBindHost() const
{
	return m_BindHost.load();
}

String ObjectImpl<ApiListener>::GetTlsProtocolmin() const
{
	return m_TlsProtocolmin.load();
}

String ObjectImpl<ApiListener>::GetCipherList() const
{
	return m_CipherList.load();
}

String ObjectImpl<ApiListener>::GetCrlPath() const
{
	return m_CrlPath.load();
}

String ObjectImpl<ApiListener>::GetCaPath() const
{
	return m_CaPath.load();
}

String ObjectImpl<ApiListener>::GetCertPath() const
{
	return m_CertPath.load();
}

double ObjectImpl<ApiListener>::GetConnectTimeout() const
{
	return m_ConnectTimeout.load();
}

Array::Ptr ObjectImpl<ApiListener>::GetAccessControlAllowOrigin() const
{
	return m_AccessControlAllowOrigin.load();
}

Dictionary::Ptr ObjectImpl<ApiListener>::GetLastFailedZonesStageValidation() const
{
	return m_LastFailedZonesStageValidation.load();
}

int ObjectImpl<ApiListener>::GetMaxAnonymousClients() const
{
	return m_MaxAnonymousClients.load();
}

Timestamp ObjectImpl<ApiListener>::GetLogMessageTimestamp() const
{
	return m_LogMessageTimestamp.load();
}

bool ObjectImpl<ApiListener>::GetAcceptConfig() const
{
	return m_AcceptConfig.load();
}

bool ObjectImpl<ApiListener>::GetAcceptCommands() const
{
	return m_AcceptCommands.load();
}

bool ObjectImpl<ApiListener>::GetAccessControlAllowCredentials() const
{
	return m_AccessControlAllowCredentials.load();
}

void ObjectImpl<ApiListener>::SetKeyPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_KeyPath.store(value);
	if (!suppress_events) {
		NotifyKeyPath(cookie);
	}

}

void ObjectImpl<ApiListener>::SetIdentity(const String& value, bool suppress_events, const Value& cookie)
{
	m_Identity.store(value);
	if (!suppress_events) {
		NotifyIdentity(cookie);
	}

}

void ObjectImpl<ApiListener>::SetAccessControlAllowMethods(const String& value, bool suppress_events, const Value& cookie)
{
	m_AccessControlAllowMethods.store(value);
	if (!suppress_events) {
		NotifyAccessControlAllowMethods(cookie);
	}

}

void ObjectImpl<ApiListener>::SetAccessControlAllowHeaders(const String& value, bool suppress_events, const Value& cookie)
{
	m_AccessControlAllowHeaders.store(value);
	if (!suppress_events) {
		NotifyAccessControlAllowHeaders(cookie);
	}

}

void ObjectImpl<ApiListener>::SetTicketSalt(const String& value, bool suppress_events, const Value& cookie)
{
	m_TicketSalt.store(value);
	if (!suppress_events) {
		NotifyTicketSalt(cookie);
	}

}

void ObjectImpl<ApiListener>::SetBindPort(const String& value, bool suppress_events, const Value& cookie)
{
	m_BindPort.store(value);
	if (!suppress_events) {
		NotifyBindPort(cookie);
	}

}

void ObjectImpl<ApiListener>::SetBindHost(const String& value, bool suppress_events, const Value& cookie)
{
	m_BindHost.store(value);
	if (!suppress_events) {
		NotifyBindHost(cookie);
	}

}

void ObjectImpl<ApiListener>::SetTlsProtocolmin(const String& value, bool suppress_events, const Value& cookie)
{
	m_TlsProtocolmin.store(value);
	if (!suppress_events) {
		NotifyTlsProtocolmin(cookie);
	}

}

void ObjectImpl<ApiListener>::SetCipherList(const String& value, bool suppress_events, const Value& cookie)
{
	m_CipherList.store(value);
	if (!suppress_events) {
		NotifyCipherList(cookie);
	}

}

void ObjectImpl<ApiListener>::SetCrlPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_CrlPath.store(value);
	if (!suppress_events) {
		NotifyCrlPath(cookie);
	}

}

void ObjectImpl<ApiListener>::SetCaPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_CaPath.store(value);
	if (!suppress_events) {
		NotifyCaPath(cookie);
	}

}

void ObjectImpl<ApiListener>::SetCertPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_CertPath.store(value);
	if (!suppress_events) {
		NotifyCertPath(cookie);
	}

}

void ObjectImpl<ApiListener>::SetConnectTimeout(double value, bool suppress_events, const Value& cookie)
{
	m_ConnectTimeout.store(value);
	if (!suppress_events) {
		NotifyConnectTimeout(cookie);
	}

}

void ObjectImpl<ApiListener>::SetAccessControlAllowOrigin(const Array::Ptr& value, bool suppress_events, const Value& cookie)
{
	m_AccessControlAllowOrigin.store(value);
	if (!suppress_events) {
		NotifyAccessControlAllowOrigin(cookie);
	}

}

void ObjectImpl<ApiListener>::SetLastFailedZonesStageValidation(const Dictionary::Ptr& value, bool suppress_events, const Value& cookie)
{
	m_LastFailedZonesStageValidation.store(value);
	if (!suppress_events) {
		NotifyLastFailedZonesStageValidation(cookie);
	}

}

void ObjectImpl<ApiListener>::SetMaxAnonymousClients(int value, bool suppress_events, const Value& cookie)
{
	m_MaxAnonymousClients.store(value);
	if (!suppress_events) {
		NotifyMaxAnonymousClients(cookie);
	}

}

void ObjectImpl<ApiListener>::SetLogMessageTimestamp(const Timestamp& value, bool suppress_events, const Value& cookie)
{
	m_LogMessageTimestamp.store(value);
	if (!suppress_events) {
		NotifyLogMessageTimestamp(cookie);
	}

}

void ObjectImpl<ApiListener>::SetAcceptConfig(bool value, bool suppress_events, const Value& cookie)
{
	m_AcceptConfig.store(value);
	if (!suppress_events) {
		NotifyAcceptConfig(cookie);
	}

}

void ObjectImpl<ApiListener>::SetAcceptCommands(bool value, bool suppress_events, const Value& cookie)
{
	m_AcceptCommands.store(value);
	if (!suppress_events) {
		NotifyAcceptCommands(cookie);
	}

}

void ObjectImpl<ApiListener>::SetAccessControlAllowCredentials(bool value, bool suppress_events, const Value& cookie)
{
	m_AccessControlAllowCredentials.store(value);
	if (!suppress_events) {
		NotifyAccessControlAllowCredentials(cookie);
	}

}

void ObjectImpl<ApiListener>::NotifyKeyPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnKeyPathChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyIdentity(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnIdentityChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyAccessControlAllowMethods(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnAccessControlAllowMethodsChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyAccessControlAllowHeaders(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnAccessControlAllowHeadersChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyTicketSalt(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnTicketSaltChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyBindPort(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnBindPortChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyBindHost(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnBindHostChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyTlsProtocolmin(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnTlsProtocolminChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyCipherList(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCipherListChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyCrlPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCrlPathChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyCaPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCaPathChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyCertPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCertPathChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyTlsHandshakeTimeout(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnTlsHandshakeTimeoutChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyConnectTimeout(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnConnectTimeoutChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyAccessControlAllowOrigin(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnAccessControlAllowOriginChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyLastFailedZonesStageValidation(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnLastFailedZonesStageValidationChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyMaxAnonymousClients(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnMaxAnonymousClientsChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyLogMessageTimestamp(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnLogMessageTimestampChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyAcceptConfig(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnAcceptConfigChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyAcceptCommands(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnAcceptCommandsChanged(static_cast<ApiListener *>(this), cookie);
}

void ObjectImpl<ApiListener>::NotifyAccessControlAllowCredentials(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnAccessControlAllowCredentialsChanged(static_cast<ApiListener *>(this), cookie);
}

String ObjectImpl<ApiListener>::GetDefaultKeyPath() const
{
	return String();
}

String ObjectImpl<ApiListener>::GetDefaultIdentity() const
{
	return String();
}

String ObjectImpl<ApiListener>::GetDefaultAccessControlAllowMethods() const
{
	return String();
}

String ObjectImpl<ApiListener>::GetDefaultAccessControlAllowHeaders() const
{
	return String();
}

String ObjectImpl<ApiListener>::GetDefaultTicketSalt() const
{
	return String();
}

String ObjectImpl<ApiListener>::GetDefaultBindPort() const
{
	 return Configuration::ApiBindPort; 
}

String ObjectImpl<ApiListener>::GetDefaultBindHost() const
{
	 return Configuration::ApiBindHost; 
}

String ObjectImpl<ApiListener>::GetDefaultTlsProtocolmin() const
{
	 return DEFAULT_TLS_PROTOCOLMIN; 
}

String ObjectImpl<ApiListener>::GetDefaultCipherList() const
{
	 return DEFAULT_TLS_CIPHERS; 
}

String ObjectImpl<ApiListener>::GetDefaultCrlPath() const
{
	return String();
}

String ObjectImpl<ApiListener>::GetDefaultCaPath() const
{
	return String();
}

String ObjectImpl<ApiListener>::GetDefaultCertPath() const
{
	return String();
}

double ObjectImpl<ApiListener>::GetDefaultTlsHandshakeTimeout() const
{
	 return Configuration::TlsHandshakeTimeout; 
}

double ObjectImpl<ApiListener>::GetDefaultConnectTimeout() const
{
	 return DEFAULT_CONNECT_TIMEOUT; 
}

Array::Ptr ObjectImpl<ApiListener>::GetDefaultAccessControlAllowOrigin() const
{
	return Array::Ptr();
}

Dictionary::Ptr ObjectImpl<ApiListener>::GetDefaultLastFailedZonesStageValidation() const
{
	return Dictionary::Ptr();
}

int ObjectImpl<ApiListener>::GetDefaultMaxAnonymousClients() const
{
	 return -1; 
}

Timestamp ObjectImpl<ApiListener>::GetDefaultLogMessageTimestamp() const
{
	return Timestamp();
}

bool ObjectImpl<ApiListener>::GetDefaultAcceptConfig() const
{
	return bool();
}

bool ObjectImpl<ApiListener>::GetDefaultAcceptCommands() const
{
	return bool();
}

bool ObjectImpl<ApiListener>::GetDefaultAccessControlAllowCredentials() const
{
	return bool();
}


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnKeyPathChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnIdentityChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnAccessControlAllowMethodsChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnAccessControlAllowHeadersChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnTicketSaltChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnBindPortChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnBindHostChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnTlsProtocolminChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnCipherListChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnCrlPathChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnCaPathChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnCertPathChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnTlsHandshakeTimeoutChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnConnectTimeoutChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnAccessControlAllowOriginChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnLastFailedZonesStageValidationChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnMaxAnonymousClientsChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnLogMessageTimestampChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnAcceptConfigChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnAcceptCommandsChanged;


boost::signals2::signal<void (const intrusive_ptr<ApiListener>&, const Value&)> ObjectImpl<ApiListener>::OnAccessControlAllowCredentialsChanged;

void ObjectImpl<ApiListener>::ValidateAcceptCommands(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateAcceptCommands(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateAcceptConfig(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateAcceptConfig(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateAccessControlAllowCredentials(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateAccessControlAllowCredentials(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateAccessControlAllowHeaders(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateAccessControlAllowHeaders(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateAccessControlAllowMethods(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateAccessControlAllowMethods(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateAccessControlAllowOrigin(const Lazy<Array::Ptr>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateAccessControlAllowOrigin(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateBindHost(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateBindHost(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateBindPort(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateBindPort(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateCaPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCaPath(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateCertPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCertPath(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateCipherList(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCipherList(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateConnectTimeout(const Lazy<double>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateConnectTimeout(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateCrlPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCrlPath(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateIdentity(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateIdentity(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateKeyPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateKeyPath(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateLastFailedZonesStageValidation(const Lazy<Dictionary::Ptr>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateLastFailedZonesStageValidation(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateLogMessageTimestamp(const Lazy<Timestamp>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateLogMessageTimestamp(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateMaxAnonymousClients(const Lazy<int>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateMaxAnonymousClients(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateTicketSalt(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateTicketSalt(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateTlsHandshakeTimeout(const Lazy<double>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateTlsHandshakeTimeout(lvalue, utils);
}

void ObjectImpl<ApiListener>::ValidateTlsProtocolmin(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateTlsProtocolmin(lvalue, utils);
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
