

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was libwbxml2-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../usr" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

FIND_PACKAGE( Expat REQUIRED )
FIND_PACKAGE( PkgConfig )
IF(PKGCONFIG_FOUND)
    PKG_SEARCH_MODULE( CHECK check )
ENDIF(PKGCONFIG_FOUND)
FIND_PACKAGE( Iconv )

set_and_check(LIBWBXML2_LIBRARIES_DIR "${PACKAGE_PREFIX_DIR}/lib")
set_and_check(LIBWBXML2_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include/libwbxml-1.1")

# This is for linking only (e.g., "-lwbxml2").
SET(LIBWBXML2_LIBRARIES "wbxml2")

check_required_components(libwbxml2)

