/*
 * This file is part of libbluray
 * Copyright (C) 2010-2012  Petri Hintukainen <phintuka@users.sourceforge.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package hdmv;

public class INSN {
    /*
     * instruction groups
     */

    final static int GROUP_BRANCH = 0;
    final static int GROUP_CMP    = 1;
    final static int GROUP_SET    = 2;

    /*
     * BRANCH group
     */

    /* BRANCH sub-groups */
    final static int BRANCH_GOTO   = 0x00;
    final static int BRANCH_JUMP   = 0x01;
    final static int BRANCH_PLAY   = 0x02;

    /* GOTO sub-group */
    final static int NOP          = 0x00;
    final static int GOTO         = 0x01;
    final static int BREAK        = 0x02;

    /* JUMP sub-group */
    final static int JUMP_OBJECT  = 0x00;
    final static int JUMP_TITLE   = 0x01;
    final static int CALL_OBJECT  = 0x02;
    final static int CALL_TITLE   = 0x03;
    final static int RESUME       = 0x04;

    /* PLAY sub-group */
    final static int PLAY_PL      = 0x00;
    final static int PLAY_PL_PI   = 0x01;
    final static int PLAY_PL_PM   = 0x02;
    final static int TERMINATE_PL = 0x03;
    final static int LINK_PI      = 0x04;
    final static int LINK_MK      = 0x05;

    /*
     * COMPARE group
     */

    final static int BC = 0x01;
    final static int EQ = 0x02;
    final static int NE = 0x03;
    final static int GE = 0x04;
    final static int GT = 0x05;
    final static int LE = 0x06;
    final static int LT = 0x07;

    /*
     * SET group
     */

    /* SET sub-groups */
    final static int SET_SET       = 0x00;
    final static int SET_SETSYSTEM = 0x01;

    /* SET sub-group */
    final static int MOVE   = 0x01;
    final static int SWAP   = 0x02;
    final static int ADD    = 0x03;
    final static int SUB    = 0x04;
    final static int MUL    = 0x05;
    final static int DIV    = 0x06;
    final static int MOD    = 0x07;
    final static int RND    = 0x08;
    final static int AND    = 0x09;
    final static int OR     = 0x0a;
    final static int XOR    = 0x0b;
    final static int BITSET = 0x0c;
    final static int BITCLR = 0x0d;
    final static int SHL    = 0x0e;
    final static int SHR    = 0x0f;

    /* SETSYSTEM sub-group */
    final static int SET_STREAM      = 0x01;
    final static int SET_NV_TIMER    = 0x02;
    final static int SET_BUTTON_PAGE = 0x03;
    final static int ENABLE_BUTTON   = 0x04;
    final static int DISABLE_BUTTON  = 0x05;
    final static int SET_SEC_STREAM  = 0x06;
    final static int POPUP_OFF       = 0x07;
    final static int STILL_ON        = 0x08;
    final static int STILL_OFF       = 0x09;
    final static int SET_OUTPUT_MODE = 0x0a;
    final static int SET_STREAM_SS   = 0x0b;

    final static int SETSYSTEM_0x10  = 0x10;

    public static class HDMV_INSN {
        public int opcode;
        public int sub_grp    ;  /* command sub-group */
        public int op_cnt     ;  /* operand count */
        public int grp        ;  /* command group */

        public int branch_opt ;  /* branch option */
        //int reserved1  ;
        public boolean imm_op2;  /* I-flag for operand 2 */
        public boolean imm_op1;  /* I-flag for operand 1 */

        public int cmp_opt    ;  /* compare option */
        //int reserved2  ;

        public int set_opt    ;  /* set option */
        //int reserved3  ;
    }

    public static class MOBJ_CMD {
        public HDMV_INSN insn;
        public int       dst;
        public int       src;
    }

}
