/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2025 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.io;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ObjectOutputStreamProxy extends java.io.ObjectOutputStream  {

    jail.java.io.ObjectOutputStream peer;

    public static class PutFieldProxy extends java.io.ObjectOutputStream.PutField {

        jail.java.io.ObjectOutputStream.PutField peer;
        ObjectOutputStreamProxy outputStream;

        public PutFieldProxy(ObjectOutputStreamProxy outputStream,jail.java.io.ObjectOutputStream.PutField peer) {
            this.outputStream = outputStream;
            this.peer = peer;
        }

        public void put(String name, boolean val) {
            peer.put(name, val);
        }

        public void put(String name, byte val) {
            peer.put(name, val);
        }

        public void put(String name, char val) {
            peer.put(name, val);
        }

        public void put(String name, short val) {
            peer.put(name, val);
        }

        public void put(String name, int val) {
            peer.put(name, val);
        }

        public void put(String name, long val) {
            peer.put(name, val);
        }

        public void put(String name, float val) {
            peer.put(name, val);
        }

        public void put(String name, double val) {
            peer.put(name, val);
        }

        public void put(String name, Object val) {
            peer.put(name, val);
        }

        public void write(java.io.ObjectOutput out) throws IOException {
            peer.write(outputStream.peer);
        }

    }

    public static ObjectOutputStreamProxy create(final jail.java.io.ObjectOutputStream peer) throws IOException {
        Object r = AccessController.doPrivileged(new PrivilegedAction(){
            @Override
            public Object run() {
                try {
                    return new ObjectOutputStreamProxy(peer);
                } catch (IOException e) {
                    return e;
                }
            }
        });
        if (r instanceof IOException) {
            throw (IOException)r;
        }
        return (ObjectOutputStreamProxy)r;
    }

    private ObjectOutputStreamProxy(jail.java.io.ObjectOutputStream peer) throws IOException {
        super();
        this.peer = peer;
    }

    public void useProtocolVersion(int version) throws IOException {
        peer.useProtocolVersion(version);
    }

    protected void writeObjectOverride(Object obj) throws IOException {
        peer.writeObject(obj);
    }

    public void writeUnshared(Object obj) throws IOException {
        peer.writeObject(obj);
    }

    public void defaultWriteObject() throws IOException {
        peer.defaultWriteObject();
    }

    public java.io.ObjectOutputStream.PutField putFields() throws IOException {
        return new PutFieldProxy(this,peer.putFields());
    }

    public void writeFields() throws IOException {
        peer.writeFields();
    }

    public void reset() throws IOException {
        peer.reset();
    }

    public void write(int val) throws IOException {
        peer.write(val);
    }

    public void write(byte[] buf) throws IOException {
        peer.write(buf);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        peer.write(buf,off,len);
    }

    public void flush() throws IOException {
        peer.flush();
    }

    public void close() throws IOException {
        peer.close();
    }

    public void writeBoolean(boolean val) throws IOException {
        peer.writeBoolean(val);
    }

    public void writeByte(int val) throws IOException  {
        peer.writeByte(val);
    }

    public void writeShort(int val)  throws IOException {
        peer.writeShort(val);
    }

    public void writeChar(int val)  throws IOException {
        peer.writeChar(val);
    }

    public void writeInt(int val)  throws IOException {
        peer.writeInt(val);
    }

    public void writeLong(long val)  throws IOException {
        peer.writeLong(val);
    }

    public void writeFloat(float val) throws IOException {
        peer.writeFloat(val);
    }

    public void writeDouble(double val) throws IOException {
        peer.writeDouble(val);
    }

    public void writeBytes(String str) throws IOException {
        peer.writeBytes(str);
    }

    public void writeChars(String str) throws IOException {
        peer.writeChars(str);
    }

    public void writeUTF(String str) throws IOException {
        peer.writeUTF(str);
    }

}
