/*
 * This file is part of libbluray
 * Copyright (C) 2019  VideoLAN
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 */

package jail.javax.microedition.io;

import java.io.IOException;

public interface SocketConnection extends StreamConnection {

    public static final byte DELAY = 0;
    public static final byte LINGER = 1;
    public static final byte KEEPALIVE = 2;
    public static final byte RCVBUF = 3;
    public static final byte SNDBUF = 4;

    public abstract String getAddress() throws IOException;
    public abstract String getLocalAddress() throws IOException;
    public abstract int getLocalPort() throws IOException;
    public abstract int getPort() throws IOException;
    public abstract int getSocketOption(byte option) throws IOException;
    public abstract void setSocketOption(byte option, int value) throws IOException;
}
