/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qt3danimation_python.h"

// main header
#include "qt3danimation_qanimationcallback_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DAnimation;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAnimationCallbackWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAnimationCallbackWrapper::QAnimationCallbackWrapper() : Qt3DAnimation::QAnimationCallback()
{
    resetPyMethodCache();
    // ... middle
}

void QAnimationCallbackWrapper::valueChanged(const ::QVariant & value)
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAnimationCallback.valueChanged()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "valueChanged";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAnimationCallback.valueChanged()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QAnimationCallbackWrapper::~QAnimationCallbackWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DAnimation_QAnimationCallback_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCALLBACK_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'Qt3DAnimation::QAnimationCallback' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DAnimation::QAnimationCallback >()))
        return -1;

    ::QAnimationCallbackWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationCallback.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QAnimationCallback()
            cptr = new ::QAnimationCallbackWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DAnimation::QAnimationCallback >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_Qt3DAnimation_QAnimationCallbackFunc_valueChanged(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QAnimationCallback *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCALLBACK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationCallback.valueChanged";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAnimationCallback::valueChanged(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // valueChanged(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QAnimationCallbackFunc_valueChanged_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // valueChanged(QVariant)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAnimationCallback.valueChanged()' not implemented.");
                return {};
            }
            cppSelf->valueChanged(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QAnimationCallbackFunc_valueChanged_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_Qt3DAnimation_QAnimationCallback_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DAnimation_QAnimationCallback_methods[] = {
    {"valueChanged", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QAnimationCallbackFunc_valueChanged), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DAnimation_QAnimationCallback_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DAnimation::QAnimationCallback *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCALLBACK_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAnimationCallbackWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DAnimation_QAnimationCallback_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DAnimation_QAnimationCallback_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DAnimation_QAnimationCallback_Type = nullptr;
static SbkObjectType *Sbk_Qt3DAnimation_QAnimationCallback_TypeF(void)
{
    return _Sbk_Qt3DAnimation_QAnimationCallback_Type;
}

static PyType_Slot Sbk_Qt3DAnimation_QAnimationCallback_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DAnimation_QAnimationCallback_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DAnimation_QAnimationCallback_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DAnimation_QAnimationCallback_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DAnimation_QAnimationCallback_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DAnimation_QAnimationCallback_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DAnimation_QAnimationCallback_spec = {
    "2:PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationCallback",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DAnimation_QAnimationCallback_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DAnimation_QAnimationCallback_Flag_PythonToCpp_Qt3DAnimation_QAnimationCallback_Flag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DAnimation::QAnimationCallback::Flag *>(cppOut) =
        static_cast<::Qt3DAnimation::QAnimationCallback::Flag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DAnimation_QAnimationCallback_Flag_PythonToCpp_Qt3DAnimation_QAnimationCallback_Flag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCALLBACK_FLAG_IDX]))
        return Qt3DAnimation_QAnimationCallback_Flag_PythonToCpp_Qt3DAnimation_QAnimationCallback_Flag;
    return {};
}
static PyObject *Qt3DAnimation_QAnimationCallback_Flag_CppToPython_Qt3DAnimation_QAnimationCallback_Flag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DAnimation::QAnimationCallback::Flag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCALLBACK_FLAG_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAnimationCallback_PythonToCpp_QAnimationCallback_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DAnimation_QAnimationCallback_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAnimationCallback_PythonToCpp_QAnimationCallback_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DAnimation_QAnimationCallback_TypeF())))
        return QAnimationCallback_PythonToCpp_QAnimationCallback_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAnimationCallback_PTR_CppToPython_QAnimationCallback(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::Qt3DAnimation::QAnimationCallback *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_Qt3DAnimation_QAnimationCallback_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DAnimation_QAnimationCallback_SignatureStrings[] = {
    "PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationCallback(self)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationCallback.valueChanged(self,value:QVariant)",
    nullptr}; // Sentinel

void init_Qt3DAnimation_QAnimationCallback(PyObject *enclosingClass)
{
    _Sbk_Qt3DAnimation_QAnimationCallback_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QAnimationCallback",
        "Qt3DAnimation::QAnimationCallback*",
        &Sbk_Qt3DAnimation_QAnimationCallback_spec,
        &Shiboken::callCppDestructor< ::Qt3DAnimation::QAnimationCallback >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DAnimation_QAnimationCallback_Type);
    InitSignatureStrings(pyType, Qt3DAnimation_QAnimationCallback_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DAnimation_QAnimationCallback_Type), Sbk_Qt3DAnimation_QAnimationCallback_PropertyStrings);
    SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCALLBACK_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DAnimation_QAnimationCallback_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DAnimation_QAnimationCallback_TypeF(),
        QAnimationCallback_PythonToCpp_QAnimationCallback_PTR,
        is_QAnimationCallback_PythonToCpp_QAnimationCallback_PTR_Convertible,
        QAnimationCallback_PTR_CppToPython_QAnimationCallback);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QAnimationCallback");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QAnimationCallback*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QAnimationCallback&");
    Shiboken::Conversions::registerConverterName(converter, "QAnimationCallback");
    Shiboken::Conversions::registerConverterName(converter, "QAnimationCallback*");
    Shiboken::Conversions::registerConverterName(converter, "QAnimationCallback&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DAnimation::QAnimationCallback).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAnimationCallbackWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'Flag'.
    SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCALLBACK_FLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DAnimation_QAnimationCallback_TypeF(),
        "Flag",
        "2:PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationCallback.Flag",
        "Qt3DAnimation::QAnimationCallback::Flag");
    if (!SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCALLBACK_FLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCALLBACK_FLAG_IDX],
        Sbk_Qt3DAnimation_QAnimationCallback_TypeF(), "OnOwningThread", (long) Qt3DAnimation::QAnimationCallback::Flag::OnOwningThread))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCALLBACK_FLAG_IDX],
        Sbk_Qt3DAnimation_QAnimationCallback_TypeF(), "OnThreadPool", (long) Qt3DAnimation::QAnimationCallback::Flag::OnThreadPool))
        return;
    // Register converter for enum 'Qt3DAnimation::QAnimationCallback::Flag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCALLBACK_FLAG_IDX],
            Qt3DAnimation_QAnimationCallback_Flag_CppToPython_Qt3DAnimation_QAnimationCallback_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DAnimation_QAnimationCallback_Flag_PythonToCpp_Qt3DAnimation_QAnimationCallback_Flag,
            is_Qt3DAnimation_QAnimationCallback_Flag_PythonToCpp_Qt3DAnimation_QAnimationCallback_Flag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCALLBACK_FLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QAnimationCallback::Flag");
        Shiboken::Conversions::registerConverterName(converter, "QAnimationCallback::Flag");
        Shiboken::Conversions::registerConverterName(converter, "Flag");
    }
    // End of 'Flag' enum.

    qRegisterMetaType< ::Qt3DAnimation::QAnimationCallback::Flag >("QAnimationCallback::Flag");
    qRegisterMetaType< ::Qt3DAnimation::QAnimationCallback::Flag >("Qt3DAnimation::QAnimationCallback::Flag");
}
