/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qt3dcore_python.h"

// main header
#include "qt3dcore_qscenechange_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSceneChangeWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSceneChangeWrapper::QSceneChangeWrapper(::Qt3DCore::ChangeFlag type, ::Qt3DCore::QNodeId subjectId) : Qt3DCore::QSceneChange(type, subjectId)
{
    resetPyMethodCache();
    // ... middle
}

QSceneChangeWrapper::~QSceneChangeWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DCore_QSceneChange_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DCore::QSceneChange >()))
        return -1;

    ::QSceneChangeWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QSceneChange.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSceneChange", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QSceneChange::QSceneChange(Qt3DCore::ChangeFlag,Qt3DCore::QNodeId)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), (pyArgs[1])))) {
        overloadId = 0; // QSceneChange(Qt3DCore::ChangeFlag,Qt3DCore::QNodeId)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QSceneChange_Init_TypeError;

    // Call function/method
    {
        ::Qt3DCore::ChangeFlag cppArg0 = static_cast< ::Qt3DCore::ChangeFlag>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::Qt3DCore::QNodeId cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QSceneChange(Qt3DCore::ChangeFlag,Qt3DCore::QNodeId)
            cptr = new ::QSceneChangeWrapper(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DCore::QSceneChange >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DCore_QSceneChange_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_Qt3DCore_QSceneChange_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DCore_QSceneChangeFunc_deliveryFlags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QSceneChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QSceneChange.deliveryFlags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // deliveryFlags()const
            QFlags<Qt3DCore::QSceneChange::DeliveryFlag> cppResult = const_cast<const ::Qt3DCore::QSceneChange *>(cppSelf)->deliveryFlags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QSceneChangeFunc_setDeliveryFlags(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QSceneChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QSceneChange.setDeliveryFlags";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSceneChange::setDeliveryFlags(QFlags<Qt3DCore::QSceneChange::DeliveryFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDeliveryFlags(QFlags<Qt3DCore::QSceneChange::DeliveryFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QSceneChangeFunc_setDeliveryFlags_TypeError;

    // Call function/method
    {
        ::QFlags<Qt3DCore::QSceneChange::DeliveryFlag> cppArg0 = QFlags<Qt3DCore::QSceneChange::DeliveryFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDeliveryFlags(QFlags<Qt3DCore::QSceneChange::DeliveryFlag>)
            cppSelf->setDeliveryFlags(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DCore_QSceneChangeFunc_setDeliveryFlags_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DCore_QSceneChangeFunc_subjectId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QSceneChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QSceneChange.subjectId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // subjectId()const
            Qt3DCore::QNodeId cppResult = const_cast<const ::Qt3DCore::QSceneChange *>(cppSelf)->subjectId();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QSceneChangeFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QSceneChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QSceneChange.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            Qt3DCore::ChangeFlag cppResult = const_cast<const ::Qt3DCore::QSceneChange *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_CHANGEFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DCore_QSceneChange_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DCore_QSceneChange_methods[] = {
    {"deliveryFlags", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QSceneChangeFunc_deliveryFlags), METH_NOARGS},
    {"setDeliveryFlags", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QSceneChangeFunc_setDeliveryFlags), METH_O},
    {"subjectId", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QSceneChangeFunc_subjectId), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QSceneChangeFunc_type), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DCore_QSceneChange_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DCore::QSceneChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSceneChangeWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DCore_QSceneChange_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DCore_QSceneChange_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DCore_QSceneChange_Type = nullptr;
static SbkObjectType *Sbk_Qt3DCore_QSceneChange_TypeF(void)
{
    return _Sbk_Qt3DCore_QSceneChange_Type;
}

static PyType_Slot Sbk_Qt3DCore_QSceneChange_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DCore_QSceneChange_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DCore_QSceneChange_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DCore_QSceneChange_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DCore_QSceneChange_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DCore_QSceneChange_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DCore_QSceneChange_spec = {
    "2:PySide2.Qt3DCore.Qt3DCore.QSceneChange",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DCore_QSceneChange_slots
};

} //extern "C"

PyObject *SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DCore::QSceneChange::DeliveryFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt3DCore::QSceneChange::DeliveryFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt3DCore::QSceneChange::DeliveryFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt3DCore::QSceneChange::DeliveryFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt3DCore::QSceneChange::DeliveryFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DCore::QSceneChange::DeliveryFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt3DCore::QSceneChange::DeliveryFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt3DCore::QSceneChange::DeliveryFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt3DCore::QSceneChange::DeliveryFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt3DCore::QSceneChange::DeliveryFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DCore::QSceneChange::DeliveryFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::Qt3DCore::QSceneChange::DeliveryFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<Qt3DCore::QSceneChange::DeliveryFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::Qt3DCore::QSceneChange::DeliveryFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<Qt3DCore::QSceneChange::DeliveryFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::Qt3DCore::QSceneChange::DeliveryFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX])->converter, self, &cppSelf);
    ::Qt3DCore::QSceneChange::DeliveryFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DCore_QSceneChange_DeliveryFlag_PythonToCpp_Qt3DCore_QSceneChange_DeliveryFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DCore::QSceneChange::DeliveryFlag *>(cppOut) =
        static_cast<::Qt3DCore::QSceneChange::DeliveryFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DCore_QSceneChange_DeliveryFlag_PythonToCpp_Qt3DCore_QSceneChange_DeliveryFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX]))
        return Qt3DCore_QSceneChange_DeliveryFlag_PythonToCpp_Qt3DCore_QSceneChange_DeliveryFlag;
    return {};
}
static PyObject *Qt3DCore_QSceneChange_DeliveryFlag_CppToPython_Qt3DCore_QSceneChange_DeliveryFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DCore::QSceneChange::DeliveryFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX], castCppIn);

}

static void QFlags_Qt3DCore_QSceneChange_DeliveryFlag__PythonToCpp_QFlags_Qt3DCore_QSceneChange_DeliveryFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt3DCore::QSceneChange::DeliveryFlag> *>(cppOut) =
        ::QFlags<Qt3DCore::QSceneChange::DeliveryFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_Qt3DCore_QSceneChange_DeliveryFlag__PythonToCpp_QFlags_Qt3DCore_QSceneChange_DeliveryFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX]))
        return QFlags_Qt3DCore_QSceneChange_DeliveryFlag__PythonToCpp_QFlags_Qt3DCore_QSceneChange_DeliveryFlag_;
    return {};
}
static PyObject *QFlags_Qt3DCore_QSceneChange_DeliveryFlag__CppToPython_QFlags_Qt3DCore_QSceneChange_DeliveryFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<Qt3DCore::QSceneChange::DeliveryFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX]));

}

static void Qt3DCore_QSceneChange_DeliveryFlag_PythonToCpp_QFlags_Qt3DCore_QSceneChange_DeliveryFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<Qt3DCore::QSceneChange::DeliveryFlag> *>(cppOut) =
        ::QFlags<Qt3DCore::QSceneChange::DeliveryFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_Qt3DCore_QSceneChange_DeliveryFlag_PythonToCpp_QFlags_Qt3DCore_QSceneChange_DeliveryFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX]))
        return Qt3DCore_QSceneChange_DeliveryFlag_PythonToCpp_QFlags_Qt3DCore_QSceneChange_DeliveryFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_Qt3DCore_QSceneChange_DeliveryFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<Qt3DCore::QSceneChange::DeliveryFlag> *>(cppOut) =
        ::QFlags<Qt3DCore::QSceneChange::DeliveryFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_Qt3DCore_QSceneChange_DeliveryFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX]))
        return number_PythonToCpp_QFlags_Qt3DCore_QSceneChange_DeliveryFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSceneChange_PythonToCpp_QSceneChange_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DCore_QSceneChange_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSceneChange_PythonToCpp_QSceneChange_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_QSceneChange_TypeF())))
        return QSceneChange_PythonToCpp_QSceneChange_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSceneChange_PTR_CppToPython_QSceneChange(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::Qt3DCore::QSceneChange *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_Qt3DCore_QSceneChange_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DCore_QSceneChange_SignatureStrings[] = {
    "PySide2.Qt3DCore.Qt3DCore.QSceneChange(self,type:PySide2.Qt3DCore.Qt3DCore.ChangeFlag,subjectId:PySide2.Qt3DCore.Qt3DCore.QNodeId)",
    "PySide2.Qt3DCore.Qt3DCore.QSceneChange.deliveryFlags(self)->PySide2.Qt3DCore.Qt3DCore.QSceneChange.DeliveryFlags",
    "PySide2.Qt3DCore.Qt3DCore.QSceneChange.setDeliveryFlags(self,flags:PySide2.Qt3DCore.Qt3DCore.QSceneChange.DeliveryFlags)",
    "PySide2.Qt3DCore.Qt3DCore.QSceneChange.subjectId(self)->PySide2.Qt3DCore.Qt3DCore.QNodeId",
    "PySide2.Qt3DCore.Qt3DCore.QSceneChange.type(self)->PySide2.Qt3DCore.Qt3DCore.ChangeFlag",
    nullptr}; // Sentinel

void init_Qt3DCore_QSceneChange(PyObject *enclosingClass)
{
    _Sbk_Qt3DCore_QSceneChange_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QSceneChange",
        "Qt3DCore::QSceneChange*",
        &Sbk_Qt3DCore_QSceneChange_spec,
        &Shiboken::callCppDestructor< ::Qt3DCore::QSceneChange >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_QSceneChange_Type);
    InitSignatureStrings(pyType, Qt3DCore_QSceneChange_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_QSceneChange_Type), Sbk_Qt3DCore_QSceneChange_PropertyStrings);
    SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_QSceneChange_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DCore_QSceneChange_TypeF(),
        QSceneChange_PythonToCpp_QSceneChange_PTR,
        is_QSceneChange_PythonToCpp_QSceneChange_PTR_Convertible,
        QSceneChange_PTR_CppToPython_QSceneChange);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QSceneChange");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QSceneChange*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QSceneChange&");
    Shiboken::Conversions::registerConverterName(converter, "QSceneChange");
    Shiboken::Conversions::registerConverterName(converter, "QSceneChange*");
    Shiboken::Conversions::registerConverterName(converter, "QSceneChange&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DCore::QSceneChange).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSceneChangeWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'DeliveryFlag'.
    SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX] = PySide::QFlags::create("2:PySide2.Qt3DCore.Qt3DCore.QSceneChange.DeliveryFlags", SbkPySide2_Qt3DCore_Qt3DCore_QSceneChange_DeliveryFlag_number_slots);
    SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DCore_QSceneChange_TypeF(),
        "DeliveryFlag",
        "2:PySide2.Qt3DCore.Qt3DCore.QSceneChange.DeliveryFlag",
        "Qt3DCore::QSceneChange::DeliveryFlag",
        SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX]);
    if (!SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX],
        Sbk_Qt3DCore_QSceneChange_TypeF(), "BackendNodes", (long) Qt3DCore::QSceneChange::DeliveryFlag::BackendNodes))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX],
        Sbk_Qt3DCore_QSceneChange_TypeF(), "Nodes", (long) Qt3DCore::QSceneChange::DeliveryFlag::Nodes))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX],
        Sbk_Qt3DCore_QSceneChange_TypeF(), "DeliverToAll", (long) Qt3DCore::QSceneChange::DeliveryFlag::DeliverToAll))
        return;
    // Register converter for enum 'Qt3DCore::QSceneChange::DeliveryFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX],
            Qt3DCore_QSceneChange_DeliveryFlag_CppToPython_Qt3DCore_QSceneChange_DeliveryFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DCore_QSceneChange_DeliveryFlag_PythonToCpp_Qt3DCore_QSceneChange_DeliveryFlag,
            is_Qt3DCore_QSceneChange_DeliveryFlag_PythonToCpp_Qt3DCore_QSceneChange_DeliveryFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QSceneChange::DeliveryFlag");
        Shiboken::Conversions::registerConverterName(converter, "QSceneChange::DeliveryFlag");
        Shiboken::Conversions::registerConverterName(converter, "DeliveryFlag");
    }
    // Register converter for flag 'QFlags<Qt3DCore::QSceneChange::DeliveryFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX],
            QFlags_Qt3DCore_QSceneChange_DeliveryFlag__CppToPython_QFlags_Qt3DCore_QSceneChange_DeliveryFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DCore_QSceneChange_DeliveryFlag_PythonToCpp_QFlags_Qt3DCore_QSceneChange_DeliveryFlag_,
            is_Qt3DCore_QSceneChange_DeliveryFlag_PythonToCpp_QFlags_Qt3DCore_QSceneChange_DeliveryFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_Qt3DCore_QSceneChange_DeliveryFlag__PythonToCpp_QFlags_Qt3DCore_QSceneChange_DeliveryFlag_,
            is_QFlags_Qt3DCore_QSceneChange_DeliveryFlag__PythonToCpp_QFlags_Qt3DCore_QSceneChange_DeliveryFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_Qt3DCore_QSceneChange_DeliveryFlag_,
            is_number_PythonToCpp_QFlags_Qt3DCore_QSceneChange_DeliveryFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DCoreTypes[SBK_QFLAGS_QT3DCORE_QSCENECHANGE_DELIVERYFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QSceneChange::DeliveryFlags");
        Shiboken::Conversions::registerConverterName(converter, "QSceneChange::DeliveryFlags");
        Shiboken::Conversions::registerConverterName(converter, "DeliveryFlags");
    }
    // End of 'DeliveryFlag' enum/flags.

    qRegisterMetaType< ::Qt3DCore::QSceneChange::DeliveryFlag >("QSceneChange::DeliveryFlag");
    qRegisterMetaType< ::Qt3DCore::QSceneChange::DeliveryFlag >("Qt3DCore::QSceneChange::DeliveryFlag");
    qRegisterMetaType< ::Qt3DCore::QSceneChange::DeliveryFlags >("Qt3DCore::QSceneChange::DeliveryFlags");
}
