/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qt3dextras_python.h"



// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_Qt3DExtrasTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_Qt3DExtrasModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_Qt3DExtrasTypeConverters = nullptr;
void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_Qt3DExtras_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_Qt3DExtrasTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------

static PyMethodDef Qt3DExtras_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_Qt3DExtrasQt3DExtras(PyObject *module);
void init_Qt3DExtras_Qt3DWindow(PyObject *enclosingClass);
void init_Qt3DExtras_QSphereGeometry(PyObject *enclosingClass);
void init_Qt3DExtras_QExtrudedTextGeometry(PyObject *enclosingClass);
void init_Qt3DExtras_QPlaneGeometry(PyObject *enclosingClass);
void init_Qt3DExtras_QCylinderGeometry(PyObject *enclosingClass);
void init_Qt3DExtras_QCuboidGeometry(PyObject *enclosingClass);
void init_Qt3DExtras_QConeGeometry(PyObject *enclosingClass);
void init_Qt3DExtras_QTorusGeometry(PyObject *enclosingClass);
void init_Qt3DExtras_QForwardRenderer(PyObject *enclosingClass);
void init_Qt3DExtras_QSpriteSheetItem(PyObject *enclosingClass);
void init_Qt3DExtras_QAbstractSpriteSheet(PyObject *enclosingClass);
void init_Qt3DExtras_QSpriteSheet(PyObject *enclosingClass);
void init_Qt3DExtras_QSpriteGrid(PyObject *enclosingClass);
void init_Qt3DExtras_QSkyboxEntity(PyObject *enclosingClass);
void init_Qt3DExtras_QText2DEntity(PyObject *enclosingClass);
void init_Qt3DExtras_QAbstractCameraController(PyObject *enclosingClass);
void init_Qt3DExtras_QFirstPersonCameraController(PyObject *enclosingClass);
void init_Qt3DExtras_QOrbitCameraController(PyObject *enclosingClass);
void init_Qt3DExtras_QAbstractCameraController_InputState(PyObject *enclosingClass);
void init_Qt3DExtras_QSphereMesh(PyObject *enclosingClass);
void init_Qt3DExtras_QExtrudedTextMesh(PyObject *enclosingClass);
void init_Qt3DExtras_QPlaneMesh(PyObject *enclosingClass);
void init_Qt3DExtras_QCylinderMesh(PyObject *enclosingClass);
void init_Qt3DExtras_QCuboidMesh(PyObject *enclosingClass);
void init_Qt3DExtras_QConeMesh(PyObject *enclosingClass);
void init_Qt3DExtras_QTorusMesh(PyObject *enclosingClass);
void init_Qt3DExtras_QDiffuseSpecularMaterial(PyObject *enclosingClass);
void init_Qt3DExtras_QDiffuseSpecularMapMaterial(PyObject *enclosingClass);
void init_Qt3DExtras_QDiffuseMapMaterial(PyObject *enclosingClass);
void init_Qt3DExtras_QPhongMaterial(PyObject *enclosingClass);
void init_Qt3DExtras_QPhongAlphaMaterial(PyObject *enclosingClass);
void init_Qt3DExtras_QPerVertexColorMaterial(PyObject *enclosingClass);
void init_Qt3DExtras_QNormalDiffuseSpecularMapMaterial(PyObject *enclosingClass);
void init_Qt3DExtras_QNormalDiffuseMapMaterial(PyObject *enclosingClass);
void init_Qt3DExtras_QNormalDiffuseMapAlphaMaterial(PyObject *enclosingClass);
void init_Qt3DExtras_QTextureMaterial(PyObject *enclosingClass);
void init_Qt3DExtras_QMorphPhongMaterial(PyObject *enclosingClass);
void init_Qt3DExtras_QMetalRoughMaterial(PyObject *enclosingClass);
void init_Qt3DExtras_QGoochMaterial(PyObject *enclosingClass);

// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_Qt3DRenderTypes;
SbkConverter **SbkPySide2_Qt3DRenderTypeConverters;
PyTypeObject **SbkPySide2_Qt3DCoreTypes;
SbkConverter **SbkPySide2_Qt3DCoreTypeConverters;
PyTypeObject **SbkPySide2_QtGuiTypes;
SbkConverter **SbkPySide2_QtGuiTypeConverters;
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for type 'QVector<Qt3DRender::QAttribute* >'.
static PyObject *_QVector_Qt3DRender_QAttributePTR__CppToPython__QVector_Qt3DRender_QAttributePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QAttribute* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QAttribute* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QAttribute* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QAttribute* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DRender_QAttributePTR__PythonToCpp__QVector_Qt3DRender_QAttributePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QAttribute* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QAttribute* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DRender_QAttributePTR__PythonToCpp__QVector_Qt3DRender_QAttributePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], pyIn))
        return _QVector_Qt3DRender_QAttributePTR__PythonToCpp__QVector_Qt3DRender_QAttributePTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DRender::QParameter* >'.
static PyObject *_QVector_Qt3DRender_QParameterPTR__CppToPython__QVector_Qt3DRender_QParameterPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QParameter* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QParameter* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QParameter* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QParameter* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QPARAMETER_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DRender_QParameterPTR__PythonToCpp__QVector_Qt3DRender_QParameterPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QParameter* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QParameter* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QPARAMETER_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DRender_QParameterPTR__PythonToCpp__QVector_Qt3DRender_QParameterPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QPARAMETER_IDX], pyIn))
        return _QVector_Qt3DRender_QParameterPTR__PythonToCpp__QVector_Qt3DRender_QParameterPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DCore::QComponent* >'.
static PyObject *_QVector_Qt3DCore_QComponentPTR__CppToPython__QVector_Qt3DCore_QComponentPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DCore::QComponent* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DCore::QComponent* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DCore::QComponent* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DCore::QComponent* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DCore_QComponentPTR__PythonToCpp__QVector_Qt3DCore_QComponentPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DCore::QComponent* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DCore::QComponent* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENT_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DCore_QComponentPTR__PythonToCpp__QVector_Qt3DCore_QComponentPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENT_IDX], pyIn))
        return _QVector_Qt3DCore_QComponentPTR__PythonToCpp__QVector_Qt3DCore_QComponentPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DCore::QNode* >'.
static PyObject *_QVector_Qt3DCore_QNodePTR__CppToPython__QVector_Qt3DCore_QNodePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DCore::QNode* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DCore::QNode* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DCore::QNode* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DCore::QNode* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DCore::QNode* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DCore::QNode* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], pyIn))
        return _QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DRender::QFilterKey* >'.
static PyObject *_QVector_Qt3DRender_QFilterKeyPTR__CppToPython__QVector_Qt3DRender_QFilterKeyPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QFilterKey* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QFilterKey* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QFilterKey* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QFilterKey* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QFILTERKEY_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DRender_QFilterKeyPTR__PythonToCpp__QVector_Qt3DRender_QFilterKeyPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QFilterKey* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QFilterKey* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QFILTERKEY_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DRender_QFilterKeyPTR__PythonToCpp__QVector_Qt3DRender_QFilterKeyPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QFILTERKEY_IDX], pyIn))
        return _QVector_Qt3DRender_QFilterKeyPTR__PythonToCpp__QVector_Qt3DRender_QFilterKeyPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DExtras::QSpriteSheetItem* >'.
static PyObject *_QVector_Qt3DExtras_QSpriteSheetItemPTR__CppToPython__QVector_Qt3DExtras_QSpriteSheetItemPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DExtras::QSpriteSheetItem* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DExtras::QSpriteSheetItem* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DExtras::QSpriteSheetItem* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DExtras::QSpriteSheetItem* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QSPRITESHEETITEM_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DExtras_QSpriteSheetItemPTR__PythonToCpp__QVector_Qt3DExtras_QSpriteSheetItemPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DExtras::QSpriteSheetItem* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DExtras::QSpriteSheetItem* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QSPRITESHEETITEM_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DExtras_QSpriteSheetItemPTR__PythonToCpp__QVector_Qt3DExtras_QSpriteSheetItemPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QSPRITESHEETITEM_IDX], pyIn))
        return _QVector_Qt3DExtras_QSpriteSheetItemPTR__PythonToCpp__QVector_Qt3DExtras_QSpriteSheetItemPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QVariant >'.
static PyObject *_QList_QVariant__CppToPython__QList_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVariant__PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _QList_QVariant__PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for type 'QMap<QString,QVariant >'.
static PyObject *_QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "Qt3DExtras",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ Qt3DExtras_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DExtras_SignatureStrings[] = {
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(Qt3DExtras)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.Qt3DRender"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_Qt3DRenderTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_Qt3DRenderTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.Qt3DCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_Qt3DCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_Qt3DCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtGui"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtGuiTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_Qt3DExtras_IDX_COUNT];
    SbkPySide2_Qt3DExtrasTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_Qt3DExtras_CONVERTERS_IDX_COUNT];
    SbkPySide2_Qt3DExtrasTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("Qt3DExtras", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("Qt3DExtras", Qt3DExtras_methods);
#endif

    // Make module available from global scope
    SbkPySide2_Qt3DExtrasModuleObject = module;

    // Initialize classes in the type system
    init_Qt3DExtrasQt3DExtras(module);
    init_Qt3DExtras_Qt3DWindow(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QSphereGeometry(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QExtrudedTextGeometry(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QPlaneGeometry(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QCylinderGeometry(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QCuboidGeometry(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QConeGeometry(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QTorusGeometry(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QForwardRenderer(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QSpriteSheetItem(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QAbstractSpriteSheet(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QSpriteSheet(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QSpriteGrid(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QSkyboxEntity(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QText2DEntity(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QAbstractCameraController(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QFirstPersonCameraController(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QOrbitCameraController(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QAbstractCameraController_InputState(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_IDX])->tp_dict);
    init_Qt3DExtras_QSphereMesh(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QExtrudedTextMesh(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QPlaneMesh(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QCylinderMesh(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QCuboidMesh(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QConeMesh(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QTorusMesh(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QDiffuseSpecularMaterial(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QDiffuseSpecularMapMaterial(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QDiffuseMapMaterial(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QPhongMaterial(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QPhongAlphaMaterial(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QPerVertexColorMaterial(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QNormalDiffuseSpecularMapMaterial(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QNormalDiffuseMapMaterial(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QNormalDiffuseMapAlphaMaterial(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QTextureMaterial(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QMorphPhongMaterial(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QMetalRoughMaterial(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);
    init_Qt3DExtras_QGoochMaterial(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX])->tp_dict);

    // Register converter for type 'QVector<Qt3DRender::QAttribute*>'.
    SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DRENDER_QATTRIBUTEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DRender_QAttributePTR__CppToPython__QVector_Qt3DRender_QAttributePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DRENDER_QATTRIBUTEPTR_IDX], "QVector<Qt3DRender::QAttribute*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DRENDER_QATTRIBUTEPTR_IDX],
        _QVector_Qt3DRender_QAttributePTR__PythonToCpp__QVector_Qt3DRender_QAttributePTR_,
        is__QVector_Qt3DRender_QAttributePTR__PythonToCpp__QVector_Qt3DRender_QAttributePTR__Convertible);

    // Register converter for type 'QVector<Qt3DRender::QParameter*>'.
    SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DRENDER_QPARAMETERPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DRender_QParameterPTR__CppToPython__QVector_Qt3DRender_QParameterPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DRENDER_QPARAMETERPTR_IDX], "QVector<Qt3DRender::QParameter*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DRENDER_QPARAMETERPTR_IDX],
        _QVector_Qt3DRender_QParameterPTR__PythonToCpp__QVector_Qt3DRender_QParameterPTR_,
        is__QVector_Qt3DRender_QParameterPTR__PythonToCpp__QVector_Qt3DRender_QParameterPTR__Convertible);

    // Register converter for type 'QVector<Qt3DCore::QComponent*>'.
    SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DCORE_QCOMPONENTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DCore_QComponentPTR__CppToPython__QVector_Qt3DCore_QComponentPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DCORE_QCOMPONENTPTR_IDX], "QVector<Qt3DCore::QComponent*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DCORE_QCOMPONENTPTR_IDX],
        _QVector_Qt3DCore_QComponentPTR__PythonToCpp__QVector_Qt3DCore_QComponentPTR_,
        is__QVector_Qt3DCore_QComponentPTR__PythonToCpp__QVector_Qt3DCore_QComponentPTR__Convertible);

    // Register converter for type 'QVector<Qt3DCore::QNode*>'.
    SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DCORE_QNODEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DCore_QNodePTR__CppToPython__QVector_Qt3DCore_QNodePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DCORE_QNODEPTR_IDX], "QVector<Qt3DCore::QNode*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DCORE_QNODEPTR_IDX],
        _QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR_,
        is__QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR__Convertible);

    // Register converter for type 'QVector<Qt3DRender::QFilterKey*>'.
    SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DRENDER_QFILTERKEYPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DRender_QFilterKeyPTR__CppToPython__QVector_Qt3DRender_QFilterKeyPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DRENDER_QFILTERKEYPTR_IDX], "QVector<Qt3DRender::QFilterKey*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DRENDER_QFILTERKEYPTR_IDX],
        _QVector_Qt3DRender_QFilterKeyPTR__PythonToCpp__QVector_Qt3DRender_QFilterKeyPTR_,
        is__QVector_Qt3DRender_QFilterKeyPTR__PythonToCpp__QVector_Qt3DRender_QFilterKeyPTR__Convertible);

    // Register converter for type 'QVector<Qt3DExtras::QSpriteSheetItem*>'.
    SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DEXTRAS_QSPRITESHEETITEMPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DExtras_QSpriteSheetItemPTR__CppToPython__QVector_Qt3DExtras_QSpriteSheetItemPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DEXTRAS_QSPRITESHEETITEMPTR_IDX], "QVector<Qt3DExtras::QSpriteSheetItem*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QVECTOR_QT3DEXTRAS_QSPRITESHEETITEMPTR_IDX],
        _QVector_Qt3DExtras_QSpriteSheetItemPTR__PythonToCpp__QVector_Qt3DExtras_QSpriteSheetItemPTR_,
        is__QVector_Qt3DExtras_QSpriteSheetItemPTR__PythonToCpp__QVector_Qt3DExtras_QSpriteSheetItemPTR__Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython__QList_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QLIST_QVARIANT_IDX],
        _QList_QVariant__PythonToCpp__QList_QVariant_,
        is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DExtrasTypeConverters[SBK_QT3DEXTRAS_QMAP_QSTRING_QVARIANT_IDX],
        _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_,
        is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible);

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPySide2_Qt3DExtrasTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_Qt3DExtrasTypeConverters);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module Qt3DExtras");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, Qt3DExtras_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
