/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3dextras_python.h"

// main header
#include "qt3dextras_qforwardrenderer_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DExtras;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QForwardRendererWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QForwardRendererWrapper::QForwardRendererWrapper(::Qt3DCore::QNode * parent) : Qt3DExtras::QForwardRenderer(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QForwardRendererWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QForwardRendererWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QForwardRendererWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QForwardRendererWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QForwardRendererWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QForwardRenderer.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QForwardRendererWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QForwardRenderer.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QForwardRendererWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QForwardRendererWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DExtras::QForwardRenderer::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QForwardRendererWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DExtras::QForwardRenderer::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QForwardRendererWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QForwardRendererWrapper *>(this));
        return Qt3DExtras::QForwardRenderer::qt_metacast(_clname);
}

QForwardRendererWrapper::~QForwardRendererWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DExtras_QForwardRenderer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DExtras::QForwardRenderer >()))
        return -1;

    ::QForwardRendererWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QForwardRenderer", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QForwardRenderer::QForwardRenderer(Qt3DCore::QNode*)
    if (numArgs == 0) {
        overloadId = 0; // QForwardRenderer(Qt3DCore::QNode*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QForwardRenderer(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QForwardRenderer_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DExtras_QForwardRenderer_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0]))))
                        goto Sbk_Qt3DExtras_QForwardRenderer_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::Qt3DCore::QNode *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QForwardRenderer(Qt3DCore::QNode*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QForwardRendererWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QForwardRendererWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DExtras::QForwardRenderer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DExtras_QForwardRenderer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DExtras_QForwardRenderer_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DExtras_QForwardRenderer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_buffersToClear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.buffersToClear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // buffersToClear()const
            Qt3DRender::QClearBuffers::BufferType cppResult = const_cast<const ::Qt3DExtras::QForwardRenderer *>(cppSelf)->buffersToClear();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_camera(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.camera";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // camera()const
            Qt3DCore::QEntity * cppResult = const_cast<const ::Qt3DExtras::QForwardRenderer *>(cppSelf)->camera();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_clearColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.clearColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearColor()const
            QColor cppResult = const_cast<const ::Qt3DExtras::QForwardRenderer *>(cppSelf)->clearColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_externalRenderTargetSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.externalRenderTargetSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // externalRenderTargetSize()const
            QSize cppResult = const_cast<const ::Qt3DExtras::QForwardRenderer *>(cppSelf)->externalRenderTargetSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_gamma(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.gamma";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // gamma()const
            float cppResult = const_cast<const ::Qt3DExtras::QForwardRenderer *>(cppSelf)->gamma();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_isFrustumCullingEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.isFrustumCullingEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFrustumCullingEnabled()const
            bool cppResult = const_cast<const ::Qt3DExtras::QForwardRenderer *>(cppSelf)->isFrustumCullingEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_setBuffersToClear(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setBuffersToClear";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QForwardRenderer::setBuffersToClear(Qt3DRender::QClearBuffers::BufferType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QCLEARBUFFERS_BUFFERTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setBuffersToClear(Qt3DRender::QClearBuffers::BufferType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QForwardRendererFunc_setBuffersToClear_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QClearBuffers::BufferType cppArg0{Qt3DRender::QClearBuffers::None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBuffersToClear(Qt3DRender::QClearBuffers::BufferType)
            cppSelf->setBuffersToClear(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QForwardRendererFunc_setBuffersToClear_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_setCamera(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setCamera";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QForwardRenderer::setCamera(Qt3DCore::QEntity*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX]), (pyArg)))) {
        overloadId = 0; // setCamera(Qt3DCore::QEntity*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QForwardRendererFunc_setCamera_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DCore::QEntity *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCamera(Qt3DCore::QEntity*)
            cppSelf->setCamera(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QForwardRendererFunc_setCamera_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_setClearColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setClearColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QForwardRenderer::setClearColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setClearColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QForwardRendererFunc_setClearColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setClearColor(QColor)
            cppSelf->setClearColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QForwardRendererFunc_setClearColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_setExternalRenderTargetSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setExternalRenderTargetSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QForwardRenderer::setExternalRenderTargetSize(QSize)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArg)))) {
        overloadId = 0; // setExternalRenderTargetSize(QSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QForwardRendererFunc_setExternalRenderTargetSize_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSize cppArg0_local;
        ::QSize *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setExternalRenderTargetSize(QSize)
            cppSelf->setExternalRenderTargetSize(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QForwardRendererFunc_setExternalRenderTargetSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_setFrustumCullingEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setFrustumCullingEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QForwardRenderer::setFrustumCullingEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFrustumCullingEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QForwardRendererFunc_setFrustumCullingEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFrustumCullingEnabled(bool)
            cppSelf->setFrustumCullingEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QForwardRendererFunc_setFrustumCullingEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_setGamma(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setGamma";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QForwardRenderer::setGamma(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setGamma(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QForwardRendererFunc_setGamma_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGamma(float)
            cppSelf->setGamma(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QForwardRendererFunc_setGamma_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_setShowDebugOverlay(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setShowDebugOverlay";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QForwardRenderer::setShowDebugOverlay(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowDebugOverlay(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QForwardRendererFunc_setShowDebugOverlay_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setShowDebugOverlay(bool)
            cppSelf->setShowDebugOverlay(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QForwardRendererFunc_setShowDebugOverlay_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_setSurface(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setSurface";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QForwardRenderer::setSurface(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // setSurface(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QForwardRendererFunc_setSurface_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSurface(QObject*)
            cppSelf->setSurface(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QForwardRendererFunc_setSurface_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_setViewportRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setViewportRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QForwardRenderer::setViewportRect(QRectF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
        overloadId = 0; // setViewportRect(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QForwardRendererFunc_setViewportRect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setViewportRect(QRectF)
            cppSelf->setViewportRect(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QForwardRendererFunc_setViewportRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_showDebugOverlay(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.showDebugOverlay";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // showDebugOverlay()const
            bool cppResult = const_cast<const ::Qt3DExtras::QForwardRenderer *>(cppSelf)->showDebugOverlay();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_surface(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.surface";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // surface()const
            QObject * cppResult = const_cast<const ::Qt3DExtras::QForwardRenderer *>(cppSelf)->surface();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QForwardRendererFunc_viewportRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.viewportRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // viewportRect()const
            QRectF cppResult = const_cast<const ::Qt3DExtras::QForwardRenderer *>(cppSelf)->viewportRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DExtras_QForwardRenderer_PropertyStrings[] = {
    "buffersToClear::",
    "camera::",
    "clearColor::",
    "externalRenderTargetSize::",
    "frustumCulling:isFrustumCullingEnabled:setFrustumCullingEnabled",
    "gamma::",
    "showDebugOverlay::",
    "surface::",
    "viewportRect::",
    "window:surface:setSurface",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DExtras_QForwardRenderer_methods[] = {
    {"buffersToClear", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_buffersToClear), METH_NOARGS},
    {"camera", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_camera), METH_NOARGS},
    {"clearColor", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_clearColor), METH_NOARGS},
    {"externalRenderTargetSize", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_externalRenderTargetSize), METH_NOARGS},
    {"gamma", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_gamma), METH_NOARGS},
    {"isFrustumCullingEnabled", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_isFrustumCullingEnabled), METH_NOARGS},
    {"setBuffersToClear", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_setBuffersToClear), METH_O},
    {"setCamera", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_setCamera), METH_O},
    {"setClearColor", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_setClearColor), METH_O},
    {"setExternalRenderTargetSize", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_setExternalRenderTargetSize), METH_O},
    {"setFrustumCullingEnabled", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_setFrustumCullingEnabled), METH_O},
    {"setGamma", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_setGamma), METH_O},
    {"setShowDebugOverlay", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_setShowDebugOverlay), METH_O},
    {"setSurface", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_setSurface), METH_O},
    {"setViewportRect", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_setViewportRect), METH_O},
    {"showDebugOverlay", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_showDebugOverlay), METH_NOARGS},
    {"surface", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_surface), METH_NOARGS},
    {"viewportRect", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QForwardRendererFunc_viewportRect), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DExtras_QForwardRenderer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DExtras::QForwardRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QForwardRendererWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DExtras_QForwardRenderer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DExtras_QForwardRenderer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DExtras_QForwardRenderer_Type = nullptr;
static SbkObjectType *Sbk_Qt3DExtras_QForwardRenderer_TypeF(void)
{
    return _Sbk_Qt3DExtras_QForwardRenderer_Type;
}

static PyType_Slot Sbk_Qt3DExtras_QForwardRenderer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DExtras_QForwardRenderer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DExtras_QForwardRenderer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DExtras_QForwardRenderer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DExtras_QForwardRenderer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DExtras_QForwardRenderer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DExtras_QForwardRenderer_spec = {
    "2:PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DExtras_QForwardRenderer_slots
};

} //extern "C"

static void *Sbk_Qt3DExtras_QForwardRenderer_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DExtras::QForwardRenderer *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QForwardRenderer_PythonToCpp_QForwardRenderer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DExtras_QForwardRenderer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QForwardRenderer_PythonToCpp_QForwardRenderer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DExtras_QForwardRenderer_TypeF())))
        return QForwardRenderer_PythonToCpp_QForwardRenderer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QForwardRenderer_PTR_CppToPython_QForwardRenderer(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DExtras::QForwardRenderer *>(const_cast<void *>(cppIn)), Sbk_Qt3DExtras_QForwardRenderer_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DExtras_QForwardRenderer_SignatureStrings[] = {
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.buffersToClear(self)->PySide2.Qt3DRender.Qt3DRender.QClearBuffers.BufferType",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.camera(self)->PySide2.Qt3DCore.Qt3DCore.QEntity",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.clearColor(self)->PySide2.QtGui.QColor",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.externalRenderTargetSize(self)->PySide2.QtCore.QSize",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.gamma(self)->float",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.isFrustumCullingEnabled(self)->bool",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setBuffersToClear(self,arg__1:PySide2.Qt3DRender.Qt3DRender.QClearBuffers.BufferType)",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setCamera(self,camera:PySide2.Qt3DCore.Qt3DCore.QEntity)",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setClearColor(self,clearColor:PySide2.QtGui.QColor)",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setExternalRenderTargetSize(self,size:PySide2.QtCore.QSize)",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setFrustumCullingEnabled(self,enabled:bool)",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setGamma(self,gamma:float)",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setShowDebugOverlay(self,showDebugOverlay:bool)",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setSurface(self,surface:PySide2.QtCore.QObject)",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.setViewportRect(self,viewportRect:PySide2.QtCore.QRectF)",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.showDebugOverlay(self)->bool",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.surface(self)->PySide2.QtCore.QObject",
    "PySide2.Qt3DExtras.Qt3DExtras.QForwardRenderer.viewportRect(self)->PySide2.QtCore.QRectF",
    nullptr}; // Sentinel

void init_Qt3DExtras_QForwardRenderer(PyObject *enclosingClass)
{
    _Sbk_Qt3DExtras_QForwardRenderer_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QForwardRenderer",
        "Qt3DExtras::QForwardRenderer*",
        &Sbk_Qt3DExtras_QForwardRenderer_spec,
        &Shiboken::callCppDestructor< ::Qt3DExtras::QForwardRenderer >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTECHNIQUEFILTER_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DExtras_QForwardRenderer_Type);
    InitSignatureStrings(pyType, Qt3DExtras_QForwardRenderer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DExtras_QForwardRenderer_Type), Sbk_Qt3DExtras_QForwardRenderer_PropertyStrings);
    SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QFORWARDRENDERER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DExtras_QForwardRenderer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DExtras_QForwardRenderer_TypeF(),
        QForwardRenderer_PythonToCpp_QForwardRenderer_PTR,
        is_QForwardRenderer_PythonToCpp_QForwardRenderer_PTR_Convertible,
        QForwardRenderer_PTR_CppToPython_QForwardRenderer);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DExtras::QForwardRenderer");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DExtras::QForwardRenderer*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DExtras::QForwardRenderer&");
    Shiboken::Conversions::registerConverterName(converter, "QForwardRenderer");
    Shiboken::Conversions::registerConverterName(converter, "QForwardRenderer*");
    Shiboken::Conversions::registerConverterName(converter, "QForwardRenderer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DExtras::QForwardRenderer).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QForwardRendererWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DExtras_QForwardRenderer_TypeF(), &Sbk_Qt3DExtras_QForwardRenderer_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_Qt3DExtras_QForwardRenderer_TypeF(), &::Qt3DExtras::QForwardRenderer::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DExtras_QForwardRenderer_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DExtras_QForwardRenderer_TypeF(), &::Qt3DExtras::QForwardRenderer::staticMetaObject, sizeof(QForwardRendererWrapper));
}
