/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3dextras_python.h"

// main header
#include "qt3dextras_qtorusmesh_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DExtras;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QTorusMeshWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QTorusMeshWrapper::QTorusMeshWrapper(::Qt3DCore::QNode * parent) : Qt3DExtras::QTorusMesh(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QTorusMeshWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QTorusMeshWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QTorusMeshWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QTorusMeshWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QTorusMeshWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTorusMesh.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QTorusMeshWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTorusMesh.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QTorusMeshWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QTorusMeshWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DExtras::QTorusMesh::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QTorusMeshWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DExtras::QTorusMesh::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QTorusMeshWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QTorusMeshWrapper *>(this));
        return Qt3DExtras::QTorusMesh::qt_metacast(_clname);
}

QTorusMeshWrapper::~QTorusMeshWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DExtras_QTorusMesh_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DExtras::QTorusMesh >()))
        return -1;

    ::QTorusMeshWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QTorusMesh", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QTorusMesh::QTorusMesh(Qt3DCore::QNode*)
    if (numArgs == 0) {
        overloadId = 0; // QTorusMesh(Qt3DCore::QNode*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QTorusMesh(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QTorusMesh_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DExtras_QTorusMesh_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0]))))
                        goto Sbk_Qt3DExtras_QTorusMesh_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::Qt3DCore::QNode *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QTorusMesh(Qt3DCore::QNode*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QTorusMeshWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QTorusMeshWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DExtras::QTorusMesh >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DExtras_QTorusMesh_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DExtras_QTorusMesh_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DExtras_QTorusMesh_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_minorRadius(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.minorRadius";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minorRadius()const
            float cppResult = const_cast<const ::Qt3DExtras::QTorusMesh *>(cppSelf)->minorRadius();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_radius(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.radius";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // radius()const
            float cppResult = const_cast<const ::Qt3DExtras::QTorusMesh *>(cppSelf)->radius();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_rings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.rings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rings()const
            int cppResult = const_cast<const ::Qt3DExtras::QTorusMesh *>(cppSelf)->rings();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_setFirstInstance(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setFirstInstance";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeometryRenderer::setFirstInstance(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setFirstInstance(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QTorusMeshFunc_setFirstInstance_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "setFirstInstance(int firstInstance)");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QTorusMeshFunc_setFirstInstance_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_setGeometry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setGeometry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeometryRenderer::setGeometry(Qt3DRender::QGeometry*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGEOMETRY_IDX]), (pyArg)))) {
        overloadId = 0; // setGeometry(Qt3DRender::QGeometry*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QTorusMeshFunc_setGeometry_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "setGeometry(Qt3DRender.QGeometry * geometry)");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QTorusMeshFunc_setGeometry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_setIndexOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setIndexOffset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeometryRenderer::setIndexOffset(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setIndexOffset(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QTorusMeshFunc_setIndexOffset_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "setIndexOffset(int indexOffset)");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QTorusMeshFunc_setIndexOffset_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_setInstanceCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setInstanceCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeometryRenderer::setInstanceCount(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setInstanceCount(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QTorusMeshFunc_setInstanceCount_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "setInstanceCount(int instanceCount)");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QTorusMeshFunc_setInstanceCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_setMinorRadius(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setMinorRadius";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTorusMesh::setMinorRadius(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setMinorRadius(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QTorusMeshFunc_setMinorRadius_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMinorRadius(float)
            cppSelf->setMinorRadius(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QTorusMeshFunc_setMinorRadius_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_setPrimitiveRestartEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setPrimitiveRestartEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeometryRenderer::setPrimitiveRestartEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setPrimitiveRestartEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QTorusMeshFunc_setPrimitiveRestartEnabled_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "setPrimitiveRestartEnabled(bool enabled)");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QTorusMeshFunc_setPrimitiveRestartEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_setPrimitiveType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setPrimitiveType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeometryRenderer::setPrimitiveType(Qt3DRender::QGeometryRenderer::PrimitiveType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGEOMETRYRENDERER_PRIMITIVETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPrimitiveType(Qt3DRender::QGeometryRenderer::PrimitiveType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QTorusMeshFunc_setPrimitiveType_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "setPrimitiveType(Qt3DRender.QGeometryRenderer.PrimitiveType primitiveType)");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QTorusMeshFunc_setPrimitiveType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_setRadius(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setRadius";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTorusMesh::setRadius(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setRadius(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QTorusMeshFunc_setRadius_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRadius(float)
            cppSelf->setRadius(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QTorusMeshFunc_setRadius_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_setRestartIndexValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setRestartIndexValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeometryRenderer::setRestartIndexValue(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setRestartIndexValue(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QTorusMeshFunc_setRestartIndexValue_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "setRestartIndexValue(int index)");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QTorusMeshFunc_setRestartIndexValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_setRings(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setRings";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTorusMesh::setRings(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setRings(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QTorusMeshFunc_setRings_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRings(int)
            cppSelf->setRings(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QTorusMeshFunc_setRings_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_setSlices(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setSlices";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTorusMesh::setSlices(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSlices(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QTorusMeshFunc_setSlices_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSlices(int)
            cppSelf->setSlices(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QTorusMeshFunc_setSlices_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_setVertexCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setVertexCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeometryRenderer::setVertexCount(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setVertexCount(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QTorusMeshFunc_setVertexCount_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "setVertexCount(int vertexCount)");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtras_QTorusMeshFunc_setVertexCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DExtras_QTorusMeshFunc_slices(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.slices";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // slices()const
            int cppResult = const_cast<const ::Qt3DExtras::QTorusMesh *>(cppSelf)->slices();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DExtras_QTorusMesh_PropertyStrings[] = {
    "minorRadius::",
    "radius::",
    "rings::",
    "slices::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DExtras_QTorusMesh_methods[] = {
    {"minorRadius", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_minorRadius), METH_NOARGS},
    {"radius", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_radius), METH_NOARGS},
    {"rings", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_rings), METH_NOARGS},
    {"setFirstInstance", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_setFirstInstance), METH_O},
    {"setGeometry", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_setGeometry), METH_O},
    {"setIndexOffset", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_setIndexOffset), METH_O},
    {"setInstanceCount", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_setInstanceCount), METH_O},
    {"setMinorRadius", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_setMinorRadius), METH_O},
    {"setPrimitiveRestartEnabled", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_setPrimitiveRestartEnabled), METH_O},
    {"setPrimitiveType", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_setPrimitiveType), METH_O},
    {"setRadius", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_setRadius), METH_O},
    {"setRestartIndexValue", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_setRestartIndexValue), METH_O},
    {"setRings", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_setRings), METH_O},
    {"setSlices", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_setSlices), METH_O},
    {"setVertexCount", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_setVertexCount), METH_O},
    {"slices", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QTorusMeshFunc_slices), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DExtras_QTorusMesh_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DExtras::QTorusMesh *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QTorusMeshWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DExtras_QTorusMesh_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DExtras_QTorusMesh_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DExtras_QTorusMesh_Type = nullptr;
static SbkObjectType *Sbk_Qt3DExtras_QTorusMesh_TypeF(void)
{
    return _Sbk_Qt3DExtras_QTorusMesh_Type;
}

static PyType_Slot Sbk_Qt3DExtras_QTorusMesh_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DExtras_QTorusMesh_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DExtras_QTorusMesh_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DExtras_QTorusMesh_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DExtras_QTorusMesh_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DExtras_QTorusMesh_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DExtras_QTorusMesh_spec = {
    "2:PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DExtras_QTorusMesh_slots
};

} //extern "C"

static void *Sbk_Qt3DExtras_QTorusMesh_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DExtras::QTorusMesh *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTorusMesh_PythonToCpp_QTorusMesh_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DExtras_QTorusMesh_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTorusMesh_PythonToCpp_QTorusMesh_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DExtras_QTorusMesh_TypeF())))
        return QTorusMesh_PythonToCpp_QTorusMesh_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTorusMesh_PTR_CppToPython_QTorusMesh(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DExtras::QTorusMesh *>(const_cast<void *>(cppIn)), Sbk_Qt3DExtras_QTorusMesh_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DExtras_QTorusMesh_SignatureStrings[] = {
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.minorRadius(self)->float",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.radius(self)->float",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.rings(self)->int",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setFirstInstance(self,firstInstance:int)",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setGeometry(self,geometry:PySide2.Qt3DRender.Qt3DRender.QGeometry)",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setIndexOffset(self,indexOffset:int)",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setInstanceCount(self,instanceCount:int)",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setMinorRadius(self,minorRadius:float)",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setPrimitiveRestartEnabled(self,enabled:bool)",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setPrimitiveType(self,primitiveType:PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer.PrimitiveType)",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setRadius(self,radius:float)",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setRestartIndexValue(self,index:int)",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setRings(self,rings:int)",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setSlices(self,slices:int)",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.setVertexCount(self,vertexCount:int)",
    "PySide2.Qt3DExtras.Qt3DExtras.QTorusMesh.slices(self)->int",
    nullptr}; // Sentinel

void init_Qt3DExtras_QTorusMesh(PyObject *enclosingClass)
{
    _Sbk_Qt3DExtras_QTorusMesh_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QTorusMesh",
        "Qt3DExtras::QTorusMesh*",
        &Sbk_Qt3DExtras_QTorusMesh_spec,
        &Shiboken::callCppDestructor< ::Qt3DExtras::QTorusMesh >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QGEOMETRYRENDERER_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DExtras_QTorusMesh_Type);
    InitSignatureStrings(pyType, Qt3DExtras_QTorusMesh_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DExtras_QTorusMesh_Type), Sbk_Qt3DExtras_QTorusMesh_PropertyStrings);
    SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QTORUSMESH_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DExtras_QTorusMesh_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DExtras_QTorusMesh_TypeF(),
        QTorusMesh_PythonToCpp_QTorusMesh_PTR,
        is_QTorusMesh_PythonToCpp_QTorusMesh_PTR_Convertible,
        QTorusMesh_PTR_CppToPython_QTorusMesh);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DExtras::QTorusMesh");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DExtras::QTorusMesh*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DExtras::QTorusMesh&");
    Shiboken::Conversions::registerConverterName(converter, "QTorusMesh");
    Shiboken::Conversions::registerConverterName(converter, "QTorusMesh*");
    Shiboken::Conversions::registerConverterName(converter, "QTorusMesh&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DExtras::QTorusMesh).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTorusMeshWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DExtras_QTorusMesh_TypeF(), &Sbk_Qt3DExtras_QTorusMesh_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_Qt3DExtras_QTorusMesh_TypeF(), &::Qt3DExtras::QTorusMesh::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DExtras_QTorusMesh_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DExtras_QTorusMesh_TypeF(), &::Qt3DExtras::QTorusMesh::staticMetaObject, sizeof(QTorusMeshWrapper));
}
