/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qt3dextras_python.h"

// main header
#include "qt3dextras_wrapper.h"

// inner classes
#include "qt3dextras_qtorusmesh_wrapper.h"
#include "qt3dextras_qtorusgeometry_wrapper.h"
#include "qt3dextras_qtexturematerial_wrapper.h"
#include "qt3dextras_qtext2dentity_wrapper.h"
#include "qt3dextras_qt3dwindow_wrapper.h"
#include "qt3dextras_qspritesheetitem_wrapper.h"
#include "qt3dextras_qspheremesh_wrapper.h"
#include "qt3dextras_qspheregeometry_wrapper.h"
#include "qt3dextras_qskyboxentity_wrapper.h"
#include "qt3dextras_qplanemesh_wrapper.h"
#include "qt3dextras_qplanegeometry_wrapper.h"
#include "qt3dextras_qphongmaterial_wrapper.h"
#include "qt3dextras_qphongalphamaterial_wrapper.h"
#include "qt3dextras_qpervertexcolormaterial_wrapper.h"
#include "qt3dextras_qnormaldiffusespecularmapmaterial_wrapper.h"
#include "qt3dextras_qnormaldiffusemapmaterial_wrapper.h"
#include "qt3dextras_qnormaldiffusemapalphamaterial_wrapper.h"
#include "qt3dextras_qmorphphongmaterial_wrapper.h"
#include "qt3dextras_qmetalroughmaterial_wrapper.h"
#include "qt3dextras_qgoochmaterial_wrapper.h"
#include "qt3dextras_qforwardrenderer_wrapper.h"
#include "qt3dextras_qextrudedtextmesh_wrapper.h"
#include "qt3dextras_qextrudedtextgeometry_wrapper.h"
#include "qt3dextras_qdiffusespecularmaterial_wrapper.h"
#include "qt3dextras_qdiffusespecularmapmaterial_wrapper.h"
#include "qt3dextras_qdiffusemapmaterial_wrapper.h"
#include "qt3dextras_qcylindermesh_wrapper.h"
#include "qt3dextras_qcylindergeometry_wrapper.h"
#include "qt3dextras_qcuboidmesh_wrapper.h"
#include "qt3dextras_qcuboidgeometry_wrapper.h"
#include "qt3dextras_qconemesh_wrapper.h"
#include "qt3dextras_qconegeometry_wrapper.h"
#include "qt3dextras_qabstractspritesheet_wrapper.h"
#include "qt3dextras_qspritesheet_wrapper.h"
#include "qt3dextras_qspritegrid_wrapper.h"
#include "qt3dextras_qabstractcameracontroller_wrapper.h"
#include "qt3dextras_qfirstpersoncameracontroller_wrapper.h"
#include "qt3dextras_qorbitcameracontroller_wrapper.h"

// Extra includes
#include <QtGui/qwindow.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_Qt3DExtrasFunc_setupWindowSurface(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.setupWindowSurface";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setupWindowSurface", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static Qt3DExtras::setupWindowSurface(QWindow*,Qt3DRender::API)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_API_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // setupWindowSurface(QWindow*,Qt3DRender::API)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtrasFunc_setupWindowSurface_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWindow *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt3DRender::API cppArg1{Qt3DRender::API::OpenGL};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setupWindowSurface(QWindow*,Qt3DRender::API)
            ::Qt3DExtras::setupWindowSurface(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DExtrasFunc_setupWindowSurface_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_Qt3DExtras_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DExtras_methods[] = {
    {"setupWindowSurface", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtrasFunc_setupWindowSurface), METH_VARARGS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_Qt3DExtras_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DExtras_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DExtras_Type = nullptr;
static SbkObjectType *Sbk_Qt3DExtras_TypeF(void)
{
    return _Sbk_Qt3DExtras_Type;
}

static PyType_Slot Sbk_Qt3DExtras_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DExtras_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DExtras_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DExtras_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DExtras_spec = {
    "2:PySide2.Qt3DExtras.Qt3DExtras",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DExtras_slots
};

} //extern "C"


// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DExtrasQt3DExtras_SignatureStrings[] = {
    "PySide2.Qt3DExtras.Qt3DExtras.setupWindowSurface(window:PySide2.QtGui.QWindow,arg__2:PySide2.Qt3DRender.Qt3DRender.API)",
    nullptr}; // Sentinel

void init_Qt3DExtrasQt3DExtras(PyObject *module)
{
    _Sbk_Qt3DExtras_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "Qt3DExtras",
        "Qt3DExtras",
        &Sbk_Qt3DExtras_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DExtras_Type);
    InitSignatureStrings(pyType, Qt3DExtrasQt3DExtras_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DExtras_Type), Sbk_Qt3DExtras_PropertyStrings);
    SbkPySide2_Qt3DExtrasTypes[SBK_Qt3DExtrasQT3DEXTRAS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DExtras_TypeF());


}
