/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3dinput_python.h"

// main header
#include "qt3dinput_qwheelevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DInput;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QWheelEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QWheelEventWrapper::QWheelEventWrapper(const ::QWheelEvent & e) : Qt3DInput::QWheelEvent(e)
{
    resetPyMethodCache();
    // ... middle
}

void QWheelEventWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QWheelEventWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QWheelEventWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QWheelEventWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QWheelEventWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWheelEvent.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QWheelEventWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWheelEvent.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QWheelEventWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QWheelEventWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DInput::QWheelEvent::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QWheelEventWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DInput::QWheelEvent::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QWheelEventWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QWheelEventWrapper *>(this));
        return Qt3DInput::QWheelEvent::qt_metacast(_clname);
}

QWheelEventWrapper::~QWheelEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DInput_QWheelEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DInput::QWheelEvent >()))
        return -1;

    ::QWheelEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QWheelEvent", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QWheelEvent::QWheelEvent(QWheelEvent)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QWheelEvent(QWheelEvent)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DInput_QWheelEvent_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWheelEvent *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QWheelEvent(QWheelEvent)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QWheelEventWrapper(*cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QWheelEventWrapper(*cppArg0);
            }

        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DInput::QWheelEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DInput_QWheelEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DInput_QWheelEvent_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DInput_QWheelEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DInput_QWheelEventFunc_angleDelta(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.angleDelta";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // angleDelta()const
            QPoint cppResult = const_cast<const ::Qt3DInput::QWheelEvent *>(cppSelf)->angleDelta();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QWheelEventFunc_buttons(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.buttons";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // buttons()const
            int cppResult = const_cast<const ::Qt3DInput::QWheelEvent *>(cppSelf)->buttons();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QWheelEventFunc_isAccepted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.isAccepted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAccepted()const
            bool cppResult = const_cast<const ::Qt3DInput::QWheelEvent *>(cppSelf)->isAccepted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QWheelEventFunc_modifiers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.modifiers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // modifiers()const
            Qt3DInput::QWheelEvent::Modifiers cppResult = const_cast<const ::Qt3DInput::QWheelEvent *>(cppSelf)->modifiers();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_MODIFIERS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QWheelEventFunc_setAccepted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.setAccepted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWheelEvent::setAccepted(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAccepted(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DInput_QWheelEventFunc_setAccepted_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAccepted(bool)
            cppSelf->setAccepted(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DInput_QWheelEventFunc_setAccepted_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DInput_QWheelEventFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QEvent::Type cppResult = const_cast<const ::Qt3DInput::QWheelEvent *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QWheelEventFunc_x(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.x";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // x()const
            int cppResult = const_cast<const ::Qt3DInput::QWheelEvent *>(cppSelf)->x();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QWheelEventFunc_y(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.y";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // y()const
            int cppResult = const_cast<const ::Qt3DInput::QWheelEvent *>(cppSelf)->y();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DInput_QWheelEvent_PropertyStrings[] = {
    "accepted:isAccepted:",
    "angleDelta:",
    "buttons:",
    "modifiers:",
    "x:",
    "y:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DInput_QWheelEvent_methods[] = {
    {"angleDelta", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QWheelEventFunc_angleDelta), METH_NOARGS},
    {"buttons", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QWheelEventFunc_buttons), METH_NOARGS},
    {"isAccepted", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QWheelEventFunc_isAccepted), METH_NOARGS},
    {"modifiers", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QWheelEventFunc_modifiers), METH_NOARGS},
    {"setAccepted", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QWheelEventFunc_setAccepted), METH_O},
    {"type", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QWheelEventFunc_type), METH_NOARGS},
    {"x", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QWheelEventFunc_x), METH_NOARGS},
    {"y", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QWheelEventFunc_y), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DInput_QWheelEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DInput::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QWheelEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DInput_QWheelEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DInput_QWheelEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DInput_QWheelEvent_Type = nullptr;
static SbkObjectType *Sbk_Qt3DInput_QWheelEvent_TypeF(void)
{
    return _Sbk_Qt3DInput_QWheelEvent_Type;
}

static PyType_Slot Sbk_Qt3DInput_QWheelEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DInput_QWheelEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DInput_QWheelEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DInput_QWheelEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DInput_QWheelEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DInput_QWheelEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DInput_QWheelEvent_spec = {
    "2:PySide2.Qt3DInput.Qt3DInput.QWheelEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DInput_QWheelEvent_slots
};

} //extern "C"

static void *Sbk_Qt3DInput_QWheelEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DInput::QWheelEvent *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DInput_QWheelEvent_Buttons_PythonToCpp_Qt3DInput_QWheelEvent_Buttons(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DInput::QWheelEvent::Buttons *>(cppOut) =
        static_cast<::Qt3DInput::QWheelEvent::Buttons>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DInput_QWheelEvent_Buttons_PythonToCpp_Qt3DInput_QWheelEvent_Buttons_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_BUTTONS_IDX]))
        return Qt3DInput_QWheelEvent_Buttons_PythonToCpp_Qt3DInput_QWheelEvent_Buttons;
    return {};
}
static PyObject *Qt3DInput_QWheelEvent_Buttons_CppToPython_Qt3DInput_QWheelEvent_Buttons(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DInput::QWheelEvent::Buttons *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_BUTTONS_IDX], castCppIn);

}

static void Qt3DInput_QWheelEvent_Modifiers_PythonToCpp_Qt3DInput_QWheelEvent_Modifiers(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DInput::QWheelEvent::Modifiers *>(cppOut) =
        static_cast<::Qt3DInput::QWheelEvent::Modifiers>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DInput_QWheelEvent_Modifiers_PythonToCpp_Qt3DInput_QWheelEvent_Modifiers_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_MODIFIERS_IDX]))
        return Qt3DInput_QWheelEvent_Modifiers_PythonToCpp_Qt3DInput_QWheelEvent_Modifiers;
    return {};
}
static PyObject *Qt3DInput_QWheelEvent_Modifiers_CppToPython_Qt3DInput_QWheelEvent_Modifiers(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DInput::QWheelEvent::Modifiers *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_MODIFIERS_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWheelEvent_PythonToCpp_QWheelEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DInput_QWheelEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWheelEvent_PythonToCpp_QWheelEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DInput_QWheelEvent_TypeF())))
        return QWheelEvent_PythonToCpp_QWheelEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWheelEvent_PTR_CppToPython_QWheelEvent(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DInput::QWheelEvent *>(const_cast<void *>(cppIn)), Sbk_Qt3DInput_QWheelEvent_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DInput_QWheelEvent_SignatureStrings[] = {
    "PySide2.Qt3DInput.Qt3DInput.QWheelEvent(self,e:PySide2.QtGui.QWheelEvent)",
    "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.angleDelta(self)->PySide2.QtCore.QPoint",
    "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.buttons(self)->int",
    "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.isAccepted(self)->bool",
    "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.modifiers(self)->PySide2.Qt3DInput.Qt3DInput.QWheelEvent.Modifiers",
    "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.setAccepted(self,accepted:bool)",
    "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.type(self)->PySide2.QtCore.QEvent.Type",
    "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.x(self)->int",
    "PySide2.Qt3DInput.Qt3DInput.QWheelEvent.y(self)->int",
    nullptr}; // Sentinel

void init_Qt3DInput_QWheelEvent(PyObject *enclosingClass)
{
    _Sbk_Qt3DInput_QWheelEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QWheelEvent",
        "Qt3DInput::QWheelEvent*",
        &Sbk_Qt3DInput_QWheelEvent_spec,
        &Shiboken::callCppDestructor< ::Qt3DInput::QWheelEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DInput_QWheelEvent_Type);
    InitSignatureStrings(pyType, Qt3DInput_QWheelEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DInput_QWheelEvent_Type), Sbk_Qt3DInput_QWheelEvent_PropertyStrings);
    SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DInput_QWheelEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DInput_QWheelEvent_TypeF(),
        QWheelEvent_PythonToCpp_QWheelEvent_PTR,
        is_QWheelEvent_PythonToCpp_QWheelEvent_PTR_Convertible,
        QWheelEvent_PTR_CppToPython_QWheelEvent);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DInput::QWheelEvent");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DInput::QWheelEvent*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DInput::QWheelEvent&");
    Shiboken::Conversions::registerConverterName(converter, "QWheelEvent");
    Shiboken::Conversions::registerConverterName(converter, "QWheelEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QWheelEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DInput::QWheelEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWheelEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DInput_QWheelEvent_TypeF(), &Sbk_Qt3DInput_QWheelEvent_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Buttons'.
    SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_BUTTONS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DInput_QWheelEvent_TypeF(),
        "Buttons",
        "2:PySide2.Qt3DInput.Qt3DInput.QWheelEvent.Buttons",
        "Qt3DInput::QWheelEvent::Buttons");
    if (!SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_BUTTONS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_BUTTONS_IDX],
        Sbk_Qt3DInput_QWheelEvent_TypeF(), "LeftButton", (long) Qt3DInput::QWheelEvent::Buttons::LeftButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_BUTTONS_IDX],
        Sbk_Qt3DInput_QWheelEvent_TypeF(), "RightButton", (long) Qt3DInput::QWheelEvent::Buttons::RightButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_BUTTONS_IDX],
        Sbk_Qt3DInput_QWheelEvent_TypeF(), "MiddleButton", (long) Qt3DInput::QWheelEvent::Buttons::MiddleButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_BUTTONS_IDX],
        Sbk_Qt3DInput_QWheelEvent_TypeF(), "BackButton", (long) Qt3DInput::QWheelEvent::Buttons::BackButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_BUTTONS_IDX],
        Sbk_Qt3DInput_QWheelEvent_TypeF(), "NoButton", (long) Qt3DInput::QWheelEvent::Buttons::NoButton))
        return;
    // Register converter for enum 'Qt3DInput::QWheelEvent::Buttons'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_BUTTONS_IDX],
            Qt3DInput_QWheelEvent_Buttons_CppToPython_Qt3DInput_QWheelEvent_Buttons);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DInput_QWheelEvent_Buttons_PythonToCpp_Qt3DInput_QWheelEvent_Buttons,
            is_Qt3DInput_QWheelEvent_Buttons_PythonToCpp_Qt3DInput_QWheelEvent_Buttons_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_BUTTONS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DInput::QWheelEvent::Buttons");
        Shiboken::Conversions::registerConverterName(converter, "QWheelEvent::Buttons");
        Shiboken::Conversions::registerConverterName(converter, "Buttons");
    }
    // End of 'Buttons' enum.

    // Initialization of enum 'Modifiers'.
    SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_MODIFIERS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DInput_QWheelEvent_TypeF(),
        "Modifiers",
        "2:PySide2.Qt3DInput.Qt3DInput.QWheelEvent.Modifiers",
        "Qt3DInput::QWheelEvent::Modifiers");
    if (!SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_MODIFIERS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_MODIFIERS_IDX],
        Sbk_Qt3DInput_QWheelEvent_TypeF(), "NoModifier", (long) Qt3DInput::QWheelEvent::Modifiers::NoModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_MODIFIERS_IDX],
        Sbk_Qt3DInput_QWheelEvent_TypeF(), "ShiftModifier", (long) Qt3DInput::QWheelEvent::Modifiers::ShiftModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_MODIFIERS_IDX],
        Sbk_Qt3DInput_QWheelEvent_TypeF(), "ControlModifier", (long) Qt3DInput::QWheelEvent::Modifiers::ControlModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_MODIFIERS_IDX],
        Sbk_Qt3DInput_QWheelEvent_TypeF(), "AltModifier", (long) Qt3DInput::QWheelEvent::Modifiers::AltModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_MODIFIERS_IDX],
        Sbk_Qt3DInput_QWheelEvent_TypeF(), "MetaModifier", (long) Qt3DInput::QWheelEvent::Modifiers::MetaModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_MODIFIERS_IDX],
        Sbk_Qt3DInput_QWheelEvent_TypeF(), "KeypadModifier", (long) Qt3DInput::QWheelEvent::Modifiers::KeypadModifier))
        return;
    // Register converter for enum 'Qt3DInput::QWheelEvent::Modifiers'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_MODIFIERS_IDX],
            Qt3DInput_QWheelEvent_Modifiers_CppToPython_Qt3DInput_QWheelEvent_Modifiers);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DInput_QWheelEvent_Modifiers_PythonToCpp_Qt3DInput_QWheelEvent_Modifiers,
            is_Qt3DInput_QWheelEvent_Modifiers_PythonToCpp_Qt3DInput_QWheelEvent_Modifiers_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QWHEELEVENT_MODIFIERS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DInput::QWheelEvent::Modifiers");
        Shiboken::Conversions::registerConverterName(converter, "QWheelEvent::Modifiers");
        Shiboken::Conversions::registerConverterName(converter, "Modifiers");
    }
    // End of 'Modifiers' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DInput_QWheelEvent_TypeF(), &::Qt3DInput::QWheelEvent::staticMetaObject);
    qRegisterMetaType< ::Qt3DInput::QWheelEvent::Buttons >("QWheelEvent::Buttons");
    qRegisterMetaType< ::Qt3DInput::QWheelEvent::Buttons >("Qt3DInput::QWheelEvent::Buttons");
    qRegisterMetaType< ::Qt3DInput::QWheelEvent::Modifiers >("QWheelEvent::Modifiers");
    qRegisterMetaType< ::Qt3DInput::QWheelEvent::Modifiers >("Qt3DInput::QWheelEvent::Modifiers");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DInput_QWheelEvent_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DInput_QWheelEvent_TypeF(), &::Qt3DInput::QWheelEvent::staticMetaObject, sizeof(QWheelEventWrapper));
}
