/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qabstractraycaster_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstractRayCasterWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAbstractRayCasterWrapper::QAbstractRayCasterWrapper(::Qt3DCore::QNode * parent) : Qt3DRender::QAbstractRayCaster(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QAbstractRayCasterWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractRayCasterWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractRayCasterWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractRayCasterWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAbstractRayCasterWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractRayCaster.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAbstractRayCasterWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractRayCaster.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAbstractRayCasterWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QAbstractRayCasterWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DRender::QAbstractRayCaster::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAbstractRayCasterWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DRender::QAbstractRayCaster::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAbstractRayCasterWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAbstractRayCasterWrapper *>(this));
        return Qt3DRender::QAbstractRayCaster::qt_metacast(_clname);
}

QAbstractRayCasterWrapper::~QAbstractRayCasterWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QAbstractRayCaster_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QAbstractRayCaster >()))
        return -1;

    ::QAbstractRayCasterWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QAbstractRayCaster", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QAbstractRayCaster::QAbstractRayCaster(Qt3DCore::QNode*)
    if (numArgs == 0) {
        overloadId = 0; // QAbstractRayCaster(Qt3DCore::QNode*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QAbstractRayCaster(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractRayCaster_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DRender_QAbstractRayCaster_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0]))))
                        goto Sbk_Qt3DRender_QAbstractRayCaster_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::Qt3DCore::QNode *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QAbstractRayCaster(Qt3DCore::QNode*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QAbstractRayCasterWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QAbstractRayCasterWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QAbstractRayCaster >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DRender_QAbstractRayCaster_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DRender_QAbstractRayCaster_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DRender_QAbstractRayCaster_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DRender_QAbstractRayCasterFunc_addLayer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractRayCaster *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.addLayer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractRayCaster::addLayer(Qt3DRender::QLayer*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QLAYER_IDX]), (pyArg)))) {
        overloadId = 0; // addLayer(Qt3DRender::QLayer*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractRayCasterFunc_addLayer_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DRender::QLayer *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addLayer(Qt3DRender::QLayer*)
            cppSelf->addLayer(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractRayCasterFunc_addLayer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractRayCasterFunc_filterMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractRayCaster *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.filterMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // filterMode()const
            Qt3DRender::QAbstractRayCaster::FilterMode cppResult = const_cast<const ::Qt3DRender::QAbstractRayCaster *>(cppSelf)->filterMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_FILTERMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractRayCasterFunc_hits(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractRayCaster *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.hits";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hits()const
            QVector<Qt3DRender::QRayCasterHit > cppResult = const_cast<const ::Qt3DRender::QAbstractRayCaster *>(cppSelf)->hits();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QRAYCASTERHIT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractRayCasterFunc_layers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractRayCaster *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.layers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // layers()const
            QVector<Qt3DRender::QLayer* > cppResult = const_cast<const ::Qt3DRender::QAbstractRayCaster *>(cppSelf)->layers();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QLAYERPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractRayCasterFunc_removeLayer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractRayCaster *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.removeLayer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractRayCaster::removeLayer(Qt3DRender::QLayer*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QLAYER_IDX]), (pyArg)))) {
        overloadId = 0; // removeLayer(Qt3DRender::QLayer*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractRayCasterFunc_removeLayer_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DRender::QLayer *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeLayer(Qt3DRender::QLayer*)
            cppSelf->removeLayer(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractRayCasterFunc_removeLayer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractRayCasterFunc_runMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractRayCaster *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.runMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // runMode()const
            Qt3DRender::QAbstractRayCaster::RunMode cppResult = const_cast<const ::Qt3DRender::QAbstractRayCaster *>(cppSelf)->runMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_RUNMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractRayCasterFunc_setFilterMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractRayCaster *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.setFilterMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractRayCaster::setFilterMode(Qt3DRender::QAbstractRayCaster::FilterMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_FILTERMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFilterMode(Qt3DRender::QAbstractRayCaster::FilterMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractRayCasterFunc_setFilterMode_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAbstractRayCaster::FilterMode cppArg0{Qt3DRender::QAbstractRayCaster::AcceptAnyMatchingLayers};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFilterMode(Qt3DRender::QAbstractRayCaster::FilterMode)
            cppSelf->setFilterMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractRayCasterFunc_setFilterMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractRayCasterFunc_setRunMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractRayCaster *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.setRunMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractRayCaster::setRunMode(Qt3DRender::QAbstractRayCaster::RunMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_RUNMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setRunMode(Qt3DRender::QAbstractRayCaster::RunMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractRayCasterFunc_setRunMode_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAbstractRayCaster::RunMode cppArg0{Qt3DRender::QAbstractRayCaster::Continuous};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRunMode(Qt3DRender::QAbstractRayCaster::RunMode)
            cppSelf->setRunMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractRayCasterFunc_setRunMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_Qt3DRender_QAbstractRayCaster_PropertyStrings[] = {
    "filterMode::",
    "runMode::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QAbstractRayCaster_methods[] = {
    {"addLayer", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractRayCasterFunc_addLayer), METH_O},
    {"filterMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractRayCasterFunc_filterMode), METH_NOARGS},
    {"hits", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractRayCasterFunc_hits), METH_NOARGS},
    {"layers", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractRayCasterFunc_layers), METH_NOARGS},
    {"removeLayer", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractRayCasterFunc_removeLayer), METH_O},
    {"runMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractRayCasterFunc_runMode), METH_NOARGS},
    {"setFilterMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractRayCasterFunc_setFilterMode), METH_O},
    {"setRunMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractRayCasterFunc_setRunMode), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DRender_QAbstractRayCaster_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DRender::QAbstractRayCaster *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstractRayCasterWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DRender_QAbstractRayCaster_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QAbstractRayCaster_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QAbstractRayCaster_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QAbstractRayCaster_TypeF(void)
{
    return _Sbk_Qt3DRender_QAbstractRayCaster_Type;
}

static PyType_Slot Sbk_Qt3DRender_QAbstractRayCaster_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DRender_QAbstractRayCaster_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QAbstractRayCaster_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QAbstractRayCaster_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QAbstractRayCaster_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QAbstractRayCaster_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QAbstractRayCaster_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QAbstractRayCaster_slots
};

} //extern "C"

static void *Sbk_Qt3DRender_QAbstractRayCaster_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DRender::QAbstractRayCaster *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_QAbstractRayCaster_RunMode_PythonToCpp_Qt3DRender_QAbstractRayCaster_RunMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QAbstractRayCaster::RunMode *>(cppOut) =
        static_cast<::Qt3DRender::QAbstractRayCaster::RunMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QAbstractRayCaster_RunMode_PythonToCpp_Qt3DRender_QAbstractRayCaster_RunMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_RUNMODE_IDX]))
        return Qt3DRender_QAbstractRayCaster_RunMode_PythonToCpp_Qt3DRender_QAbstractRayCaster_RunMode;
    return {};
}
static PyObject *Qt3DRender_QAbstractRayCaster_RunMode_CppToPython_Qt3DRender_QAbstractRayCaster_RunMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QAbstractRayCaster::RunMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_RUNMODE_IDX], castCppIn);

}

static void Qt3DRender_QAbstractRayCaster_FilterMode_PythonToCpp_Qt3DRender_QAbstractRayCaster_FilterMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QAbstractRayCaster::FilterMode *>(cppOut) =
        static_cast<::Qt3DRender::QAbstractRayCaster::FilterMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QAbstractRayCaster_FilterMode_PythonToCpp_Qt3DRender_QAbstractRayCaster_FilterMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_FILTERMODE_IDX]))
        return Qt3DRender_QAbstractRayCaster_FilterMode_PythonToCpp_Qt3DRender_QAbstractRayCaster_FilterMode;
    return {};
}
static PyObject *Qt3DRender_QAbstractRayCaster_FilterMode_CppToPython_Qt3DRender_QAbstractRayCaster_FilterMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QAbstractRayCaster::FilterMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_FILTERMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstractRayCaster_PythonToCpp_QAbstractRayCaster_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QAbstractRayCaster_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstractRayCaster_PythonToCpp_QAbstractRayCaster_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QAbstractRayCaster_TypeF())))
        return QAbstractRayCaster_PythonToCpp_QAbstractRayCaster_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstractRayCaster_PTR_CppToPython_QAbstractRayCaster(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DRender::QAbstractRayCaster *>(const_cast<void *>(cppIn)), Sbk_Qt3DRender_QAbstractRayCaster_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QAbstractRayCaster_SignatureStrings[] = {
    "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.addLayer(self,layer:PySide2.Qt3DRender.Qt3DRender.QLayer)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.filterMode(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.FilterMode",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.hits(self)->QVector[PySide2.Qt3DRender.Qt3DRender.QRayCasterHit]",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.layers(self)->QVector[PySide2.Qt3DRender.Qt3DRender.QLayer]",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.removeLayer(self,layer:PySide2.Qt3DRender.Qt3DRender.QLayer)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.runMode(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.RunMode",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.setFilterMode(self,filterMode:PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.FilterMode)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.setRunMode(self,runMode:PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.RunMode)",
    nullptr}; // Sentinel

void init_Qt3DRender_QAbstractRayCaster(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QAbstractRayCaster_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QAbstractRayCaster",
        "Qt3DRender::QAbstractRayCaster*",
        &Sbk_Qt3DRender_QAbstractRayCaster_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QAbstractRayCaster >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QAbstractRayCaster_Type);
    InitSignatureStrings(pyType, Qt3DRender_QAbstractRayCaster_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QAbstractRayCaster_Type), Sbk_Qt3DRender_QAbstractRayCaster_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QAbstractRayCaster_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QAbstractRayCaster_TypeF(),
        QAbstractRayCaster_PythonToCpp_QAbstractRayCaster_PTR,
        is_QAbstractRayCaster_PythonToCpp_QAbstractRayCaster_PTR_Convertible,
        QAbstractRayCaster_PTR_CppToPython_QAbstractRayCaster);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractRayCaster");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractRayCaster*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractRayCaster&");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractRayCaster");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractRayCaster*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractRayCaster&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QAbstractRayCaster).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractRayCasterWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DRender_QAbstractRayCaster_TypeF(), &Sbk_Qt3DRender_QAbstractRayCaster_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'RunMode'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_RUNMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QAbstractRayCaster_TypeF(),
        "RunMode",
        "2:PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.RunMode",
        "Qt3DRender::QAbstractRayCaster::RunMode");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_RUNMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_RUNMODE_IDX],
        Sbk_Qt3DRender_QAbstractRayCaster_TypeF(), "Continuous", (long) Qt3DRender::QAbstractRayCaster::RunMode::Continuous))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_RUNMODE_IDX],
        Sbk_Qt3DRender_QAbstractRayCaster_TypeF(), "SingleShot", (long) Qt3DRender::QAbstractRayCaster::RunMode::SingleShot))
        return;
    // Register converter for enum 'Qt3DRender::QAbstractRayCaster::RunMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_RUNMODE_IDX],
            Qt3DRender_QAbstractRayCaster_RunMode_CppToPython_Qt3DRender_QAbstractRayCaster_RunMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QAbstractRayCaster_RunMode_PythonToCpp_Qt3DRender_QAbstractRayCaster_RunMode,
            is_Qt3DRender_QAbstractRayCaster_RunMode_PythonToCpp_Qt3DRender_QAbstractRayCaster_RunMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_RUNMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractRayCaster::RunMode");
        Shiboken::Conversions::registerConverterName(converter, "QAbstractRayCaster::RunMode");
        Shiboken::Conversions::registerConverterName(converter, "RunMode");
    }
    // End of 'RunMode' enum.

    // Initialization of enum 'FilterMode'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_FILTERMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QAbstractRayCaster_TypeF(),
        "FilterMode",
        "2:PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.FilterMode",
        "Qt3DRender::QAbstractRayCaster::FilterMode");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_FILTERMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_FILTERMODE_IDX],
        Sbk_Qt3DRender_QAbstractRayCaster_TypeF(), "AcceptAnyMatchingLayers", (long) Qt3DRender::QAbstractRayCaster::FilterMode::AcceptAnyMatchingLayers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_FILTERMODE_IDX],
        Sbk_Qt3DRender_QAbstractRayCaster_TypeF(), "AcceptAllMatchingLayers", (long) Qt3DRender::QAbstractRayCaster::FilterMode::AcceptAllMatchingLayers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_FILTERMODE_IDX],
        Sbk_Qt3DRender_QAbstractRayCaster_TypeF(), "DiscardAnyMatchingLayers", (long) Qt3DRender::QAbstractRayCaster::FilterMode::DiscardAnyMatchingLayers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_FILTERMODE_IDX],
        Sbk_Qt3DRender_QAbstractRayCaster_TypeF(), "DiscardAllMatchingLayers", (long) Qt3DRender::QAbstractRayCaster::FilterMode::DiscardAllMatchingLayers))
        return;
    // Register converter for enum 'Qt3DRender::QAbstractRayCaster::FilterMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_FILTERMODE_IDX],
            Qt3DRender_QAbstractRayCaster_FilterMode_CppToPython_Qt3DRender_QAbstractRayCaster_FilterMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QAbstractRayCaster_FilterMode_PythonToCpp_Qt3DRender_QAbstractRayCaster_FilterMode,
            is_Qt3DRender_QAbstractRayCaster_FilterMode_PythonToCpp_Qt3DRender_QAbstractRayCaster_FilterMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTRAYCASTER_FILTERMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractRayCaster::FilterMode");
        Shiboken::Conversions::registerConverterName(converter, "QAbstractRayCaster::FilterMode");
        Shiboken::Conversions::registerConverterName(converter, "FilterMode");
    }
    // End of 'FilterMode' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DRender_QAbstractRayCaster_TypeF(), &::Qt3DRender::QAbstractRayCaster::staticMetaObject);
    qRegisterMetaType< ::Qt3DRender::QAbstractRayCaster::RunMode >("QAbstractRayCaster::RunMode");
    qRegisterMetaType< ::Qt3DRender::QAbstractRayCaster::RunMode >("Qt3DRender::QAbstractRayCaster::RunMode");
    qRegisterMetaType< ::Qt3DRender::QAbstractRayCaster::FilterMode >("QAbstractRayCaster::FilterMode");
    qRegisterMetaType< ::Qt3DRender::QAbstractRayCaster::FilterMode >("Qt3DRender::QAbstractRayCaster::FilterMode");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DRender_QAbstractRayCaster_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DRender_QAbstractRayCaster_TypeF(), &::Qt3DRender::QAbstractRayCaster::staticMetaObject, sizeof(QAbstractRayCasterWrapper));
}
