/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qattribute_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAttributeWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAttributeWrapper::QAttributeWrapper(::Qt3DCore::QNode * parent) : Qt3DRender::QAttribute(parent)
{
    resetPyMethodCache();
    // ... middle
}

QAttributeWrapper::QAttributeWrapper(::Qt3DRender::QBuffer * buf, ::Qt3DRender::QAttribute::VertexBaseType vertexBaseType, uint vertexSize, uint count, uint offset, uint stride, ::Qt3DCore::QNode * parent) : Qt3DRender::QAttribute(buf, vertexBaseType, vertexSize, count, offset, stride, parent)
{
    resetPyMethodCache();
    // ... middle
}

QAttributeWrapper::QAttributeWrapper(::Qt3DRender::QBuffer * buf, const ::QString & name, ::Qt3DRender::QAttribute::VertexBaseType vertexBaseType, uint vertexSize, uint count, uint offset, uint stride, ::Qt3DCore::QNode * parent) : Qt3DRender::QAttribute(buf, name, vertexBaseType, vertexSize, count, offset, stride, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QAttributeWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAttributeWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAttributeWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAttributeWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAttributeWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAttribute.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAttributeWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAttribute.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAttributeWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QAttributeWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DRender::QAttribute::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAttributeWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DRender::QAttribute::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAttributeWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAttributeWrapper *>(this));
        return Qt3DRender::QAttribute::qt_metacast(_clname);
}

QAttributeWrapper::~QAttributeWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QAttribute_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QAttribute >()))
        return -1;

    ::QAttributeWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_Qt3DRender_QAttribute_Init_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOOOO:QAttribute", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return -1;


    // Overloaded function decisor
    // 0: QAttribute::QAttribute(Qt3DCore::QNode*)
    // 1: QAttribute::QAttribute(Qt3DRender::QBuffer*,Qt3DRender::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)
    // 2: QAttribute::QAttribute(Qt3DRender::QBuffer*,QString,Qt3DRender::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)
    if (numArgs == 0) {
        overloadId = 0; // QAttribute(Qt3DCore::QNode*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX]), (pyArgs[0])))) {
        if (numArgs >= 5
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX])->converter, (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[4])))) {
            if (numArgs == 5) {
                overloadId = 2; // QAttribute(Qt3DRender::QBuffer*,QString,Qt3DRender::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)
            } else if (numArgs >= 6
                && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[5])))) {
                if (numArgs == 6) {
                    overloadId = 2; // QAttribute(Qt3DRender::QBuffer*,QString,Qt3DRender::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)
                } else if (numArgs >= 7
                    && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[6])))) {
                    if (numArgs == 7) {
                        overloadId = 2; // QAttribute(Qt3DRender::QBuffer*,QString,Qt3DRender::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)
                    } else if (numArgs >= 8
                        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[7])))) {
                        overloadId = 2; // QAttribute(Qt3DRender::QBuffer*,QString,Qt3DRender::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)
                    }
                }
            }
        } else if (numArgs >= 4
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX])->converter, (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 1; // QAttribute(Qt3DRender::QBuffer*,Qt3DRender::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 1; // QAttribute(Qt3DRender::QBuffer*,Qt3DRender::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[5])))) {
                    if (numArgs == 6) {
                        overloadId = 1; // QAttribute(Qt3DRender::QBuffer*,Qt3DRender::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)
                    } else if (numArgs >= 7
                        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[6])))) {
                        overloadId = 1; // QAttribute(Qt3DRender::QBuffer*,Qt3DRender::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)
                    }
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QAttribute(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAttribute_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QAttribute(Qt3DCore::QNode * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DRender_QAttribute_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0]))))
                            goto Sbk_Qt3DRender_QAttribute_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Qt3DCore::QNode *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QAttribute(Qt3DCore::QNode*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QAttributeWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QAttributeWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QAttribute(Qt3DRender::QBuffer * buf, Qt3DRender::QAttribute::VertexBaseType vertexBaseType, uint vertexSize, uint count, uint offset, uint stride, Qt3DCore::QNode * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_offset = Shiboken::String::createStaticString("offset");
                if (PyDict_Contains(kwds, key_offset)) {
                    value = PyDict_GetItem(kwds, key_offset);
                    if (value && pyArgs[4]) {
                        errInfo = key_offset;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DRender_QAttribute_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[4]))))
                            goto Sbk_Qt3DRender_QAttribute_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_offset);
                }
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[5]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DRender_QAttribute_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[5]))))
                            goto Sbk_Qt3DRender_QAttribute_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[6]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DRender_QAttribute_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[6]))))
                            goto Sbk_Qt3DRender_QAttribute_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Qt3DRender::QBuffer *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt3DRender::QAttribute::VertexBaseType cppArg1{Qt3DRender::QAttribute::Byte};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            uint cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            uint cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            uint cppArg4 = 0;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            uint cppArg5 = 0;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return -1;
            ::Qt3DCore::QNode *cppArg6 = nullptr;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

            if (!PyErr_Occurred()) {
                // QAttribute(Qt3DRender::QBuffer*,Qt3DRender::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QAttributeWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QAttributeWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
                }

                Shiboken::Object::setParent(pyArgs[6], self);
            }
            break;
        }
        case 2: // QAttribute(Qt3DRender::QBuffer * buf, const QString & name, Qt3DRender::QAttribute::VertexBaseType vertexBaseType, uint vertexSize, uint count, uint offset, uint stride, Qt3DCore::QNode * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_offset = Shiboken::String::createStaticString("offset");
                if (PyDict_Contains(kwds, key_offset)) {
                    value = PyDict_GetItem(kwds, key_offset);
                    if (value && pyArgs[5]) {
                        errInfo = key_offset;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DRender_QAttribute_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[5]))))
                            goto Sbk_Qt3DRender_QAttribute_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_offset);
                }
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[6]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DRender_QAttribute_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[6]))))
                            goto Sbk_Qt3DRender_QAttribute_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[7]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DRender_QAttribute_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[7]))))
                            goto Sbk_Qt3DRender_QAttribute_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Qt3DRender::QBuffer *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt3DRender::QAttribute::VertexBaseType cppArg2{Qt3DRender::QAttribute::Byte};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            uint cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            uint cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            uint cppArg5 = 0;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
            uint cppArg6 = 0;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);
            if (!Shiboken::Object::isValid(pyArgs[7]))
                return -1;
            ::Qt3DCore::QNode *cppArg7 = nullptr;
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);

            if (!PyErr_Occurred()) {
                // QAttribute(Qt3DRender::QBuffer*,QString,Qt3DRender::QAttribute::VertexBaseType,uint,uint,uint,uint,Qt3DCore::QNode*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QAttributeWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QAttributeWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
                }

                Shiboken::Object::setParent(pyArgs[7], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QAttribute >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DRender_QAttribute_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DRender_QAttribute_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DRender_QAttribute_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_attributeType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.attributeType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // attributeType()const
            Qt3DRender::QAttribute::AttributeType cppResult = const_cast<const ::Qt3DRender::QAttribute *>(cppSelf)->attributeType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_ATTRIBUTETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_buffer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.buffer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // buffer()const
            Qt3DRender::QBuffer * cppResult = const_cast<const ::Qt3DRender::QAttribute *>(cppSelf)->buffer();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_byteOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.byteOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // byteOffset()const
            uint cppResult = const_cast<const ::Qt3DRender::QAttribute *>(cppSelf)->byteOffset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_byteStride(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.byteStride";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // byteStride()const
            uint cppResult = const_cast<const ::Qt3DRender::QAttribute *>(cppSelf)->byteStride();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.count";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // count()const
            uint cppResult = const_cast<const ::Qt3DRender::QAttribute *>(cppSelf)->count();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_defaultColorAttributeName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultColorAttributeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultColorAttributeName()
            QString cppResult = ::Qt3DRender::QAttribute::defaultColorAttributeName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_defaultJointIndicesAttributeName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultJointIndicesAttributeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultJointIndicesAttributeName()
            QString cppResult = ::Qt3DRender::QAttribute::defaultJointIndicesAttributeName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_defaultJointWeightsAttributeName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultJointWeightsAttributeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultJointWeightsAttributeName()
            QString cppResult = ::Qt3DRender::QAttribute::defaultJointWeightsAttributeName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_defaultNormalAttributeName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultNormalAttributeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultNormalAttributeName()
            QString cppResult = ::Qt3DRender::QAttribute::defaultNormalAttributeName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_defaultPositionAttributeName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultPositionAttributeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultPositionAttributeName()
            QString cppResult = ::Qt3DRender::QAttribute::defaultPositionAttributeName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_defaultTangentAttributeName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultTangentAttributeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultTangentAttributeName()
            QString cppResult = ::Qt3DRender::QAttribute::defaultTangentAttributeName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_defaultTextureCoordinate1AttributeName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultTextureCoordinate1AttributeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultTextureCoordinate1AttributeName()
            QString cppResult = ::Qt3DRender::QAttribute::defaultTextureCoordinate1AttributeName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_defaultTextureCoordinate2AttributeName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultTextureCoordinate2AttributeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultTextureCoordinate2AttributeName()
            QString cppResult = ::Qt3DRender::QAttribute::defaultTextureCoordinate2AttributeName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_defaultTextureCoordinateAttributeName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultTextureCoordinateAttributeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultTextureCoordinateAttributeName()
            QString cppResult = ::Qt3DRender::QAttribute::defaultTextureCoordinateAttributeName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_divisor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.divisor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // divisor()const
            uint cppResult = const_cast<const ::Qt3DRender::QAttribute *>(cppSelf)->divisor();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::Qt3DRender::QAttribute *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_setAttributeType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.setAttributeType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAttribute::setAttributeType(Qt3DRender::QAttribute::AttributeType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_ATTRIBUTETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAttributeType(Qt3DRender::QAttribute::AttributeType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAttributeFunc_setAttributeType_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAttribute::AttributeType cppArg0{Qt3DRender::QAttribute::VertexAttribute};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAttributeType(Qt3DRender::QAttribute::AttributeType)
            cppSelf->setAttributeType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAttributeFunc_setAttributeType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_setBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.setBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAttribute::setBuffer(Qt3DRender::QBuffer*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBUFFER_IDX]), (pyArg)))) {
        overloadId = 0; // setBuffer(Qt3DRender::QBuffer*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAttributeFunc_setBuffer_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DRender::QBuffer *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBuffer(Qt3DRender::QBuffer*)
            cppSelf->setBuffer(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAttributeFunc_setBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_setByteOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.setByteOffset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAttribute::setByteOffset(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // setByteOffset(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAttributeFunc_setByteOffset_TypeError;

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setByteOffset(uint)
            cppSelf->setByteOffset(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAttributeFunc_setByteOffset_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_setByteStride(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.setByteStride";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAttribute::setByteStride(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // setByteStride(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAttributeFunc_setByteStride_TypeError;

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setByteStride(uint)
            cppSelf->setByteStride(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAttributeFunc_setByteStride_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_setCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.setCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAttribute::setCount(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // setCount(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAttributeFunc_setCount_TypeError;

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCount(uint)
            cppSelf->setCount(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAttributeFunc_setCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_setDataSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.setDataSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAttribute::setDataSize(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // setDataSize(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAttributeFunc_setDataSize_TypeError;

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDataSize(uint)
            cppSelf->setDataSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAttributeFunc_setDataSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_setDataType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.setDataType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAttribute::setDataType(Qt3DRender::QAttribute::VertexBaseType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDataType(Qt3DRender::QAttribute::VertexBaseType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAttributeFunc_setDataType_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAttribute::VertexBaseType cppArg0{Qt3DRender::QAttribute::Byte};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDataType(Qt3DRender::QAttribute::VertexBaseType)
            cppSelf->setDataType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAttributeFunc_setDataType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_setDivisor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.setDivisor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAttribute::setDivisor(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // setDivisor(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAttributeFunc_setDivisor_TypeError;

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDivisor(uint)
            cppSelf->setDivisor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAttributeFunc_setDivisor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_setName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.setName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAttribute::setName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAttributeFunc_setName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setName(QString)
            cppSelf->setName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAttributeFunc_setName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_setVertexBaseType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.setVertexBaseType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAttribute::setVertexBaseType(Qt3DRender::QAttribute::VertexBaseType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setVertexBaseType(Qt3DRender::QAttribute::VertexBaseType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAttributeFunc_setVertexBaseType_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAttribute::VertexBaseType cppArg0{Qt3DRender::QAttribute::Byte};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVertexBaseType(Qt3DRender::QAttribute::VertexBaseType)
            cppSelf->setVertexBaseType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAttributeFunc_setVertexBaseType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_setVertexSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.setVertexSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAttribute::setVertexSize(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // setVertexSize(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAttributeFunc_setVertexSize_TypeError;

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVertexSize(uint)
            cppSelf->setVertexSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAttributeFunc_setVertexSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_vertexBaseType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.vertexBaseType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // vertexBaseType()const
            Qt3DRender::QAttribute::VertexBaseType cppResult = const_cast<const ::Qt3DRender::QAttribute *>(cppSelf)->vertexBaseType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAttributeFunc_vertexSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAttribute.vertexSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // vertexSize()const
            uint cppResult = const_cast<const ::Qt3DRender::QAttribute *>(cppSelf)->vertexSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QAttribute_PropertyStrings[] = {
    "attributeType::",
    "buffer::",
    "byteOffset::",
    "byteStride::",
    "count::",
    "defaultColorAttributeName:",
    "defaultJointIndicesAttributeName:",
    "defaultJointWeightsAttributeName:",
    "defaultNormalAttributeName:",
    "defaultPositionAttributeName:",
    "defaultTangentAttributeName:",
    "defaultTextureCoordinate1AttributeName:",
    "defaultTextureCoordinate2AttributeName:",
    "defaultTextureCoordinateAttributeName:",
    "divisor::",
    "name::",
    "vertexBaseType::",
    "vertexSize::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QAttribute_methods[] = {
    {"attributeType", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_attributeType), METH_NOARGS},
    {"buffer", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_buffer), METH_NOARGS},
    {"byteOffset", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_byteOffset), METH_NOARGS},
    {"byteStride", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_byteStride), METH_NOARGS},
    {"count", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_count), METH_NOARGS},
    {"defaultColorAttributeName", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_defaultColorAttributeName), METH_NOARGS|METH_STATIC},
    {"defaultJointIndicesAttributeName", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_defaultJointIndicesAttributeName), METH_NOARGS|METH_STATIC},
    {"defaultJointWeightsAttributeName", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_defaultJointWeightsAttributeName), METH_NOARGS|METH_STATIC},
    {"defaultNormalAttributeName", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_defaultNormalAttributeName), METH_NOARGS|METH_STATIC},
    {"defaultPositionAttributeName", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_defaultPositionAttributeName), METH_NOARGS|METH_STATIC},
    {"defaultTangentAttributeName", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_defaultTangentAttributeName), METH_NOARGS|METH_STATIC},
    {"defaultTextureCoordinate1AttributeName", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_defaultTextureCoordinate1AttributeName), METH_NOARGS|METH_STATIC},
    {"defaultTextureCoordinate2AttributeName", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_defaultTextureCoordinate2AttributeName), METH_NOARGS|METH_STATIC},
    {"defaultTextureCoordinateAttributeName", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_defaultTextureCoordinateAttributeName), METH_NOARGS|METH_STATIC},
    {"divisor", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_divisor), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_name), METH_NOARGS},
    {"setAttributeType", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_setAttributeType), METH_O},
    {"setBuffer", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_setBuffer), METH_O},
    {"setByteOffset", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_setByteOffset), METH_O},
    {"setByteStride", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_setByteStride), METH_O},
    {"setCount", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_setCount), METH_O},
    {"setDataSize", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_setDataSize), METH_O},
    {"setDataType", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_setDataType), METH_O},
    {"setDivisor", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_setDivisor), METH_O},
    {"setName", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_setName), METH_O},
    {"setVertexBaseType", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_setVertexBaseType), METH_O},
    {"setVertexSize", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_setVertexSize), METH_O},
    {"vertexBaseType", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_vertexBaseType), METH_NOARGS},
    {"vertexSize", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAttributeFunc_vertexSize), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DRender_QAttribute_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DRender::QAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAttributeWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DRender_QAttribute_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QAttribute_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QAttribute_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QAttribute_TypeF(void)
{
    return _Sbk_Qt3DRender_QAttribute_Type;
}

static PyType_Slot Sbk_Qt3DRender_QAttribute_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DRender_QAttribute_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QAttribute_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QAttribute_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QAttribute_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QAttribute_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QAttribute_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QAttribute",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QAttribute_slots
};

} //extern "C"

static void *Sbk_Qt3DRender_QAttribute_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DRender::QAttribute *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_QAttribute_AttributeType_PythonToCpp_Qt3DRender_QAttribute_AttributeType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QAttribute::AttributeType *>(cppOut) =
        static_cast<::Qt3DRender::QAttribute::AttributeType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QAttribute_AttributeType_PythonToCpp_Qt3DRender_QAttribute_AttributeType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_ATTRIBUTETYPE_IDX]))
        return Qt3DRender_QAttribute_AttributeType_PythonToCpp_Qt3DRender_QAttribute_AttributeType;
    return {};
}
static PyObject *Qt3DRender_QAttribute_AttributeType_CppToPython_Qt3DRender_QAttribute_AttributeType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QAttribute::AttributeType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_ATTRIBUTETYPE_IDX], castCppIn);

}

static void Qt3DRender_QAttribute_VertexBaseType_PythonToCpp_Qt3DRender_QAttribute_VertexBaseType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QAttribute::VertexBaseType *>(cppOut) =
        static_cast<::Qt3DRender::QAttribute::VertexBaseType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QAttribute_VertexBaseType_PythonToCpp_Qt3DRender_QAttribute_VertexBaseType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX]))
        return Qt3DRender_QAttribute_VertexBaseType_PythonToCpp_Qt3DRender_QAttribute_VertexBaseType;
    return {};
}
static PyObject *Qt3DRender_QAttribute_VertexBaseType_CppToPython_Qt3DRender_QAttribute_VertexBaseType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QAttribute::VertexBaseType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAttribute_PythonToCpp_QAttribute_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QAttribute_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAttribute_PythonToCpp_QAttribute_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QAttribute_TypeF())))
        return QAttribute_PythonToCpp_QAttribute_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAttribute_PTR_CppToPython_QAttribute(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DRender::QAttribute *>(const_cast<void *>(cppIn)), Sbk_Qt3DRender_QAttribute_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QAttribute_SignatureStrings[] = {
    "2:PySide2.Qt3DRender.Qt3DRender.QAttribute(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "1:PySide2.Qt3DRender.Qt3DRender.QAttribute(self,buf:PySide2.Qt3DRender.Qt3DRender.QBuffer,vertexBaseType:PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType,vertexSize:uint,count:uint,offset:uint=0,stride:uint=0,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "0:PySide2.Qt3DRender.Qt3DRender.QAttribute(self,buf:PySide2.Qt3DRender.Qt3DRender.QBuffer,name:QString,vertexBaseType:PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType,vertexSize:uint,count:uint,offset:uint=0,stride:uint=0,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.attributeType(self)->PySide2.Qt3DRender.Qt3DRender.QAttribute.AttributeType",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.buffer(self)->PySide2.Qt3DRender.Qt3DRender.QBuffer",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.byteOffset(self)->uint",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.byteStride(self)->uint",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.count(self)->uint",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultColorAttributeName()->QString",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultJointIndicesAttributeName()->QString",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultJointWeightsAttributeName()->QString",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultNormalAttributeName()->QString",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultPositionAttributeName()->QString",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultTangentAttributeName()->QString",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultTextureCoordinate1AttributeName()->QString",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultTextureCoordinate2AttributeName()->QString",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.defaultTextureCoordinateAttributeName()->QString",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.divisor(self)->uint",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.name(self)->QString",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.setAttributeType(self,attributeType:PySide2.Qt3DRender.Qt3DRender.QAttribute.AttributeType)",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.setBuffer(self,buffer:PySide2.Qt3DRender.Qt3DRender.QBuffer)",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.setByteOffset(self,byteOffset:uint)",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.setByteStride(self,byteStride:uint)",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.setCount(self,count:uint)",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.setDataSize(self,size:uint)",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.setDataType(self,type:PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType)",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.setDivisor(self,divisor:uint)",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.setName(self,name:QString)",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.setVertexBaseType(self,type:PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType)",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.setVertexSize(self,size:uint)",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.vertexBaseType(self)->PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType",
    "PySide2.Qt3DRender.Qt3DRender.QAttribute.vertexSize(self)->uint",
    nullptr}; // Sentinel

void init_Qt3DRender_QAttribute(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QAttribute_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QAttribute",
        "Qt3DRender::QAttribute*",
        &Sbk_Qt3DRender_QAttribute_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QAttribute >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QAttribute_Type);
    InitSignatureStrings(pyType, Qt3DRender_QAttribute_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QAttribute_Type), Sbk_Qt3DRender_QAttribute_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QAttribute_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QAttribute_TypeF(),
        QAttribute_PythonToCpp_QAttribute_PTR,
        is_QAttribute_PythonToCpp_QAttribute_PTR_Convertible,
        QAttribute_PTR_CppToPython_QAttribute);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAttribute");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAttribute*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAttribute&");
    Shiboken::Conversions::registerConverterName(converter, "QAttribute");
    Shiboken::Conversions::registerConverterName(converter, "QAttribute*");
    Shiboken::Conversions::registerConverterName(converter, "QAttribute&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QAttribute).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAttributeWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DRender_QAttribute_TypeF(), &Sbk_Qt3DRender_QAttribute_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'AttributeType'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_ATTRIBUTETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QAttribute_TypeF(),
        "AttributeType",
        "2:PySide2.Qt3DRender.Qt3DRender.QAttribute.AttributeType",
        "Qt3DRender::QAttribute::AttributeType");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_ATTRIBUTETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_ATTRIBUTETYPE_IDX],
        Sbk_Qt3DRender_QAttribute_TypeF(), "VertexAttribute", (long) Qt3DRender::QAttribute::AttributeType::VertexAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_ATTRIBUTETYPE_IDX],
        Sbk_Qt3DRender_QAttribute_TypeF(), "IndexAttribute", (long) Qt3DRender::QAttribute::AttributeType::IndexAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_ATTRIBUTETYPE_IDX],
        Sbk_Qt3DRender_QAttribute_TypeF(), "DrawIndirectAttribute", (long) Qt3DRender::QAttribute::AttributeType::DrawIndirectAttribute))
        return;
    // Register converter for enum 'Qt3DRender::QAttribute::AttributeType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_ATTRIBUTETYPE_IDX],
            Qt3DRender_QAttribute_AttributeType_CppToPython_Qt3DRender_QAttribute_AttributeType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QAttribute_AttributeType_PythonToCpp_Qt3DRender_QAttribute_AttributeType,
            is_Qt3DRender_QAttribute_AttributeType_PythonToCpp_Qt3DRender_QAttribute_AttributeType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_ATTRIBUTETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAttribute::AttributeType");
        Shiboken::Conversions::registerConverterName(converter, "QAttribute::AttributeType");
        Shiboken::Conversions::registerConverterName(converter, "AttributeType");
    }
    // End of 'AttributeType' enum.

    // Initialization of enum 'VertexBaseType'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QAttribute_TypeF(),
        "VertexBaseType",
        "2:PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType",
        "Qt3DRender::QAttribute::VertexBaseType");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX],
        Sbk_Qt3DRender_QAttribute_TypeF(), "Byte", (long) Qt3DRender::QAttribute::VertexBaseType::Byte))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX],
        Sbk_Qt3DRender_QAttribute_TypeF(), "UnsignedByte", (long) Qt3DRender::QAttribute::VertexBaseType::UnsignedByte))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX],
        Sbk_Qt3DRender_QAttribute_TypeF(), "Short", (long) Qt3DRender::QAttribute::VertexBaseType::Short))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX],
        Sbk_Qt3DRender_QAttribute_TypeF(), "UnsignedShort", (long) Qt3DRender::QAttribute::VertexBaseType::UnsignedShort))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX],
        Sbk_Qt3DRender_QAttribute_TypeF(), "Int", (long) Qt3DRender::QAttribute::VertexBaseType::Int))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX],
        Sbk_Qt3DRender_QAttribute_TypeF(), "UnsignedInt", (long) Qt3DRender::QAttribute::VertexBaseType::UnsignedInt))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX],
        Sbk_Qt3DRender_QAttribute_TypeF(), "HalfFloat", (long) Qt3DRender::QAttribute::VertexBaseType::HalfFloat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX],
        Sbk_Qt3DRender_QAttribute_TypeF(), "Float", (long) Qt3DRender::QAttribute::VertexBaseType::Float))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX],
        Sbk_Qt3DRender_QAttribute_TypeF(), "Double", (long) Qt3DRender::QAttribute::VertexBaseType::Double))
        return;
    // Register converter for enum 'Qt3DRender::QAttribute::VertexBaseType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX],
            Qt3DRender_QAttribute_VertexBaseType_CppToPython_Qt3DRender_QAttribute_VertexBaseType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QAttribute_VertexBaseType_PythonToCpp_Qt3DRender_QAttribute_VertexBaseType,
            is_Qt3DRender_QAttribute_VertexBaseType_PythonToCpp_Qt3DRender_QAttribute_VertexBaseType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_VERTEXBASETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAttribute::VertexBaseType");
        Shiboken::Conversions::registerConverterName(converter, "QAttribute::VertexBaseType");
        Shiboken::Conversions::registerConverterName(converter, "VertexBaseType");
    }
    // End of 'VertexBaseType' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DRender_QAttribute_TypeF(), &::Qt3DRender::QAttribute::staticMetaObject);
    qRegisterMetaType< ::Qt3DRender::QAttribute::AttributeType >("QAttribute::AttributeType");
    qRegisterMetaType< ::Qt3DRender::QAttribute::AttributeType >("Qt3DRender::QAttribute::AttributeType");
    qRegisterMetaType< ::Qt3DRender::QAttribute::VertexBaseType >("QAttribute::VertexBaseType");
    qRegisterMetaType< ::Qt3DRender::QAttribute::VertexBaseType >("Qt3DRender::QAttribute::VertexBaseType");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DRender_QAttribute_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DRender_QAttribute_TypeF(), &::Qt3DRender::QAttribute::staticMetaObject, sizeof(QAttributeWrapper));
}
