/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qblitframebuffer_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QBlitFramebufferWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QBlitFramebufferWrapper::QBlitFramebufferWrapper(::Qt3DCore::QNode * parent) : Qt3DRender::QBlitFramebuffer(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QBlitFramebufferWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QBlitFramebufferWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QBlitFramebufferWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QBlitFramebufferWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QBlitFramebufferWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBlitFramebuffer.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QBlitFramebufferWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBlitFramebuffer.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QBlitFramebufferWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QBlitFramebufferWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DRender::QBlitFramebuffer::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QBlitFramebufferWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DRender::QBlitFramebuffer::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QBlitFramebufferWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QBlitFramebufferWrapper *>(this));
        return Qt3DRender::QBlitFramebuffer::qt_metacast(_clname);
}

QBlitFramebufferWrapper::~QBlitFramebufferWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QBlitFramebuffer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QBlitFramebuffer >()))
        return -1;

    ::QBlitFramebufferWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QBlitFramebuffer", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QBlitFramebuffer::QBlitFramebuffer(Qt3DCore::QNode*)
    if (numArgs == 0) {
        overloadId = 0; // QBlitFramebuffer(Qt3DCore::QNode*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QBlitFramebuffer(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlitFramebuffer_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DRender_QBlitFramebuffer_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0]))))
                        goto Sbk_Qt3DRender_QBlitFramebuffer_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::Qt3DCore::QNode *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QBlitFramebuffer(Qt3DCore::QNode*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QBlitFramebufferWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QBlitFramebufferWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QBlitFramebuffer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DRender_QBlitFramebuffer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DRender_QBlitFramebuffer_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DRender_QBlitFramebuffer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DRender_QBlitFramebufferFunc_destination(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlitFramebuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.destination";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // destination()const
            Qt3DRender::QRenderTarget * cppResult = const_cast<const ::Qt3DRender::QBlitFramebuffer *>(cppSelf)->destination();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGET_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QBlitFramebufferFunc_destinationAttachmentPoint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlitFramebuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.destinationAttachmentPoint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // destinationAttachmentPoint()const
            Qt3DRender::QRenderTargetOutput::AttachmentPoint cppResult = const_cast<const ::Qt3DRender::QBlitFramebuffer *>(cppSelf)->destinationAttachmentPoint();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGETOUTPUT_ATTACHMENTPOINT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QBlitFramebufferFunc_destinationRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlitFramebuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.destinationRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // destinationRect()const
            QRectF cppResult = const_cast<const ::Qt3DRender::QBlitFramebuffer *>(cppSelf)->destinationRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QBlitFramebufferFunc_interpolationMethod(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlitFramebuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.interpolationMethod";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // interpolationMethod()const
            Qt3DRender::QBlitFramebuffer::InterpolationMethod cppResult = const_cast<const ::Qt3DRender::QBlitFramebuffer *>(cppSelf)->interpolationMethod();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_INTERPOLATIONMETHOD_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QBlitFramebufferFunc_setDestination(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlitFramebuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.setDestination";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBlitFramebuffer::setDestination(Qt3DRender::QRenderTarget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGET_IDX]), (pyArg)))) {
        overloadId = 0; // setDestination(Qt3DRender::QRenderTarget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlitFramebufferFunc_setDestination_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DRender::QRenderTarget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDestination(Qt3DRender::QRenderTarget*)
            cppSelf->setDestination(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBlitFramebufferFunc_setDestination_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBlitFramebufferFunc_setDestinationAttachmentPoint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlitFramebuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.setDestinationAttachmentPoint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBlitFramebuffer::setDestinationAttachmentPoint(Qt3DRender::QRenderTargetOutput::AttachmentPoint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGETOUTPUT_ATTACHMENTPOINT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDestinationAttachmentPoint(Qt3DRender::QRenderTargetOutput::AttachmentPoint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlitFramebufferFunc_setDestinationAttachmentPoint_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QRenderTargetOutput::AttachmentPoint cppArg0{Qt3DRender::QRenderTargetOutput::Color0};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDestinationAttachmentPoint(Qt3DRender::QRenderTargetOutput::AttachmentPoint)
            cppSelf->setDestinationAttachmentPoint(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBlitFramebufferFunc_setDestinationAttachmentPoint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBlitFramebufferFunc_setDestinationRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlitFramebuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.setDestinationRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBlitFramebuffer::setDestinationRect(QRectF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
        overloadId = 0; // setDestinationRect(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlitFramebufferFunc_setDestinationRect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDestinationRect(QRectF)
            cppSelf->setDestinationRect(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBlitFramebufferFunc_setDestinationRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBlitFramebufferFunc_setInterpolationMethod(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlitFramebuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.setInterpolationMethod";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBlitFramebuffer::setInterpolationMethod(Qt3DRender::QBlitFramebuffer::InterpolationMethod)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_INTERPOLATIONMETHOD_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setInterpolationMethod(Qt3DRender::QBlitFramebuffer::InterpolationMethod)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlitFramebufferFunc_setInterpolationMethod_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QBlitFramebuffer::InterpolationMethod cppArg0{Qt3DRender::QBlitFramebuffer::Nearest};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInterpolationMethod(Qt3DRender::QBlitFramebuffer::InterpolationMethod)
            cppSelf->setInterpolationMethod(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBlitFramebufferFunc_setInterpolationMethod_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBlitFramebufferFunc_setSource(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlitFramebuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.setSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBlitFramebuffer::setSource(Qt3DRender::QRenderTarget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGET_IDX]), (pyArg)))) {
        overloadId = 0; // setSource(Qt3DRender::QRenderTarget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlitFramebufferFunc_setSource_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DRender::QRenderTarget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSource(Qt3DRender::QRenderTarget*)
            cppSelf->setSource(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBlitFramebufferFunc_setSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBlitFramebufferFunc_setSourceAttachmentPoint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlitFramebuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.setSourceAttachmentPoint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBlitFramebuffer::setSourceAttachmentPoint(Qt3DRender::QRenderTargetOutput::AttachmentPoint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGETOUTPUT_ATTACHMENTPOINT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSourceAttachmentPoint(Qt3DRender::QRenderTargetOutput::AttachmentPoint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlitFramebufferFunc_setSourceAttachmentPoint_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QRenderTargetOutput::AttachmentPoint cppArg0{Qt3DRender::QRenderTargetOutput::Color0};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSourceAttachmentPoint(Qt3DRender::QRenderTargetOutput::AttachmentPoint)
            cppSelf->setSourceAttachmentPoint(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBlitFramebufferFunc_setSourceAttachmentPoint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBlitFramebufferFunc_setSourceRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlitFramebuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.setSourceRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBlitFramebuffer::setSourceRect(QRectF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
        overloadId = 0; // setSourceRect(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QBlitFramebufferFunc_setSourceRect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSourceRect(QRectF)
            cppSelf->setSourceRect(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QBlitFramebufferFunc_setSourceRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QBlitFramebufferFunc_source(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlitFramebuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.source";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // source()const
            Qt3DRender::QRenderTarget * cppResult = const_cast<const ::Qt3DRender::QBlitFramebuffer *>(cppSelf)->source();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGET_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QBlitFramebufferFunc_sourceAttachmentPoint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlitFramebuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.sourceAttachmentPoint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sourceAttachmentPoint()const
            Qt3DRender::QRenderTargetOutput::AttachmentPoint cppResult = const_cast<const ::Qt3DRender::QBlitFramebuffer *>(cppSelf)->sourceAttachmentPoint();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRENDERTARGETOUTPUT_ATTACHMENTPOINT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QBlitFramebufferFunc_sourceRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QBlitFramebuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.sourceRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sourceRect()const
            QRectF cppResult = const_cast<const ::Qt3DRender::QBlitFramebuffer *>(cppSelf)->sourceRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QBlitFramebuffer_PropertyStrings[] = {
    "destination::",
    "destinationAttachmentPoint::",
    "destinationRect::",
    "interpolationMethod::",
    "source::",
    "sourceAttachmentPoint::",
    "sourceRect::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QBlitFramebuffer_methods[] = {
    {"destination", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlitFramebufferFunc_destination), METH_NOARGS},
    {"destinationAttachmentPoint", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlitFramebufferFunc_destinationAttachmentPoint), METH_NOARGS},
    {"destinationRect", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlitFramebufferFunc_destinationRect), METH_NOARGS},
    {"interpolationMethod", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlitFramebufferFunc_interpolationMethod), METH_NOARGS},
    {"setDestination", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlitFramebufferFunc_setDestination), METH_O},
    {"setDestinationAttachmentPoint", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlitFramebufferFunc_setDestinationAttachmentPoint), METH_O},
    {"setDestinationRect", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlitFramebufferFunc_setDestinationRect), METH_O},
    {"setInterpolationMethod", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlitFramebufferFunc_setInterpolationMethod), METH_O},
    {"setSource", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlitFramebufferFunc_setSource), METH_O},
    {"setSourceAttachmentPoint", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlitFramebufferFunc_setSourceAttachmentPoint), METH_O},
    {"setSourceRect", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlitFramebufferFunc_setSourceRect), METH_O},
    {"source", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlitFramebufferFunc_source), METH_NOARGS},
    {"sourceAttachmentPoint", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlitFramebufferFunc_sourceAttachmentPoint), METH_NOARGS},
    {"sourceRect", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QBlitFramebufferFunc_sourceRect), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DRender_QBlitFramebuffer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DRender::QBlitFramebuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QBlitFramebufferWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DRender_QBlitFramebuffer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QBlitFramebuffer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QBlitFramebuffer_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QBlitFramebuffer_TypeF(void)
{
    return _Sbk_Qt3DRender_QBlitFramebuffer_Type;
}

static PyType_Slot Sbk_Qt3DRender_QBlitFramebuffer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DRender_QBlitFramebuffer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QBlitFramebuffer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QBlitFramebuffer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QBlitFramebuffer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QBlitFramebuffer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QBlitFramebuffer_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QBlitFramebuffer_slots
};

} //extern "C"

static void *Sbk_Qt3DRender_QBlitFramebuffer_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DRender::QBlitFramebuffer *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_QBlitFramebuffer_InterpolationMethod_PythonToCpp_Qt3DRender_QBlitFramebuffer_InterpolationMethod(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QBlitFramebuffer::InterpolationMethod *>(cppOut) =
        static_cast<::Qt3DRender::QBlitFramebuffer::InterpolationMethod>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QBlitFramebuffer_InterpolationMethod_PythonToCpp_Qt3DRender_QBlitFramebuffer_InterpolationMethod_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_INTERPOLATIONMETHOD_IDX]))
        return Qt3DRender_QBlitFramebuffer_InterpolationMethod_PythonToCpp_Qt3DRender_QBlitFramebuffer_InterpolationMethod;
    return {};
}
static PyObject *Qt3DRender_QBlitFramebuffer_InterpolationMethod_CppToPython_Qt3DRender_QBlitFramebuffer_InterpolationMethod(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QBlitFramebuffer::InterpolationMethod *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_INTERPOLATIONMETHOD_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QBlitFramebuffer_PythonToCpp_QBlitFramebuffer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QBlitFramebuffer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QBlitFramebuffer_PythonToCpp_QBlitFramebuffer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QBlitFramebuffer_TypeF())))
        return QBlitFramebuffer_PythonToCpp_QBlitFramebuffer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QBlitFramebuffer_PTR_CppToPython_QBlitFramebuffer(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DRender::QBlitFramebuffer *>(const_cast<void *>(cppIn)), Sbk_Qt3DRender_QBlitFramebuffer_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QBlitFramebuffer_SignatureStrings[] = {
    "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.destination(self)->PySide2.Qt3DRender.Qt3DRender.QRenderTarget",
    "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.destinationAttachmentPoint(self)->PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint",
    "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.destinationRect(self)->PySide2.QtCore.QRectF",
    "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.interpolationMethod(self)->PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.InterpolationMethod",
    "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.setDestination(self,destination:PySide2.Qt3DRender.Qt3DRender.QRenderTarget)",
    "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.setDestinationAttachmentPoint(self,destinationAttachmentPoint:PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint)",
    "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.setDestinationRect(self,destinationRect:PySide2.QtCore.QRectF)",
    "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.setInterpolationMethod(self,interpolationMethod:PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.InterpolationMethod)",
    "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.setSource(self,source:PySide2.Qt3DRender.Qt3DRender.QRenderTarget)",
    "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.setSourceAttachmentPoint(self,sourceAttachmentPoint:PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint)",
    "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.setSourceRect(self,sourceRect:PySide2.QtCore.QRectF)",
    "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.source(self)->PySide2.Qt3DRender.Qt3DRender.QRenderTarget",
    "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.sourceAttachmentPoint(self)->PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint",
    "PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.sourceRect(self)->PySide2.QtCore.QRectF",
    nullptr}; // Sentinel

void init_Qt3DRender_QBlitFramebuffer(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QBlitFramebuffer_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QBlitFramebuffer",
        "Qt3DRender::QBlitFramebuffer*",
        &Sbk_Qt3DRender_QBlitFramebuffer_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QBlitFramebuffer >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QFRAMEGRAPHNODE_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QBlitFramebuffer_Type);
    InitSignatureStrings(pyType, Qt3DRender_QBlitFramebuffer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QBlitFramebuffer_Type), Sbk_Qt3DRender_QBlitFramebuffer_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QBlitFramebuffer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QBlitFramebuffer_TypeF(),
        QBlitFramebuffer_PythonToCpp_QBlitFramebuffer_PTR,
        is_QBlitFramebuffer_PythonToCpp_QBlitFramebuffer_PTR_Convertible,
        QBlitFramebuffer_PTR_CppToPython_QBlitFramebuffer);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QBlitFramebuffer");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QBlitFramebuffer*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QBlitFramebuffer&");
    Shiboken::Conversions::registerConverterName(converter, "QBlitFramebuffer");
    Shiboken::Conversions::registerConverterName(converter, "QBlitFramebuffer*");
    Shiboken::Conversions::registerConverterName(converter, "QBlitFramebuffer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QBlitFramebuffer).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QBlitFramebufferWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DRender_QBlitFramebuffer_TypeF(), &Sbk_Qt3DRender_QBlitFramebuffer_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'InterpolationMethod'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_INTERPOLATIONMETHOD_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QBlitFramebuffer_TypeF(),
        "InterpolationMethod",
        "2:PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.InterpolationMethod",
        "Qt3DRender::QBlitFramebuffer::InterpolationMethod");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_INTERPOLATIONMETHOD_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_INTERPOLATIONMETHOD_IDX],
        Sbk_Qt3DRender_QBlitFramebuffer_TypeF(), "Nearest", (long) Qt3DRender::QBlitFramebuffer::InterpolationMethod::Nearest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_INTERPOLATIONMETHOD_IDX],
        Sbk_Qt3DRender_QBlitFramebuffer_TypeF(), "Linear", (long) Qt3DRender::QBlitFramebuffer::InterpolationMethod::Linear))
        return;
    // Register converter for enum 'Qt3DRender::QBlitFramebuffer::InterpolationMethod'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_INTERPOLATIONMETHOD_IDX],
            Qt3DRender_QBlitFramebuffer_InterpolationMethod_CppToPython_Qt3DRender_QBlitFramebuffer_InterpolationMethod);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QBlitFramebuffer_InterpolationMethod_PythonToCpp_Qt3DRender_QBlitFramebuffer_InterpolationMethod,
            is_Qt3DRender_QBlitFramebuffer_InterpolationMethod_PythonToCpp_Qt3DRender_QBlitFramebuffer_InterpolationMethod_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QBLITFRAMEBUFFER_INTERPOLATIONMETHOD_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QBlitFramebuffer::InterpolationMethod");
        Shiboken::Conversions::registerConverterName(converter, "QBlitFramebuffer::InterpolationMethod");
        Shiboken::Conversions::registerConverterName(converter, "InterpolationMethod");
    }
    // End of 'InterpolationMethod' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DRender_QBlitFramebuffer_TypeF(), &::Qt3DRender::QBlitFramebuffer::staticMetaObject);
    qRegisterMetaType< ::Qt3DRender::QBlitFramebuffer::InterpolationMethod >("QBlitFramebuffer::InterpolationMethod");
    qRegisterMetaType< ::Qt3DRender::QBlitFramebuffer::InterpolationMethod >("Qt3DRender::QBlitFramebuffer::InterpolationMethod");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DRender_QBlitFramebuffer_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DRender_QBlitFramebuffer_TypeF(), &::Qt3DRender::QBlitFramebuffer::staticMetaObject, sizeof(QBlitFramebufferWrapper));
}
