/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qtexturedata_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QTextureData_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QTextureData >()))
        return -1;

    ::Qt3DRender::QTextureData *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QTextureData()
            cptr = new ::Qt3DRender::QTextureData();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QTextureData >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_comparisonFunction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.comparisonFunction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // comparisonFunction()const
            Qt3DRender::QAbstractTexture::ComparisonFunction cppResult = const_cast<const ::Qt3DRender::QTextureData *>(cppSelf)->comparisonFunction();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_comparisonMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.comparisonMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // comparisonMode()const
            Qt3DRender::QAbstractTexture::ComparisonMode cppResult = const_cast<const ::Qt3DRender::QTextureData *>(cppSelf)->comparisonMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_depth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.depth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // depth()const
            int cppResult = const_cast<const ::Qt3DRender::QTextureData *>(cppSelf)->depth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            Qt3DRender::QAbstractTexture::TextureFormat cppResult = const_cast<const ::Qt3DRender::QTextureData *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_height(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.height";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // height()const
            int cppResult = const_cast<const ::Qt3DRender::QTextureData *>(cppSelf)->height();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_isAutoMipMapGenerationEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.isAutoMipMapGenerationEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAutoMipMapGenerationEnabled()const
            bool cppResult = const_cast<const ::Qt3DRender::QTextureData *>(cppSelf)->isAutoMipMapGenerationEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_layers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.layers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // layers()const
            int cppResult = const_cast<const ::Qt3DRender::QTextureData *>(cppSelf)->layers();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_magnificationFilter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.magnificationFilter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // magnificationFilter()const
            Qt3DRender::QAbstractTexture::Filter cppResult = const_cast<const ::Qt3DRender::QTextureData *>(cppSelf)->magnificationFilter();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_maximumAnisotropy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.maximumAnisotropy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumAnisotropy()const
            float cppResult = const_cast<const ::Qt3DRender::QTextureData *>(cppSelf)->maximumAnisotropy();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_minificationFilter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.minificationFilter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minificationFilter()const
            Qt3DRender::QAbstractTexture::Filter cppResult = const_cast<const ::Qt3DRender::QTextureData *>(cppSelf)->minificationFilter();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_setAutoMipMapGenerationEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.setAutoMipMapGenerationEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureData::setAutoMipMapGenerationEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoMipMapGenerationEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureDataFunc_setAutoMipMapGenerationEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoMipMapGenerationEnabled(bool)
            cppSelf->setAutoMipMapGenerationEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureDataFunc_setAutoMipMapGenerationEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_setComparisonFunction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.setComparisonFunction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureData::setComparisonFunction(Qt3DRender::QAbstractTexture::ComparisonFunction)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setComparisonFunction(Qt3DRender::QAbstractTexture::ComparisonFunction)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureDataFunc_setComparisonFunction_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAbstractTexture::ComparisonFunction cppArg0 = static_cast< ::Qt3DRender::QAbstractTexture::ComparisonFunction>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setComparisonFunction(Qt3DRender::QAbstractTexture::ComparisonFunction)
            cppSelf->setComparisonFunction(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureDataFunc_setComparisonFunction_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_setComparisonMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.setComparisonMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureData::setComparisonMode(Qt3DRender::QAbstractTexture::ComparisonMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setComparisonMode(Qt3DRender::QAbstractTexture::ComparisonMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureDataFunc_setComparisonMode_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAbstractTexture::ComparisonMode cppArg0{Qt3DRender::QAbstractTexture::CompareNone};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setComparisonMode(Qt3DRender::QAbstractTexture::ComparisonMode)
            cppSelf->setComparisonMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureDataFunc_setComparisonMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_setDepth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.setDepth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureData::setDepth(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setDepth(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureDataFunc_setDepth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDepth(int)
            cppSelf->setDepth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureDataFunc_setDepth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_setFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.setFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureData::setFormat(Qt3DRender::QAbstractTexture::TextureFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFormat(Qt3DRender::QAbstractTexture::TextureFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureDataFunc_setFormat_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAbstractTexture::TextureFormat cppArg0{Qt3DRender::QAbstractTexture::NoFormat};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFormat(Qt3DRender::QAbstractTexture::TextureFormat)
            cppSelf->setFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureDataFunc_setFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_setHeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.setHeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureData::setHeight(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setHeight(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureDataFunc_setHeight_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHeight(int)
            cppSelf->setHeight(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureDataFunc_setHeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_setLayers(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.setLayers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureData::setLayers(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLayers(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureDataFunc_setLayers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLayers(int)
            cppSelf->setLayers(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureDataFunc_setLayers_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_setMagnificationFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.setMagnificationFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureData::setMagnificationFilter(Qt3DRender::QAbstractTexture::Filter)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMagnificationFilter(Qt3DRender::QAbstractTexture::Filter)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureDataFunc_setMagnificationFilter_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAbstractTexture::Filter cppArg0 = static_cast< ::Qt3DRender::QAbstractTexture::Filter>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMagnificationFilter(Qt3DRender::QAbstractTexture::Filter)
            cppSelf->setMagnificationFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureDataFunc_setMagnificationFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_setMaximumAnisotropy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.setMaximumAnisotropy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureData::setMaximumAnisotropy(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setMaximumAnisotropy(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureDataFunc_setMaximumAnisotropy_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaximumAnisotropy(float)
            cppSelf->setMaximumAnisotropy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureDataFunc_setMaximumAnisotropy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_setMinificationFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.setMinificationFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureData::setMinificationFilter(Qt3DRender::QAbstractTexture::Filter)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMinificationFilter(Qt3DRender::QAbstractTexture::Filter)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureDataFunc_setMinificationFilter_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAbstractTexture::Filter cppArg0 = static_cast< ::Qt3DRender::QAbstractTexture::Filter>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMinificationFilter(Qt3DRender::QAbstractTexture::Filter)
            cppSelf->setMinificationFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureDataFunc_setMinificationFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_setTarget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.setTarget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureData::setTarget(Qt3DRender::QAbstractTexture::Target)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTarget(Qt3DRender::QAbstractTexture::Target)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureDataFunc_setTarget_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAbstractTexture::Target cppArg0{Qt3DRender::QAbstractTexture::TargetAutomatic};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTarget(Qt3DRender::QAbstractTexture::Target)
            cppSelf->setTarget(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureDataFunc_setTarget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_setWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.setWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureData::setWidth(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setWidth(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureDataFunc_setWidth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWidth(int)
            cppSelf->setWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureDataFunc_setWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_setWrapModeX(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.setWrapModeX";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureData::setWrapModeX(Qt3DRender::QTextureWrapMode::WrapMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREWRAPMODE_WRAPMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setWrapModeX(Qt3DRender::QTextureWrapMode::WrapMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureDataFunc_setWrapModeX_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QTextureWrapMode::WrapMode cppArg0 = static_cast< ::Qt3DRender::QTextureWrapMode::WrapMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWrapModeX(Qt3DRender::QTextureWrapMode::WrapMode)
            cppSelf->setWrapModeX(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureDataFunc_setWrapModeX_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_setWrapModeY(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.setWrapModeY";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureData::setWrapModeY(Qt3DRender::QTextureWrapMode::WrapMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREWRAPMODE_WRAPMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setWrapModeY(Qt3DRender::QTextureWrapMode::WrapMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureDataFunc_setWrapModeY_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QTextureWrapMode::WrapMode cppArg0 = static_cast< ::Qt3DRender::QTextureWrapMode::WrapMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWrapModeY(Qt3DRender::QTextureWrapMode::WrapMode)
            cppSelf->setWrapModeY(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureDataFunc_setWrapModeY_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_setWrapModeZ(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.setWrapModeZ";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureData::setWrapModeZ(Qt3DRender::QTextureWrapMode::WrapMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREWRAPMODE_WRAPMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setWrapModeZ(Qt3DRender::QTextureWrapMode::WrapMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureDataFunc_setWrapModeZ_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QTextureWrapMode::WrapMode cppArg0 = static_cast< ::Qt3DRender::QTextureWrapMode::WrapMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWrapModeZ(Qt3DRender::QTextureWrapMode::WrapMode)
            cppSelf->setWrapModeZ(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureDataFunc_setWrapModeZ_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_target(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.target";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // target()const
            Qt3DRender::QAbstractTexture::Target cppResult = const_cast<const ::Qt3DRender::QTextureData *>(cppSelf)->target();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_width(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.width";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width()const
            int cppResult = const_cast<const ::Qt3DRender::QTextureData *>(cppSelf)->width();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_wrapModeX(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.wrapModeX";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wrapModeX()const
            Qt3DRender::QTextureWrapMode::WrapMode cppResult = const_cast<const ::Qt3DRender::QTextureData *>(cppSelf)->wrapModeX();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREWRAPMODE_WRAPMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_wrapModeY(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.wrapModeY";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wrapModeY()const
            Qt3DRender::QTextureWrapMode::WrapMode cppResult = const_cast<const ::Qt3DRender::QTextureData *>(cppSelf)->wrapModeY();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREWRAPMODE_WRAPMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureDataFunc_wrapModeZ(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureData.wrapModeZ";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wrapModeZ()const
            Qt3DRender::QTextureWrapMode::WrapMode cppResult = const_cast<const ::Qt3DRender::QTextureData *>(cppSelf)->wrapModeZ();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREWRAPMODE_WRAPMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QTextureData_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QTextureData_methods[] = {
    {"comparisonFunction", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_comparisonFunction), METH_NOARGS},
    {"comparisonMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_comparisonMode), METH_NOARGS},
    {"depth", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_depth), METH_NOARGS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_format), METH_NOARGS},
    {"height", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_height), METH_NOARGS},
    {"isAutoMipMapGenerationEnabled", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_isAutoMipMapGenerationEnabled), METH_NOARGS},
    {"layers", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_layers), METH_NOARGS},
    {"magnificationFilter", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_magnificationFilter), METH_NOARGS},
    {"maximumAnisotropy", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_maximumAnisotropy), METH_NOARGS},
    {"minificationFilter", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_minificationFilter), METH_NOARGS},
    {"setAutoMipMapGenerationEnabled", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_setAutoMipMapGenerationEnabled), METH_O},
    {"setComparisonFunction", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_setComparisonFunction), METH_O},
    {"setComparisonMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_setComparisonMode), METH_O},
    {"setDepth", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_setDepth), METH_O},
    {"setFormat", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_setFormat), METH_O},
    {"setHeight", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_setHeight), METH_O},
    {"setLayers", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_setLayers), METH_O},
    {"setMagnificationFilter", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_setMagnificationFilter), METH_O},
    {"setMaximumAnisotropy", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_setMaximumAnisotropy), METH_O},
    {"setMinificationFilter", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_setMinificationFilter), METH_O},
    {"setTarget", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_setTarget), METH_O},
    {"setWidth", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_setWidth), METH_O},
    {"setWrapModeX", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_setWrapModeX), METH_O},
    {"setWrapModeY", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_setWrapModeY), METH_O},
    {"setWrapModeZ", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_setWrapModeZ), METH_O},
    {"target", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_target), METH_NOARGS},
    {"width", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_width), METH_NOARGS},
    {"wrapModeX", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_wrapModeX), METH_NOARGS},
    {"wrapModeY", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_wrapModeY), METH_NOARGS},
    {"wrapModeZ", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureDataFunc_wrapModeZ), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_Qt3DRender_QTextureData_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QTextureData_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QTextureData_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QTextureData_TypeF(void)
{
    return _Sbk_Qt3DRender_QTextureData_Type;
}

static PyType_Slot Sbk_Qt3DRender_QTextureData_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QTextureData_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QTextureData_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QTextureData_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QTextureData_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QTextureData_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QTextureData",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QTextureData_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextureData_PythonToCpp_QTextureData_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QTextureData_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextureData_PythonToCpp_QTextureData_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QTextureData_TypeF())))
        return QTextureData_PythonToCpp_QTextureData_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextureData_PTR_CppToPython_QTextureData(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::Qt3DRender::QTextureData *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_Qt3DRender_QTextureData_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QTextureData_SignatureStrings[] = {
    "PySide2.Qt3DRender.Qt3DRender.QTextureData(self)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.comparisonFunction(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.comparisonMode(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.depth(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.format(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.height(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.isAutoMipMapGenerationEnabled(self)->bool",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.layers(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.magnificationFilter(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.maximumAnisotropy(self)->float",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.minificationFilter(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.setAutoMipMapGenerationEnabled(self,isAutoMipMapGenerationEnabled:bool)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.setComparisonFunction(self,comparisonFunction:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.setComparisonMode(self,comparisonMode:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.setDepth(self,depth:int)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.setFormat(self,arg__1:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.setHeight(self,height:int)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.setLayers(self,layers:int)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.setMagnificationFilter(self,filter:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.setMaximumAnisotropy(self,maximumAnisotropy:float)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.setMinificationFilter(self,filter:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.setTarget(self,target:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Target)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.setWidth(self,width:int)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.setWrapModeX(self,wrapModeX:PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.setWrapModeY(self,wrapModeY:PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.setWrapModeZ(self,wrapModeZ:PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.target(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Target",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.width(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.wrapModeX(self)->PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.wrapModeY(self)->PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode",
    "PySide2.Qt3DRender.Qt3DRender.QTextureData.wrapModeZ(self)->PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode",
    nullptr}; // Sentinel

void init_Qt3DRender_QTextureData(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QTextureData_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QTextureData",
        "Qt3DRender::QTextureData*",
        &Sbk_Qt3DRender_QTextureData_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QTextureData >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QTextureData_Type);
    InitSignatureStrings(pyType, Qt3DRender_QTextureData_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QTextureData_Type), Sbk_Qt3DRender_QTextureData_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREDATA_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QTextureData_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QTextureData_TypeF(),
        QTextureData_PythonToCpp_QTextureData_PTR,
        is_QTextureData_PythonToCpp_QTextureData_PTR_Convertible,
        QTextureData_PTR_CppToPython_QTextureData);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QTextureData");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QTextureData*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QTextureData&");
    Shiboken::Conversions::registerConverterName(converter, "QTextureData");
    Shiboken::Conversions::registerConverterName(converter, "QTextureData*");
    Shiboken::Conversions::registerConverterName(converter, "QTextureData&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QTextureData).name());


}
