/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcharts_python.h"

// main header
#include "qtcharts_qabstractbarseries_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtCharts;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstractBarSeriesWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

void QAbstractBarSeriesWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractBarSeriesWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractBarSeriesWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractBarSeriesWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAbstractBarSeriesWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractBarSeries.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAbstractBarSeriesWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractBarSeries.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAbstractBarSeriesWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QtCharts::QAbstractSeries::SeriesType QAbstractBarSeriesWrapper::type() const
{
    if (m_PyMethodCache[8]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractBarSeries.type()' not implemented.");
        return QtCharts::QAbstractSeries::SeriesTypeLine;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QtCharts::QAbstractSeries::SeriesTypeLine;
    static PyObject *nameCache[2] = {};
    // This method belongs to a property.
    static const char *funcName = "1:type";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractBarSeries.type()' not implemented.");
        return QtCharts::QAbstractSeries::SeriesTypeLine;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QtCharts::QAbstractSeries::SeriesTypeLine;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTSERIES_SERIESTYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractBarSeries.type", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QtCharts::QAbstractSeries::SeriesType >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QtCharts::QAbstractSeries::SeriesTypeLine;
    }
    ::QtCharts::QAbstractSeries::SeriesType cppResult{QtCharts::QAbstractSeries::SeriesTypeLine};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QAbstractBarSeriesWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtCharts::QAbstractBarSeries::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAbstractBarSeriesWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtCharts::QAbstractBarSeries::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAbstractBarSeriesWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAbstractBarSeriesWrapper *>(this));
        return QtCharts::QAbstractBarSeries::qt_metacast(_clname);
}

QAbstractBarSeriesWrapper::~QAbstractBarSeriesWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_append(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.append";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractBarSeries::append(QList<QtCharts::QBarSet*>)
    // 1: QAbstractBarSeries::append(QtCharts::QBarSet*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBARSET_IDX]), (pyArg)))) {
        overloadId = 1; // append(QtCharts::QBarSet*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QBARSETPTR_IDX], (pyArg)))) {
        overloadId = 0; // append(QList<QtCharts::QBarSet*>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractBarSeriesFunc_append_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // append(QList<QtCharts::QBarSet* > sets)
        {
            ::QList<QtCharts::QBarSet* > cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // append(QList<QtCharts::QBarSet*>)
                bool cppResult = cppSelf->append(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
                Shiboken::Object::setParent(self, pyArg);
            }
            break;
        }
        case 1: // append(QtCharts::QBarSet * set)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QtCharts::QBarSet *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // append(QtCharts::QBarSet*)
                bool cppResult = cppSelf->append(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
                Shiboken::Object::setParent(self, pyArg);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtCharts_QAbstractBarSeriesFunc_append_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_barSets(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.barSets";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // barSets()const
            QList<QtCharts::QBarSet* > cppResult = const_cast<const ::QtCharts::QAbstractBarSeries *>(cppSelf)->barSets();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QBARSETPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_barWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.barWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // barWidth()const
            qreal cppResult = const_cast<const ::QtCharts::QAbstractBarSeries *>(cppSelf)->barWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.count";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // count()const
            int cppResult = const_cast<const ::QtCharts::QAbstractBarSeries *>(cppSelf)->count();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_insert(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.insert";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insert", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractBarSeries::insert(int,QtCharts::QBarSet*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBARSET_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insert(int,QtCharts::QBarSet*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractBarSeriesFunc_insert_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QtCharts::QBarSet *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // insert(int,QtCharts::QBarSet*)
            bool cppResult = cppSelf->insert(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            Shiboken::Object::setParent(self, pyArgs[1]);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtCharts_QAbstractBarSeriesFunc_insert_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_isLabelsVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.isLabelsVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLabelsVisible()const
            bool cppResult = const_cast<const ::QtCharts::QAbstractBarSeries *>(cppSelf)->isLabelsVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_labelsAngle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.labelsAngle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelsAngle()const
            qreal cppResult = const_cast<const ::QtCharts::QAbstractBarSeries *>(cppSelf)->labelsAngle();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_labelsFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.labelsFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelsFormat()const
            QString cppResult = const_cast<const ::QtCharts::QAbstractBarSeries *>(cppSelf)->labelsFormat();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_labelsPosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.labelsPosition";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelsPosition()const
            QtCharts::QAbstractBarSeries::LabelsPosition cppResult = const_cast<const ::QtCharts::QAbstractBarSeries *>(cppSelf)->labelsPosition();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_LABELSPOSITION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_labelsPrecision(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.labelsPrecision";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelsPrecision()const
            int cppResult = const_cast<const ::QtCharts::QAbstractBarSeries *>(cppSelf)->labelsPrecision();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_remove(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.remove";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractBarSeries::remove(QtCharts::QBarSet*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBARSET_IDX]), (pyArg)))) {
        overloadId = 0; // remove(QtCharts::QBarSet*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractBarSeriesFunc_remove_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtCharts::QBarSet *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // remove(QtCharts::QBarSet*)
            bool cppResult = cppSelf->remove(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtCharts_QAbstractBarSeriesFunc_remove_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_setBarWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.setBarWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractBarSeries::setBarWidth(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setBarWidth(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractBarSeriesFunc_setBarWidth_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBarWidth(qreal)
            cppSelf->setBarWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractBarSeriesFunc_setBarWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsAngle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.setLabelsAngle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractBarSeries::setLabelsAngle(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setLabelsAngle(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsAngle_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelsAngle(qreal)
            cppSelf->setLabelsAngle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsAngle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.setLabelsFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractBarSeries::setLabelsFormat(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setLabelsFormat(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsFormat_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelsFormat(QString)
            cppSelf->setLabelsFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsPosition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.setLabelsPosition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractBarSeries::setLabelsPosition(QtCharts::QAbstractBarSeries::LabelsPosition)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_LABELSPOSITION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setLabelsPosition(QtCharts::QAbstractBarSeries::LabelsPosition)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsPosition_TypeError;

    // Call function/method
    {
        ::QtCharts::QAbstractBarSeries::LabelsPosition cppArg0{QtCharts::QAbstractBarSeries::LabelsCenter};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelsPosition(QtCharts::QAbstractBarSeries::LabelsPosition)
            cppSelf->setLabelsPosition(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsPrecision(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.setLabelsPrecision";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractBarSeries::setLabelsPrecision(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLabelsPrecision(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsPrecision_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelsPrecision(int)
            cppSelf->setLabelsPrecision(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsPrecision_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsVisible(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.setLabelsVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsVisible_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setLabelsVisible", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractBarSeries::setLabelsVisible(bool)
    if (numArgs == 0) {
        overloadId = 0; // setLabelsVisible(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setLabelsVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsVisible_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_visible = Shiboken::String::createStaticString("visible");
            if (PyDict_Contains(kwds, key_visible)) {
                value = PyDict_GetItem(kwds, key_visible);
                if (value && pyArgs[0]) {
                    errInfo = key_visible;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsVisible_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsVisible_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_visible);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsVisible_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelsVisible(bool)
            cppSelf->setLabelsVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QAbstractBarSeriesFunc_take(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QAbstractBarSeries.take";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractBarSeries::take(QtCharts::QBarSet*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBARSET_IDX]), (pyArg)))) {
        overloadId = 0; // take(QtCharts::QBarSet*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QAbstractBarSeriesFunc_take_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtCharts::QBarSet *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // take(QtCharts::QBarSet*)
            bool cppResult = cppSelf->take(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtCharts_QAbstractBarSeriesFunc_take_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QtCharts_QAbstractBarSeries_PropertyStrings[] = {
    "barWidth::",
    "count:",
    "labelsAngle::",
    "labelsFormat::",
    "labelsPosition::",
    "labelsPrecision::",
    "labelsVisible:isLabelsVisible:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtCharts_QAbstractBarSeries_methods[] = {
    {"append", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_append), METH_O},
    {"barSets", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_barSets), METH_NOARGS},
    {"barWidth", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_barWidth), METH_NOARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_clear), METH_NOARGS},
    {"count", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_count), METH_NOARGS},
    {"insert", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_insert), METH_VARARGS},
    {"isLabelsVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_isLabelsVisible), METH_NOARGS},
    {"labelsAngle", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_labelsAngle), METH_NOARGS},
    {"labelsFormat", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_labelsFormat), METH_NOARGS},
    {"labelsPosition", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_labelsPosition), METH_NOARGS},
    {"labelsPrecision", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_labelsPrecision), METH_NOARGS},
    {"remove", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_remove), METH_O},
    {"setBarWidth", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_setBarWidth), METH_O},
    {"setLabelsAngle", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsAngle), METH_O},
    {"setLabelsFormat", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsFormat), METH_O},
    {"setLabelsPosition", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsPosition), METH_O},
    {"setLabelsPrecision", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsPrecision), METH_O},
    {"setLabelsVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_setLabelsVisible), METH_VARARGS|METH_KEYWORDS},
    {"take", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QAbstractBarSeriesFunc_take), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtCharts_QAbstractBarSeries_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtCharts::QAbstractBarSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstractBarSeriesWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtCharts_QAbstractBarSeries_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtCharts_QAbstractBarSeries_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtCharts_QAbstractBarSeries_Type = nullptr;
static SbkObjectType *Sbk_QtCharts_QAbstractBarSeries_TypeF(void)
{
    return _Sbk_QtCharts_QAbstractBarSeries_Type;
}

static PyType_Slot Sbk_QtCharts_QAbstractBarSeries_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtCharts_QAbstractBarSeries_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtCharts_QAbstractBarSeries_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtCharts_QAbstractBarSeries_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtCharts_QAbstractBarSeries_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtCharts_QAbstractBarSeries_spec = {
    "2:PySide2.QtCharts.QtCharts.QAbstractBarSeries",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtCharts_QAbstractBarSeries_slots
};

} //extern "C"

static void *Sbk_QtCharts_QAbstractBarSeries_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtCharts::QAbstractBarSeries *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QtCharts_QAbstractBarSeries_LabelsPosition_PythonToCpp_QtCharts_QAbstractBarSeries_LabelsPosition(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtCharts::QAbstractBarSeries::LabelsPosition *>(cppOut) =
        static_cast<::QtCharts::QAbstractBarSeries::LabelsPosition>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtCharts_QAbstractBarSeries_LabelsPosition_PythonToCpp_QtCharts_QAbstractBarSeries_LabelsPosition_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_LABELSPOSITION_IDX]))
        return QtCharts_QAbstractBarSeries_LabelsPosition_PythonToCpp_QtCharts_QAbstractBarSeries_LabelsPosition;
    return {};
}
static PyObject *QtCharts_QAbstractBarSeries_LabelsPosition_CppToPython_QtCharts_QAbstractBarSeries_LabelsPosition(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtCharts::QAbstractBarSeries::LabelsPosition *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_LABELSPOSITION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstractBarSeries_PythonToCpp_QAbstractBarSeries_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtCharts_QAbstractBarSeries_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstractBarSeries_PythonToCpp_QAbstractBarSeries_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtCharts_QAbstractBarSeries_TypeF())))
        return QAbstractBarSeries_PythonToCpp_QAbstractBarSeries_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstractBarSeries_PTR_CppToPython_QAbstractBarSeries(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtCharts::QAbstractBarSeries *>(const_cast<void *>(cppIn)), Sbk_QtCharts_QAbstractBarSeries_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtCharts_QAbstractBarSeries_SignatureStrings[] = {
    "1:PySide2.QtCharts.QtCharts.QAbstractBarSeries.append(self,sets:QList[PySide2.QtCharts.QtCharts.QBarSet])->bool",
    "0:PySide2.QtCharts.QtCharts.QAbstractBarSeries.append(self,set:PySide2.QtCharts.QtCharts.QBarSet)->bool",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.barSets(self)->QList[PySide2.QtCharts.QtCharts.QBarSet]",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.barWidth(self)->qreal",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.clear(self)",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.count(self)->int",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.insert(self,index:int,set:PySide2.QtCharts.QtCharts.QBarSet)->bool",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.isLabelsVisible(self)->bool",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.labelsAngle(self)->qreal",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.labelsFormat(self)->QString",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.labelsPosition(self)->PySide2.QtCharts.QtCharts.QAbstractBarSeries.LabelsPosition",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.labelsPrecision(self)->int",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.remove(self,set:PySide2.QtCharts.QtCharts.QBarSet)->bool",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.setBarWidth(self,width:qreal)",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.setLabelsAngle(self,angle:qreal)",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.setLabelsFormat(self,format:QString)",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.setLabelsPosition(self,position:PySide2.QtCharts.QtCharts.QAbstractBarSeries.LabelsPosition)",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.setLabelsPrecision(self,precision:int)",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.setLabelsVisible(self,visible:bool=true)",
    "PySide2.QtCharts.QtCharts.QAbstractBarSeries.take(self,set:PySide2.QtCharts.QtCharts.QBarSet)->bool",
    nullptr}; // Sentinel

void init_QtCharts_QAbstractBarSeries(PyObject *enclosingClass)
{
    _Sbk_QtCharts_QAbstractBarSeries_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QAbstractBarSeries",
        "QtCharts::QAbstractBarSeries*",
        &Sbk_QtCharts_QAbstractBarSeries_spec,
        &Shiboken::callCppDestructor< ::QtCharts::QAbstractBarSeries >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTSERIES_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtCharts_QAbstractBarSeries_Type);
    InitSignatureStrings(pyType, QtCharts_QAbstractBarSeries_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtCharts_QAbstractBarSeries_Type), Sbk_QtCharts_QAbstractBarSeries_PropertyStrings);
    SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtCharts_QAbstractBarSeries_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtCharts_QAbstractBarSeries_TypeF(),
        QAbstractBarSeries_PythonToCpp_QAbstractBarSeries_PTR,
        is_QAbstractBarSeries_PythonToCpp_QAbstractBarSeries_PTR_Convertible,
        QAbstractBarSeries_PTR_CppToPython_QAbstractBarSeries);

    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QAbstractBarSeries");
    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QAbstractBarSeries*");
    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QAbstractBarSeries&");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractBarSeries");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractBarSeries*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractBarSeries&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtCharts::QAbstractBarSeries).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractBarSeriesWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtCharts_QAbstractBarSeries_TypeF(), &Sbk_QtCharts_QAbstractBarSeries_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'LabelsPosition'.
    SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_LABELSPOSITION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtCharts_QAbstractBarSeries_TypeF(),
        "LabelsPosition",
        "2:PySide2.QtCharts.QtCharts.QAbstractBarSeries.LabelsPosition",
        "QtCharts::QAbstractBarSeries::LabelsPosition");
    if (!SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_LABELSPOSITION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_LABELSPOSITION_IDX],
        Sbk_QtCharts_QAbstractBarSeries_TypeF(), "LabelsCenter", (long) QtCharts::QAbstractBarSeries::LabelsPosition::LabelsCenter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_LABELSPOSITION_IDX],
        Sbk_QtCharts_QAbstractBarSeries_TypeF(), "LabelsInsideEnd", (long) QtCharts::QAbstractBarSeries::LabelsPosition::LabelsInsideEnd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_LABELSPOSITION_IDX],
        Sbk_QtCharts_QAbstractBarSeries_TypeF(), "LabelsInsideBase", (long) QtCharts::QAbstractBarSeries::LabelsPosition::LabelsInsideBase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_LABELSPOSITION_IDX],
        Sbk_QtCharts_QAbstractBarSeries_TypeF(), "LabelsOutsideEnd", (long) QtCharts::QAbstractBarSeries::LabelsPosition::LabelsOutsideEnd))
        return;
    // Register converter for enum 'QtCharts::QAbstractBarSeries::LabelsPosition'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_LABELSPOSITION_IDX],
            QtCharts_QAbstractBarSeries_LabelsPosition_CppToPython_QtCharts_QAbstractBarSeries_LabelsPosition);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtCharts_QAbstractBarSeries_LabelsPosition_PythonToCpp_QtCharts_QAbstractBarSeries_LabelsPosition,
            is_QtCharts_QAbstractBarSeries_LabelsPosition_PythonToCpp_QtCharts_QAbstractBarSeries_LabelsPosition_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTBARSERIES_LABELSPOSITION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtCharts::QAbstractBarSeries::LabelsPosition");
        Shiboken::Conversions::registerConverterName(converter, "QAbstractBarSeries::LabelsPosition");
        Shiboken::Conversions::registerConverterName(converter, "LabelsPosition");
    }
    // End of 'LabelsPosition' enum.

    PySide::Signal::registerSignals(Sbk_QtCharts_QAbstractBarSeries_TypeF(), &::QtCharts::QAbstractBarSeries::staticMetaObject);
    qRegisterMetaType< ::QtCharts::QAbstractBarSeries::LabelsPosition >("QAbstractBarSeries::LabelsPosition");
    qRegisterMetaType< ::QtCharts::QAbstractBarSeries::LabelsPosition >("QtCharts::QAbstractBarSeries::LabelsPosition");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtCharts_QAbstractBarSeries_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtCharts_QAbstractBarSeries_TypeF(), &::QtCharts::QAbstractBarSeries::staticMetaObject, sizeof(QAbstractBarSeriesWrapper));
}
