/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcharts_python.h"

// main header
#include "qtcharts_qboxplotseries_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtCharts;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QBoxPlotSeriesWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QBoxPlotSeriesWrapper::QBoxPlotSeriesWrapper(::QObject * parent) : QtCharts::QBoxPlotSeries(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QBoxPlotSeriesWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QBoxPlotSeriesWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QBoxPlotSeriesWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QBoxPlotSeriesWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QBoxPlotSeriesWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxPlotSeries.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QBoxPlotSeriesWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxPlotSeries.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QBoxPlotSeriesWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QtCharts::QAbstractSeries::SeriesType QBoxPlotSeriesWrapper::type() const
{
    if (m_PyMethodCache[8])
        return this->::QtCharts::QBoxPlotSeries::type();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QtCharts::QAbstractSeries::SeriesTypeLine;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "type";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QtCharts::QBoxPlotSeries::type();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QtCharts::QAbstractSeries::SeriesTypeLine;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTSERIES_SERIESTYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QBoxPlotSeries.type", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QtCharts::QAbstractSeries::SeriesType >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QtCharts::QAbstractSeries::SeriesTypeLine;
    }
    ::QtCharts::QAbstractSeries::SeriesType cppResult{QtCharts::QAbstractSeries::SeriesTypeLine};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QBoxPlotSeriesWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtCharts::QBoxPlotSeries::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QBoxPlotSeriesWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtCharts::QBoxPlotSeries::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QBoxPlotSeriesWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QBoxPlotSeriesWrapper *>(this));
        return QtCharts::QBoxPlotSeries::qt_metacast(_clname);
}

QBoxPlotSeriesWrapper::~QBoxPlotSeriesWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QtCharts_QBoxPlotSeries_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QtCharts::QBoxPlotSeries >()))
        return -1;

    ::QBoxPlotSeriesWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QBoxPlotSeries", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QBoxPlotSeries::QBoxPlotSeries(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QBoxPlotSeries(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QBoxPlotSeries(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QBoxPlotSeries_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QBoxPlotSeries_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QtCharts_QBoxPlotSeries_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QBoxPlotSeries(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QBoxPlotSeriesWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QBoxPlotSeriesWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QtCharts::QBoxPlotSeries >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QtCharts_QBoxPlotSeries_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QtCharts_QBoxPlotSeries_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QtCharts_QBoxPlotSeries_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_append(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.append";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBoxPlotSeries::append(QList<QtCharts::QBoxSet*>)
    // 1: QBoxPlotSeries::append(QtCharts::QBoxSet*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXSET_IDX]), (pyArg)))) {
        overloadId = 1; // append(QtCharts::QBoxSet*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QBOXSETPTR_IDX], (pyArg)))) {
        overloadId = 0; // append(QList<QtCharts::QBoxSet*>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QBoxPlotSeriesFunc_append_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // append(QList<QtCharts::QBoxSet* > boxes)
        {
            ::QList<QtCharts::QBoxSet* > cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // append(QList<QtCharts::QBoxSet*>)
                bool cppResult = cppSelf->append(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
                Shiboken::Object::setParent(self, pyArg);
            }
            break;
        }
        case 1: // append(QtCharts::QBoxSet * box)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QtCharts::QBoxSet *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // append(QtCharts::QBoxSet*)
                bool cppResult = cppSelf->append(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
                Shiboken::Object::setParent(self, pyArg);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtCharts_QBoxPlotSeriesFunc_append_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_boxOutlineVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.boxOutlineVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // boxOutlineVisible()
            bool cppResult = cppSelf->boxOutlineVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_boxSets(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.boxSets";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // boxSets()const
            QList<QtCharts::QBoxSet* > cppResult = const_cast<const ::QtCharts::QBoxPlotSeries *>(cppSelf)->boxSets();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtChartsTypeConverters[SBK_QTCHARTS_QLIST_QTCHARTS_QBOXSETPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_boxWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.boxWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // boxWidth()
            qreal cppResult = cppSelf->boxWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_brush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.brush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // brush()const
            QBrush cppResult = const_cast<const ::QtCharts::QBoxPlotSeries *>(cppSelf)->brush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.count";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // count()const
            int cppResult = const_cast<const ::QtCharts::QBoxPlotSeries *>(cppSelf)->count();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_insert(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.insert";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insert", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QBoxPlotSeries::insert(int,QtCharts::QBoxSet*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXSET_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insert(int,QtCharts::QBoxSet*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QBoxPlotSeriesFunc_insert_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QtCharts::QBoxSet *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // insert(int,QtCharts::QBoxSet*)
            bool cppResult = cppSelf->insert(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            Shiboken::Object::setParent(self, pyArgs[1]);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtCharts_QBoxPlotSeriesFunc_insert_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_pen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.pen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pen()const
            QPen cppResult = const_cast<const ::QtCharts::QBoxPlotSeries *>(cppSelf)->pen();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_remove(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.remove";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBoxPlotSeries::remove(QtCharts::QBoxSet*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXSET_IDX]), (pyArg)))) {
        overloadId = 0; // remove(QtCharts::QBoxSet*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QBoxPlotSeriesFunc_remove_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtCharts::QBoxSet *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // remove(QtCharts::QBoxSet*)
            bool cppResult = cppSelf->remove(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtCharts_QBoxPlotSeriesFunc_remove_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_setBoxOutlineVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.setBoxOutlineVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBoxPlotSeries::setBoxOutlineVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setBoxOutlineVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QBoxPlotSeriesFunc_setBoxOutlineVisible_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBoxOutlineVisible(bool)
            cppSelf->setBoxOutlineVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QBoxPlotSeriesFunc_setBoxOutlineVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_setBoxWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.setBoxWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBoxPlotSeries::setBoxWidth(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setBoxWidth(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QBoxPlotSeriesFunc_setBoxWidth_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBoxWidth(qreal)
            cppSelf->setBoxWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QBoxPlotSeriesFunc_setBoxWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_setBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.setBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBoxPlotSeries::setBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QBoxPlotSeriesFunc_setBrush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBrush(QBrush)
            cppSelf->setBrush(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QBoxPlotSeriesFunc_setBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_setPen(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.setPen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBoxPlotSeries::setPen(QPen)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArg)))) {
        overloadId = 0; // setPen(QPen)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QBoxPlotSeriesFunc_setPen_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPen cppArg0_local;
        ::QPen *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPen(QPen)
            cppSelf->setPen(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QBoxPlotSeriesFunc_setPen_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_take(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.take";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBoxPlotSeries::take(QtCharts::QBoxSet*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXSET_IDX]), (pyArg)))) {
        overloadId = 0; // take(QtCharts::QBoxSet*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QBoxPlotSeriesFunc_take_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtCharts::QBoxSet *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // take(QtCharts::QBoxSet*)
            bool cppResult = cppSelf->take(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtCharts_QBoxPlotSeriesFunc_take_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QBoxPlotSeriesFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QBoxPlotSeries.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QtCharts::QAbstractSeries::SeriesType cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QtCharts::QBoxPlotSeries *>(cppSelf)->::QtCharts::QBoxPlotSeries::type()
                : const_cast<const ::QtCharts::QBoxPlotSeries *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTSERIES_SERIESTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QtCharts_QBoxPlotSeries_PropertyStrings[] = {
    "boxOutlineVisible::",
    "boxWidth::",
    "brush::",
    "count:",
    "pen::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtCharts_QBoxPlotSeries_methods[] = {
    {"append", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_append), METH_O},
    {"boxOutlineVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_boxOutlineVisible), METH_NOARGS},
    {"boxSets", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_boxSets), METH_NOARGS},
    {"boxWidth", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_boxWidth), METH_NOARGS},
    {"brush", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_brush), METH_NOARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_clear), METH_NOARGS},
    {"count", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_count), METH_NOARGS},
    {"insert", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_insert), METH_VARARGS},
    {"pen", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_pen), METH_NOARGS},
    {"remove", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_remove), METH_O},
    {"setBoxOutlineVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_setBoxOutlineVisible), METH_O},
    {"setBoxWidth", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_setBoxWidth), METH_O},
    {"setBrush", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_setBrush), METH_O},
    {"setPen", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_setPen), METH_O},
    {"take", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_take), METH_O},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QBoxPlotSeriesFunc_type), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtCharts_QBoxPlotSeries_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtCharts::QBoxPlotSeries *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QBoxPlotSeriesWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtCharts_QBoxPlotSeries_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtCharts_QBoxPlotSeries_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtCharts_QBoxPlotSeries_Type = nullptr;
static SbkObjectType *Sbk_QtCharts_QBoxPlotSeries_TypeF(void)
{
    return _Sbk_QtCharts_QBoxPlotSeries_Type;
}

static PyType_Slot Sbk_QtCharts_QBoxPlotSeries_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtCharts_QBoxPlotSeries_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtCharts_QBoxPlotSeries_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtCharts_QBoxPlotSeries_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtCharts_QBoxPlotSeries_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QtCharts_QBoxPlotSeries_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtCharts_QBoxPlotSeries_spec = {
    "2:PySide2.QtCharts.QtCharts.QBoxPlotSeries",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtCharts_QBoxPlotSeries_slots
};

} //extern "C"

static void *Sbk_QtCharts_QBoxPlotSeries_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtCharts::QBoxPlotSeries *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QBoxPlotSeries_PythonToCpp_QBoxPlotSeries_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtCharts_QBoxPlotSeries_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QBoxPlotSeries_PythonToCpp_QBoxPlotSeries_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtCharts_QBoxPlotSeries_TypeF())))
        return QBoxPlotSeries_PythonToCpp_QBoxPlotSeries_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QBoxPlotSeries_PTR_CppToPython_QBoxPlotSeries(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtCharts::QBoxPlotSeries *>(const_cast<void *>(cppIn)), Sbk_QtCharts_QBoxPlotSeries_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtCharts_QBoxPlotSeries_SignatureStrings[] = {
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries(self,parent:PySide2.QtCore.QObject=nullptr)",
    "1:PySide2.QtCharts.QtCharts.QBoxPlotSeries.append(self,boxes:QList[PySide2.QtCharts.QtCharts.QBoxSet])->bool",
    "0:PySide2.QtCharts.QtCharts.QBoxPlotSeries.append(self,box:PySide2.QtCharts.QtCharts.QBoxSet)->bool",
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries.boxOutlineVisible(self)->bool",
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries.boxSets(self)->QList[PySide2.QtCharts.QtCharts.QBoxSet]",
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries.boxWidth(self)->qreal",
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries.brush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries.clear(self)",
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries.count(self)->int",
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries.insert(self,index:int,box:PySide2.QtCharts.QtCharts.QBoxSet)->bool",
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries.pen(self)->PySide2.QtGui.QPen",
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries.remove(self,box:PySide2.QtCharts.QtCharts.QBoxSet)->bool",
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries.setBoxOutlineVisible(self,visible:bool)",
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries.setBoxWidth(self,width:qreal)",
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries.setBrush(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries.setPen(self,pen:PySide2.QtGui.QPen)",
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries.take(self,box:PySide2.QtCharts.QtCharts.QBoxSet)->bool",
    "PySide2.QtCharts.QtCharts.QBoxPlotSeries.type(self)->PySide2.QtCharts.QtCharts.QAbstractSeries.SeriesType",
    nullptr}; // Sentinel

void init_QtCharts_QBoxPlotSeries(PyObject *enclosingClass)
{
    _Sbk_QtCharts_QBoxPlotSeries_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QBoxPlotSeries",
        "QtCharts::QBoxPlotSeries*",
        &Sbk_QtCharts_QBoxPlotSeries_spec,
        &Shiboken::callCppDestructor< ::QtCharts::QBoxPlotSeries >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTSERIES_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtCharts_QBoxPlotSeries_Type);
    InitSignatureStrings(pyType, QtCharts_QBoxPlotSeries_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtCharts_QBoxPlotSeries_Type), Sbk_QtCharts_QBoxPlotSeries_PropertyStrings);
    SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QBOXPLOTSERIES_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtCharts_QBoxPlotSeries_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtCharts_QBoxPlotSeries_TypeF(),
        QBoxPlotSeries_PythonToCpp_QBoxPlotSeries_PTR,
        is_QBoxPlotSeries_PythonToCpp_QBoxPlotSeries_PTR_Convertible,
        QBoxPlotSeries_PTR_CppToPython_QBoxPlotSeries);

    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QBoxPlotSeries");
    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QBoxPlotSeries*");
    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QBoxPlotSeries&");
    Shiboken::Conversions::registerConverterName(converter, "QBoxPlotSeries");
    Shiboken::Conversions::registerConverterName(converter, "QBoxPlotSeries*");
    Shiboken::Conversions::registerConverterName(converter, "QBoxPlotSeries&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtCharts::QBoxPlotSeries).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QBoxPlotSeriesWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtCharts_QBoxPlotSeries_TypeF(), &Sbk_QtCharts_QBoxPlotSeries_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QtCharts_QBoxPlotSeries_TypeF(), &::QtCharts::QBoxPlotSeries::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtCharts_QBoxPlotSeries_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtCharts_QBoxPlotSeries_TypeF(), &::QtCharts::QBoxPlotSeries::staticMetaObject, sizeof(QBoxPlotSeriesWrapper));
}
