/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QCHARTVIEWWRAPPER_H
#define SBK_QCHARTVIEWWRAPPER_H

#define protected public

#include <QtCharts/qchartview.h>


// Extra includes
#include <qobject.h>
#include <QtWidgets/qwidget.h>
#include <QtCharts/qchart.h>
#include <QtGui/qevent.h>
#include <QtGui/qpaintdevice.h>
#include <qpoint.h>
#include <QList>
#include <QtWidgets/qgraphicsitem.h>
#include <qrect.h>
#include <QtGui/qpainter.h>
#include <qmetaobject.h>
#include <qbytearray.h>
#include <qsize.h>
#include <QtGui/qpolygon.h>
#include <QtGui/qtransform.h>
#include <QtGui/qmatrix.h>
#include <qcoreevent.h>
#include <QtGui/qpainterpath.h>
#include <QtWidgets/qgraphicsscene.h>
#include <QtGui/qbrush.h>
#include <QtGui/qpaintengine.h>
#include <qobjectdefs.h>
namespace PySide { class DynamicQMetaObject; }

class QChartViewWrapper : public QtCharts::QChartView
{
public:
    QChartViewWrapper(::QWidget * parent = nullptr);
    QChartViewWrapper(::QtCharts::QChart * chart, ::QWidget * parent = nullptr);
    void actionEvent(::QActionEvent * event) override;
    void changeEvent(::QEvent * arg__1) override;
    void childEvent(::QChildEvent * event) override;
    void closeEvent(::QCloseEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void contextMenuEvent(::QContextMenuEvent * event) override;
    void customEvent(::QEvent * event) override;
    int devType() const override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent(::QDragEnterEvent * event) override;
    void dragLeaveEvent(::QDragLeaveEvent * event) override;
    void dragMoveEvent(::QDragMoveEvent * event) override;
    void drawBackground(::QPainter * painter, const ::QRectF & rect) override;
    void drawForeground(::QPainter * painter, const ::QRectF & rect) override;
    void drawItems(::QPainter * painter, int numItems, ::QGraphicsItem * items[], const ::QStyleOptionGraphicsItem options[]) override;
    void dropEvent(::QDropEvent * event) override;
    void enterEvent(::QEvent * event) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * arg__1, ::QEvent * arg__2) override;
    void focusInEvent(::QFocusEvent * event) override;
    bool focusNextPrevChild(bool next) override;
    void focusOutEvent(::QFocusEvent * event) override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void hideEvent(::QHideEvent * event) override;
    void initPainter(::QPainter * painter) const override;
    void inputMethodEvent(::QInputMethodEvent * event) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery query) const override;
    void keyPressEvent(::QKeyEvent * event) override;
    void keyReleaseEvent(::QKeyEvent * event) override;
    void leaveEvent(::QEvent * event) override;
    const ::QMetaObject * metaObject() const override;
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    ::QSize minimumSizeHint() const override;
    void mouseDoubleClickEvent(::QMouseEvent * event) override;
    void mouseMoveEvent(::QMouseEvent * event) override;
    void mousePressEvent(::QMouseEvent * event) override;
    void mouseReleaseEvent(::QMouseEvent * event) override;
    void moveEvent(::QMoveEvent * event) override;
    bool nativeEvent(const ::QByteArray & eventType, void * message, long * result) override;
    ::QPaintEngine * paintEngine() const override;
    void paintEvent(::QPaintEvent * event) override;
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    void resizeEvent(::QResizeEvent * event) override;
    void scrollContentsBy(int dx, int dy) override;
    void setVisible(bool visible) override;
    void setupViewport(::QWidget * widget) override;
    ::QPainter * sharedPainter() const override;
    void showEvent(::QShowEvent * event) override;
    ::QSize sizeHint() const override;
    void tabletEvent(::QTabletEvent * event) override;
    void timerEvent(::QTimerEvent * event) override;
    bool viewportEvent(::QEvent * event) override;
    ::QSize viewportSizeHint() const override;
    void wheelEvent(::QWheelEvent * event) override;
    ~QChartViewWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[55];
};

#endif // SBK_QCHARTVIEWWRAPPER_H

