/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <algorithm>
#include <set>
#include <iterator>

// module include
#include "pyside2_qtcharts_python.h"

// main header
#include "qtcharts_qpolarchart_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtCharts;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QPolarChartWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QPolarChartWrapper::QPolarChartWrapper(::QGraphicsItem * parent, ::QFlags<Qt::WindowType> wFlags) : QtCharts::QPolarChart(parent, wFlags)
{
    resetPyMethodCache();
    // ... middle
}

void QPolarChartWrapper::advance(int phase)
{
    if (m_PyMethodCache[0]) {
        return this->::QGraphicsItem::advance(phase);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "advance";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QGraphicsItem::advance(phase);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    phase
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QRectF QPolarChartWrapper::boundingRect() const
{
    if (m_PyMethodCache[1])
        return this->::QGraphicsWidget::boundingRect();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "boundingRect";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QGraphicsWidget::boundingRect();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.boundingRect", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRectF >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRectF cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPolarChartWrapper::changeEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QGraphicsWidget::changeEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "changeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QGraphicsWidget::changeEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QPolarChartWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QPolarChartWrapper::closeEvent(::QCloseEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QGraphicsWidget::closeEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "closeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QGraphicsWidget::closeEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCLOSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QPolarChartWrapper::collidesWithItem(const ::QGraphicsItem * other, ::Qt::ItemSelectionMode mode) const
{
    if (m_PyMethodCache[5])
        return this->::QGraphicsItem::collidesWithItem(other, mode);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "collidesWithItem";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QGraphicsItem::collidesWithItem(other, mode);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), other),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, &mode)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.collidesWithItem", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QPolarChartWrapper::collidesWithPath(const ::QPainterPath & path, ::Qt::ItemSelectionMode mode) const
{
    if (m_PyMethodCache[6])
        return this->::QGraphicsItem::collidesWithPath(path, mode);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "collidesWithPath";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QGraphicsItem::collidesWithPath(path, mode);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), &path),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])->converter, &mode)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.collidesWithPath", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPolarChartWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QPolarChartWrapper::contains(const ::QPointF & point) const
{
    if (m_PyMethodCache[8])
        return this->::QGraphicsItem::contains(point);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "contains";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QGraphicsItem::contains(point);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &point)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.contains", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPolarChartWrapper::contextMenuEvent(::QGraphicsSceneContextMenuEvent * event)
{
    if (m_PyMethodCache[9]) {
        return this->::QGraphicsItem::contextMenuEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "contextMenuEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QGraphicsItem::contextMenuEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENECONTEXTMENUEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[10]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QPolarChartWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[11]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::dragEnterEvent(::QGraphicsSceneDragDropEvent * event)
{
    if (m_PyMethodCache[12]) {
        return this->::QGraphicsItem::dragEnterEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragEnterEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QGraphicsItem::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::dragLeaveEvent(::QGraphicsSceneDragDropEvent * event)
{
    if (m_PyMethodCache[13]) {
        return this->::QGraphicsItem::dragLeaveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragLeaveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QGraphicsItem::dragLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::dragMoveEvent(::QGraphicsSceneDragDropEvent * event)
{
    if (m_PyMethodCache[14]) {
        return this->::QGraphicsItem::dragMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QGraphicsItem::dragMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::dropEvent(::QGraphicsSceneDragDropEvent * event)
{
    if (m_PyMethodCache[15]) {
        return this->::QGraphicsItem::dropEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dropEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QGraphicsItem::dropEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QPolarChartWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[16])
        return this->::QGraphicsWidget::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QGraphicsWidget::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QPolarChartWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[17])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QVariant QPolarChartWrapper::extension(const ::QVariant & variant) const
{
    if (m_PyMethodCache[18])
        return this->::QGraphicsItem::extension(variant);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "extension";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QGraphicsItem::extension(variant);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &variant)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.extension", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPolarChartWrapper::focusInEvent(::QFocusEvent * event)
{
    if (m_PyMethodCache[19]) {
        return this->::QGraphicsWidget::focusInEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusInEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QGraphicsWidget::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QPolarChartWrapper::focusNextPrevChild(bool next)
{
    if (m_PyMethodCache[20])
        return this->::QGraphicsWidget::focusNextPrevChild(next);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusNextPrevChild";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QGraphicsWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &next)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.focusNextPrevChild", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPolarChartWrapper::focusOutEvent(::QFocusEvent * event)
{
    if (m_PyMethodCache[21]) {
        return this->::QGraphicsWidget::focusOutEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusOutEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QGraphicsWidget::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::getContentsMargins(qreal * left, qreal * top, qreal * right, qreal * bottom) const
{
    if (m_PyMethodCache[22]) {
        return this->::QGraphicsWidget::getContentsMargins(left, top, right, bottom);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "getContentsMargins";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QGraphicsWidget::getContentsMargins(left, top, right, bottom);
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }

}

void QPolarChartWrapper::grabKeyboardEvent(::QEvent * event)
{
    if (m_PyMethodCache[23]) {
        return this->::QGraphicsWidget::grabKeyboardEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "grabKeyboardEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QGraphicsWidget::grabKeyboardEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QPolarChartWrapper::grabMouseEvent(::QEvent * event)
{
    if (m_PyMethodCache[24]) {
        return this->::QGraphicsWidget::grabMouseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "grabMouseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QGraphicsWidget::grabMouseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QPolarChartWrapper::hideEvent(::QHideEvent * event)
{
    if (m_PyMethodCache[25]) {
        return this->::QGraphicsWidget::hideEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hideEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        return this->::QGraphicsWidget::hideEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHIDEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QPolarChartWrapper::hoverEnterEvent(::QGraphicsSceneHoverEvent * event)
{
    if (m_PyMethodCache[26]) {
        return this->::QGraphicsItem::hoverEnterEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hoverEnterEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QGraphicsItem::hoverEnterEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEHOVEREVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::hoverLeaveEvent(::QGraphicsSceneHoverEvent * event)
{
    if (m_PyMethodCache[27]) {
        return this->::QGraphicsWidget::hoverLeaveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hoverLeaveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        return this->::QGraphicsWidget::hoverLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEHOVEREVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::hoverMoveEvent(::QGraphicsSceneHoverEvent * event)
{
    if (m_PyMethodCache[28]) {
        return this->::QGraphicsWidget::hoverMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hoverMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[28] = true;
        return this->::QGraphicsWidget::hoverMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEHOVEREVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::initStyleOption(::QStyleOption * option) const
{
    if (m_PyMethodCache[29]) {
        return this->::QGraphicsWidget::initStyleOption(option);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initStyleOption";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[29] = true;
        return this->::QGraphicsWidget::initStyleOption(option);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), option)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    if (m_PyMethodCache[30]) {
        return this->::QGraphicsItem::inputMethodEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[30] = true;
        return this->::QGraphicsItem::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QVariant QPolarChartWrapper::inputMethodQuery(::Qt::InputMethodQuery query) const
{
    if (m_PyMethodCache[31])
        return this->::QGraphicsItem::inputMethodQuery(query);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodQuery";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[31] = true;
        return this->::QGraphicsItem::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])->converter, &query)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.inputMethodQuery", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QPolarChartWrapper::isObscuredBy(const ::QGraphicsItem * item) const
{
    if (m_PyMethodCache[32])
        return this->::QGraphicsItem::isObscuredBy(item);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isObscuredBy";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[32] = true;
        return this->::QGraphicsItem::isObscuredBy(item);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), item)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.isObscuredBy", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QVariant QPolarChartWrapper::itemChange(::QGraphicsItem::GraphicsItemChange change, const ::QVariant & value)
{
    if (m_PyMethodCache[33])
        return this->::QGraphicsWidget::itemChange(change, value);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "itemChange";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[33] = true;
        return this->::QGraphicsWidget::itemChange(change, value);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_GRAPHICSITEMCHANGE_IDX])->converter, &change),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.itemChange", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPolarChartWrapper::keyPressEvent(::QKeyEvent * event)
{
    if (m_PyMethodCache[34]) {
        return this->::QGraphicsItem::keyPressEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyPressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[34] = true;
        return this->::QGraphicsItem::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    if (m_PyMethodCache[35]) {
        return this->::QGraphicsItem::keyReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[35] = true;
        return this->::QGraphicsItem::keyReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::mouseDoubleClickEvent(::QGraphicsSceneMouseEvent * event)
{
    if (m_PyMethodCache[37]) {
        return this->::QGraphicsItem::mouseDoubleClickEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseDoubleClickEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[37] = true;
        return this->::QGraphicsItem::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::mouseMoveEvent(::QGraphicsSceneMouseEvent * event)
{
    if (m_PyMethodCache[38]) {
        return this->::QGraphicsItem::mouseMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[38] = true;
        return this->::QGraphicsItem::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::mousePressEvent(::QGraphicsSceneMouseEvent * event)
{
    if (m_PyMethodCache[39]) {
        return this->::QGraphicsItem::mousePressEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mousePressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[39] = true;
        return this->::QGraphicsItem::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::mouseReleaseEvent(::QGraphicsSceneMouseEvent * event)
{
    if (m_PyMethodCache[40]) {
        return this->::QGraphicsItem::mouseReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[40] = true;
        return this->::QGraphicsItem::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::moveEvent(::QGraphicsSceneMoveEvent * event)
{
    if (m_PyMethodCache[41]) {
        return this->::QGraphicsWidget::moveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "moveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[41] = true;
        return this->::QGraphicsWidget::moveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEMOVEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QPainterPath QPolarChartWrapper::opaqueArea() const
{
    if (m_PyMethodCache[42])
        return this->::QGraphicsItem::opaqueArea();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "opaqueArea";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[42] = true;
        return this->::QGraphicsItem::opaqueArea();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.opaqueArea", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPainterPath >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QPainterPath cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPolarChartWrapper::paint(::QPainter * painter, const ::QStyleOptionGraphicsItem * option, ::QWidget * widget)
{
    if (m_PyMethodCache[43]) {
        return this->::QGraphicsWidget::paint(painter, option, widget);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[43] = true;
        return this->::QGraphicsWidget::paint(painter, option, widget);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_IDX]), option),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::paintWindowFrame(::QPainter * painter, const ::QStyleOptionGraphicsItem * option, ::QWidget * widget)
{
    if (m_PyMethodCache[44]) {
        return this->::QGraphicsWidget::paintWindowFrame(painter, option, widget);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paintWindowFrame";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[44] = true;
        return this->::QGraphicsWidget::paintWindowFrame(painter, option, widget);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONGRAPHICSITEM_IDX]), option),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QPolarChartWrapper::polishEvent()
{
    if (m_PyMethodCache[45]) {
        return this->::QGraphicsWidget::polishEvent();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "polishEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[45] = true;
        return this->::QGraphicsWidget::polishEvent();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QVariant QPolarChartWrapper::propertyChange(const ::QString & propertyName, const ::QVariant & value)
{
    if (m_PyMethodCache[46])
        return this->::QGraphicsWidget::propertyChange(propertyName, value);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "propertyChange";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[46] = true;
        return this->::QGraphicsWidget::propertyChange(propertyName, value);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &propertyName),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.propertyChange", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPolarChartWrapper::resizeEvent(::QGraphicsSceneResizeEvent * event)
{
    if (m_PyMethodCache[47]) {
        return this->::QGraphicsWidget::resizeEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "resizeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[47] = true;
        return this->::QGraphicsWidget::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENERESIZEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QPolarChartWrapper::sceneEvent(::QEvent * event)
{
    if (m_PyMethodCache[48])
        return this->::QGraphicsWidget::sceneEvent(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sceneEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[48] = true;
        return this->::QGraphicsWidget::sceneEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.sceneEvent", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QPolarChartWrapper::sceneEventFilter(::QGraphicsItem * watched, ::QEvent * event)
{
    if (m_PyMethodCache[49])
        return this->::QGraphicsItem::sceneEventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sceneEventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[49] = true;
        return this->::QGraphicsItem::sceneEventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.sceneEventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPolarChartWrapper::setGeometry(const ::QRectF & rect)
{
    if (m_PyMethodCache[50]) {
        return this->::QGraphicsWidget::setGeometry(rect);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    // This method belongs to a property.
    static const char *funcName = "2:setGeometry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[50] = true;
        return this->::QGraphicsWidget::setGeometry(rect);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &rect)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QPainterPath QPolarChartWrapper::shape() const
{
    if (m_PyMethodCache[51])
        return this->::QGraphicsWidget::shape();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "shape";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[51] = true;
        return this->::QGraphicsWidget::shape();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.shape", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPainterPath >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QPainterPath cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPolarChartWrapper::showEvent(::QShowEvent * event)
{
    if (m_PyMethodCache[52]) {
        return this->::QGraphicsWidget::showEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "showEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[52] = true;
        return this->::QGraphicsWidget::showEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSHOWEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QSizeF QPolarChartWrapper::sizeHint(::Qt::SizeHint which, const ::QSizeF & constraint) const
{
    if (m_PyMethodCache[53])
        return this->::QGraphicsWidget::sizeHint(which, constraint);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sizeHint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[53] = true;
        return this->::QGraphicsWidget::sizeHint(which, constraint);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SIZEHINT_IDX])->converter, &which),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &constraint)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.sizeHint", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSizeF >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSizeF cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPolarChartWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[54]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[54] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

int QPolarChartWrapper::type() const
{
    if (m_PyMethodCache[55])
        return this->::QGraphicsWidget::type();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "type";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[55] = true;
        return this->::QGraphicsWidget::type();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.type", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPolarChartWrapper::ungrabKeyboardEvent(::QEvent * event)
{
    if (m_PyMethodCache[56]) {
        return this->::QGraphicsWidget::ungrabKeyboardEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "ungrabKeyboardEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[56] = true;
        return this->::QGraphicsWidget::ungrabKeyboardEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QPolarChartWrapper::ungrabMouseEvent(::QEvent * event)
{
    if (m_PyMethodCache[57]) {
        return this->::QGraphicsWidget::ungrabMouseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "ungrabMouseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[57] = true;
        return this->::QGraphicsWidget::ungrabMouseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QPolarChartWrapper::updateGeometry()
{
    if (m_PyMethodCache[58]) {
        return this->::QGraphicsWidget::updateGeometry();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updateGeometry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[58] = true;
        return this->::QGraphicsWidget::updateGeometry();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPolarChartWrapper::wheelEvent(::QGraphicsSceneWheelEvent * event)
{
    if (m_PyMethodCache[59]) {
        return this->::QGraphicsItem::wheelEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "wheelEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[59] = true;
        return this->::QGraphicsItem::wheelEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEWHEELEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QPolarChartWrapper::windowFrameEvent(::QEvent * e)
{
    if (m_PyMethodCache[60])
        return this->::QGraphicsWidget::windowFrameEvent(e);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "windowFrameEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[60] = true;
        return this->::QGraphicsWidget::windowFrameEvent(e);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), e)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.windowFrameEvent", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

::Qt::WindowFrameSection QPolarChartWrapper::windowFrameSectionAt(const ::QPointF & pos) const
{
    if (m_PyMethodCache[61])
        return this->::QGraphicsWidget::windowFrameSectionAt(pos);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return Qt::NoSection;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "windowFrameSectionAt";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[61] = true;
        return this->::QGraphicsWidget::windowFrameSectionAt(pos);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &pos)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return Qt::NoSection;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPolarChart.windowFrameSectionAt", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< Qt::WindowFrameSection >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return Qt::NoSection;
    }
    ::Qt::WindowFrameSection cppResult{Qt::NoSection};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QPolarChartWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtCharts::QPolarChart::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QPolarChartWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtCharts::QPolarChart::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QPolarChartWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QPolarChartWrapper *>(this));
        return QtCharts::QPolarChart::qt_metacast(_clname);
}

QPolarChartWrapper::~QPolarChartWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QtCharts_QPolarChart_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QtCharts::QPolarChart >()))
        return -1;

    ::QPolarChartWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPolarChart.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QPolarChart", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QPolarChart::QPolarChart(QGraphicsItem*,QFlags<Qt::WindowType>)
    if (numArgs == 0) {
        overloadId = 0; // QPolarChart(QGraphicsItem*,QFlags<Qt::WindowType>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QPolarChart(QGraphicsItem*,QFlags<Qt::WindowType>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // QPolarChart(QGraphicsItem*,QFlags<Qt::WindowType>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPolarChart_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QPolarChart_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), (pyArgs[0]))))
                        goto Sbk_QtCharts_QPolarChart_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            static PyObject *const key_wFlags = Shiboken::String::createStaticString("wFlags");
            if (PyDict_Contains(kwds, key_wFlags)) {
                value = PyDict_GetItem(kwds, key_wFlags);
                if (value && pyArgs[1]) {
                    errInfo = key_wFlags;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QPolarChart_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QtCharts_QPolarChart_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_wFlags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QGraphicsItem *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<Qt::WindowType> cppArg1 = Qt::WindowFlags();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QPolarChart(QGraphicsItem*,QFlags<Qt::WindowType>)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QPolarChartWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QPolarChartWrapper(cppArg0, cppArg1);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QtCharts::QPolarChart >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QtCharts_QPolarChart_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QtCharts_QPolarChart_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QtCharts_QPolarChart_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QtCharts_QPolarChartFunc_addAxis(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPolarChart *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPOLARCHART_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPolarChart.addAxis";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addAxis", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPolarChart::addAxis(QtCharts::QAbstractAxis*,QtCharts::QPolarChart::PolarOrientation)
    // 1: QChart::addAxis(QtCharts::QAbstractAxis*,QFlags<Qt::AlignmentFlag>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // addAxis(QtCharts::QAbstractAxis*,QFlags<Qt::AlignmentFlag>)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // addAxis(QtCharts::QAbstractAxis*,QtCharts::QPolarChart::PolarOrientation)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPolarChartFunc_addAxis_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addAxis(QtCharts::QAbstractAxis * axis, QtCharts::QPolarChart::PolarOrientation polarOrientation)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QtCharts::QAbstractAxis *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QtCharts::QPolarChart::PolarOrientation cppArg1 = static_cast< ::QtCharts::QPolarChart::PolarOrientation>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addAxis(QtCharts::QAbstractAxis*,QtCharts::QPolarChart::PolarOrientation)
                cppSelf->addAxis(cppArg0, cppArg1);
                Shiboken::Object::setParent(self, pyArgs[0]);
            }
            break;
        }
        case 1: // addAxis(QtCharts::QAbstractAxis * axis, QFlags<Qt::AlignmentFlag> alignment)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QtCharts::QAbstractAxis *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<Qt::AlignmentFlag> cppArg1 = QFlags<Qt::AlignmentFlag>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addAxis(QtCharts::QAbstractAxis*,QFlags<Qt::AlignmentFlag>)
                reinterpret_cast<QtCharts::QChart *>(cppSelf)->addAxis(cppArg0, cppArg1);
                Shiboken::Object::setParent(self, pyArgs[0]);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPolarChartFunc_addAxis_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPolarChartFunc_axisPolarOrientation(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPolarChart.axisPolarOrientation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QPolarChart::axisPolarOrientation(QtCharts::QAbstractAxis*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QABSTRACTAXIS_IDX]), (pyArg)))) {
        overloadId = 0; // axisPolarOrientation(QtCharts::QAbstractAxis*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPolarChartFunc_axisPolarOrientation_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QtCharts::QAbstractAxis *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // axisPolarOrientation(QtCharts::QAbstractAxis*)
            QtCharts::QPolarChart::PolarOrientation cppResult = ::QtCharts::QPolarChart::axisPolarOrientation(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QtCharts_QPolarChartFunc_axisPolarOrientation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QtCharts_QPolarChart_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtCharts_QPolarChart_methods[] = {
    {"addAxis", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPolarChartFunc_addAxis), METH_VARARGS},
    {"axisPolarOrientation", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPolarChartFunc_axisPolarOrientation), METH_O|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtCharts_QPolarChart_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtCharts::QPolarChart *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPOLARCHART_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QPolarChartWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtCharts_QPolarChart_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtCharts_QPolarChart_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
static void * Sbk_QtCharts_QPolarChartSpecialCastFunction(void *obj, SbkObjectType *desiredType)
{
    auto me = reinterpret_cast< ::QtCharts::QPolarChart *>(obj);
    if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QCHART_IDX]))
        return static_cast< ::QtCharts::QChart *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSWIDGET_IDX]))
        return static_cast< ::QGraphicsWidget *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSOBJECT_IDX]))
        return static_cast< ::QGraphicsObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]))
        return static_cast< ::QGraphicsItem *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX]))
        return static_cast< ::QGraphicsLayoutItem *>(me);
    return me;
}


// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtCharts_QPolarChart_Type = nullptr;
static SbkObjectType *Sbk_QtCharts_QPolarChart_TypeF(void)
{
    return _Sbk_QtCharts_QPolarChart_Type;
}

static PyType_Slot Sbk_QtCharts_QPolarChart_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtCharts_QPolarChart_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtCharts_QPolarChart_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtCharts_QPolarChart_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtCharts_QPolarChart_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QtCharts_QPolarChart_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtCharts_QPolarChart_spec = {
    "2:PySide2.QtCharts.QtCharts.QPolarChart",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtCharts_QPolarChart_slots
};

} //extern "C"

static void *Sbk_QtCharts_QPolarChart_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QGraphicsItem >()))
        return dynamic_cast< ::QtCharts::QPolarChart *>(reinterpret_cast< ::QGraphicsItem *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtCharts::QPolarChart *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QGraphicsLayoutItem >()))
        return dynamic_cast< ::QtCharts::QPolarChart *>(reinterpret_cast< ::QGraphicsLayoutItem *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation___and__(PyObject *self, PyObject *pyArg)
{
    ::QtCharts::QPolarChart::PolarOrientations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QtCharts::QPolarChart::PolarOrientations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QtCharts::QPolarChart::PolarOrientations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QtCharts::QPolarChart::PolarOrientations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QtCharts::QPolarChart::PolarOrientations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QFLAGS_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation___or__(PyObject *self, PyObject *pyArg)
{
    ::QtCharts::QPolarChart::PolarOrientations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QtCharts::QPolarChart::PolarOrientations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QtCharts::QPolarChart::PolarOrientations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QtCharts::QPolarChart::PolarOrientations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QtCharts::QPolarChart::PolarOrientations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QFLAGS_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation___xor__(PyObject *self, PyObject *pyArg)
{
    ::QtCharts::QPolarChart::PolarOrientations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QtCharts::QPolarChart::PolarOrientations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QtCharts::QPolarChart::PolarOrientations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QtCharts::QPolarChart::PolarOrientations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QtCharts::QPolarChart::PolarOrientations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QFLAGS_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation___invert__(PyObject *self, PyObject *pyArg)
{
    ::QtCharts::QPolarChart::PolarOrientations cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QFLAGS_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX])->converter, self, &cppSelf);
    ::QtCharts::QPolarChart::PolarOrientations cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QFLAGS_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QFLAGS_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QFLAGS_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QtCharts_QPolarChart_PolarOrientation_PythonToCpp_QtCharts_QPolarChart_PolarOrientation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtCharts::QPolarChart::PolarOrientation *>(cppOut) =
        static_cast<::QtCharts::QPolarChart::PolarOrientation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtCharts_QPolarChart_PolarOrientation_PythonToCpp_QtCharts_QPolarChart_PolarOrientation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX]))
        return QtCharts_QPolarChart_PolarOrientation_PythonToCpp_QtCharts_QPolarChart_PolarOrientation;
    return {};
}
static PyObject *QtCharts_QPolarChart_PolarOrientation_CppToPython_QtCharts_QPolarChart_PolarOrientation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtCharts::QPolarChart::PolarOrientation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX], castCppIn);

}

static void QFlags_QtCharts_QPolarChart_PolarOrientation__PythonToCpp_QFlags_QtCharts_QPolarChart_PolarOrientation_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QtCharts::QPolarChart::PolarOrientation> *>(cppOut) =
        ::QFlags<QtCharts::QPolarChart::PolarOrientation>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QtCharts_QPolarChart_PolarOrientation__PythonToCpp_QFlags_QtCharts_QPolarChart_PolarOrientation__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtChartsTypes[SBK_QFLAGS_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX]))
        return QFlags_QtCharts_QPolarChart_PolarOrientation__PythonToCpp_QFlags_QtCharts_QPolarChart_PolarOrientation_;
    return {};
}
static PyObject *QFlags_QtCharts_QPolarChart_PolarOrientation__CppToPython_QFlags_QtCharts_QPolarChart_PolarOrientation_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QtCharts::QPolarChart::PolarOrientation> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtChartsTypes[SBK_QFLAGS_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX]));

}

static void QtCharts_QPolarChart_PolarOrientation_PythonToCpp_QFlags_QtCharts_QPolarChart_PolarOrientation_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QtCharts::QPolarChart::PolarOrientation> *>(cppOut) =
        ::QFlags<QtCharts::QPolarChart::PolarOrientation>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QtCharts_QPolarChart_PolarOrientation_PythonToCpp_QFlags_QtCharts_QPolarChart_PolarOrientation__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX]))
        return QtCharts_QPolarChart_PolarOrientation_PythonToCpp_QFlags_QtCharts_QPolarChart_PolarOrientation_;
    return {};
}
static void number_PythonToCpp_QFlags_QtCharts_QPolarChart_PolarOrientation_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QtCharts::QPolarChart::PolarOrientation> *>(cppOut) =
        ::QFlags<QtCharts::QPolarChart::PolarOrientation>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QtCharts_QPolarChart_PolarOrientation__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX]))
        return number_PythonToCpp_QFlags_QtCharts_QPolarChart_PolarOrientation_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPolarChart_PythonToCpp_QPolarChart_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtCharts_QPolarChart_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPolarChart_PythonToCpp_QPolarChart_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtCharts_QPolarChart_TypeF())))
        return QPolarChart_PythonToCpp_QPolarChart_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPolarChart_PTR_CppToPython_QPolarChart(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtCharts::QPolarChart *>(const_cast<void *>(cppIn)), Sbk_QtCharts_QPolarChart_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtCharts_QPolarChart_SignatureStrings[] = {
    "PySide2.QtCharts.QtCharts.QPolarChart(self,parent:PySide2.QtWidgets.QGraphicsItem=nullptr,wFlags:PySide2.QtCore.Qt.WindowFlags=Qt.WindowFlags())",
    "1:PySide2.QtCharts.QtCharts.QPolarChart.addAxis(self,axis:PySide2.QtCharts.QtCharts.QAbstractAxis,polarOrientation:PySide2.QtCharts.QtCharts.QPolarChart.PolarOrientation)",
    "0:PySide2.QtCharts.QtCharts.QPolarChart.addAxis(self,axis:PySide2.QtCharts.QtCharts.QAbstractAxis,alignment:PySide2.QtCore.Qt.Alignment)",
    "PySide2.QtCharts.QtCharts.QPolarChart.axisPolarOrientation(axis:PySide2.QtCharts.QtCharts.QAbstractAxis)->PySide2.QtCharts.QtCharts.QPolarChart.PolarOrientation",
    nullptr}; // Sentinel

void init_QtCharts_QPolarChart(PyObject *enclosingClass)
{
    _Sbk_QtCharts_QPolarChart_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QPolarChart",
        "QtCharts::QPolarChart*",
        &Sbk_QtCharts_QPolarChart_spec,
        &Shiboken::callCppDestructor< ::QtCharts::QPolarChart >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QCHART_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtCharts_QPolarChart_Type);
    InitSignatureStrings(pyType, QtCharts_QPolarChart_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtCharts_QPolarChart_Type), Sbk_QtCharts_QPolarChart_PropertyStrings);
    SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPOLARCHART_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtCharts_QPolarChart_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtCharts_QPolarChart_TypeF(),
        QPolarChart_PythonToCpp_QPolarChart_PTR,
        is_QPolarChart_PythonToCpp_QPolarChart_PTR_Convertible,
        QPolarChart_PTR_CppToPython_QPolarChart);

    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QPolarChart");
    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QPolarChart*");
    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QPolarChart&");
    Shiboken::Conversions::registerConverterName(converter, "QPolarChart");
    Shiboken::Conversions::registerConverterName(converter, "QPolarChart*");
    Shiboken::Conversions::registerConverterName(converter, "QPolarChart&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtCharts::QPolarChart).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPolarChartWrapper).name());


    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSWIDGET_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_QtCharts_QPolarChart_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_QtCharts_QPolarChart_TypeF(), &Sbk_QtCharts_QPolarChartSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtCharts_QPolarChart_TypeF(), &Sbk_QtCharts_QPolarChart_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'PolarOrientation'.
    SbkPySide2_QtChartsTypes[SBK_QFLAGS_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX] = PySide::QFlags::create("2:PySide2.QtCharts.QtCharts.QPolarChart.PolarOrientations", SbkPySide2_QtCharts_QtCharts_QPolarChart_PolarOrientation_number_slots);
    SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtCharts_QPolarChart_TypeF(),
        "PolarOrientation",
        "2:PySide2.QtCharts.QtCharts.QPolarChart.PolarOrientation",
        "QtCharts::QPolarChart::PolarOrientation",
        SbkPySide2_QtChartsTypes[SBK_QFLAGS_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX]);
    if (!SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX],
        Sbk_QtCharts_QPolarChart_TypeF(), "PolarOrientationRadial", (long) QtCharts::QPolarChart::PolarOrientation::PolarOrientationRadial))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX],
        Sbk_QtCharts_QPolarChart_TypeF(), "PolarOrientationAngular", (long) QtCharts::QPolarChart::PolarOrientation::PolarOrientationAngular))
        return;
    // Register converter for enum 'QtCharts::QPolarChart::PolarOrientation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX],
            QtCharts_QPolarChart_PolarOrientation_CppToPython_QtCharts_QPolarChart_PolarOrientation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtCharts_QPolarChart_PolarOrientation_PythonToCpp_QtCharts_QPolarChart_PolarOrientation,
            is_QtCharts_QPolarChart_PolarOrientation_PythonToCpp_QtCharts_QPolarChart_PolarOrientation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtCharts::QPolarChart::PolarOrientation");
        Shiboken::Conversions::registerConverterName(converter, "QPolarChart::PolarOrientation");
        Shiboken::Conversions::registerConverterName(converter, "PolarOrientation");
    }
    // Register converter for flag 'QFlags<QtCharts::QPolarChart::PolarOrientation>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtChartsTypes[SBK_QFLAGS_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX],
            QFlags_QtCharts_QPolarChart_PolarOrientation__CppToPython_QFlags_QtCharts_QPolarChart_PolarOrientation_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtCharts_QPolarChart_PolarOrientation_PythonToCpp_QFlags_QtCharts_QPolarChart_PolarOrientation_,
            is_QtCharts_QPolarChart_PolarOrientation_PythonToCpp_QFlags_QtCharts_QPolarChart_PolarOrientation__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QtCharts_QPolarChart_PolarOrientation__PythonToCpp_QFlags_QtCharts_QPolarChart_PolarOrientation_,
            is_QFlags_QtCharts_QPolarChart_PolarOrientation__PythonToCpp_QFlags_QtCharts_QPolarChart_PolarOrientation__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QtCharts_QPolarChart_PolarOrientation_,
            is_number_PythonToCpp_QFlags_QtCharts_QPolarChart_PolarOrientation__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtChartsTypes[SBK_QFLAGS_QTCHARTS_QPOLARCHART_POLARORIENTATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtCharts::QPolarChart::PolarOrientations");
        Shiboken::Conversions::registerConverterName(converter, "QPolarChart::PolarOrientations");
        Shiboken::Conversions::registerConverterName(converter, "PolarOrientations");
    }
    // End of 'PolarOrientation' enum/flags.

    PySide::Signal::registerSignals(Sbk_QtCharts_QPolarChart_TypeF(), &::QtCharts::QPolarChart::staticMetaObject);
    qRegisterMetaType< ::QtCharts::QPolarChart::PolarOrientation >("QPolarChart::PolarOrientation");
    qRegisterMetaType< ::QtCharts::QPolarChart::PolarOrientation >("QtCharts::QPolarChart::PolarOrientation");
    qRegisterMetaType< ::QtCharts::QPolarChart::PolarOrientations >("QtCharts::QPolarChart::PolarOrientations");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtCharts_QPolarChart_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtCharts_QPolarChart_TypeF(), &::QtCharts::QPolarChart::staticMetaObject, sizeof(QPolarChartWrapper));
}
