/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qabstracteventdispatcher_timerinfo_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAbstractEventDispatcher_TimerInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAbstractEventDispatcher::TimerInfo >()))
        return -1;

    ::QAbstractEventDispatcher::TimerInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractEventDispatcher.TimerInfo.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "TimerInfo", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: TimerInfo::TimerInfo(int,int,Qt::TimerType)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[2])))) {
        overloadId = 0; // TimerInfo(int,int,Qt::TimerType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractEventDispatcher_TimerInfo_Init_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::Qt::TimerType cppArg2{Qt::PreciseTimer};
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // TimerInfo(int,int,Qt::TimerType)
            cptr = new ::QAbstractEventDispatcher::TimerInfo(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAbstractEventDispatcher::TimerInfo >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAbstractEventDispatcher_TimerInfo_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QAbstractEventDispatcher_TimerInfo_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}


static const char *Sbk_QAbstractEventDispatcher_TimerInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAbstractEventDispatcher_TimerInfo_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QAbstractEventDispatcher_TimerInfo_get_timerId(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAbstractEventDispatcher::TimerInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_TIMERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->timerId;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAbstractEventDispatcher_TimerInfo_set_timerId(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAbstractEventDispatcher::TimerInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_TIMERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'timerId' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'timerId', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->timerId;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->timerId = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAbstractEventDispatcher_TimerInfo_get_interval(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAbstractEventDispatcher::TimerInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_TIMERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->interval;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QAbstractEventDispatcher_TimerInfo_set_interval(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAbstractEventDispatcher::TimerInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_TIMERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'interval' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'interval', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->interval;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->interval = cppOut_local;

    return 0;
}

static PyObject *Sbk_QAbstractEventDispatcher_TimerInfo_get_timerType(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAbstractEventDispatcher::TimerInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_TIMERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::Qt::TimerType cppOut_local = cppSelf->timerType;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QAbstractEventDispatcher_TimerInfo_set_timerType(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAbstractEventDispatcher::TimerInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_TIMERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'timerType' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'timerType', 'TimerType' or convertible type expected");
        return -1;
    }

    ::Qt::TimerType cppOut_local = cppSelf->timerType;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->timerType = cppOut_local;

    return 0;
}

// Getters and Setters for TimerInfo
static PyGetSetDef Sbk_QAbstractEventDispatcher_TimerInfo_getsetlist[] = {
    {const_cast<char *>("timerId"), Sbk_QAbstractEventDispatcher_TimerInfo_get_timerId, Sbk_QAbstractEventDispatcher_TimerInfo_set_timerId},
    {const_cast<char *>("interval"), Sbk_QAbstractEventDispatcher_TimerInfo_get_interval, Sbk_QAbstractEventDispatcher_TimerInfo_set_interval},
    {const_cast<char *>("timerType"), Sbk_QAbstractEventDispatcher_TimerInfo_get_timerType, Sbk_QAbstractEventDispatcher_TimerInfo_set_timerType},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QAbstractEventDispatcher_TimerInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAbstractEventDispatcher_TimerInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAbstractEventDispatcher_TimerInfo_Type = nullptr;
static SbkObjectType *Sbk_QAbstractEventDispatcher_TimerInfo_TypeF(void)
{
    return _Sbk_QAbstractEventDispatcher_TimerInfo_Type;
}

static PyType_Slot Sbk_QAbstractEventDispatcher_TimerInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAbstractEventDispatcher_TimerInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAbstractEventDispatcher_TimerInfo_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAbstractEventDispatcher_TimerInfo_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QAbstractEventDispatcher_TimerInfo_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAbstractEventDispatcher_TimerInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAbstractEventDispatcher_TimerInfo_spec = {
    "2:PySide2.QtCore.QAbstractEventDispatcher.TimerInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAbstractEventDispatcher_TimerInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void TimerInfo_PythonToCpp_TimerInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAbstractEventDispatcher_TimerInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_TimerInfo_PythonToCpp_TimerInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAbstractEventDispatcher_TimerInfo_TypeF())))
        return TimerInfo_PythonToCpp_TimerInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *TimerInfo_PTR_CppToPython_TimerInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAbstractEventDispatcher::TimerInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAbstractEventDispatcher_TimerInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAbstractEventDispatcher_TimerInfo_SignatureStrings[] = {
    "PySide2.QtCore.QAbstractEventDispatcher.TimerInfo(self,id:int,i:int,t:PySide2.QtCore.Qt.TimerType)",
    nullptr}; // Sentinel

void init_QAbstractEventDispatcher_TimerInfo(PyObject *enclosingClass)
{
    _Sbk_QAbstractEventDispatcher_TimerInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "TimerInfo",
        "QAbstractEventDispatcher::TimerInfo*",
        &Sbk_QAbstractEventDispatcher_TimerInfo_spec,
        &Shiboken::callCppDestructor< ::QAbstractEventDispatcher::TimerInfo >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractEventDispatcher_TimerInfo_Type);
    InitSignatureStrings(pyType, QAbstractEventDispatcher_TimerInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractEventDispatcher_TimerInfo_Type), Sbk_QAbstractEventDispatcher_TimerInfo_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_TIMERINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAbstractEventDispatcher_TimerInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAbstractEventDispatcher_TimerInfo_TypeF(),
        TimerInfo_PythonToCpp_TimerInfo_PTR,
        is_TimerInfo_PythonToCpp_TimerInfo_PTR_Convertible,
        TimerInfo_PTR_CppToPython_TimerInfo);

    Shiboken::Conversions::registerConverterName(converter, "QAbstractEventDispatcher::TimerInfo");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractEventDispatcher::TimerInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractEventDispatcher::TimerInfo&");
    Shiboken::Conversions::registerConverterName(converter, "TimerInfo");
    Shiboken::Conversions::registerConverterName(converter, "TimerInfo*");
    Shiboken::Conversions::registerConverterName(converter, "TimerInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractEventDispatcher::TimerInfo).name());


}
