/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qbasictimer_wrapper.h"

// inner classes

// Extra includes
#include <qbasictimer.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QBasicTimer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QBasicTimer >()))
        return -1;

    ::QBasicTimer *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QBasicTimer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QBasicTimer", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QBasicTimer::QBasicTimer()
    // 1: QBasicTimer::QBasicTimer(QBasicTimer)
    if (numArgs == 0) {
        overloadId = 0; // QBasicTimer()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBASICTIMER_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QBasicTimer(QBasicTimer)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBasicTimer_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QBasicTimer()
        {

            if (!PyErr_Occurred()) {
                // QBasicTimer()
                cptr = new ::QBasicTimer();
            }
            break;
        }
        case 1: // QBasicTimer(const QBasicTimer & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QBasicTimer *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QBasicTimer(QBasicTimer)
                cptr = new ::QBasicTimer(*cppArg0);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QBasicTimer.QBasicTimer(const QBasicTimer & arg__1) is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QBasicTimer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QBasicTimer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QBasicTimer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QBasicTimerFunc_isActive(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBasicTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBASICTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QBasicTimer.isActive";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isActive()const
            bool cppResult = const_cast<const ::QBasicTimer *>(cppSelf)->isActive();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QBasicTimerFunc_start(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBasicTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBASICTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QBasicTimer.start";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "start", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QBasicTimer::start(int,QObject*)
    // 1: QBasicTimer::start(int,Qt::TimerType,QObject*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMERTYPE_IDX])->converter, (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))) {
            overloadId = 1; // start(int,Qt::TimerType,QObject*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // start(int,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBasicTimerFunc_start_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // start(int msec, QObject * obj)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // start(int,QObject*)
                cppSelf->start(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // start(int msec, Qt::TimerType timerType, QObject * obj)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::TimerType cppArg1{Qt::PreciseTimer};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QObject *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // start(int,Qt::TimerType,QObject*)
                cppSelf->start(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBasicTimerFunc_start_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBasicTimerFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBasicTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBASICTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QBasicTimer.stop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stop()
            cppSelf->stop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QBasicTimerFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBasicTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBASICTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QBasicTimer.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBasicTimer::swap(QBasicTimer&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBASICTIMER_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QBasicTimer&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QBasicTimerFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBasicTimer *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // swap(QBasicTimer&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QBasicTimerFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QBasicTimerFunc_timerId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QBasicTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBASICTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QBasicTimer.timerId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // timerId()const
            int cppResult = const_cast<const ::QBasicTimer *>(cppSelf)->timerId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QBasicTimer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QBasicTimer_methods[] = {
    {"isActive", reinterpret_cast<PyCFunction>(Sbk_QBasicTimerFunc_isActive), METH_NOARGS},
    {"start", reinterpret_cast<PyCFunction>(Sbk_QBasicTimerFunc_start), METH_VARARGS},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_QBasicTimerFunc_stop), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QBasicTimerFunc_swap), METH_O},
    {"timerId", reinterpret_cast<PyCFunction>(Sbk_QBasicTimerFunc_timerId), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QBasicTimer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QBasicTimer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QBasicTimer_Type = nullptr;
static SbkObjectType *Sbk_QBasicTimer_TypeF(void)
{
    return _Sbk_QBasicTimer_Type;
}

static PyType_Slot Sbk_QBasicTimer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QBasicTimer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QBasicTimer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QBasicTimer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QBasicTimer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QBasicTimer_spec = {
    "2:PySide2.QtCore.QBasicTimer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QBasicTimer_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QBasicTimer_PythonToCpp_QBasicTimer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QBasicTimer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QBasicTimer_PythonToCpp_QBasicTimer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QBasicTimer_TypeF())))
        return QBasicTimer_PythonToCpp_QBasicTimer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QBasicTimer_PTR_CppToPython_QBasicTimer(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QBasicTimer *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QBasicTimer_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QBasicTimer_SignatureStrings[] = {
    "1:PySide2.QtCore.QBasicTimer(self)",
    "0:PySide2.QtCore.QBasicTimer(self,arg__1:PySide2.QtCore.QBasicTimer)",
    "PySide2.QtCore.QBasicTimer.isActive(self)->bool",
    "1:PySide2.QtCore.QBasicTimer.start(self,msec:int,obj:PySide2.QtCore.QObject)",
    "0:PySide2.QtCore.QBasicTimer.start(self,msec:int,timerType:PySide2.QtCore.Qt.TimerType,obj:PySide2.QtCore.QObject)",
    "PySide2.QtCore.QBasicTimer.stop(self)",
    "PySide2.QtCore.QBasicTimer.swap(self,other:PySide2.QtCore.QBasicTimer)",
    "PySide2.QtCore.QBasicTimer.timerId(self)->int",
    nullptr}; // Sentinel

void init_QBasicTimer(PyObject *module)
{
    _Sbk_QBasicTimer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QBasicTimer",
        "QBasicTimer*",
        &Sbk_QBasicTimer_spec,
        &Shiboken::callCppDestructor< ::QBasicTimer >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QBasicTimer_Type);
    InitSignatureStrings(pyType, QBasicTimer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QBasicTimer_Type), Sbk_QBasicTimer_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QBASICTIMER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QBasicTimer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QBasicTimer_TypeF(),
        QBasicTimer_PythonToCpp_QBasicTimer_PTR,
        is_QBasicTimer_PythonToCpp_QBasicTimer_PTR_Convertible,
        QBasicTimer_PTR_CppToPython_QBasicTimer);

    Shiboken::Conversions::registerConverterName(converter, "QBasicTimer");
    Shiboken::Conversions::registerConverterName(converter, "QBasicTimer*");
    Shiboken::Conversions::registerConverterName(converter, "QBasicTimer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QBasicTimer).name());


}
