/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qcborparsererror_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCborParserError_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCborParserError >()))
        return -1;

    ::QCborParserError *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborParserError.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QCborParserError", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QCborParserError::QCborParserError()
    // 1: QCborParserError::QCborParserError(QCborParserError)
    if (numArgs == 0) {
        overloadId = 0; // QCborParserError()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QCborParserError(QCborParserError)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborParserError_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QCborParserError()
        {

            if (!PyErr_Occurred()) {
                // QCborParserError()
                cptr = new ::QCborParserError();
            }
            break;
        }
        case 1: // QCborParserError(const QCborParserError & QCborParserError)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QCborParserError cppArg0_local;
            ::QCborParserError *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QCborParserError(QCborParserError)
                cptr = new ::QCborParserError(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCborParserError >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCborParserError_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QCborParserError_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCborParserErrorFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborParserError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborParserError.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QCborParserError *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborParserError___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QCborParserError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCborParserError_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCborParserError_methods[] = {
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QCborParserErrorFunc_errorString), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QCborParserError___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QCborParserError_get_offset(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QCborParserError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    qint64 cppOut_local = cppSelf->offset;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QCborParserError_set_offset(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QCborParserError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'offset' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'offset', 'qint64' or convertible type expected");
        return -1;
    }

    qint64 cppOut_local = cppSelf->offset;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->offset = cppOut_local;

    return 0;
}

static PyObject *Sbk_QCborParserError_get_error(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QCborParserError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->error)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->error))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->error)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_IDX]), &(cppSelf->error), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QCborParserError_set_error(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QCborParserError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'error' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'error', 'QCborError' or convertible type expected");
        return -1;
    }

    ::QCborError& cppOut_ptr = cppSelf->error;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for QCborParserError
static PyGetSetDef Sbk_QCborParserError_getsetlist[] = {
    {const_cast<char *>("offset"), Sbk_QCborParserError_get_offset, Sbk_QCborParserError_set_offset},
    {const_cast<char *>("error"), Sbk_QCborParserError_get_error, Sbk_QCborParserError_set_error},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QCborParserError_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCborParserError_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCborParserError_Type = nullptr;
static SbkObjectType *Sbk_QCborParserError_TypeF(void)
{
    return _Sbk_QCborParserError_Type;
}

static PyType_Slot Sbk_QCborParserError_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCborParserError_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCborParserError_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCborParserError_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QCborParserError_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCborParserError_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCborParserError_spec = {
    "2:PySide2.QtCore.QCborParserError",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCborParserError_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCborParserError_PythonToCpp_QCborParserError_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCborParserError_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCborParserError_PythonToCpp_QCborParserError_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCborParserError_TypeF())))
        return QCborParserError_PythonToCpp_QCborParserError_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCborParserError_PTR_CppToPython_QCborParserError(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QCborParserError *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QCborParserError_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QCborParserError_COPY_CppToPython_QCborParserError(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QCborParserError_TypeF(), new ::QCborParserError(*reinterpret_cast<const ::QCborParserError *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QCborParserError_PythonToCpp_QCborParserError_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCborParserError *>(cppOut) = *reinterpret_cast< ::QCborParserError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QCborParserError_PythonToCpp_QCborParserError_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCborParserError_TypeF())))
        return QCborParserError_PythonToCpp_QCborParserError_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCborParserError_SignatureStrings[] = {
    "1:PySide2.QtCore.QCborParserError(self)",
    "0:PySide2.QtCore.QCborParserError(self,QCborParserError:PySide2.QtCore.QCborParserError)",
    "PySide2.QtCore.QCborParserError.errorString(self)->QString",
    "PySide2.QtCore.QCborParserError.__copy__()",
    nullptr}; // Sentinel

void init_QCborParserError(PyObject *module)
{
    _Sbk_QCborParserError_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCborParserError",
        "QCborParserError",
        &Sbk_QCborParserError_spec,
        &Shiboken::callCppDestructor< ::QCborParserError >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCborParserError_Type);
    InitSignatureStrings(pyType, QCborParserError_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCborParserError_Type), Sbk_QCborParserError_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCborParserError_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCborParserError_TypeF(),
        QCborParserError_PythonToCpp_QCborParserError_PTR,
        is_QCborParserError_PythonToCpp_QCborParserError_PTR_Convertible,
        QCborParserError_PTR_CppToPython_QCborParserError,
        QCborParserError_COPY_CppToPython_QCborParserError);

    Shiboken::Conversions::registerConverterName(converter, "QCborParserError");
    Shiboken::Conversions::registerConverterName(converter, "QCborParserError*");
    Shiboken::Conversions::registerConverterName(converter, "QCborParserError&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCborParserError).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QCborParserError_PythonToCpp_QCborParserError_COPY,
        is_QCborParserError_PythonToCpp_QCborParserError_COPY_Convertible);

    qRegisterMetaType< ::QCborParserError >("QCborParserError");
}
