/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qcborstringresultstring_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCborStringResultString_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCborStringResultString >()))
        return -1;

    ::QCborStringResultString *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStringResultString.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QCborStringResultString", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QCborStringResultString::QCborStringResultString()
    // 1: QCborStringResultString::QCborStringResultString(QCborStringResultString)
    if (numArgs == 0) {
        overloadId = 0; // QCborStringResultString()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORSTRINGRESULTSTRING_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QCborStringResultString(QCborStringResultString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborStringResultString_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QCborStringResultString()
        {

            if (!PyErr_Occurred()) {
                // QCborStringResultString()
                cptr = new ::QCborStringResultString();
            }
            break;
        }
        case 1: // QCborStringResultString(const QCborStringResultString & QCborStringResultString)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QCborStringResultString cppArg0_local;
            ::QCborStringResultString *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORSTRINGRESULTSTRING_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QCborStringResultString(QCborStringResultString)
                cptr = new ::QCborStringResultString(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCborStringResultString >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCborStringResultString_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QCborStringResultString_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCborStringResultString___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QCborStringResultString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTRINGRESULTSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORSTRINGRESULTSTRING_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCborStringResultString_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCborStringResultString_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QCborStringResultString___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QCborStringResultString_get_data(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QCborStringResultString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTRINGRESULTSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->data);
    return pyOut;
}
static int Sbk_QCborStringResultString_set_data(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QCborStringResultString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTRINGRESULTSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'data' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'data', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->data;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QCborStringResultString_get_status(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QCborStringResultString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTRINGRESULTSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QCborStreamReader::StringResultCode cppOut_local = cppSelf->status;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_STRINGRESULTCODE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QCborStringResultString_set_status(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QCborStringResultString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTRINGRESULTSTRING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'status' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_STRINGRESULTCODE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'status', 'StringResultCode' or convertible type expected");
        return -1;
    }

    ::QCborStreamReader::StringResultCode cppOut_local = cppSelf->status;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->status = cppOut_local;

    return 0;
}

// Getters and Setters for QCborStringResultString
static PyGetSetDef Sbk_QCborStringResultString_getsetlist[] = {
    {const_cast<char *>("data"), Sbk_QCborStringResultString_get_data, Sbk_QCborStringResultString_set_data},
    {const_cast<char *>("status"), Sbk_QCborStringResultString_get_status, Sbk_QCborStringResultString_set_status},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QCborStringResultString_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCborStringResultString_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCborStringResultString_Type = nullptr;
static SbkObjectType *Sbk_QCborStringResultString_TypeF(void)
{
    return _Sbk_QCborStringResultString_Type;
}

static PyType_Slot Sbk_QCborStringResultString_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCborStringResultString_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCborStringResultString_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCborStringResultString_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QCborStringResultString_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCborStringResultString_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCborStringResultString_spec = {
    "2:PySide2.QtCore.QCborStringResultString",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCborStringResultString_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCborStringResultString_PythonToCpp_QCborStringResultString_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCborStringResultString_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCborStringResultString_PythonToCpp_QCborStringResultString_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCborStringResultString_TypeF())))
        return QCborStringResultString_PythonToCpp_QCborStringResultString_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCborStringResultString_PTR_CppToPython_QCborStringResultString(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QCborStringResultString *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QCborStringResultString_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QCborStringResultString_COPY_CppToPython_QCborStringResultString(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QCborStringResultString_TypeF(), new ::QCborStringResultString(*reinterpret_cast<const ::QCborStringResultString *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QCborStringResultString_PythonToCpp_QCborStringResultString_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCborStringResultString *>(cppOut) = *reinterpret_cast< ::QCborStringResultString *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTRINGRESULTSTRING_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QCborStringResultString_PythonToCpp_QCborStringResultString_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCborStringResultString_TypeF())))
        return QCborStringResultString_PythonToCpp_QCborStringResultString_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCborStringResultString_SignatureStrings[] = {
    "1:PySide2.QtCore.QCborStringResultString(self)",
    "0:PySide2.QtCore.QCborStringResultString(self,QCborStringResultString:PySide2.QtCore.QCborStringResultString)",
    "PySide2.QtCore.QCborStringResultString.__copy__()",
    nullptr}; // Sentinel

void init_QCborStringResultString(PyObject *module)
{
    _Sbk_QCborStringResultString_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCborStringResultString",
        "QCborStringResultString",
        &Sbk_QCborStringResultString_spec,
        &Shiboken::callCppDestructor< ::QCborStringResultString >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCborStringResultString_Type);
    InitSignatureStrings(pyType, QCborStringResultString_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCborStringResultString_Type), Sbk_QCborStringResultString_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QCBORSTRINGRESULTSTRING_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCborStringResultString_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCborStringResultString_TypeF(),
        QCborStringResultString_PythonToCpp_QCborStringResultString_PTR,
        is_QCborStringResultString_PythonToCpp_QCborStringResultString_PTR_Convertible,
        QCborStringResultString_PTR_CppToPython_QCborStringResultString,
        QCborStringResultString_COPY_CppToPython_QCborStringResultString);

    Shiboken::Conversions::registerConverterName(converter, "QCborStringResultString");
    Shiboken::Conversions::registerConverterName(converter, "QCborStringResultString*");
    Shiboken::Conversions::registerConverterName(converter, "QCborStringResultString&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCborStringResultString).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QCborStringResultString_PythonToCpp_QCborStringResultString_COPY,
        is_QCborStringResultString_PythonToCpp_QCborStringResultString_COPY_Convertible);

    qRegisterMetaType< ::QCborStringResultString >("QCborStringResultString");
}
