/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qcommandlineparser_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <qcommandlineoption.h>
#include <qcoreapplication.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCommandLineParser_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCommandLineParser >()))
        return -1;

    ::QCommandLineParser *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QCommandLineParser()
            cptr = new ::QCommandLineParser();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCommandLineParser >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QCommandLineParserFunc_addHelpOption(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.addHelpOption";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // addHelpOption()
            QCommandLineOption* cppResult = new QCommandLineOption(cppSelf->addHelpOption());
            pyResult = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX]), cppResult, true, true);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCommandLineParserFunc_addOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.addOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineParser::addOption(QCommandLineOption)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX]), (pyArg)))) {
        overloadId = 0; // addOption(QCommandLineOption)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineParserFunc_addOption_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QCommandLineOption *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addOption(QCommandLineOption)
            bool cppResult = cppSelf->addOption(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCommandLineParserFunc_addOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineParserFunc_addOptions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.addOptions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineParser::addOptions(QList<QCommandLineOption>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QLIST_QCOMMANDLINEOPTION_IDX], (pyArg)))) {
        overloadId = 0; // addOptions(QList<QCommandLineOption>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineParserFunc_addOptions_TypeError;

    // Call function/method
    {
        ::QList<QCommandLineOption > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addOptions(QList<QCommandLineOption>)
            bool cppResult = cppSelf->addOptions(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCommandLineParserFunc_addOptions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineParserFunc_addPositionalArgument(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.addPositionalArgument";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCommandLineParserFunc_addPositionalArgument_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QCommandLineParserFunc_addPositionalArgument_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:addPositionalArgument", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QCommandLineParser::addPositionalArgument(QString,QString,QString)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // addPositionalArgument(QString,QString,QString)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
            overloadId = 0; // addPositionalArgument(QString,QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineParserFunc_addPositionalArgument_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_syntax = Shiboken::String::createStaticString("syntax");
            if (PyDict_Contains(kwds, key_syntax)) {
                value = PyDict_GetItem(kwds, key_syntax);
                if (value && pyArgs[2]) {
                    errInfo = key_syntax;
                    Py_INCREF(errInfo);
                    goto Sbk_QCommandLineParserFunc_addPositionalArgument_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                        goto Sbk_QCommandLineParserFunc_addPositionalArgument_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_syntax);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCommandLineParserFunc_addPositionalArgument_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // addPositionalArgument(QString,QString,QString)
            cppSelf->addPositionalArgument(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCommandLineParserFunc_addPositionalArgument_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineParserFunc_addVersionOption(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.addVersionOption";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // addVersionOption()
            QCommandLineOption* cppResult = new QCommandLineOption(cppSelf->addVersionOption());
            pyResult = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX]), cppResult, true, true);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCommandLineParserFunc_applicationDescription(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.applicationDescription";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // applicationDescription()const
            QString cppResult = const_cast<const ::QCommandLineParser *>(cppSelf)->applicationDescription();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCommandLineParserFunc_clearPositionalArguments(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.clearPositionalArguments";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearPositionalArguments()
            cppSelf->clearPositionalArguments();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCommandLineParserFunc_errorText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.errorText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorText()const
            QString cppResult = const_cast<const ::QCommandLineParser *>(cppSelf)->errorText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCommandLineParserFunc_helpText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.helpText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // helpText()const
            QString cppResult = const_cast<const ::QCommandLineParser *>(cppSelf)->helpText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCommandLineParserFunc_isSet(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.isSet";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineParser::isSet(QCommandLineOption)const
    // 1: QCommandLineParser::isSet(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 1; // isSet(QString)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX]), (pyArg)))) {
        overloadId = 0; // isSet(QCommandLineOption)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineParserFunc_isSet_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // isSet(const QCommandLineOption & option) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QCommandLineOption *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // isSet(QCommandLineOption)const
                bool cppResult = const_cast<const ::QCommandLineParser *>(cppSelf)->isSet(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // isSet(const QString & name) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // isSet(QString)const
                bool cppResult = const_cast<const ::QCommandLineParser *>(cppSelf)->isSet(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCommandLineParserFunc_isSet_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineParserFunc_optionNames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.optionNames";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // optionNames()const
            QStringList cppResult = const_cast<const ::QCommandLineParser *>(cppSelf)->optionNames();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCommandLineParserFunc_parse(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.parse";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineParser::parse(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // parse(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineParserFunc_parse_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // parse(QStringList)
            bool cppResult = cppSelf->parse(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCommandLineParserFunc_parse_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineParserFunc_positionalArguments(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.positionalArguments";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // positionalArguments()const
            QStringList cppResult = const_cast<const ::QCommandLineParser *>(cppSelf)->positionalArguments();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCommandLineParserFunc_process(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.process";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineParser::process(QCoreApplication)
    // 1: QCommandLineParser::process(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 1; // process(QStringList)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCOREAPPLICATION_IDX]), (pyArg)))) {
        overloadId = 0; // process(QCoreApplication)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineParserFunc_process_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // process(const QCoreApplication & app)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QCoreApplication *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // process(QCoreApplication)
                cppSelf->process(*cppArg0);
            }
            break;
        }
        case 1: // process(const QStringList & arguments)
        {
            ::QStringList cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // process(QStringList)
                cppSelf->process(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCommandLineParserFunc_process_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineParserFunc_setApplicationDescription(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.setApplicationDescription";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineParser::setApplicationDescription(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setApplicationDescription(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineParserFunc_setApplicationDescription_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setApplicationDescription(QString)
            cppSelf->setApplicationDescription(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCommandLineParserFunc_setApplicationDescription_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineParserFunc_setOptionsAfterPositionalArgumentsMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.setOptionsAfterPositionalArgumentsMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineParser::setOptionsAfterPositionalArgumentsMode(QCommandLineParser::OptionsAfterPositionalArgumentsMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_OPTIONSAFTERPOSITIONALARGUMENTSMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setOptionsAfterPositionalArgumentsMode(QCommandLineParser::OptionsAfterPositionalArgumentsMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineParserFunc_setOptionsAfterPositionalArgumentsMode_TypeError;

    // Call function/method
    {
        ::QCommandLineParser::OptionsAfterPositionalArgumentsMode cppArg0{QCommandLineParser::ParseAsOptions};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOptionsAfterPositionalArgumentsMode(QCommandLineParser::OptionsAfterPositionalArgumentsMode)
            cppSelf->setOptionsAfterPositionalArgumentsMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCommandLineParserFunc_setOptionsAfterPositionalArgumentsMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineParserFunc_setSingleDashWordOptionMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.setSingleDashWordOptionMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineParser::setSingleDashWordOptionMode(QCommandLineParser::SingleDashWordOptionMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_SINGLEDASHWORDOPTIONMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSingleDashWordOptionMode(QCommandLineParser::SingleDashWordOptionMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineParserFunc_setSingleDashWordOptionMode_TypeError;

    // Call function/method
    {
        ::QCommandLineParser::SingleDashWordOptionMode cppArg0{QCommandLineParser::ParseAsCompactedShortOptions};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSingleDashWordOptionMode(QCommandLineParser::SingleDashWordOptionMode)
            cppSelf->setSingleDashWordOptionMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCommandLineParserFunc_setSingleDashWordOptionMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineParserFunc_showHelp(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.showHelp";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCommandLineParserFunc_showHelp_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:showHelp", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCommandLineParser::showHelp(int)
    if (numArgs == 0) {
        overloadId = 0; // showHelp(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // showHelp(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineParserFunc_showHelp_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_exitCode = Shiboken::String::createStaticString("exitCode");
            if (PyDict_Contains(kwds, key_exitCode)) {
                value = PyDict_GetItem(kwds, key_exitCode);
                if (value && pyArgs[0]) {
                    errInfo = key_exitCode;
                    Py_INCREF(errInfo);
                    goto Sbk_QCommandLineParserFunc_showHelp_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QCommandLineParserFunc_showHelp_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_exitCode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCommandLineParserFunc_showHelp_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // showHelp(int)
            cppSelf->showHelp(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCommandLineParserFunc_showHelp_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineParserFunc_showVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.showVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // showVersion()
            cppSelf->showVersion();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCommandLineParserFunc_unknownOptionNames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.unknownOptionNames";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unknownOptionNames()const
            QStringList cppResult = const_cast<const ::QCommandLineParser *>(cppSelf)->unknownOptionNames();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCommandLineParserFunc_value(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.value";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineParser::value(QCommandLineOption)const
    // 1: QCommandLineParser::value(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 1; // value(QString)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX]), (pyArg)))) {
        overloadId = 0; // value(QCommandLineOption)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineParserFunc_value_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // value(const QCommandLineOption & option) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QCommandLineOption *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // value(QCommandLineOption)const
                QString cppResult = const_cast<const ::QCommandLineParser *>(cppSelf)->value(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // value(const QString & name) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // value(QString)const
                QString cppResult = const_cast<const ::QCommandLineParser *>(cppSelf)->value(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCommandLineParserFunc_value_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineParserFunc_values(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineParser *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineParser.values";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineParser::values(QCommandLineOption)const
    // 1: QCommandLineParser::values(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 1; // values(QString)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX]), (pyArg)))) {
        overloadId = 0; // values(QCommandLineOption)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineParserFunc_values_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // values(const QCommandLineOption & option) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QCommandLineOption *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // values(QCommandLineOption)const
                QStringList cppResult = const_cast<const ::QCommandLineParser *>(cppSelf)->values(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
            }
            break;
        }
        case 1: // values(const QString & name) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // values(QString)const
                QStringList cppResult = const_cast<const ::QCommandLineParser *>(cppSelf)->values(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCommandLineParserFunc_values_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QCommandLineParser_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCommandLineParser_methods[] = {
    {"addHelpOption", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_addHelpOption), METH_NOARGS},
    {"addOption", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_addOption), METH_O},
    {"addOptions", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_addOptions), METH_O},
    {"addPositionalArgument", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_addPositionalArgument), METH_VARARGS|METH_KEYWORDS},
    {"addVersionOption", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_addVersionOption), METH_NOARGS},
    {"applicationDescription", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_applicationDescription), METH_NOARGS},
    {"clearPositionalArguments", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_clearPositionalArguments), METH_NOARGS},
    {"errorText", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_errorText), METH_NOARGS},
    {"helpText", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_helpText), METH_NOARGS},
    {"isSet", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_isSet), METH_O},
    {"optionNames", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_optionNames), METH_NOARGS},
    {"parse", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_parse), METH_O},
    {"positionalArguments", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_positionalArguments), METH_NOARGS},
    {"process", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_process), METH_O},
    {"setApplicationDescription", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_setApplicationDescription), METH_O},
    {"setOptionsAfterPositionalArgumentsMode", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_setOptionsAfterPositionalArgumentsMode), METH_O},
    {"setSingleDashWordOptionMode", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_setSingleDashWordOptionMode), METH_O},
    {"showHelp", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_showHelp), METH_VARARGS|METH_KEYWORDS},
    {"showVersion", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_showVersion), METH_NOARGS},
    {"unknownOptionNames", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_unknownOptionNames), METH_NOARGS},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_value), METH_O},
    {"values", reinterpret_cast<PyCFunction>(Sbk_QCommandLineParserFunc_values), METH_O},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QCommandLineParser_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCommandLineParser_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCommandLineParser_Type = nullptr;
static SbkObjectType *Sbk_QCommandLineParser_TypeF(void)
{
    return _Sbk_QCommandLineParser_Type;
}

static PyType_Slot Sbk_QCommandLineParser_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCommandLineParser_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCommandLineParser_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCommandLineParser_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCommandLineParser_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCommandLineParser_spec = {
    "2:PySide2.QtCore.QCommandLineParser",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCommandLineParser_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QCommandLineParser_SingleDashWordOptionMode_PythonToCpp_QCommandLineParser_SingleDashWordOptionMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCommandLineParser::SingleDashWordOptionMode *>(cppOut) =
        static_cast<::QCommandLineParser::SingleDashWordOptionMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCommandLineParser_SingleDashWordOptionMode_PythonToCpp_QCommandLineParser_SingleDashWordOptionMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_SINGLEDASHWORDOPTIONMODE_IDX]))
        return QCommandLineParser_SingleDashWordOptionMode_PythonToCpp_QCommandLineParser_SingleDashWordOptionMode;
    return {};
}
static PyObject *QCommandLineParser_SingleDashWordOptionMode_CppToPython_QCommandLineParser_SingleDashWordOptionMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCommandLineParser::SingleDashWordOptionMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_SINGLEDASHWORDOPTIONMODE_IDX], castCppIn);

}

static void QCommandLineParser_OptionsAfterPositionalArgumentsMode_PythonToCpp_QCommandLineParser_OptionsAfterPositionalArgumentsMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCommandLineParser::OptionsAfterPositionalArgumentsMode *>(cppOut) =
        static_cast<::QCommandLineParser::OptionsAfterPositionalArgumentsMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCommandLineParser_OptionsAfterPositionalArgumentsMode_PythonToCpp_QCommandLineParser_OptionsAfterPositionalArgumentsMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_OPTIONSAFTERPOSITIONALARGUMENTSMODE_IDX]))
        return QCommandLineParser_OptionsAfterPositionalArgumentsMode_PythonToCpp_QCommandLineParser_OptionsAfterPositionalArgumentsMode;
    return {};
}
static PyObject *QCommandLineParser_OptionsAfterPositionalArgumentsMode_CppToPython_QCommandLineParser_OptionsAfterPositionalArgumentsMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCommandLineParser::OptionsAfterPositionalArgumentsMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_OPTIONSAFTERPOSITIONALARGUMENTSMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCommandLineParser_PythonToCpp_QCommandLineParser_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCommandLineParser_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCommandLineParser_PythonToCpp_QCommandLineParser_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCommandLineParser_TypeF())))
        return QCommandLineParser_PythonToCpp_QCommandLineParser_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCommandLineParser_PTR_CppToPython_QCommandLineParser(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QCommandLineParser *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QCommandLineParser_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCommandLineParser_SignatureStrings[] = {
    "PySide2.QtCore.QCommandLineParser(self)",
    "PySide2.QtCore.QCommandLineParser.addHelpOption(self)->PySide2.QtCore.QCommandLineOption",
    "PySide2.QtCore.QCommandLineParser.addOption(self,commandLineOption:PySide2.QtCore.QCommandLineOption)->bool",
    "PySide2.QtCore.QCommandLineParser.addOptions(self,options:QList[PySide2.QtCore.QCommandLineOption])->bool",
    "PySide2.QtCore.QCommandLineParser.addPositionalArgument(self,name:QString,description:QString,syntax:QString=QString())",
    "PySide2.QtCore.QCommandLineParser.addVersionOption(self)->PySide2.QtCore.QCommandLineOption",
    "PySide2.QtCore.QCommandLineParser.applicationDescription(self)->QString",
    "PySide2.QtCore.QCommandLineParser.clearPositionalArguments(self)",
    "PySide2.QtCore.QCommandLineParser.errorText(self)->QString",
    "PySide2.QtCore.QCommandLineParser.helpText(self)->QString",
    "1:PySide2.QtCore.QCommandLineParser.isSet(self,option:PySide2.QtCore.QCommandLineOption)->bool",
    "0:PySide2.QtCore.QCommandLineParser.isSet(self,name:QString)->bool",
    "PySide2.QtCore.QCommandLineParser.optionNames(self)->QStringList",
    "PySide2.QtCore.QCommandLineParser.parse(self,arguments:QStringList)->bool",
    "PySide2.QtCore.QCommandLineParser.positionalArguments(self)->QStringList",
    "1:PySide2.QtCore.QCommandLineParser.process(self,app:PySide2.QtCore.QCoreApplication)",
    "0:PySide2.QtCore.QCommandLineParser.process(self,arguments:QStringList)",
    "PySide2.QtCore.QCommandLineParser.setApplicationDescription(self,description:QString)",
    "PySide2.QtCore.QCommandLineParser.setOptionsAfterPositionalArgumentsMode(self,mode:PySide2.QtCore.QCommandLineParser.OptionsAfterPositionalArgumentsMode)",
    "PySide2.QtCore.QCommandLineParser.setSingleDashWordOptionMode(self,parsingMode:PySide2.QtCore.QCommandLineParser.SingleDashWordOptionMode)",
    "PySide2.QtCore.QCommandLineParser.showHelp(self,exitCode:int=0)",
    "PySide2.QtCore.QCommandLineParser.showVersion(self)",
    "PySide2.QtCore.QCommandLineParser.unknownOptionNames(self)->QStringList",
    "1:PySide2.QtCore.QCommandLineParser.value(self,option:PySide2.QtCore.QCommandLineOption)->QString",
    "0:PySide2.QtCore.QCommandLineParser.value(self,name:QString)->QString",
    "1:PySide2.QtCore.QCommandLineParser.values(self,option:PySide2.QtCore.QCommandLineOption)->QStringList",
    "0:PySide2.QtCore.QCommandLineParser.values(self,name:QString)->QStringList",
    nullptr}; // Sentinel

void init_QCommandLineParser(PyObject *module)
{
    _Sbk_QCommandLineParser_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCommandLineParser",
        "QCommandLineParser*",
        &Sbk_QCommandLineParser_spec,
        &Shiboken::callCppDestructor< ::QCommandLineParser >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCommandLineParser_Type);
    InitSignatureStrings(pyType, QCommandLineParser_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCommandLineParser_Type), Sbk_QCommandLineParser_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCommandLineParser_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCommandLineParser_TypeF(),
        QCommandLineParser_PythonToCpp_QCommandLineParser_PTR,
        is_QCommandLineParser_PythonToCpp_QCommandLineParser_PTR_Convertible,
        QCommandLineParser_PTR_CppToPython_QCommandLineParser);

    Shiboken::Conversions::registerConverterName(converter, "QCommandLineParser");
    Shiboken::Conversions::registerConverterName(converter, "QCommandLineParser*");
    Shiboken::Conversions::registerConverterName(converter, "QCommandLineParser&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCommandLineParser).name());


    // Initialization of enums.

    // Initialization of enum 'SingleDashWordOptionMode'.
    SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_SINGLEDASHWORDOPTIONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCommandLineParser_TypeF(),
        "SingleDashWordOptionMode",
        "2:PySide2.QtCore.QCommandLineParser.SingleDashWordOptionMode",
        "QCommandLineParser::SingleDashWordOptionMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_SINGLEDASHWORDOPTIONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_SINGLEDASHWORDOPTIONMODE_IDX],
        Sbk_QCommandLineParser_TypeF(), "ParseAsCompactedShortOptions", (long) QCommandLineParser::SingleDashWordOptionMode::ParseAsCompactedShortOptions))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_SINGLEDASHWORDOPTIONMODE_IDX],
        Sbk_QCommandLineParser_TypeF(), "ParseAsLongOptions", (long) QCommandLineParser::SingleDashWordOptionMode::ParseAsLongOptions))
        return;
    // Register converter for enum 'QCommandLineParser::SingleDashWordOptionMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_SINGLEDASHWORDOPTIONMODE_IDX],
            QCommandLineParser_SingleDashWordOptionMode_CppToPython_QCommandLineParser_SingleDashWordOptionMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCommandLineParser_SingleDashWordOptionMode_PythonToCpp_QCommandLineParser_SingleDashWordOptionMode,
            is_QCommandLineParser_SingleDashWordOptionMode_PythonToCpp_QCommandLineParser_SingleDashWordOptionMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_SINGLEDASHWORDOPTIONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCommandLineParser::SingleDashWordOptionMode");
        Shiboken::Conversions::registerConverterName(converter, "SingleDashWordOptionMode");
    }
    // End of 'SingleDashWordOptionMode' enum.

    // Initialization of enum 'OptionsAfterPositionalArgumentsMode'.
    SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_OPTIONSAFTERPOSITIONALARGUMENTSMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCommandLineParser_TypeF(),
        "OptionsAfterPositionalArgumentsMode",
        "2:PySide2.QtCore.QCommandLineParser.OptionsAfterPositionalArgumentsMode",
        "QCommandLineParser::OptionsAfterPositionalArgumentsMode");
    if (!SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_OPTIONSAFTERPOSITIONALARGUMENTSMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_OPTIONSAFTERPOSITIONALARGUMENTSMODE_IDX],
        Sbk_QCommandLineParser_TypeF(), "ParseAsOptions", (long) QCommandLineParser::OptionsAfterPositionalArgumentsMode::ParseAsOptions))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_OPTIONSAFTERPOSITIONALARGUMENTSMODE_IDX],
        Sbk_QCommandLineParser_TypeF(), "ParseAsPositionalArguments", (long) QCommandLineParser::OptionsAfterPositionalArgumentsMode::ParseAsPositionalArguments))
        return;
    // Register converter for enum 'QCommandLineParser::OptionsAfterPositionalArgumentsMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_OPTIONSAFTERPOSITIONALARGUMENTSMODE_IDX],
            QCommandLineParser_OptionsAfterPositionalArgumentsMode_CppToPython_QCommandLineParser_OptionsAfterPositionalArgumentsMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCommandLineParser_OptionsAfterPositionalArgumentsMode_PythonToCpp_QCommandLineParser_OptionsAfterPositionalArgumentsMode,
            is_QCommandLineParser_OptionsAfterPositionalArgumentsMode_PythonToCpp_QCommandLineParser_OptionsAfterPositionalArgumentsMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEPARSER_OPTIONSAFTERPOSITIONALARGUMENTSMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCommandLineParser::OptionsAfterPositionalArgumentsMode");
        Shiboken::Conversions::registerConverterName(converter, "OptionsAfterPositionalArgumentsMode");
    }
    // End of 'OptionsAfterPositionalArgumentsMode' enum.

    qRegisterMetaType< ::QCommandLineParser::SingleDashWordOptionMode >("QCommandLineParser::SingleDashWordOptionMode");
    qRegisterMetaType< ::QCommandLineParser::OptionsAfterPositionalArgumentsMode >("QCommandLineParser::OptionsAfterPositionalArgumentsMode");
}
