/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qcryptographichash_wrapper.h"

// inner classes

// Extra includes
#include <qbytearray.h>
#include <qiodevice.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCryptographicHash_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCryptographicHash >()))
        return -1;

    ::QCryptographicHash *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCryptographicHash.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QCryptographicHash", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QCryptographicHash::QCryptographicHash(QCryptographicHash::Algorithm)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QCryptographicHash(QCryptographicHash::Algorithm)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCryptographicHash_Init_TypeError;

    // Call function/method
    {
        ::QCryptographicHash::Algorithm cppArg0{QCryptographicHash::Md4};
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QCryptographicHash(QCryptographicHash::Algorithm)
            cptr = new ::QCryptographicHash(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCryptographicHash >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCryptographicHash_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QCryptographicHash_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCryptographicHashFunc_addData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCryptographicHash *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCryptographicHash.addData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCryptographicHash::addData(QIODevice*)
    // 1: QCryptographicHash::addData(QByteArray)
    // 2: QCryptographicHash::addData(const char*,int)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 2; // addData(const char*,int)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 1; // addData(QByteArray)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // addData(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCryptographicHashFunc_addData_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addData(QIODevice * device)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QIODevice *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // addData(QIODevice*)
                bool cppResult = cppSelf->addData(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // addData(const QByteArray & data)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // addData(QByteArray)
                cppSelf->addData(*cppArg0);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 2: // addData(const char * data, int length)
        {

            if (!PyErr_Occurred()) {
                // addData(const char*,int)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qcryptographichash-adddata)]
                cppSelf->addData(Shiboken::String::toCString(pyArg), Shiboken::String::len(pyArg));
                // END of custom code block [file: ../glue/qtcore.cpp (qcryptographichash-adddata)]
                // ========================================================================

                // End of code injection

                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCryptographicHashFunc_addData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCryptographicHashFunc_hash(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCryptographicHash.hash";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "hash", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QCryptographicHash::hash(QByteArray,QCryptographicHash::Algorithm)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // hash(QByteArray,QCryptographicHash::Algorithm)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCryptographicHashFunc_hash_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QCryptographicHash::Algorithm cppArg1{QCryptographicHash::Md4};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // hash(QByteArray,QCryptographicHash::Algorithm)
            QByteArray cppResult = ::QCryptographicHash::hash(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCryptographicHashFunc_hash_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCryptographicHashFunc_hashLength(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCryptographicHash.hashLength";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCryptographicHash::hashLength(QCryptographicHash::Algorithm)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX])->converter, (pyArg)))) {
        overloadId = 0; // hashLength(QCryptographicHash::Algorithm)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCryptographicHashFunc_hashLength_TypeError;

    // Call function/method
    {
        ::QCryptographicHash::Algorithm cppArg0{QCryptographicHash::Md4};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hashLength(QCryptographicHash::Algorithm)
            int cppResult = ::QCryptographicHash::hashLength(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCryptographicHashFunc_hashLength_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCryptographicHashFunc_reset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCryptographicHash *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCryptographicHash.reset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reset()
            cppSelf->reset();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCryptographicHashFunc_result(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCryptographicHash *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCryptographicHash.result";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // result()const
            QByteArray cppResult = const_cast<const ::QCryptographicHash *>(cppSelf)->result();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCryptographicHash_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCryptographicHash_methods[] = {
    {"addData", reinterpret_cast<PyCFunction>(Sbk_QCryptographicHashFunc_addData), METH_O},
    {"hash", reinterpret_cast<PyCFunction>(Sbk_QCryptographicHashFunc_hash), METH_VARARGS|METH_STATIC},
    {"hashLength", reinterpret_cast<PyCFunction>(Sbk_QCryptographicHashFunc_hashLength), METH_O|METH_STATIC},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_QCryptographicHashFunc_reset), METH_NOARGS},
    {"result", reinterpret_cast<PyCFunction>(Sbk_QCryptographicHashFunc_result), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QCryptographicHash_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCryptographicHash_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCryptographicHash_Type = nullptr;
static SbkObjectType *Sbk_QCryptographicHash_TypeF(void)
{
    return _Sbk_QCryptographicHash_Type;
}

static PyType_Slot Sbk_QCryptographicHash_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCryptographicHash_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCryptographicHash_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCryptographicHash_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCryptographicHash_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCryptographicHash_spec = {
    "2:PySide2.QtCore.QCryptographicHash",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCryptographicHash_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QCryptographicHash_Algorithm_PythonToCpp_QCryptographicHash_Algorithm(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCryptographicHash::Algorithm *>(cppOut) =
        static_cast<::QCryptographicHash::Algorithm>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCryptographicHash_Algorithm_PythonToCpp_QCryptographicHash_Algorithm_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX]))
        return QCryptographicHash_Algorithm_PythonToCpp_QCryptographicHash_Algorithm;
    return {};
}
static PyObject *QCryptographicHash_Algorithm_CppToPython_QCryptographicHash_Algorithm(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCryptographicHash::Algorithm *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCryptographicHash_PythonToCpp_QCryptographicHash_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCryptographicHash_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCryptographicHash_PythonToCpp_QCryptographicHash_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCryptographicHash_TypeF())))
        return QCryptographicHash_PythonToCpp_QCryptographicHash_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCryptographicHash_PTR_CppToPython_QCryptographicHash(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QCryptographicHash *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QCryptographicHash_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCryptographicHash_SignatureStrings[] = {
    "PySide2.QtCore.QCryptographicHash(self,method:PySide2.QtCore.QCryptographicHash.Algorithm)",
    "2:PySide2.QtCore.QCryptographicHash.addData(self,device:PySide2.QtCore.QIODevice)->bool",
    "1:PySide2.QtCore.QCryptographicHash.addData(self,data:PySide2.QtCore.QByteArray)",
    "0:PySide2.QtCore.QCryptographicHash.addData(self,data:char*,length:int)",
    "PySide2.QtCore.QCryptographicHash.hash(data:PySide2.QtCore.QByteArray,method:PySide2.QtCore.QCryptographicHash.Algorithm)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QCryptographicHash.hashLength(method:PySide2.QtCore.QCryptographicHash.Algorithm)->int",
    "PySide2.QtCore.QCryptographicHash.reset(self)",
    "PySide2.QtCore.QCryptographicHash.result(self)->PySide2.QtCore.QByteArray",
    nullptr}; // Sentinel

void init_QCryptographicHash(PyObject *module)
{
    _Sbk_QCryptographicHash_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCryptographicHash",
        "QCryptographicHash*",
        &Sbk_QCryptographicHash_spec,
        &Shiboken::callCppDestructor< ::QCryptographicHash >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCryptographicHash_Type);
    InitSignatureStrings(pyType, QCryptographicHash_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCryptographicHash_Type), Sbk_QCryptographicHash_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCryptographicHash_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCryptographicHash_TypeF(),
        QCryptographicHash_PythonToCpp_QCryptographicHash_PTR,
        is_QCryptographicHash_PythonToCpp_QCryptographicHash_PTR_Convertible,
        QCryptographicHash_PTR_CppToPython_QCryptographicHash);

    Shiboken::Conversions::registerConverterName(converter, "QCryptographicHash");
    Shiboken::Conversions::registerConverterName(converter, "QCryptographicHash*");
    Shiboken::Conversions::registerConverterName(converter, "QCryptographicHash&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCryptographicHash).name());


    // Initialization of enums.

    // Initialization of enum 'Algorithm'.
    SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCryptographicHash_TypeF(),
        "Algorithm",
        "2:PySide2.QtCore.QCryptographicHash.Algorithm",
        "QCryptographicHash::Algorithm");
    if (!SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "Md4", (long) QCryptographicHash::Algorithm::Md4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "Md5", (long) QCryptographicHash::Algorithm::Md5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "Sha1", (long) QCryptographicHash::Algorithm::Sha1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "Sha224", (long) QCryptographicHash::Algorithm::Sha224))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "Sha256", (long) QCryptographicHash::Algorithm::Sha256))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "Sha384", (long) QCryptographicHash::Algorithm::Sha384))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "Sha512", (long) QCryptographicHash::Algorithm::Sha512))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "Keccak_224", (long) QCryptographicHash::Algorithm::Keccak_224))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "Keccak_256", (long) QCryptographicHash::Algorithm::Keccak_256))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "Keccak_384", (long) QCryptographicHash::Algorithm::Keccak_384))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "Keccak_512", (long) QCryptographicHash::Algorithm::Keccak_512))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "RealSha3_224", (long) QCryptographicHash::Algorithm::RealSha3_224))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "RealSha3_256", (long) QCryptographicHash::Algorithm::RealSha3_256))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "RealSha3_384", (long) QCryptographicHash::Algorithm::RealSha3_384))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "RealSha3_512", (long) QCryptographicHash::Algorithm::RealSha3_512))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "Sha3_224", (long) QCryptographicHash::Algorithm::Sha3_224))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "Sha3_256", (long) QCryptographicHash::Algorithm::Sha3_256))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "Sha3_384", (long) QCryptographicHash::Algorithm::Sha3_384))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
        Sbk_QCryptographicHash_TypeF(), "Sha3_512", (long) QCryptographicHash::Algorithm::Sha3_512))
        return;
    // Register converter for enum 'QCryptographicHash::Algorithm'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX],
            QCryptographicHash_Algorithm_CppToPython_QCryptographicHash_Algorithm);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCryptographicHash_Algorithm_PythonToCpp_QCryptographicHash_Algorithm,
            is_QCryptographicHash_Algorithm_PythonToCpp_QCryptographicHash_Algorithm_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCryptographicHash::Algorithm");
        Shiboken::Conversions::registerConverterName(converter, "Algorithm");
    }
    // End of 'Algorithm' enum.

    qRegisterMetaType< ::QCryptographicHash::Algorithm >("QCryptographicHash::Algorithm");
}
