/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qdatastream_wrapper.h"

// inner classes

// Extra includes
#include <QtCore/QtCore>
#include <qbitarray.h>
#include <qbytearray.h>
#include <qcborarray.h>
#include <qcbormap.h>
#include <qcborvalue.h>
#include <qdatetime.h>
#include <qeasingcurve.h>
#include <qiodevice.h>
#include <qjsonarray.h>
#include <qjsondocument.h>
#include <qjsonvalue.h>
#include <qline.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregexp.h>
#include <qregularexpression.h>
#include <qsize.h>
#include <qtimezone.h>
#include <qurl.h>
#include <quuid.h>
#include <qversionnumber.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDataStream_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDataStream >()))
        return -1;

    ::QDataStream *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QDataStream", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QDataStream::QDataStream()
    // 1: QDataStream::QDataStream(QByteArray*,QFlags<QIODevice::OpenModeFlag>)
    // 2: QDataStream::QDataStream(QIODevice*)
    // 3: QDataStream::QDataStream(QByteArray)
    if (numArgs == 0) {
        overloadId = 0; // QDataStream()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QDataStream(QIODevice*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // QDataStream(QByteArray)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // QDataStream(QByteArray*,QFlags<QIODevice::OpenModeFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStream_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QDataStream()
        {

            if (!PyErr_Occurred()) {
                // QDataStream()
                cptr = new ::QDataStream();
            }
            break;
        }
        case 1: // QDataStream(QByteArray * arg__1, QFlags<QIODevice::OpenModeFlag> flags)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QIODevice::OpenModeFlag> cppArg1 = QFlags<QIODevice::OpenModeFlag>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QDataStream(QByteArray*,QFlags<QIODevice::OpenModeFlag>)
                cptr = new ::QDataStream(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QDataStream(QIODevice * arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QDataStream(QIODevice*)
                cptr = new ::QDataStream(cppArg0);
            }
            break;
        }
        case 3: // QDataStream(const QByteArray & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QDataStream(QByteArray)
                cptr = new ::QDataStream(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDataStream >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDataStream_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QDataStream_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDataStreamFunc_abortTransaction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.abortTransaction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // abortTransaction()
            cppSelf->abortTransaction();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QDataStreamFunc_atEnd(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.atEnd";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // atEnd()const
            bool cppResult = const_cast<const ::QDataStream *>(cppSelf)->atEnd();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_byteOrder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.byteOrder";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // byteOrder()const
            QDataStream::ByteOrder cppResult = const_cast<const ::QDataStream *>(cppSelf)->byteOrder();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_BYTEORDER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_commitTransaction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.commitTransaction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // commitTransaction()
            bool cppResult = cppSelf->commitTransaction();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_device(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.device";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // device()const
            QIODevice * cppResult = const_cast<const ::QDataStream *>(cppSelf)->device();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_floatingPointPrecision(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.floatingPointPrecision";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // floatingPointPrecision()const
            QDataStream::FloatingPointPrecision cppResult = const_cast<const ::QDataStream *>(cppSelf)->floatingPointPrecision();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_FLOATINGPOINTPRECISION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readBool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readBool";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readBool()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            bool _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readDouble(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readDouble";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readDouble()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            qreal _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readFloat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readFloat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readFloat()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            float _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readInt16(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readInt16";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readInt16()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            qint16 _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint16>(), &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readInt32(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readInt32";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readInt32()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            qint32 _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readInt64(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readInt64";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readInt64()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            qint64 _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readInt8(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readInt8";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readInt8()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            qint8 _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint8>(), &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readQChar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readQChar";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readQChar()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            ::QChar _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readQString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readQString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readQString()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            ::QString _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readQStringList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readQStringList";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readQStringList()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            ::QStringList _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readQVariant(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readQVariant";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readQVariant()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            ::QVariant _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readRawData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readRawData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::readRawData(char*,int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // readRawData(char*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_readRawData_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // readRawData(char*,int)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qdatastream-readrawdata)]
            QByteArray data;
            data.resize(cppArg0);
            int result = 0;
            Py_BEGIN_ALLOW_THREADS
            result = cppSelf->readRawData(data.data(), data.size());
            Py_END_ALLOW_THREADS
            if (result == -1) {
                Py_INCREF(Py_None);
                pyResult = Py_None;
            } else {
                pyResult = PyBytes_FromStringAndSize(data.data(), result);
            }
            // END of custom code block [file: ../glue/qtcore.cpp (qdatastream-readrawdata)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDataStreamFunc_readRawData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_readString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readString()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            ::QString _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readUInt16(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readUInt16";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readUInt16()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            quint16 _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readUInt32(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readUInt32";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readUInt32()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            quint32 _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readUInt64(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readUInt64";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readUInt64()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            quint64 _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_readUInt8(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.readUInt8";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readUInt8()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            quint8 _cpp_result;
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) >> _cpp_result;
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint8>(), &_cpp_result);
            // END of custom code block [file: ../glue/qtcore.cpp (stream-read-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_resetStatus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.resetStatus";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resetStatus()
            cppSelf->resetStatus();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QDataStreamFunc_rollbackTransaction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.rollbackTransaction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rollbackTransaction()
            cppSelf->rollbackTransaction();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QDataStreamFunc_setByteOrder(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.setByteOrder";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::setByteOrder(QDataStream::ByteOrder)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_BYTEORDER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setByteOrder(QDataStream::ByteOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_setByteOrder_TypeError;

    // Call function/method
    {
        ::QDataStream::ByteOrder cppArg0{QDataStream::BigEndian};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setByteOrder(QDataStream::ByteOrder)
            cppSelf->setByteOrder(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_setByteOrder_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_setDevice(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.setDevice";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::setDevice(QIODevice*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // setDevice(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_setDevice_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIODevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDevice(QIODevice*)
            cppSelf->setDevice(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_setDevice_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_setFloatingPointPrecision(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.setFloatingPointPrecision";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::setFloatingPointPrecision(QDataStream::FloatingPointPrecision)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_FLOATINGPOINTPRECISION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFloatingPointPrecision(QDataStream::FloatingPointPrecision)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_setFloatingPointPrecision_TypeError;

    // Call function/method
    {
        ::QDataStream::FloatingPointPrecision cppArg0{QDataStream::SinglePrecision};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFloatingPointPrecision(QDataStream::FloatingPointPrecision)
            cppSelf->setFloatingPointPrecision(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_setFloatingPointPrecision_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_setStatus(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.setStatus";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::setStatus(QDataStream::Status)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_STATUS_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setStatus(QDataStream::Status)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_setStatus_TypeError;

    // Call function/method
    {
        ::QDataStream::Status cppArg0{QDataStream::Ok};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStatus(QDataStream::Status)
            cppSelf->setStatus(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_setStatus_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_setVersion(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.setVersion";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::setVersion(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setVersion(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_setVersion_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVersion(int)
            cppSelf->setVersion(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_setVersion_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_skipRawData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.skipRawData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::skipRawData(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // skipRawData(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_skipRawData_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // skipRawData(int)
            int cppResult = cppSelf->skipRawData(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDataStreamFunc_skipRawData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_startTransaction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.startTransaction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startTransaction()
            cppSelf->startTransaction();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QDataStreamFunc_status(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.status";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // status()const
            QDataStream::Status cppResult = const_cast<const ::QDataStream *>(cppSelf)->status();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_STATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_unsetDevice(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.unsetDevice";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unsetDevice()
            cppSelf->unsetDevice();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QDataStreamFunc_version(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.version";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // version()const
            int cppResult = const_cast<const ::QDataStream *>(cppSelf)->version();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDataStreamFunc_writeBool(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeBool";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeBool(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // writeBool(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeBool_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeBool(bool)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeBool_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeDouble(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeDouble";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeDouble(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // writeDouble(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeDouble_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeDouble(qreal)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeDouble_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeFloat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeFloat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeFloat(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // writeFloat(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeFloat_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeFloat(float)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeFloat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeInt16(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeInt16";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeInt16(qint16)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint16>(), (pyArg)))) {
        overloadId = 0; // writeInt16(qint16)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeInt16_TypeError;

    // Call function/method
    {
        qint16 cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeInt16(qint16)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeInt16_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeInt32(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeInt32";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeInt32(qint32)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), (pyArg)))) {
        overloadId = 0; // writeInt32(qint32)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeInt32_TypeError;

    // Call function/method
    {
        qint32 cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeInt32(qint32)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeInt32_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeInt64(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeInt64";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeInt64(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // writeInt64(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeInt64_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeInt64(qint64)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeInt64_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeInt8(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeInt8";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeInt8(qint8)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint8>(), (pyArg)))) {
        overloadId = 0; // writeInt8(qint8)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeInt8_TypeError;

    // Call function/method
    {
        qint8 cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeInt8(qint8)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeInt8_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeQChar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeQChar";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeQChar(QChar)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArg)))) {
        overloadId = 0; // writeQChar(QChar)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeQChar_TypeError;

    // Call function/method
    {
        ::QChar cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeQChar(QChar)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeQChar_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeQString(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeQString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeQString(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // writeQString(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeQString_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeQString(QString)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeQString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeQStringList(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeQStringList";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeQStringList(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // writeQStringList(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeQStringList_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeQStringList(QStringList)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeQStringList_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeQVariant(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeQVariant";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeQVariant(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // writeQVariant(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeQVariant_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeQVariant(QVariant)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeQVariant_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeRawData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeRawData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeRawData(const char*,int)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // writeRawData(const char*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeRawData_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // writeRawData(const char*,int)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qdatastream-writerawdata)]
            int r = 0;
            Py_BEGIN_ALLOW_THREADS
            r = cppSelf->writeRawData(cppArg0, Shiboken::String::len(pyArg));
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &r);
            // END of custom code block [file: ../glue/qtcore.cpp (qdatastream-writerawdata)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDataStreamFunc_writeRawData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeString(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeString(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // writeString(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeString_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeString(QString)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeUInt16(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeUInt16";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeUInt16(quint16)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArg)))) {
        overloadId = 0; // writeUInt16(quint16)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeUInt16_TypeError;

    // Call function/method
    {
        quint16 cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeUInt16(quint16)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeUInt16_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeUInt32(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeUInt32";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeUInt32(quint32)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArg)))) {
        overloadId = 0; // writeUInt32(quint32)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeUInt32_TypeError;

    // Call function/method
    {
        quint32 cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeUInt32(quint32)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeUInt32_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeUInt64(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeUInt64";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeUInt64(quint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyArg)))) {
        overloadId = 0; // writeUInt64(quint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeUInt64_TypeError;

    // Call function/method
    {
        quint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeUInt64(quint64)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeUInt64_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc_writeUInt8(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.writeUInt8";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDataStream::writeUInt8(quint8)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint8>(), (pyArg)))) {
        overloadId = 0; // writeUInt8(quint8)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDataStreamFunc_writeUInt8_TypeError;

    // Call function/method
    {
        quint8 cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // writeUInt8(quint8)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            Py_BEGIN_ALLOW_THREADS
            (*cppSelf) << cppArg0;
            Py_END_ALLOW_THREADS
            // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDataStreamFunc_writeUInt8_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QDataStream_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDataStream_methods[] = {
    {"abortTransaction", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_abortTransaction), METH_NOARGS},
    {"atEnd", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_atEnd), METH_NOARGS},
    {"byteOrder", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_byteOrder), METH_NOARGS},
    {"commitTransaction", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_commitTransaction), METH_NOARGS},
    {"device", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_device), METH_NOARGS},
    {"floatingPointPrecision", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_floatingPointPrecision), METH_NOARGS},
    {"readBool", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readBool), METH_NOARGS},
    {"readDouble", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readDouble), METH_NOARGS},
    {"readFloat", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readFloat), METH_NOARGS},
    {"readInt16", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readInt16), METH_NOARGS},
    {"readInt32", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readInt32), METH_NOARGS},
    {"readInt64", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readInt64), METH_NOARGS},
    {"readInt8", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readInt8), METH_NOARGS},
    {"readQChar", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readQChar), METH_NOARGS},
    {"readQString", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readQString), METH_NOARGS},
    {"readQStringList", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readQStringList), METH_NOARGS},
    {"readQVariant", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readQVariant), METH_NOARGS},
    {"readRawData", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readRawData), METH_O},
    {"readString", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readString), METH_NOARGS},
    {"readUInt16", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readUInt16), METH_NOARGS},
    {"readUInt32", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readUInt32), METH_NOARGS},
    {"readUInt64", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readUInt64), METH_NOARGS},
    {"readUInt8", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_readUInt8), METH_NOARGS},
    {"resetStatus", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_resetStatus), METH_NOARGS},
    {"rollbackTransaction", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_rollbackTransaction), METH_NOARGS},
    {"setByteOrder", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_setByteOrder), METH_O},
    {"setDevice", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_setDevice), METH_O},
    {"setFloatingPointPrecision", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_setFloatingPointPrecision), METH_O},
    {"setStatus", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_setStatus), METH_O},
    {"setVersion", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_setVersion), METH_O},
    {"skipRawData", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_skipRawData), METH_O},
    {"startTransaction", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_startTransaction), METH_NOARGS},
    {"status", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_status), METH_NOARGS},
    {"unsetDevice", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_unsetDevice), METH_NOARGS},
    {"version", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_version), METH_NOARGS},
    {"writeBool", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeBool), METH_O},
    {"writeDouble", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeDouble), METH_O},
    {"writeFloat", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeFloat), METH_O},
    {"writeInt16", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeInt16), METH_O},
    {"writeInt32", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeInt32), METH_O},
    {"writeInt64", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeInt64), METH_O},
    {"writeInt8", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeInt8), METH_O},
    {"writeQChar", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeQChar), METH_O},
    {"writeQString", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeQString), METH_O},
    {"writeQStringList", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeQStringList), METH_O},
    {"writeQVariant", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeQVariant), METH_O},
    {"writeRawData", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeRawData), METH_O},
    {"writeString", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeString), METH_O},
    {"writeUInt16", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeUInt16), METH_O},
    {"writeUInt32", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeUInt32), METH_O},
    {"writeUInt64", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeUInt64), METH_O},
    {"writeUInt8", reinterpret_cast<PyCFunction>(Sbk_QDataStreamFunc_writeUInt8), METH_O},

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QDataStreamFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QDataStream::operator<<(QString)
        // 1: QDataStream::operator<<(QDataStream&,QBitArray)
        // 2: QDataStream::operator<<(QDataStream&,QByteArray)
        // 3: QDataStream::operator<<(QDataStream&,QCborArray)
        // 4: QDataStream::operator<<(QDataStream&,QCborMap)
        // 5: QDataStream::operator<<(QDataStream&,QCborValue)
        // 6: QDataStream::operator<<(QDataStream&,QDate)
        // 7: QDataStream::operator<<(QDataStream&,QDateTime)
        // 8: QDataStream::operator<<(QDataStream&,QEasingCurve)
        // 9: QDataStream::operator<<(QDataStream&,QJsonArray)
        // 10: QDataStream::operator<<(QDataStream&,QJsonDocument)
        // 11: QDataStream::operator<<(QDataStream&,QJsonValue)
        // 12: QDataStream::operator<<(QDataStream&,QLine)
        // 13: QDataStream::operator<<(QDataStream&,QLineF)
        // 14: QDataStream::operator<<(QDataStream&,QLocale)
        // 15: QDataStream::operator<<(QDataStream&,QMargins)
        // 16: QDataStream::operator<<(QDataStream&,QMarginsF)
        // 17: QDataStream::operator<<(QDataStream&,QPoint)
        // 18: QDataStream::operator<<(QDataStream&,QPointF)
        // 19: QDataStream::operator<<(QDataStream&,QRect)
        // 20: QDataStream::operator<<(QDataStream&,QRectF)
        // 21: QDataStream::operator<<(QDataStream&,QRegExp)
        // 22: QDataStream::operator<<(QDataStream&,QRegularExpression)
        // 23: QDataStream::operator<<(QDataStream&,QSize)
        // 24: QDataStream::operator<<(QDataStream&,QSizeF)
        // 25: QDataStream::operator<<(QDataStream&,QTime)
        // 26: QDataStream::operator<<(QDataStream&,QTimeZone)
        // 27: QDataStream::operator<<(QDataStream&,QUrl)
        // 28: QDataStream::operator<<(QDataStream&,QUuid)
        // 29: QDataStream::operator<<(QDataStream&,QVersionNumber)
        if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), (pyArg)))) {
            overloadId = 29; // operator<<(QDataStream&,QVersionNumber)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), (pyArg)))) {
            overloadId = 26; // operator<<(QDataStream&,QTimeZone)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), (pyArg)))) {
            overloadId = 25; // operator<<(QDataStream&,QTime)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArg)))) {
            overloadId = 23; // operator<<(QDataStream&,QSize)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArg)))) {
            overloadId = 24; // operator<<(QDataStream&,QSizeF)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArg)))) {
            overloadId = 19; // operator<<(QDataStream&,QRect)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
            overloadId = 20; // operator<<(QDataStream&,QRectF)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
            overloadId = 17; // operator<<(QDataStream&,QPoint)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
            overloadId = 18; // operator<<(QDataStream&,QPointF)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINS_IDX]), (pyArg)))) {
            overloadId = 15; // operator<<(QDataStream&,QMargins)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArg)))) {
            overloadId = 16; // operator<<(QDataStream&,QMarginsF)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), (pyArg)))) {
            overloadId = 12; // operator<<(QDataStream&,QLine)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), (pyArg)))) {
            overloadId = 13; // operator<<(QDataStream&,QLineF)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), (pyArg)))) {
            overloadId = 10; // operator<<(QDataStream&,QJsonDocument)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX]), (pyArg)))) {
            overloadId = 9; // operator<<(QDataStream&,QJsonArray)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), (pyArg)))) {
            overloadId = 8; // operator<<(QDataStream&,QEasingCurve)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
            overloadId = 7; // operator<<(QDataStream&,QDateTime)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), (pyArg)))) {
            overloadId = 6; // operator<<(QDataStream&,QDate)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORMAP_IDX]), (pyArg)))) {
            overloadId = 4; // operator<<(QDataStream&,QCborMap)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORARRAY_IDX]), (pyArg)))) {
            overloadId = 3; // operator<<(QDataStream&,QCborArray)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBITARRAY_IDX]), (pyArg)))) {
            overloadId = 1; // operator<<(QDataStream&,QBitArray)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
            overloadId = 0; // operator<<(QString)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArg)))) {
            overloadId = 14; // operator<<(QDataStream&,QLocale)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), (pyArg)))) {
            overloadId = 11; // operator<<(QDataStream&,QJsonValue)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
            overloadId = 27; // operator<<(QDataStream&,QUrl)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), (pyArg)))) {
            overloadId = 22; // operator<<(QDataStream&,QRegularExpression)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArg)))) {
            overloadId = 21; // operator<<(QDataStream&,QRegExp)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
            overloadId = 2; // operator<<(QDataStream&,QByteArray)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), (pyArg)))) {
            overloadId = 28; // operator<<(QDataStream&,QUuid)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), (pyArg)))) {
            overloadId = 5; // operator<<(QDataStream&,QCborValue)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QDataStreamFunc___lshift___TypeError;

        // Call function/method
        switch (overloadId) {
            case 0: // operator<<(QString arg__1)
            {
                ::QString cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                SBK_UNUSED(cppArg0)

                if (!PyErr_Occurred()) {
                    // operator<<(QString)
                    // Begin code injection
                    // ========================================================================
                    // START of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
                    Py_BEGIN_ALLOW_THREADS
                    (*cppSelf) << cppArg0;
                    Py_END_ALLOW_THREADS
                    // END of custom code block [file: ../glue/qtcore.cpp (stream-write-method)]
                    // ========================================================================

                    // End of code injection

                    pyResult = Py_None;
                    Py_INCREF(Py_None);
                }
                break;
            }
            case 1: // operator<<(const QBitArray & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QBitArray cppArg0_local;
                ::QBitArray *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBITARRAY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QBitArray)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 2: // operator<<(const QByteArray & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QByteArray cppArg0_local;
                ::QByteArray *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QByteArray)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 3: // operator<<(const QCborArray & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QCborArray cppArg0_local;
                ::QCborArray *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORARRAY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QCborArray)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 4: // operator<<(const QCborMap & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QCborMap cppArg0_local;
                ::QCborMap *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORMAP_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QCborMap)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 5: // operator<<(const QCborValue & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QCborValue cppArg0_local;
                ::QCborValue *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QCborValue)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 6: // operator<<(const QDate & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDate cppArg0_local;
                ::QDate *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QDate)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 7: // operator<<(const QDateTime & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDateTime cppArg0_local;
                ::QDateTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QDateTime)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 8: // operator<<(const QEasingCurve & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QEasingCurve cppArg0_local;
                ::QEasingCurve *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QEasingCurve)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 9: // operator<<(const QJsonArray & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QJsonArray cppArg0_local;
                ::QJsonArray *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QJsonArray)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 10: // operator<<(const QJsonDocument & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QJsonDocument cppArg0_local;
                ::QJsonDocument *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QJsonDocument)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 11: // operator<<(const QJsonValue & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QJsonValue cppArg0_local;
                ::QJsonValue *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QJsonValue)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 12: // operator<<(const QLine & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QLine cppArg0_local;
                ::QLine *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QLine)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 13: // operator<<(const QLineF & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QLineF cppArg0_local;
                ::QLineF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QLineF)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 14: // operator<<(const QLocale & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QLocale cppArg0_local;
                ::QLocale *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QLocale)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 15: // operator<<(const QMargins & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMargins cppArg0_local;
                ::QMargins *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QMargins)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 16: // operator<<(const QMarginsF & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMarginsF cppArg0_local;
                ::QMarginsF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QMarginsF)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 17: // operator<<(const QPoint & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPoint cppArg0_local;
                ::QPoint *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QPoint)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 18: // operator<<(const QPointF & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPointF cppArg0_local;
                ::QPointF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QPointF)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 19: // operator<<(const QRect & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QRect cppArg0_local;
                ::QRect *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QRect)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 20: // operator<<(const QRectF & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QRectF cppArg0_local;
                ::QRectF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QRectF)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 21: // operator<<(const QRegExp & regExp)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QRegExp cppArg0_local;
                ::QRegExp *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QRegExp)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 22: // operator<<(const QRegularExpression & re)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QRegularExpression cppArg0_local;
                ::QRegularExpression *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QRegularExpression)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 23: // operator<<(const QSize & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSize cppArg0_local;
                ::QSize *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QSize)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 24: // operator<<(const QSizeF & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSizeF cppArg0_local;
                ::QSizeF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QSizeF)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 25: // operator<<(const QTime & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTime cppArg0_local;
                ::QTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QTime)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 26: // operator<<(const QTimeZone & tz)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTimeZone cppArg0_local;
                ::QTimeZone *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QTimeZone)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 27: // operator<<(const QUrl & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QUrl cppArg0_local;
                ::QUrl *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QUrl)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 28: // operator<<(const QUuid & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QUuid cppArg0_local;
                ::QUuid *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QUuid)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 29: // operator<<(const QVersionNumber & version)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVersionNumber cppArg0_local;
                ::QVersionNumber *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator<<(QDataStream&,QVersionNumber)
                    QDataStream & cppResult = (*cppSelf) << (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDataStreamFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDataStreamFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDataStream *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDataStream.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QDataStream::operator>>(QDataStream&,QBitArray&)
        // 1: QDataStream::operator>>(QDataStream&,QByteArray&)
        // 2: QDataStream::operator>>(QDataStream&,QCborArray&)
        // 3: QDataStream::operator>>(QDataStream&,QCborMap&)
        // 4: QDataStream::operator>>(QDataStream&,QCborValue&)
        // 5: QDataStream::operator>>(QDataStream&,QDate&)
        // 6: QDataStream::operator>>(QDataStream&,QDateTime&)
        // 7: QDataStream::operator>>(QDataStream&,QEasingCurve&)
        // 8: QDataStream::operator>>(QDataStream&,QJsonArray&)
        // 9: QDataStream::operator>>(QDataStream&,QJsonDocument&)
        // 10: QDataStream::operator>>(QDataStream&,QJsonValue&)
        // 11: QDataStream::operator>>(QDataStream&,QLine&)
        // 12: QDataStream::operator>>(QDataStream&,QLineF&)
        // 13: QDataStream::operator>>(QDataStream&,QLocale&)
        // 14: QDataStream::operator>>(QDataStream&,QMargins&)
        // 15: QDataStream::operator>>(QDataStream&,QMarginsF&)
        // 16: QDataStream::operator>>(QDataStream&,QPoint&)
        // 17: QDataStream::operator>>(QDataStream&,QPointF&)
        // 18: QDataStream::operator>>(QDataStream&,QRect&)
        // 19: QDataStream::operator>>(QDataStream&,QRectF&)
        // 20: QDataStream::operator>>(QDataStream&,QRegExp&)
        // 21: QDataStream::operator>>(QDataStream&,QRegularExpression&)
        // 22: QDataStream::operator>>(QDataStream&,QSize&)
        // 23: QDataStream::operator>>(QDataStream&,QSizeF&)
        // 24: QDataStream::operator>>(QDataStream&,QTime&)
        // 25: QDataStream::operator>>(QDataStream&,QTimeZone&)
        // 26: QDataStream::operator>>(QDataStream&,QUrl&)
        // 27: QDataStream::operator>>(QDataStream&,QUuid&)
        // 28: QDataStream::operator>>(QDataStream&,QVersionNumber&)
        if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), (pyArg)))) {
            overloadId = 28; // operator>>(QDataStream&,QVersionNumber&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
            overloadId = 26; // operator>>(QDataStream&,QUrl&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), (pyArg)))) {
            overloadId = 25; // operator>>(QDataStream&,QTimeZone&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), (pyArg)))) {
            overloadId = 24; // operator>>(QDataStream&,QTime&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArg)))) {
            overloadId = 22; // operator>>(QDataStream&,QSize&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArg)))) {
            overloadId = 23; // operator>>(QDataStream&,QSizeF&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), (pyArg)))) {
            overloadId = 21; // operator>>(QDataStream&,QRegularExpression&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArg)))) {
            overloadId = 20; // operator>>(QDataStream&,QRegExp&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArg)))) {
            overloadId = 18; // operator>>(QDataStream&,QRect&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
            overloadId = 19; // operator>>(QDataStream&,QRectF&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
            overloadId = 16; // operator>>(QDataStream&,QPoint&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
            overloadId = 17; // operator>>(QDataStream&,QPointF&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINS_IDX]), (pyArg)))) {
            overloadId = 14; // operator>>(QDataStream&,QMargins&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArg)))) {
            overloadId = 15; // operator>>(QDataStream&,QMarginsF&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArg)))) {
            overloadId = 13; // operator>>(QDataStream&,QLocale&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), (pyArg)))) {
            overloadId = 11; // operator>>(QDataStream&,QLine&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), (pyArg)))) {
            overloadId = 12; // operator>>(QDataStream&,QLineF&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), (pyArg)))) {
            overloadId = 9; // operator>>(QDataStream&,QJsonDocument&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX]), (pyArg)))) {
            overloadId = 8; // operator>>(QDataStream&,QJsonArray&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), (pyArg)))) {
            overloadId = 10; // operator>>(QDataStream&,QJsonValue&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), (pyArg)))) {
            overloadId = 7; // operator>>(QDataStream&,QEasingCurve&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
            overloadId = 6; // operator>>(QDataStream&,QDateTime&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), (pyArg)))) {
            overloadId = 5; // operator>>(QDataStream&,QDate&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORMAP_IDX]), (pyArg)))) {
            overloadId = 3; // operator>>(QDataStream&,QCborMap&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORARRAY_IDX]), (pyArg)))) {
            overloadId = 2; // operator>>(QDataStream&,QCborArray&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
            overloadId = 1; // operator>>(QDataStream&,QByteArray&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), (pyArg)))) {
            overloadId = 27; // operator>>(QDataStream&,QUuid&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), (pyArg)))) {
            overloadId = 4; // operator>>(QDataStream&,QCborValue&)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBITARRAY_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QBitArray&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QDataStreamFunc___rshift___TypeError;

        // Call function/method
        switch (overloadId) {
            case 0: // operator>>(QBitArray & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QBitArray cppArg0_local;
                ::QBitArray *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBITARRAY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QBitArray&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 1: // operator>>(QByteArray & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QByteArray cppArg0_local;
                ::QByteArray *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QByteArray&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 2: // operator>>(QCborArray & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QCborArray cppArg0_local;
                ::QCborArray *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORARRAY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QCborArray&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 3: // operator>>(QCborMap & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QCborMap cppArg0_local;
                ::QCborMap *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORMAP_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QCborMap&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 4: // operator>>(QCborValue & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QCborValue cppArg0_local;
                ::QCborValue *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QCborValue&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 5: // operator>>(QDate & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDate cppArg0_local;
                ::QDate *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QDate&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 6: // operator>>(QDateTime & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDateTime cppArg0_local;
                ::QDateTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QDateTime&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 7: // operator>>(QEasingCurve & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QEasingCurve cppArg0_local;
                ::QEasingCurve *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QEasingCurve&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 8: // operator>>(QJsonArray & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QJsonArray cppArg0_local;
                ::QJsonArray *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONARRAY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QJsonArray&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 9: // operator>>(QJsonDocument & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QJsonDocument cppArg0_local;
                ::QJsonDocument *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONDOCUMENT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QJsonDocument&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 10: // operator>>(QJsonValue & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QJsonValue cppArg0_local;
                ::QJsonValue *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QJsonValue&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 11: // operator>>(QLine & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QLine cppArg0_local;
                ::QLine *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QLine&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 12: // operator>>(QLineF & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QLineF cppArg0_local;
                ::QLineF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QLineF&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 13: // operator>>(QLocale & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QLocale cppArg0_local;
                ::QLocale *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QLocale&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 14: // operator>>(QMargins & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMargins cppArg0_local;
                ::QMargins *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QMargins&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 15: // operator>>(QMarginsF & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMarginsF cppArg0_local;
                ::QMarginsF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QMarginsF&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 16: // operator>>(QPoint & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPoint cppArg0_local;
                ::QPoint *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QPoint&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 17: // operator>>(QPointF & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPointF cppArg0_local;
                ::QPointF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QPointF&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 18: // operator>>(QRect & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QRect cppArg0_local;
                ::QRect *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QRect&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 19: // operator>>(QRectF & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QRectF cppArg0_local;
                ::QRectF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QRectF&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 20: // operator>>(QRegExp & regExp)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QRegExp cppArg0_local;
                ::QRegExp *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QRegExp&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 21: // operator>>(QRegularExpression & re)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QRegularExpression cppArg0_local;
                ::QRegularExpression *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QRegularExpression&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 22: // operator>>(QSize & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSize cppArg0_local;
                ::QSize *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QSize&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 23: // operator>>(QSizeF & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSizeF cppArg0_local;
                ::QSizeF *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QSizeF&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 24: // operator>>(QTime & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTime cppArg0_local;
                ::QTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QTime&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 25: // operator>>(QTimeZone & tz)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTimeZone cppArg0_local;
                ::QTimeZone *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QTimeZone&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 26: // operator>>(QUrl & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QUrl cppArg0_local;
                ::QUrl *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QUrl&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 27: // operator>>(QUuid & arg__2)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QUuid cppArg0_local;
                ::QUuid *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QUuid&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
            case 28: // operator>>(QVersionNumber & version)
            {
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVersionNumber cppArg0_local;
                ::QVersionNumber *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);


                if (!PyErr_Occurred()) {
                    // operator>>(QDataStream&,QVersionNumber&)
                    QDataStream & cppResult = (*cppSelf) >> (*cppArg0);
                    pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
                }
                break;
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDataStreamFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

} // extern "C"

static int Sbk_QDataStream_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDataStream_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDataStream_Type = nullptr;
static SbkObjectType *Sbk_QDataStream_TypeF(void)
{
    return _Sbk_QDataStream_Type;
}

static PyType_Slot Sbk_QDataStream_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDataStream_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDataStream_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDataStream_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDataStream_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QDataStreamFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QDataStreamFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QDataStream_spec = {
    "2:PySide2.QtCore.QDataStream",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDataStream_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QDataStream_Version_PythonToCpp_QDataStream_Version(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDataStream::Version *>(cppOut) =
        static_cast<::QDataStream::Version>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDataStream_Version_PythonToCpp_QDataStream_Version_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX]))
        return QDataStream_Version_PythonToCpp_QDataStream_Version;
    return {};
}
static PyObject *QDataStream_Version_CppToPython_QDataStream_Version(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDataStream::Version *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX], castCppIn);

}

static void QDataStream_ByteOrder_PythonToCpp_QDataStream_ByteOrder(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDataStream::ByteOrder *>(cppOut) =
        static_cast<::QDataStream::ByteOrder>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDataStream_ByteOrder_PythonToCpp_QDataStream_ByteOrder_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_BYTEORDER_IDX]))
        return QDataStream_ByteOrder_PythonToCpp_QDataStream_ByteOrder;
    return {};
}
static PyObject *QDataStream_ByteOrder_CppToPython_QDataStream_ByteOrder(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDataStream::ByteOrder *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_BYTEORDER_IDX], castCppIn);

}

static void QDataStream_Status_PythonToCpp_QDataStream_Status(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDataStream::Status *>(cppOut) =
        static_cast<::QDataStream::Status>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDataStream_Status_PythonToCpp_QDataStream_Status_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_STATUS_IDX]))
        return QDataStream_Status_PythonToCpp_QDataStream_Status;
    return {};
}
static PyObject *QDataStream_Status_CppToPython_QDataStream_Status(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDataStream::Status *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_STATUS_IDX], castCppIn);

}

static void QDataStream_FloatingPointPrecision_PythonToCpp_QDataStream_FloatingPointPrecision(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDataStream::FloatingPointPrecision *>(cppOut) =
        static_cast<::QDataStream::FloatingPointPrecision>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDataStream_FloatingPointPrecision_PythonToCpp_QDataStream_FloatingPointPrecision_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_FLOATINGPOINTPRECISION_IDX]))
        return QDataStream_FloatingPointPrecision_PythonToCpp_QDataStream_FloatingPointPrecision;
    return {};
}
static PyObject *QDataStream_FloatingPointPrecision_CppToPython_QDataStream_FloatingPointPrecision(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDataStream::FloatingPointPrecision *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_FLOATINGPOINTPRECISION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDataStream_PythonToCpp_QDataStream_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDataStream_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDataStream_PythonToCpp_QDataStream_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDataStream_TypeF())))
        return QDataStream_PythonToCpp_QDataStream_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDataStream_PTR_CppToPython_QDataStream(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QDataStream *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QDataStream_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDataStream_SignatureStrings[] = {
    "3:PySide2.QtCore.QDataStream(self)",
    "2:PySide2.QtCore.QDataStream(self,arg__1:PySide2.QtCore.QByteArray,flags:PySide2.QtCore.QIODevice.OpenMode)",
    "1:PySide2.QtCore.QDataStream(self,arg__1:PySide2.QtCore.QIODevice)",
    "0:PySide2.QtCore.QDataStream(self,arg__1:PySide2.QtCore.QByteArray)",
    "PySide2.QtCore.QDataStream.abortTransaction(self)",
    "PySide2.QtCore.QDataStream.atEnd(self)->bool",
    "PySide2.QtCore.QDataStream.byteOrder(self)->PySide2.QtCore.QDataStream.ByteOrder",
    "PySide2.QtCore.QDataStream.commitTransaction(self)->bool",
    "PySide2.QtCore.QDataStream.device(self)->PySide2.QtCore.QIODevice",
    "PySide2.QtCore.QDataStream.floatingPointPrecision(self)->PySide2.QtCore.QDataStream.FloatingPointPrecision",
    "PySide2.QtCore.QDataStream.readBool(self)->bool",
    "PySide2.QtCore.QDataStream.readDouble(self)->qreal",
    "PySide2.QtCore.QDataStream.readFloat(self)->float",
    "PySide2.QtCore.QDataStream.readInt16(self)->qint16",
    "PySide2.QtCore.QDataStream.readInt32(self)->qint32",
    "PySide2.QtCore.QDataStream.readInt64(self)->qint64",
    "PySide2.QtCore.QDataStream.readInt8(self)->qint8",
    "PySide2.QtCore.QDataStream.readQChar(self)->QChar",
    "PySide2.QtCore.QDataStream.readQString(self)->QString",
    "PySide2.QtCore.QDataStream.readQStringList(self)->QStringList",
    "PySide2.QtCore.QDataStream.readQVariant(self)->QVariant",
    "PySide2.QtCore.QDataStream.readRawData(self,arg__1:char*,len:int)->int",
    "PySide2.QtCore.QDataStream.readString(self)->QString",
    "PySide2.QtCore.QDataStream.readUInt16(self)->quint16",
    "PySide2.QtCore.QDataStream.readUInt32(self)->quint32",
    "PySide2.QtCore.QDataStream.readUInt64(self)->quint64",
    "PySide2.QtCore.QDataStream.readUInt8(self)->quint8",
    "PySide2.QtCore.QDataStream.resetStatus(self)",
    "PySide2.QtCore.QDataStream.rollbackTransaction(self)",
    "PySide2.QtCore.QDataStream.setByteOrder(self,arg__1:PySide2.QtCore.QDataStream.ByteOrder)",
    "PySide2.QtCore.QDataStream.setDevice(self,arg__1:PySide2.QtCore.QIODevice)",
    "PySide2.QtCore.QDataStream.setFloatingPointPrecision(self,precision:PySide2.QtCore.QDataStream.FloatingPointPrecision)",
    "PySide2.QtCore.QDataStream.setStatus(self,status:PySide2.QtCore.QDataStream.Status)",
    "PySide2.QtCore.QDataStream.setVersion(self,arg__1:int)",
    "PySide2.QtCore.QDataStream.skipRawData(self,len:int)->int",
    "PySide2.QtCore.QDataStream.startTransaction(self)",
    "PySide2.QtCore.QDataStream.status(self)->PySide2.QtCore.QDataStream.Status",
    "PySide2.QtCore.QDataStream.unsetDevice(self)",
    "PySide2.QtCore.QDataStream.version(self)->int",
    "PySide2.QtCore.QDataStream.writeBool(self,arg__1:bool)",
    "PySide2.QtCore.QDataStream.writeDouble(self,arg__1:qreal)",
    "PySide2.QtCore.QDataStream.writeFloat(self,arg__1:float)",
    "PySide2.QtCore.QDataStream.writeInt16(self,arg__1:qint16)",
    "PySide2.QtCore.QDataStream.writeInt32(self,arg__1:qint32)",
    "PySide2.QtCore.QDataStream.writeInt64(self,arg__1:qint64)",
    "PySide2.QtCore.QDataStream.writeInt8(self,arg__1:qint8)",
    "PySide2.QtCore.QDataStream.writeQChar(self,arg__1:QChar)",
    "PySide2.QtCore.QDataStream.writeQString(self,arg__1:QString)",
    "PySide2.QtCore.QDataStream.writeQStringList(self,arg__1:QStringList)",
    "PySide2.QtCore.QDataStream.writeQVariant(self,arg__1:QVariant)",
    "PySide2.QtCore.QDataStream.writeRawData(self,arg__1:char*,len:int)->int",
    "PySide2.QtCore.QDataStream.writeString(self,arg__1:QString)",
    "PySide2.QtCore.QDataStream.writeUInt16(self,arg__1:quint16)",
    "PySide2.QtCore.QDataStream.writeUInt32(self,arg__1:quint32)",
    "PySide2.QtCore.QDataStream.writeUInt64(self,arg__1:quint64)",
    "PySide2.QtCore.QDataStream.writeUInt8(self,arg__1:quint8)",
    "29:PySide2.QtCore.QDataStream.__lshift__(self,arg__1:QString)",
    "28:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QBitArray)->PySide2.QtCore.QDataStream",
    "27:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QByteArray)->PySide2.QtCore.QDataStream",
    "26:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QCborArray)->PySide2.QtCore.QDataStream",
    "25:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QCborMap)->PySide2.QtCore.QDataStream",
    "24:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QCborValue)->PySide2.QtCore.QDataStream",
    "23:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QDate)->PySide2.QtCore.QDataStream",
    "22:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QDateTime)->PySide2.QtCore.QDataStream",
    "21:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QEasingCurve)->PySide2.QtCore.QDataStream",
    "20:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QJsonArray)->PySide2.QtCore.QDataStream",
    "19:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QJsonDocument)->PySide2.QtCore.QDataStream",
    "18:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QJsonValue)->PySide2.QtCore.QDataStream",
    "17:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QLine)->PySide2.QtCore.QDataStream",
    "16:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QLineF)->PySide2.QtCore.QDataStream",
    "15:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QLocale)->PySide2.QtCore.QDataStream",
    "14:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QMargins)->PySide2.QtCore.QDataStream",
    "13:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QMarginsF)->PySide2.QtCore.QDataStream",
    "12:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QPoint)->PySide2.QtCore.QDataStream",
    "11:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QPointF)->PySide2.QtCore.QDataStream",
    "10:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QRect)->PySide2.QtCore.QDataStream",
    "9:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QRectF)->PySide2.QtCore.QDataStream",
    "8:PySide2.QtCore.QDataStream.__lshift__(self,regExp:PySide2.QtCore.QRegExp)->PySide2.QtCore.QDataStream",
    "7:PySide2.QtCore.QDataStream.__lshift__(self,re:PySide2.QtCore.QRegularExpression)->PySide2.QtCore.QDataStream",
    "6:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QSize)->PySide2.QtCore.QDataStream",
    "5:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QSizeF)->PySide2.QtCore.QDataStream",
    "4:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QTime)->PySide2.QtCore.QDataStream",
    "3:PySide2.QtCore.QDataStream.__lshift__(self,tz:PySide2.QtCore.QTimeZone)->PySide2.QtCore.QDataStream",
    "2:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QUrl)->PySide2.QtCore.QDataStream",
    "1:PySide2.QtCore.QDataStream.__lshift__(self,arg__2:PySide2.QtCore.QUuid)->PySide2.QtCore.QDataStream",
    "0:PySide2.QtCore.QDataStream.__lshift__(self,version:PySide2.QtCore.QVersionNumber)->PySide2.QtCore.QDataStream",
    "28:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QBitArray)->PySide2.QtCore.QDataStream",
    "27:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QByteArray)->PySide2.QtCore.QDataStream",
    "26:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QCborArray)->PySide2.QtCore.QDataStream",
    "25:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QCborMap)->PySide2.QtCore.QDataStream",
    "24:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QCborValue)->PySide2.QtCore.QDataStream",
    "23:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QDate)->PySide2.QtCore.QDataStream",
    "22:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QDateTime)->PySide2.QtCore.QDataStream",
    "21:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QEasingCurve)->PySide2.QtCore.QDataStream",
    "20:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QJsonArray)->PySide2.QtCore.QDataStream",
    "19:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QJsonDocument)->PySide2.QtCore.QDataStream",
    "18:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QJsonValue)->PySide2.QtCore.QDataStream",
    "17:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QLine)->PySide2.QtCore.QDataStream",
    "16:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QLineF)->PySide2.QtCore.QDataStream",
    "15:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QLocale)->PySide2.QtCore.QDataStream",
    "14:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QMargins)->PySide2.QtCore.QDataStream",
    "13:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QMarginsF)->PySide2.QtCore.QDataStream",
    "12:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QPoint)->PySide2.QtCore.QDataStream",
    "11:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QPointF)->PySide2.QtCore.QDataStream",
    "10:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QRect)->PySide2.QtCore.QDataStream",
    "9:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QRectF)->PySide2.QtCore.QDataStream",
    "8:PySide2.QtCore.QDataStream.__rshift__(self,regExp:PySide2.QtCore.QRegExp)->PySide2.QtCore.QDataStream",
    "7:PySide2.QtCore.QDataStream.__rshift__(self,re:PySide2.QtCore.QRegularExpression)->PySide2.QtCore.QDataStream",
    "6:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QSize)->PySide2.QtCore.QDataStream",
    "5:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QSizeF)->PySide2.QtCore.QDataStream",
    "4:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QTime)->PySide2.QtCore.QDataStream",
    "3:PySide2.QtCore.QDataStream.__rshift__(self,tz:PySide2.QtCore.QTimeZone)->PySide2.QtCore.QDataStream",
    "2:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QUrl)->PySide2.QtCore.QDataStream",
    "1:PySide2.QtCore.QDataStream.__rshift__(self,arg__2:PySide2.QtCore.QUuid)->PySide2.QtCore.QDataStream",
    "0:PySide2.QtCore.QDataStream.__rshift__(self,version:PySide2.QtCore.QVersionNumber)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QDataStream(PyObject *module)
{
    _Sbk_QDataStream_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDataStream",
        "QDataStream*",
        &Sbk_QDataStream_spec,
        &Shiboken::callCppDestructor< ::QDataStream >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDataStream_Type);
    InitSignatureStrings(pyType, QDataStream_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDataStream_Type), Sbk_QDataStream_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDataStream_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDataStream_TypeF(),
        QDataStream_PythonToCpp_QDataStream_PTR,
        is_QDataStream_PythonToCpp_QDataStream_PTR_Convertible,
        QDataStream_PTR_CppToPython_QDataStream);

    Shiboken::Conversions::registerConverterName(converter, "QDataStream");
    Shiboken::Conversions::registerConverterName(converter, "QDataStream*");
    Shiboken::Conversions::registerConverterName(converter, "QDataStream&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDataStream).name());


    // Initialization of enums.

    // Initialization of enum 'Version'.
    SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDataStream_TypeF(),
        "Version",
        "2:PySide2.QtCore.QDataStream.Version",
        "QDataStream::Version");
    if (!SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_1_0", (long) QDataStream::Version::Qt_1_0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_2_0", (long) QDataStream::Version::Qt_2_0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_2_1", (long) QDataStream::Version::Qt_2_1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_3_0", (long) QDataStream::Version::Qt_3_0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_3_1", (long) QDataStream::Version::Qt_3_1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_3_3", (long) QDataStream::Version::Qt_3_3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_4_0", (long) QDataStream::Version::Qt_4_0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_4_1", (long) QDataStream::Version::Qt_4_1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_4_2", (long) QDataStream::Version::Qt_4_2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_4_3", (long) QDataStream::Version::Qt_4_3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_4_4", (long) QDataStream::Version::Qt_4_4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_4_5", (long) QDataStream::Version::Qt_4_5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_4_6", (long) QDataStream::Version::Qt_4_6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_4_7", (long) QDataStream::Version::Qt_4_7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_4_8", (long) QDataStream::Version::Qt_4_8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_4_9", (long) QDataStream::Version::Qt_4_9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_0", (long) QDataStream::Version::Qt_5_0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_1", (long) QDataStream::Version::Qt_5_1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_2", (long) QDataStream::Version::Qt_5_2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_3", (long) QDataStream::Version::Qt_5_3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_4", (long) QDataStream::Version::Qt_5_4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_5", (long) QDataStream::Version::Qt_5_5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_6", (long) QDataStream::Version::Qt_5_6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_7", (long) QDataStream::Version::Qt_5_7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_8", (long) QDataStream::Version::Qt_5_8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_9", (long) QDataStream::Version::Qt_5_9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_10", (long) QDataStream::Version::Qt_5_10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_11", (long) QDataStream::Version::Qt_5_11))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_12", (long) QDataStream::Version::Qt_5_12))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_13", (long) QDataStream::Version::Qt_5_13))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_14", (long) QDataStream::Version::Qt_5_14))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_5_15", (long) QDataStream::Version::Qt_5_15))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
        Sbk_QDataStream_TypeF(), "Qt_DefaultCompiledVersion", (long) QDataStream::Version::Qt_DefaultCompiledVersion))
        return;
    // Register converter for enum 'QDataStream::Version'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX],
            QDataStream_Version_CppToPython_QDataStream_Version);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDataStream_Version_PythonToCpp_QDataStream_Version,
            is_QDataStream_Version_PythonToCpp_QDataStream_Version_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDataStream::Version");
        Shiboken::Conversions::registerConverterName(converter, "Version");
    }
    // End of 'Version' enum.

    // Initialization of enum 'ByteOrder'.
    SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_BYTEORDER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDataStream_TypeF(),
        "ByteOrder",
        "2:PySide2.QtCore.QDataStream.ByteOrder",
        "QDataStream::ByteOrder");
    if (!SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_BYTEORDER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_BYTEORDER_IDX],
        Sbk_QDataStream_TypeF(), "BigEndian", (long) QDataStream::ByteOrder::BigEndian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_BYTEORDER_IDX],
        Sbk_QDataStream_TypeF(), "LittleEndian", (long) QDataStream::ByteOrder::LittleEndian))
        return;
    // Register converter for enum 'QDataStream::ByteOrder'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_BYTEORDER_IDX],
            QDataStream_ByteOrder_CppToPython_QDataStream_ByteOrder);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDataStream_ByteOrder_PythonToCpp_QDataStream_ByteOrder,
            is_QDataStream_ByteOrder_PythonToCpp_QDataStream_ByteOrder_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_BYTEORDER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDataStream::ByteOrder");
        Shiboken::Conversions::registerConverterName(converter, "ByteOrder");
    }
    // End of 'ByteOrder' enum.

    // Initialization of enum 'Status'.
    SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_STATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDataStream_TypeF(),
        "Status",
        "2:PySide2.QtCore.QDataStream.Status",
        "QDataStream::Status");
    if (!SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_STATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_STATUS_IDX],
        Sbk_QDataStream_TypeF(), "Ok", (long) QDataStream::Status::Ok))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_STATUS_IDX],
        Sbk_QDataStream_TypeF(), "ReadPastEnd", (long) QDataStream::Status::ReadPastEnd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_STATUS_IDX],
        Sbk_QDataStream_TypeF(), "ReadCorruptData", (long) QDataStream::Status::ReadCorruptData))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_STATUS_IDX],
        Sbk_QDataStream_TypeF(), "WriteFailed", (long) QDataStream::Status::WriteFailed))
        return;
    // Register converter for enum 'QDataStream::Status'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_STATUS_IDX],
            QDataStream_Status_CppToPython_QDataStream_Status);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDataStream_Status_PythonToCpp_QDataStream_Status,
            is_QDataStream_Status_PythonToCpp_QDataStream_Status_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_STATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDataStream::Status");
        Shiboken::Conversions::registerConverterName(converter, "Status");
    }
    // End of 'Status' enum.

    // Initialization of enum 'FloatingPointPrecision'.
    SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_FLOATINGPOINTPRECISION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDataStream_TypeF(),
        "FloatingPointPrecision",
        "2:PySide2.QtCore.QDataStream.FloatingPointPrecision",
        "QDataStream::FloatingPointPrecision");
    if (!SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_FLOATINGPOINTPRECISION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_FLOATINGPOINTPRECISION_IDX],
        Sbk_QDataStream_TypeF(), "SinglePrecision", (long) QDataStream::FloatingPointPrecision::SinglePrecision))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_FLOATINGPOINTPRECISION_IDX],
        Sbk_QDataStream_TypeF(), "DoublePrecision", (long) QDataStream::FloatingPointPrecision::DoublePrecision))
        return;
    // Register converter for enum 'QDataStream::FloatingPointPrecision'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_FLOATINGPOINTPRECISION_IDX],
            QDataStream_FloatingPointPrecision_CppToPython_QDataStream_FloatingPointPrecision);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDataStream_FloatingPointPrecision_PythonToCpp_QDataStream_FloatingPointPrecision,
            is_QDataStream_FloatingPointPrecision_PythonToCpp_QDataStream_FloatingPointPrecision_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_FLOATINGPOINTPRECISION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDataStream::FloatingPointPrecision");
        Shiboken::Conversions::registerConverterName(converter, "FloatingPointPrecision");
    }
    // End of 'FloatingPointPrecision' enum.

    qRegisterMetaType< ::QDataStream::Version >("QDataStream::Version");
    qRegisterMetaType< ::QDataStream::ByteOrder >("QDataStream::ByteOrder");
    qRegisterMetaType< ::QDataStream::Status >("QDataStream::Status");
    qRegisterMetaType< ::QDataStream::FloatingPointPrecision >("QDataStream::FloatingPointPrecision");
}
