/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qdate_wrapper.h"

// inner classes

// Extra includes
#include <datetime.h>
#include <qcalendar.h>
#include <qdatetime.h>
#include <qtimezone.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Begin code injection
// TEMPLATE - pydatetime_importandcheck_function - START
#ifdef IS_PY3K
#define PySideDateTime_IMPORT PyDateTime_IMPORT
#else
#define PySideDateTime_IMPORT \
            (PyDateTimeAPI = (PyDateTime_CAPI*) PyCObject_Import((char*)"datetime", \
                                                             (char*)"datetime_CAPI"))
#endif
static bool PyDateTime_ImportAndCheck(PyObject *pyIn) {
    if (!PyDateTimeAPI) PySideDateTime_IMPORT;
    return PyDate_Check(pyIn);
}
// TEMPLATE - pydatetime_importandcheck_function - END

// End of code injection



// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDate_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDate >()))
        return -1;

    ::QDate *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto Sbk_QDate_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QDate", 0, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QDate::QDate()
    // 1: QDate::QDate(QDate)
    // 2: QDate::QDate(int,int,int)
    // 3: QDate::QDate(int,int,int,QCalendar)
    if (numArgs == 0) {
        overloadId = 0; // QDate()
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 2; // QDate(int,int,int)
        } else if (numArgs == 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[3])))) {
            overloadId = 3; // QDate(int,int,int,QCalendar)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QDate(QDate)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDate_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QDate()
        {

            if (!PyErr_Occurred()) {
                // QDate()
                cptr = new ::QDate();
            }
            break;
        }
        case 1: // QDate(const QDate & QDate)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDate cppArg0_local;
            ::QDate *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QDate(QDate)
                cptr = new ::QDate(*cppArg0);
            }
            break;
        }
        case 2: // QDate(int y, int m, int d)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QDate(int,int,int)
                cptr = new ::QDate(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 3: // QDate(int y, int m, int d, QCalendar cal)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return -1;
            ::QCalendar cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QDate(int,int,int,QCalendar)
                cptr = new ::QDate(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDate >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDate_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QDate_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDateFunc___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // TEMPLATE - reduce_code - START
            pyResult = Py_BuildValue("(N(iii))", PyObject_Type(self), cppSelf->year(), cppSelf->month(), cppSelf->day());
            // TEMPLATE - reduce_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateFunc___repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.__repr__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __repr__()
            // Begin code injection
            // TEMPLATE - repr_code - START
            QString format = QString::asprintf("%s(%i, %i, %i)",
                Py_TYPE(self)->tp_name, cppSelf->year(), cppSelf->month(), cppSelf->day());
            pyResult = Shiboken::String::fromCString(qPrintable(format));
            // TEMPLATE - repr_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateFunc_addDays(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.addDays";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDate::addDays(qint64)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // addDays(qint64)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_addDays_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addDays(qint64)const
            QDate cppResult = const_cast<const ::QDate *>(cppSelf)->addDays(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_addDays_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_addMonths(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.addMonths";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addMonths", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDate::addMonths(int)const
    // 1: QDate::addMonths(int,QCalendar)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addMonths(int)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[1])))) {
            overloadId = 1; // addMonths(int,QCalendar)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_addMonths_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addMonths(int months) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // addMonths(int)const
                QDate cppResult = const_cast<const ::QDate *>(cppSelf)->addMonths(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // addMonths(int months, QCalendar cal) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QCalendar cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addMonths(int,QCalendar)const
                QDate cppResult = const_cast<const ::QDate *>(cppSelf)->addMonths(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_addMonths_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_addYears(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.addYears";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addYears", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDate::addYears(int)const
    // 1: QDate::addYears(int,QCalendar)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addYears(int)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[1])))) {
            overloadId = 1; // addYears(int,QCalendar)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_addYears_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addYears(int years) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // addYears(int)const
                QDate cppResult = const_cast<const ::QDate *>(cppSelf)->addYears(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // addYears(int years, QCalendar cal) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QCalendar cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addYears(int,QCalendar)const
                QDate cppResult = const_cast<const ::QDate *>(cppSelf)->addYears(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_addYears_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_currentDate(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.currentDate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentDate()
            QDate cppResult = ::QDate::currentDate();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateFunc_day(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.day";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "day", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDate::day()const
    // 1: QDate::day(QCalendar)const
    if (numArgs == 0) {
        overloadId = 0; // day()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // day(QCalendar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_day_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // day() const
        {

            if (!PyErr_Occurred()) {
                // day()const
                int cppResult = const_cast<const ::QDate *>(cppSelf)->day();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // day(QCalendar cal) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QCalendar cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // day(QCalendar)const
                int cppResult = const_cast<const ::QDate *>(cppSelf)->day(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_day_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_dayOfWeek(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.dayOfWeek";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "dayOfWeek", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDate::dayOfWeek()const
    // 1: QDate::dayOfWeek(QCalendar)const
    if (numArgs == 0) {
        overloadId = 0; // dayOfWeek()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // dayOfWeek(QCalendar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_dayOfWeek_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // dayOfWeek() const
        {

            if (!PyErr_Occurred()) {
                // dayOfWeek()const
                int cppResult = const_cast<const ::QDate *>(cppSelf)->dayOfWeek();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // dayOfWeek(QCalendar cal) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QCalendar cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // dayOfWeek(QCalendar)const
                int cppResult = const_cast<const ::QDate *>(cppSelf)->dayOfWeek(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_dayOfWeek_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_dayOfYear(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.dayOfYear";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "dayOfYear", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDate::dayOfYear()const
    // 1: QDate::dayOfYear(QCalendar)const
    if (numArgs == 0) {
        overloadId = 0; // dayOfYear()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // dayOfYear(QCalendar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_dayOfYear_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // dayOfYear() const
        {

            if (!PyErr_Occurred()) {
                // dayOfYear()const
                int cppResult = const_cast<const ::QDate *>(cppSelf)->dayOfYear();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // dayOfYear(QCalendar cal) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QCalendar cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // dayOfYear(QCalendar)const
                int cppResult = const_cast<const ::QDate *>(cppSelf)->dayOfYear(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_dayOfYear_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_daysInMonth(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.daysInMonth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "daysInMonth", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDate::daysInMonth()const
    // 1: QDate::daysInMonth(QCalendar)const
    if (numArgs == 0) {
        overloadId = 0; // daysInMonth()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // daysInMonth(QCalendar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_daysInMonth_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // daysInMonth() const
        {

            if (!PyErr_Occurred()) {
                // daysInMonth()const
                int cppResult = const_cast<const ::QDate *>(cppSelf)->daysInMonth();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // daysInMonth(QCalendar cal) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QCalendar cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // daysInMonth(QCalendar)const
                int cppResult = const_cast<const ::QDate *>(cppSelf)->daysInMonth(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_daysInMonth_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_daysInYear(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.daysInYear";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "daysInYear", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDate::daysInYear()const
    // 1: QDate::daysInYear(QCalendar)const
    if (numArgs == 0) {
        overloadId = 0; // daysInYear()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // daysInYear(QCalendar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_daysInYear_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // daysInYear() const
        {

            if (!PyErr_Occurred()) {
                // daysInYear()const
                int cppResult = const_cast<const ::QDate *>(cppSelf)->daysInYear();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // daysInYear(QCalendar cal) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QCalendar cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // daysInYear(QCalendar)const
                int cppResult = const_cast<const ::QDate *>(cppSelf)->daysInYear(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_daysInYear_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_daysTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.daysTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDate::daysTo(QDate)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), (pyArg)))) {
        overloadId = 0; // daysTo(QDate)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_daysTo_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDate cppArg0_local;
        ::QDate *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // daysTo(QDate)const
            qint64 cppResult = const_cast<const ::QDate *>(cppSelf)->daysTo(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_daysTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_endOfDay(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.endOfDay";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDateFunc_endOfDay_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:endOfDay", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDate::endOfDay(Qt::TimeSpec,int)const
    // 1: QDate::endOfDay(QTimeZone)const
    if (numArgs == 0) {
        overloadId = 0; // endOfDay(Qt::TimeSpec,int)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // endOfDay(QTimeZone)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // endOfDay(Qt::TimeSpec,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // endOfDay(Qt::TimeSpec,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_endOfDay_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // endOfDay(Qt::TimeSpec spec, int offsetSeconds) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_spec = Shiboken::String::createStaticString("spec");
                if (PyDict_Contains(kwds, key_spec)) {
                    value = PyDict_GetItem(kwds, key_spec);
                    if (value && pyArgs[0]) {
                        errInfo = key_spec;
                        Py_INCREF(errInfo);
                        goto Sbk_QDateFunc_endOfDay_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QDateFunc_endOfDay_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_spec);
                }
                static PyObject *const key_offsetSeconds = Shiboken::String::createStaticString("offsetSeconds");
                if (PyDict_Contains(kwds, key_offsetSeconds)) {
                    value = PyDict_GetItem(kwds, key_offsetSeconds);
                    if (value && pyArgs[1]) {
                        errInfo = key_offsetSeconds;
                        Py_INCREF(errInfo);
                        goto Sbk_QDateFunc_endOfDay_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QDateFunc_endOfDay_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_offsetSeconds);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDateFunc_endOfDay_TypeError;
                }
            }
            ::Qt::TimeSpec cppArg0 = Qt::LocalTime;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // endOfDay(Qt::TimeSpec,int)const
                QDateTime cppResult = const_cast<const ::QDate *>(cppSelf)->endOfDay(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
        case 1: // endOfDay(const QTimeZone & zone) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateFunc_endOfDay_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QTimeZone cppArg0_local;
            ::QTimeZone *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // endOfDay(QTimeZone)const
                QDateTime cppResult = const_cast<const ::QDate *>(cppSelf)->endOfDay(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_endOfDay_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_fromJulianDay(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.fromJulianDay";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QDate::fromJulianDay(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // fromJulianDay(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_fromJulianDay_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromJulianDay(qint64)
            QDate cppResult = ::QDate::fromJulianDay(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_fromJulianDay_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_fromString(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.fromString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDateFunc_fromString_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDateFunc_fromString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:fromString", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QDate::fromString(QString,Qt::DateFormat)
    // 1: static QDate::fromString(QString,QString)
    // 2: static QDate::fromString(QString,QString,QCalendar)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromString(QString,Qt::DateFormat)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // fromString(QString,QString)
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[2])))) {
                overloadId = 2; // fromString(QString,QString,QCalendar)
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // fromString(QString,Qt::DateFormat)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_fromString_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fromString(const QString & s, Qt::DateFormat f)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_f = Shiboken::String::createStaticString("f");
                if (PyDict_Contains(kwds, key_f)) {
                    value = PyDict_GetItem(kwds, key_f);
                    if (value && pyArgs[1]) {
                        errInfo = key_f;
                        Py_INCREF(errInfo);
                        goto Sbk_QDateFunc_fromString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QDateFunc_fromString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_f);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDateFunc_fromString_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::DateFormat cppArg1 = Qt::TextDate;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fromString(QString,Qt::DateFormat)
                QDate cppResult = ::QDate::fromString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // fromString(const QString & s, const QString & format)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateFunc_fromString_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fromString(QString,QString)
                QDate cppResult = ::QDate::fromString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
            }
            break;
        }
        case 2: // fromString(const QString & s, const QString & format, QCalendar cal)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateFunc_fromString_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QCalendar cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // fromString(QString,QString,QCalendar)
                QDate cppResult = ::QDate::fromString(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_fromString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_getDate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.getDate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 1 || numArgs == 2)
        goto Sbk_QDateFunc_getDate_TypeError;

    if (!PyArg_UnpackTuple(args, "getDate", 0, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QDate::getDate(int*,int*,int*)
    if (numArgs == 0) {
        overloadId = 0; // getDate(int*,int*,int*)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 1; // getDate(int*,int*,int*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_getDate_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getDate(int*,int*,int*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qdate-getdate)]
            int year, month, day;
            cppSelf->getDate(&year, &month, &day);
            pyResult = PyTuple_New(3);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &year));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &month));
            PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &day));
            // END of custom code block [file: ../glue/qtcore.cpp (qdate-getdate)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_getDate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_isLeapYear(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.isLeapYear";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QDate::isLeapYear(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // isLeapYear(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_isLeapYear_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isLeapYear(int)
            bool cppResult = ::QDate::isLeapYear(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_isLeapYear_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QDate *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateFunc_isValid(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QDate *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.isValid";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 1 || numArgs == 2)
        goto Sbk_QDateFunc_isValid_TypeError;

    if (!PyArg_UnpackTuple(args, "isValid", 0, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QDate::isValid()const
    // 1: static QDate::isValid(int,int,int)
    if (numArgs == 0) {
        overloadId = 0; // isValid()const
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 1; // isValid(int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_isValid_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // isValid() const
        {

            if (!PyErr_Occurred()) {
                // isValid()const
                bool cppResult = const_cast<const ::QDate *>(cppSelf)->isValid();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // isValid(int y, int m, int d)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // isValid(int,int,int)
                bool cppResult = ::QDate::isValid(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_isValid_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_longDayName(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.longDayName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDateFunc_longDayName_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDateFunc_longDayName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:longDayName", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QDate::longDayName(int,QDate::MonthNameType)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // longDayName(int,QDate::MonthNameType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // longDayName(int,QDate::MonthNameType)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_longDayName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_type = Shiboken::String::createStaticString("type");
            if (PyDict_Contains(kwds, key_type)) {
                value = PyDict_GetItem(kwds, key_type);
                if (value && pyArgs[1]) {
                    errInfo = key_type;
                    Py_INCREF(errInfo);
                    goto Sbk_QDateFunc_longDayName_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QDateFunc_longDayName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_type);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDateFunc_longDayName_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QDate::MonthNameType cppArg1 = QDate::MonthNameType::DateFormat;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // longDayName(int,QDate::MonthNameType)
            QString cppResult = ::QDate::longDayName(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_longDayName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_longMonthName(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.longMonthName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDateFunc_longMonthName_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDateFunc_longMonthName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:longMonthName", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QDate::longMonthName(int,QDate::MonthNameType)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // longMonthName(int,QDate::MonthNameType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // longMonthName(int,QDate::MonthNameType)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_longMonthName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_type = Shiboken::String::createStaticString("type");
            if (PyDict_Contains(kwds, key_type)) {
                value = PyDict_GetItem(kwds, key_type);
                if (value && pyArgs[1]) {
                    errInfo = key_type;
                    Py_INCREF(errInfo);
                    goto Sbk_QDateFunc_longMonthName_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QDateFunc_longMonthName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_type);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDateFunc_longMonthName_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QDate::MonthNameType cppArg1 = QDate::MonthNameType::DateFormat;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // longMonthName(int,QDate::MonthNameType)
            QString cppResult = ::QDate::longMonthName(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_longMonthName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_month(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.month";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "month", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDate::month()const
    // 1: QDate::month(QCalendar)const
    if (numArgs == 0) {
        overloadId = 0; // month()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // month(QCalendar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_month_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // month() const
        {

            if (!PyErr_Occurred()) {
                // month()const
                int cppResult = const_cast<const ::QDate *>(cppSelf)->month();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // month(QCalendar cal) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QCalendar cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // month(QCalendar)const
                int cppResult = const_cast<const ::QDate *>(cppSelf)->month(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_month_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_setDate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.setDate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setDate", 3, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QDate::setDate(int,int,int)
    // 1: QDate::setDate(int,int,int,QCalendar)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // setDate(int,int,int)
        } else if (numArgs == 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[3])))) {
            overloadId = 1; // setDate(int,int,int,QCalendar)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_setDate_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setDate(int year, int month, int day)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setDate(int,int,int)
                bool cppResult = cppSelf->setDate(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // setDate(int year, int month, int day, QCalendar cal)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QCalendar cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setDate(int,int,int,QCalendar)
                bool cppResult = cppSelf->setDate(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_setDate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_shortDayName(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.shortDayName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDateFunc_shortDayName_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDateFunc_shortDayName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:shortDayName", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QDate::shortDayName(int,QDate::MonthNameType)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // shortDayName(int,QDate::MonthNameType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // shortDayName(int,QDate::MonthNameType)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_shortDayName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_type = Shiboken::String::createStaticString("type");
            if (PyDict_Contains(kwds, key_type)) {
                value = PyDict_GetItem(kwds, key_type);
                if (value && pyArgs[1]) {
                    errInfo = key_type;
                    Py_INCREF(errInfo);
                    goto Sbk_QDateFunc_shortDayName_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QDateFunc_shortDayName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_type);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDateFunc_shortDayName_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QDate::MonthNameType cppArg1 = QDate::MonthNameType::DateFormat;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // shortDayName(int,QDate::MonthNameType)
            QString cppResult = ::QDate::shortDayName(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_shortDayName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_shortMonthName(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.shortMonthName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDateFunc_shortMonthName_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDateFunc_shortMonthName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:shortMonthName", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QDate::shortMonthName(int,QDate::MonthNameType)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // shortMonthName(int,QDate::MonthNameType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // shortMonthName(int,QDate::MonthNameType)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_shortMonthName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_type = Shiboken::String::createStaticString("type");
            if (PyDict_Contains(kwds, key_type)) {
                value = PyDict_GetItem(kwds, key_type);
                if (value && pyArgs[1]) {
                    errInfo = key_type;
                    Py_INCREF(errInfo);
                    goto Sbk_QDateFunc_shortMonthName_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QDateFunc_shortMonthName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_type);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDateFunc_shortMonthName_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QDate::MonthNameType cppArg1 = QDate::MonthNameType::DateFormat;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // shortMonthName(int,QDate::MonthNameType)
            QString cppResult = ::QDate::shortMonthName(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_shortMonthName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_startOfDay(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.startOfDay";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDateFunc_startOfDay_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:startOfDay", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDate::startOfDay(Qt::TimeSpec,int)const
    // 1: QDate::startOfDay(QTimeZone)const
    if (numArgs == 0) {
        overloadId = 0; // startOfDay(Qt::TimeSpec,int)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // startOfDay(QTimeZone)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // startOfDay(Qt::TimeSpec,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // startOfDay(Qt::TimeSpec,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_startOfDay_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // startOfDay(Qt::TimeSpec spec, int offsetSeconds) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_spec = Shiboken::String::createStaticString("spec");
                if (PyDict_Contains(kwds, key_spec)) {
                    value = PyDict_GetItem(kwds, key_spec);
                    if (value && pyArgs[0]) {
                        errInfo = key_spec;
                        Py_INCREF(errInfo);
                        goto Sbk_QDateFunc_startOfDay_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QDateFunc_startOfDay_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_spec);
                }
                static PyObject *const key_offsetSeconds = Shiboken::String::createStaticString("offsetSeconds");
                if (PyDict_Contains(kwds, key_offsetSeconds)) {
                    value = PyDict_GetItem(kwds, key_offsetSeconds);
                    if (value && pyArgs[1]) {
                        errInfo = key_offsetSeconds;
                        Py_INCREF(errInfo);
                        goto Sbk_QDateFunc_startOfDay_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QDateFunc_startOfDay_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_offsetSeconds);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDateFunc_startOfDay_TypeError;
                }
            }
            ::Qt::TimeSpec cppArg0 = Qt::LocalTime;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // startOfDay(Qt::TimeSpec,int)const
                QDateTime cppResult = const_cast<const ::QDate *>(cppSelf)->startOfDay(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
        case 1: // startOfDay(const QTimeZone & zone) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateFunc_startOfDay_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QTimeZone cppArg0_local;
            ::QTimeZone *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // startOfDay(QTimeZone)const
                QDateTime cppResult = const_cast<const ::QDate *>(cppSelf)->startOfDay(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_startOfDay_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_toJulianDay(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.toJulianDay";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toJulianDay()const
            qint64 cppResult = const_cast<const ::QDate *>(cppSelf)->toJulianDay();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateFunc_toPython(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.toPython";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toPython()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qdate-topython)]
            if (!PyDateTimeAPI)
                PySideDateTime_IMPORT;
            pyResult = PyDate_FromDate(cppSelf->year(), cppSelf->month(), cppSelf->day());
            // END of custom code block [file: ../glue/qtcore.cpp (qdate-topython)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateFunc_toString(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.toString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDateFunc_toString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:toString", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDate::toString(Qt::DateFormat)const
    // 1: QDate::toString(Qt::DateFormat,QCalendar)const
    // 2: QDate::toString(QString)const
    // 3: QDate::toString(QString,QCalendar)const
    if (numArgs == 0) {
        overloadId = 0; // toString(Qt::DateFormat)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // toString(QString)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[1])))) {
            overloadId = 3; // toString(QString,QCalendar)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toString(Qt::DateFormat)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[1])))) {
            overloadId = 1; // toString(Qt::DateFormat,QCalendar)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_toString_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toString(Qt::DateFormat format) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[0]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QDateFunc_toString_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QDateFunc_toString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDateFunc_toString_TypeError;
                }
            }
            ::Qt::DateFormat cppArg0 = Qt::TextDate;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toString(Qt::DateFormat)const
                QString cppResult = const_cast<const ::QDate *>(cppSelf)->toString(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // toString(Qt::DateFormat format, QCalendar cal) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateFunc_toString_TypeError;
            }
            ::Qt::DateFormat cppArg0{Qt::TextDate};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QCalendar cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toString(Qt::DateFormat,QCalendar)const
                QString cppResult = const_cast<const ::QDate *>(cppSelf)->toString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QDate.toString(Qt::DateFormat format, QCalendar cal) const is deprecated", 1);
            break;
        }
        case 2: // toString(const QString & format) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateFunc_toString_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toString(QString)const
                QString cppResult = const_cast<const ::QDate *>(cppSelf)->toString(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 3: // toString(const QString & format, QCalendar cal) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateFunc_toString_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QCalendar cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toString(QString,QCalendar)const
                QString cppResult = const_cast<const ::QDate *>(cppSelf)->toString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_toString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateFunc_weekNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.weekNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {
        int* removed_cppArg0 = nullptr;
        SBK_UNUSED(removed_cppArg0)

        if (!PyErr_Occurred()) {
            // weekNumber(int*)const
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qdate-weeknumber)]
            int yearNumber;
            int week = cppSelf->weekNumber(&yearNumber);
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &week));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &yearNumber));
            // END of custom code block [file: ../glue/qtcore.cpp (qdate-weeknumber)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateFunc_year(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDate.year";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "year", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDate::year()const
    // 1: QDate::year(QCalendar)const
    if (numArgs == 0) {
        overloadId = 0; // year()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // year(QCalendar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateFunc_year_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // year() const
        {

            if (!PyErr_Occurred()) {
                // year()const
                int cppResult = const_cast<const ::QDate *>(cppSelf)->year();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // year(QCalendar cal) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QCalendar cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // year(QCalendar)const
                int cppResult = const_cast<const ::QDate *>(cppSelf)->year(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateFunc_year_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDate___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyMethodDef Sbk_QDateMethod_isValid = {
    "isValid", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_isValid), METH_VARARGS|METH_STATIC
};


static const char *Sbk_QDate_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDate_methods[] = {
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QDateFunc___reduce__), METH_NOARGS},
    {"addDays", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_addDays), METH_O},
    {"addMonths", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_addMonths), METH_VARARGS},
    {"addYears", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_addYears), METH_VARARGS},
    {"currentDate", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_currentDate), METH_NOARGS|METH_STATIC},
    {"day", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_day), METH_VARARGS},
    {"dayOfWeek", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_dayOfWeek), METH_VARARGS},
    {"dayOfYear", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_dayOfYear), METH_VARARGS},
    {"daysInMonth", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_daysInMonth), METH_VARARGS},
    {"daysInYear", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_daysInYear), METH_VARARGS},
    {"daysTo", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_daysTo), METH_O},
    {"endOfDay", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_endOfDay), METH_VARARGS|METH_KEYWORDS},
    {"fromJulianDay", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_fromJulianDay), METH_O|METH_STATIC},
    {"fromString", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_fromString), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"getDate", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_getDate), METH_VARARGS},
    {"isLeapYear", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_isLeapYear), METH_O|METH_STATIC},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_isNull), METH_NOARGS},
    Sbk_QDateMethod_isValid,
    {"longDayName", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_longDayName), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"longMonthName", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_longMonthName), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"month", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_month), METH_VARARGS},
    {"setDate", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_setDate), METH_VARARGS},
    {"shortDayName", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_shortDayName), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"shortMonthName", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_shortMonthName), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"startOfDay", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_startOfDay), METH_VARARGS|METH_KEYWORDS},
    {"toJulianDay", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_toJulianDay), METH_NOARGS},
    {"toPython", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_toPython), METH_NOARGS},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_toString), METH_VARARGS|METH_KEYWORDS},
    {"weekNumber", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_weekNumber), METH_NOARGS},
    {"year", reinterpret_cast<PyCFunction>(Sbk_QDateFunc_year), METH_VARARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QDate___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QDate_getattro(PyObject *self, PyObject *name)
{
    PySide::Feature::Select(self);
    // Search the method in the instance dict
    if (auto ob_dict = reinterpret_cast<SbkObject *>(self)->ob_dict) {
        if (auto meth = PyDict_GetItem(ob_dict, name)) {
            Py_INCREF(meth);
            return meth;
        }
    }
    // Search the method in the type dict
    if (Shiboken::Object::isUserType(self)) {
        Shiboken::AutoDecRef tmp(_Pep_PrivateMangle(self, name));
        if (auto meth = PyDict_GetItem(Py_TYPE(self)->tp_dict, tmp))
            return PyFunction_Check(meth) ? SBK_PyMethod_New(meth, self) : PyObject_GenericGetAttr(self, name);
    }
    static PyMethodDef non_static_Sbk_QDateMethod_isValid = {
        Sbk_QDateMethod_isValid.ml_name,
        Sbk_QDateMethod_isValid.ml_meth,
        Sbk_QDateMethod_isValid.ml_flags & (~METH_STATIC),
        Sbk_QDateMethod_isValid.ml_doc,
    };
    if (Shiboken::String::compare(name, "isValid") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QDateMethod_isValid, self, 0);
    return PyObject_GenericGetAttr(self, name);
}

static int Sbk_QDate___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QDate_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), (pyArg)))) {
                // operator!=(const QDate & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDate cppArg0_local;
                ::QDate *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), (pyArg)))) {
                // operator<(const QDate & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDate cppArg0_local;
                ::QDate *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QDate_RichComparison_TypeError;
            }

            break;
        case Py_LE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), (pyArg)))) {
                // operator<=(const QDate & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDate cppArg0_local;
                ::QDate *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QDate_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), (pyArg)))) {
                // operator==(const QDate & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDate cppArg0_local;
                ::QDate *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        case Py_GT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), (pyArg)))) {
                // operator>(const QDate & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDate cppArg0_local;
                ::QDate *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QDate_RichComparison_TypeError;
            }

            break;
        case Py_GE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), (pyArg)))) {
                // operator>=(const QDate & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDate cppArg0_local;
                ::QDate *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QDate_RichComparison_TypeError;
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QDate_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QDate_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static Py_hash_t Sbk_QDate_HashFunc(PyObject *self) {
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Py_hash_t(PySide::hash(*cppSelf));
}

static int Sbk_QDate_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDate_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDate_Type = nullptr;
static SbkObjectType *Sbk_QDate_TypeF(void)
{
    return _Sbk_QDate_Type;
}

static PyType_Slot Sbk_QDate_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QDateFunc___repr__)},
    {Py_tp_hash,        reinterpret_cast<void *>(&Sbk_QDate_HashFunc)},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    reinterpret_cast<void *>(Sbk_QDate_getattro)},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDate_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDate_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QDate_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDate_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDate_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QDate___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QDate___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QDate_spec = {
    "2:PySide2.QtCore.QDate",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDate_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QDate_MonthNameType_PythonToCpp_QDate_MonthNameType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDate::MonthNameType *>(cppOut) =
        static_cast<::QDate::MonthNameType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDate_MonthNameType_PythonToCpp_QDate_MonthNameType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX]))
        return QDate_MonthNameType_PythonToCpp_QDate_MonthNameType;
    return {};
}
static PyObject *QDate_MonthNameType_CppToPython_QDate_MonthNameType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDate::MonthNameType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDate_PythonToCpp_QDate_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDate_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDate_PythonToCpp_QDate_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDate_TypeF())))
        return QDate_PythonToCpp_QDate_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDate_PTR_CppToPython_QDate(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QDate *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QDate_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QDate_COPY_CppToPython_QDate(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QDate_TypeF(), new ::QDate(*reinterpret_cast<const ::QDate *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QDate_PythonToCpp_QDate_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDate *>(cppOut) = *reinterpret_cast< ::QDate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QDate_PythonToCpp_QDate_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDate_TypeF())))
        return QDate_PythonToCpp_QDate_COPY;
    return {};
}

// Python to C++ conversions for type 'QDate'.
static void Py_None_PythonToCpp_QDate(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pynone)]
    *reinterpret_cast<::QDate *>(cppOut) = QDate();
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pynone)]
    // ========================================================================

}
static PythonToCppFunc is_Py_None_PythonToCpp_QDate_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Py_None_PythonToCpp_QDate;
    return {};
}
static void PyDate_PythonToCpp_QDate(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qdate-pydate)]
    int day = PyDateTime_GET_DAY(pyIn);
    int month = PyDateTime_GET_MONTH(pyIn);
    int year = PyDateTime_GET_YEAR(pyIn);
    *reinterpret_cast<::QDate *>(cppOut) = QDate(year, month, day);
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qdate-pydate)]
    // ========================================================================

}
static PythonToCppFunc is_PyDate_PythonToCpp_QDate_Convertible(PyObject *pyIn) {
    if (PyDateTime_ImportAndCheck(pyIn))
        return PyDate_PythonToCpp_QDate;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDate_SignatureStrings[] = {
    "3:PySide2.QtCore.QDate(self)",
    "2:PySide2.QtCore.QDate(self,QDate:PySide2.QtCore.QDate)",
    "1:PySide2.QtCore.QDate(self,y:int,m:int,d:int)",
    "0:PySide2.QtCore.QDate(self,y:int,m:int,d:int,cal:PySide2.QtCore.QCalendar)",
    "PySide2.QtCore.QDate.__reduce__(self)->PyObject",
    "PySide2.QtCore.QDate.__repr__(self)->PyObject",
    "PySide2.QtCore.QDate.addDays(self,days:qint64)->PySide2.QtCore.QDate",
    "1:PySide2.QtCore.QDate.addMonths(self,months:int)->PySide2.QtCore.QDate",
    "0:PySide2.QtCore.QDate.addMonths(self,months:int,cal:PySide2.QtCore.QCalendar)->PySide2.QtCore.QDate",
    "1:PySide2.QtCore.QDate.addYears(self,years:int)->PySide2.QtCore.QDate",
    "0:PySide2.QtCore.QDate.addYears(self,years:int,cal:PySide2.QtCore.QCalendar)->PySide2.QtCore.QDate",
    "PySide2.QtCore.QDate.currentDate()->PySide2.QtCore.QDate",
    "1:PySide2.QtCore.QDate.day(self)->int",
    "0:PySide2.QtCore.QDate.day(self,cal:PySide2.QtCore.QCalendar)->int",
    "1:PySide2.QtCore.QDate.dayOfWeek(self)->int",
    "0:PySide2.QtCore.QDate.dayOfWeek(self,cal:PySide2.QtCore.QCalendar)->int",
    "1:PySide2.QtCore.QDate.dayOfYear(self)->int",
    "0:PySide2.QtCore.QDate.dayOfYear(self,cal:PySide2.QtCore.QCalendar)->int",
    "1:PySide2.QtCore.QDate.daysInMonth(self)->int",
    "0:PySide2.QtCore.QDate.daysInMonth(self,cal:PySide2.QtCore.QCalendar)->int",
    "1:PySide2.QtCore.QDate.daysInYear(self)->int",
    "0:PySide2.QtCore.QDate.daysInYear(self,cal:PySide2.QtCore.QCalendar)->int",
    "PySide2.QtCore.QDate.daysTo(self,arg__1:PySide2.QtCore.QDate)->qint64",
    "1:PySide2.QtCore.QDate.endOfDay(self,spec:PySide2.QtCore.Qt.TimeSpec=Qt.LocalTime,offsetSeconds:int=0)->PySide2.QtCore.QDateTime",
    "0:PySide2.QtCore.QDate.endOfDay(self,zone:PySide2.QtCore.QTimeZone)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QDate.fromJulianDay(jd_:qint64)->PySide2.QtCore.QDate",
    "2:PySide2.QtCore.QDate.fromString(s:QString,f:PySide2.QtCore.Qt.DateFormat=Qt.TextDate)->PySide2.QtCore.QDate",
    "1:PySide2.QtCore.QDate.fromString(s:QString,format:QString)->PySide2.QtCore.QDate",
    "0:PySide2.QtCore.QDate.fromString(s:QString,format:QString,cal:PySide2.QtCore.QCalendar)->PySide2.QtCore.QDate",
    "1:PySide2.QtCore.QDate.getDate(self,year:int*,month:int*,day:int*)",
    "0:PySide2.QtCore.QDate.getDate(self,year:int*,month:int*,day:int*)",
    "PySide2.QtCore.QDate.isLeapYear(year:int)->bool",
    "PySide2.QtCore.QDate.isNull(self)->bool",
    "1:PySide2.QtCore.QDate.isValid(self)->bool",
    "0:PySide2.QtCore.QDate.isValid(y:int,m:int,d:int)->bool",
    "PySide2.QtCore.QDate.longDayName(weekday:int,type:PySide2.QtCore.QDate.MonthNameType=DateFormat)->QString",
    "PySide2.QtCore.QDate.longMonthName(month:int,type:PySide2.QtCore.QDate.MonthNameType=DateFormat)->QString",
    "1:PySide2.QtCore.QDate.month(self)->int",
    "0:PySide2.QtCore.QDate.month(self,cal:PySide2.QtCore.QCalendar)->int",
    "1:PySide2.QtCore.QDate.setDate(self,year:int,month:int,day:int)->bool",
    "0:PySide2.QtCore.QDate.setDate(self,year:int,month:int,day:int,cal:PySide2.QtCore.QCalendar)->bool",
    "PySide2.QtCore.QDate.shortDayName(weekday:int,type:PySide2.QtCore.QDate.MonthNameType=DateFormat)->QString",
    "PySide2.QtCore.QDate.shortMonthName(month:int,type:PySide2.QtCore.QDate.MonthNameType=DateFormat)->QString",
    "1:PySide2.QtCore.QDate.startOfDay(self,spec:PySide2.QtCore.Qt.TimeSpec=Qt.LocalTime,offsetSeconds:int=0)->PySide2.QtCore.QDateTime",
    "0:PySide2.QtCore.QDate.startOfDay(self,zone:PySide2.QtCore.QTimeZone)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QDate.toJulianDay(self)->qint64",
    "PySide2.QtCore.QDate.toPython(self)->PyObject",
    "3:PySide2.QtCore.QDate.toString(self,format:PySide2.QtCore.Qt.DateFormat=Qt.TextDate)->QString",
    "2:PySide2.QtCore.QDate.toString(self,format:PySide2.QtCore.Qt.DateFormat,cal:PySide2.QtCore.QCalendar)->QString",
    "1:PySide2.QtCore.QDate.toString(self,format:QString)->QString",
    "0:PySide2.QtCore.QDate.toString(self,format:QString,cal:PySide2.QtCore.QCalendar)->QString",
    "PySide2.QtCore.QDate.weekNumber(self,yearNum:int*=nullptr)->int",
    "1:PySide2.QtCore.QDate.year(self)->int",
    "0:PySide2.QtCore.QDate.year(self,cal:PySide2.QtCore.QCalendar)->int",
    "PySide2.QtCore.QDate.__copy__()",
    nullptr}; // Sentinel

void init_QDate(PyObject *module)
{
    _Sbk_QDate_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDate",
        "QDate",
        &Sbk_QDate_spec,
        &Shiboken::callCppDestructor< ::QDate >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDate_Type);
    InitSignatureStrings(pyType, QDate_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDate_Type), Sbk_QDate_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDate_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDate_TypeF(),
        QDate_PythonToCpp_QDate_PTR,
        is_QDate_PythonToCpp_QDate_PTR_Convertible,
        QDate_PTR_CppToPython_QDate,
        QDate_COPY_CppToPython_QDate);

    Shiboken::Conversions::registerConverterName(converter, "QDate");
    Shiboken::Conversions::registerConverterName(converter, "QDate*");
    Shiboken::Conversions::registerConverterName(converter, "QDate&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDate).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QDate_PythonToCpp_QDate_COPY,
        is_QDate_PythonToCpp_QDate_COPY_Convertible);
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Py_None_PythonToCpp_QDate,
        is_Py_None_PythonToCpp_QDate_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PyDate_PythonToCpp_QDate,
        is_PyDate_PythonToCpp_QDate_Convertible);


    // Initialization of enums.

    // Initialization of enum 'MonthNameType'.
    SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDate_TypeF(),
        "MonthNameType",
        "2:PySide2.QtCore.QDate.MonthNameType",
        "QDate::MonthNameType");
    if (!SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX],
        Sbk_QDate_TypeF(), "DateFormat", (long) QDate::MonthNameType::DateFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX],
        Sbk_QDate_TypeF(), "StandaloneFormat", (long) QDate::MonthNameType::StandaloneFormat))
        return;
    // Register converter for enum 'QDate::MonthNameType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX],
            QDate_MonthNameType_CppToPython_QDate_MonthNameType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDate_MonthNameType_PythonToCpp_QDate_MonthNameType,
            is_QDate_MonthNameType_PythonToCpp_QDate_MonthNameType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDate::MonthNameType");
        Shiboken::Conversions::registerConverterName(converter, "MonthNameType");
    }
    // End of 'MonthNameType' enum.


    qRegisterMetaType< ::QDate >("QDate");
    qRegisterMetaType< ::QDate::MonthNameType >("QDate::MonthNameType");
}

